/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.down.pnc.impl;

import com.icetech.basics.constants.TextConstant;
import com.icetech.cloudcenter.api.DownSendService;
import com.icetech.cloudcenter.api.order.OrderService;
import com.icetech.cloudcenter.domain.enumeration.DownServiceEnum;
import com.icetech.cloudcenter.domain.request.pnc.BatchDelBizRequest;
import com.icetech.cloudcenter.domain.request.pnc.ModifyCarRequest;
import com.icetech.common.domain.SendRequest;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.Response;
import com.icetech.common.utils.AssertTools;
import com.icetech.common.utils.StringUtils;
import com.icetech.order.dao.OrderModifyRecordDao;
import com.icetech.order.domain.entity.OrderInfo;
import com.icetech.order.domain.entity.OrderModifyRecord;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.handle.PncDownHandle;
import com.icetech.park.service.handle.PublicHandle;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ModifyCarServiceImpl
extends AbstractService
implements DownSendService {
    private static final Logger log = LoggerFactory.getLogger(ModifyCarServiceImpl.class);
    @Autowired
    private OrderService orderService;
    @Autowired
    private PublicHandle publicHandle;
    @Autowired
    private PncDownHandle downHandle;
    @Autowired
    private OrderModifyRecordDao orderModifyRecordDao;

    public ObjectResponse send(SendRequest sendRequest) {
        Long serviceId = sendRequest.getServiceId();
        ObjectResponse orderModifyRecordObjectResponse = this.orderService.selectModifyRecordById(serviceId);
        if (!ObjectResponse.isSuccess((Response)orderModifyRecordObjectResponse)) {
            return ObjectResponse.failed((String)"410", (String)TextConstant.getDefaultMessage((String)"2", (String)"\u4fee\u6b63\u8bb0\u5f55\u4e0d\u5b58\u5728"));
        }
        ObjectResponse.notError((Response)orderModifyRecordObjectResponse);
        OrderModifyRecord orderModifyRecord = (OrderModifyRecord)orderModifyRecordObjectResponse.getData();
        log.info("\u8ba2\u5355\u4fee\u6539\u4e0b\u53d1\u8bf7\u6c42\u53c2\u6570:{}", (Object)orderModifyRecord);
        String orderId = this.publicHandle.convert2OrderId(sendRequest.getParkId(), orderModifyRecord.getOrderNum());
        ModifyCarRequest modifyCarUpRequest = new ModifyCarRequest();
        modifyCarUpRequest.setModifyType(orderModifyRecord.getCorrectType());
        modifyCarUpRequest.setAction(orderModifyRecord.getAction());
        modifyCarUpRequest.setOrderId(orderId);
        modifyCarUpRequest.setOldVal(orderModifyRecord.getBeforeModify());
        modifyCarUpRequest.setNewVal(orderModifyRecord.getAfterModify());
        modifyCarUpRequest.setCarDesc(orderModifyRecord.getAfterCardesc());
        this.verifyParams(modifyCarUpRequest);
        log.info("\u8ba2\u5355\u4fee\u6539\u4e0b\u53d1\u8bf7\u6c42\u53c2\u6570:{}", (Object)modifyCarUpRequest);
        String messageId = this.downHandle.signAndSend(sendRequest.getParkId(), DownServiceEnum.\u8ba2\u5355\u4fee\u6539.getServiceName(), modifyCarUpRequest, serviceId);
        if (StringUtils.isEmpty((CharSequence)messageId)) {
            return ObjectResponse.failed((String)"410", (String)TextConstant.getUnEstablishConnection());
        }
        return ObjectResponse.success();
    }

    public ObjectResponse batchSend(List<SendRequest> sendRequestList, Long parkId, String parkCode) {
        List ids = sendRequestList.stream().map(SendRequest::getServiceId).collect(Collectors.toList());
        List list = this.orderModifyRecordDao.selectBatchIds(ids);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return ObjectResponse.failed((String)"402");
        }
        List orderNumList = list.stream().map(OrderModifyRecord::getOrderNum).collect(Collectors.toList());
        List orderInfos = this.orderService.selectListByOrderNums(orderNumList);
        Map<String, String> orderNumMap = orderInfos.stream().collect(Collectors.toMap(OrderInfo::getOrderNum, OrderInfo::getLocalOrderNum, (a, b) -> a));
        List localOrderNumList = orderNumList.stream().map(orderNumMap::get).collect(Collectors.toList());
        BatchDelBizRequest batchDelBizRequest = new BatchDelBizRequest();
        batchDelBizRequest.setServiceType(Integer.valueOf(1));
        batchDelBizRequest.setIdList(localOrderNumList);
        batchDelBizRequest.setServiceIds(ids);
        String messageId = this.downHandle.signAndSend(parkId, DownServiceEnum.\u6279\u91cf\u5220\u9664\u4e1a\u52a1\u6570\u636e.getServiceName(), batchDelBizRequest);
        AssertTools.notNull((Object)messageId, (String)"500", (String)"\u4e0b\u53d1\u5931\u8d25");
        return ObjectResponse.success();
    }
}

