/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.down.pnc.impl;

import com.icetech.basics.constants.TextConstant;
import com.icetech.basics.dao.park.ParkRegionDao;
import com.icetech.basics.domain.entity.park.ParkInoutdevice;
import com.icetech.basics.domain.entity.park.ParkRegion;
import com.icetech.cloudcenter.api.DownSendService;
import com.icetech.cloudcenter.api.lcd.LedService;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.domain.enumeration.DownServiceEnum;
import com.icetech.cloudcenter.domain.enumeration.PncVersionEnum;
import com.icetech.cloudcenter.domain.request.pnc.LedConfigRequest;
import com.icetech.common.domain.SendRequest;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.Response;
import com.icetech.common.exception.ResponseBodyException;
import com.icetech.common.utils.NumberUtils;
import com.icetech.park.domain.entity.led.LedConfig;
import com.icetech.park.domain.entity.led.LedShow;
import com.icetech.park.domain.entity.led.LedSound;
import com.icetech.park.domain.entity.led.LedTips;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.handle.PncDownHandle;
import com.icetech.third.utils.RedisUtils;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class LedsoundConfigServiceImpl
extends AbstractService
implements DownSendService {
    private static final Logger log = LoggerFactory.getLogger(LedsoundConfigServiceImpl.class);
    @Resource
    private PncDownHandle downHandle;
    @Resource
    private RedisUtils redisUtils;
    @Resource
    private LedService ledService;
    @Resource
    private ParkService parkService;
    @Resource
    private ParkRegionDao parkRegionDao;

    public ObjectResponse send(SendRequest sendRequest) {
        String version = (String)this.redisUtils.hGet("pnc:version", String.valueOf(sendRequest.getParkId()), String.class);
        if (version == null) {
            return ObjectResponse.failed((String)"407", (String)TextConstant.getDefaultMessage((String)"2", (String)"\u627e\u4e0d\u5230\u8f66\u573a\u7248\u672c"));
        }
        if (PncVersionEnum.getIndex((String)version) < PncVersionEnum.\u7248\u672c5.getIndex()) {
            log.info("\u83b7\u53d6\u5230\u8f66\u573a[{}]\u7248\u672c: [{}] -> [{}]", new Object[]{sendRequest.getParkId(), version, PncVersionEnum.getIndex((String)version)});
            return ObjectResponse.failed((String)"407", (String)TextConstant.getVersionMessage((String)version, (String)PncVersionEnum.\u7248\u672c5.getVersion()));
        }
        Long channelId = sendRequest.getServiceId();
        try {
            ObjectResponse channelResp = this.parkService.getInoutDeviceById(channelId);
            ObjectResponse.notError((Response)channelResp);
            ParkInoutdevice channel = (ParkInoutdevice)channelResp.getData();
            LedConfigRequest request = this.buildRequest(channel);
            List<LedConfigRequest.DisplayConfig> displayConfigs = this.buildDisplayConfigs(channel);
            request.setLedConfig(displayConfigs);
            List<LedConfigRequest.SpecialDisplayConfig> specialDisplayConfigs = this.buildSpecialDisplayConfig(channelId);
            request.setLedSpecial(specialDisplayConfigs);
            List<LedConfigRequest.SoundConfig> soundConfigs = this.buildSoundConfig(channelId, version);
            request.setSoundConfig(soundConfigs);
            String messageId = this.downHandle.signAndSend(sendRequest.getParkId(), DownServiceEnum.LED\u8bed\u97f3\u5c4f\u663e.getServiceName(), request, channelId);
            if (messageId == null) {
                return ObjectResponse.failed((String)"410", (String)TextConstant.getUnEstablishConnection());
            }
            return ObjectResponse.success();
        }
        catch (ResponseBodyException e) {
            log.warn("\u4e0b\u53d1LED\u5c4f\u663e\u8bed\u97f3\u5931\u8d25: {}, {}", new Object[]{e.getErrCode(), e.getMessage(), e});
            return ObjectResponse.failed((String)"410", (String)TextConstant.getDefaultMessage((String)"2", (String)"\u4e0b\u53d1LED\u5c4f\u663e\u8bed\u97f3\u5931\u8d25"));
        }
        catch (Exception e) {
            log.error("\u4e0b\u53d1LED\u5c4f\u663e\u8bed\u97f3\u5931\u8d25", (Throwable)e);
            return ObjectResponse.failed((String)"410", (String)TextConstant.getUnEstablishConnection());
        }
    }

    private LedConfigRequest buildRequest(ParkInoutdevice channel) {
        ObjectResponse soundConfigResp = this.ledService.getLedConfigByChannel(channel.getId());
        LedConfig ledConfig = (LedConfig)soundConfigResp.getData();
        if (ledConfig == null) {
            ledConfig = (LedConfig)this.ledService.getLedConfigByChannel(null).getData();
        }
        LedConfigRequest request = new LedConfigRequest();
        request.setInandoutCode(channel.getInandoutCode());
        if (NumberUtils.toPrimitive((Integer)channel.getLedcardType()) == 5 && channel.getDisplayTerminal() == 2) {
            request.setIsSupportTTS(Integer.valueOf(1));
        } else if (channel.getTtsType() == 1) {
            request.setIsSupportTTS(Integer.valueOf(1));
        } else {
            request.setIsSupportTTS(Integer.valueOf(2));
        }
        request.setCtrlCardModel(channel.getLedcardType());
        request.setLedLineNum(ledConfig.getLedLineNum());
        request.setLedRemainDaysMc(ledConfig.getLedRemainDaysMc());
        request.setLedExpireDaysMc(ledConfig.getLedExpireDaysMc());
        request.setLedBlackCar(ledConfig.getLedBlackCar());
        request.setLedRestoreDefaultTime(ledConfig.getLedRestoreDefaultTime());
        request.setLedQrcodeRule(ledConfig.getLedQrcodeRule());
        request.setVolumeValue(ledConfig.getVolumeValue());
        request.setQuietHoursSwitch(ledConfig.getQuietHoursSwitch());
        request.setQuietStartTime(ledConfig.formatQuietStartTime());
        request.setQuietEndTime(ledConfig.formatQuietEndTime());
        request.setQuietVolumeValue(ledConfig.getQuietVolumeValue());
        request.setLimitType(ledConfig.getLimitType());
        request.setLimitDriveNum4(ledConfig.getLimitDriveNum4());
        request.setLimitDriveNum1(ledConfig.getLimitDriveNum1());
        request.setLimitDriveNum3(ledConfig.getLimitDriveNum3());
        request.setLimitDriveNum2(ledConfig.getLimitDriveNum2());
        request.setLimitDriveNum5(ledConfig.getLimitDriveNum5());
        if (ledConfig.getRegionFreeSpace() == null || Integer.valueOf(0).equals(ledConfig.getRegionFreeSpace())) {
            request.setRegionFreeSpace(String.valueOf(0));
        } else {
            ParkRegion parkRegion = (ParkRegion)this.parkRegionDao.selectById((Serializable)ledConfig.getRegionFreeSpace());
            if (parkRegion != null) {
                request.setRegionFreeSpace(parkRegion.getRegionCode());
            } else {
                request.setRegionFreeSpace(String.valueOf(0));
            }
        }
        return request;
    }

    private List<LedConfigRequest.DisplayConfig> buildDisplayConfigs(ParkInoutdevice channel) {
        Map ledMap = this.ledService.getLedShowMapByChannel(channel.getId());
        if (ledMap.isEmpty()) {
            return null;
        }
        int channelType = NumberUtils.toPrimitive((Integer)channel.getInandoutType());
        int otherChannelType = -1;
        String[] otherDisplayTypes = null;
        if (channelType == 1) {
            otherChannelType = 2;
            otherDisplayTypes = new String[]{String.valueOf(LedShow.DisplayTypeEnum.\u51fa\u53e3\u7a7a\u95f2\u663e\u793a.type), String.valueOf(LedShow.DisplayTypeEnum.\u51fa\u573a\u663e\u793a.type)};
        } else {
            otherChannelType = 1;
            otherDisplayTypes = new String[]{String.valueOf(LedShow.DisplayTypeEnum.\u5165\u53e3\u7a7a\u95f2\u663e\u793a.type), String.valueOf(LedShow.DisplayTypeEnum.\u5165\u573a\u663e\u793a.type)};
        }
        ObjectResponse otherChannels = this.parkService.getChannelByType(channel.getParkId(), Integer.valueOf(otherChannelType));
        Long otherChannelId = Optional.ofNullable(otherChannels).map(ObjectResponse::getData).filter(CollectionUtils::isNotEmpty).map(list -> (ParkInoutdevice)list.get(0)).map(ParkInoutdevice::getId).orElse(null);
        Map otherLedMap = this.ledService.getLedShowMapByChannel(otherChannelId);
        for (int i = 0; i < otherDisplayTypes.length; ++i) {
            String otherDisplayType = otherDisplayTypes[i];
            ledMap.put(otherDisplayType, otherLedMap.get(otherDisplayType));
        }
        return ledMap.values().stream().filter(Objects::nonNull).flatMap(Collection::stream).filter(Objects::nonNull).map(led -> {
            LedConfigRequest.DisplayConfig displayConfig = new LedConfigRequest.DisplayConfig();
            displayConfig.setDisplayType(led.getDisplayType());
            displayConfig.setRowNum(led.getRowNum());
            displayConfig.setLedColor(led.getLedColor());
            displayConfig.setFontSize(null);
            displayConfig.setAlignmentMode(null);
            displayConfig.setDynamicContent(led.getDynamicContent());
            displayConfig.setCustomContent(led.getCustomContent());
            return displayConfig;
        }).collect(Collectors.toList());
    }

    private List<LedConfigRequest.SpecialDisplayConfig> buildSpecialDisplayConfig(long channelId) {
        ObjectResponse specialLedResp = this.ledService.getLedTipsByChannel(Long.valueOf(channelId));
        LedTips specialLed = (LedTips)specialLedResp.getData();
        if (specialLed == null) {
            specialLed = (LedTips)this.ledService.getLedTipsByChannel(null).getData();
        }
        LedConfigRequest.SpecialDisplayConfig displayConfig = new LedConfigRequest.SpecialDisplayConfig();
        displayConfig.setEnterTmpSpecial(specialLed.getEnterTmpSpecial());
        displayConfig.setEnterMonthVip(specialLed.getEnterMonthVip());
        displayConfig.setEnterNotAllowTmpRun(specialLed.getEnterNotAllowTmpRun());
        displayConfig.setEnterMultiParkCar(specialLed.getEnterMultiParkCar());
        displayConfig.setEnterBlackCar(specialLed.getEnterBlackCar());
        displayConfig.setEnterMonthExpire(specialLed.getEnterMonthExpire());
        displayConfig.setEnterNoParkingSpace(specialLed.getEnterNoParkingSpace());
        displayConfig.setEnterNotAllowNocarRun(specialLed.getEnterNotAllowNocarRun());
        displayConfig.setExitPay(specialLed.getExitPay());
        displayConfig.setExitOpenGate(specialLed.getExitOpenGate());
        displayConfig.setExitNoEnterinfo(specialLed.getExitNoEnterinfo());
        displayConfig.setExitNoCarplate(specialLed.getExitNoCarplate());
        displayConfig.setExitNotAllowRun(specialLed.getExitNotAllowRun());
        return Collections.singletonList(displayConfig);
    }

    private List<LedConfigRequest.SoundConfig> buildSoundConfig(long channelId, String version) {
        Map soundMap = this.ledService.getLedSoundMapByChannel(Long.valueOf(channelId));
        if (MapUtils.isEmpty((Map)soundMap)) {
            soundMap = this.ledService.getLedSoundMapByChannel(null);
        }
        return soundMap.values().stream().filter(Objects::nonNull).filter(ledSound -> PncVersionEnum.getIndex((String)version) >= PncVersionEnum.\u7248\u672c2500.getIndex() || LedSound.SoundTypeEnum.\u5165\u53e3\u6b20\u8d39\u8865\u7f34.type != ledSound.getSoundType() && LedSound.SoundTypeEnum.\u51fa\u53e3\u6b20\u8d39\u8865\u7f34.type != ledSound.getSoundType() && LedSound.SoundTypeEnum.\u5165\u53e3\u865a\u5047\u8f66\u724c.type != ledSound.getSoundType() && LedSound.SoundTypeEnum.\u51fa\u53e3\u865a\u5047\u8f66\u724c.type != ledSound.getSoundType()).map(sound -> {
            LedConfigRequest.SoundConfig soundConfig = new LedConfigRequest.SoundConfig();
            soundConfig.setSoundType(sound.getSoundType());
            soundConfig.setDynamicContent(sound.getDynamicContent());
            soundConfig.setCustomContent(sound.getCustomContent());
            return soundConfig;
        }).collect(Collectors.toList());
    }
}

