/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.down.pnc.impl;

import com.icetech.basics.constants.TextConstant;
import com.icetech.basics.dao.park.ParkRegionDao;
import com.icetech.basics.domain.entity.park.ParkInoutdevice;
import com.icetech.basics.domain.entity.park.ParkRegion;
import com.icetech.cloudcenter.api.DownSendService;
import com.icetech.cloudcenter.api.lcd.LcdService;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.domain.enumeration.DownServiceEnum;
import com.icetech.cloudcenter.domain.enumeration.PncVersionEnum;
import com.icetech.cloudcenter.domain.request.pnc.LcdConfigRequest;
import com.icetech.common.domain.SendRequest;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.Response;
import com.icetech.common.exception.ResponseBodyException;
import com.icetech.common.utils.NumberUtils;
import com.icetech.park.domain.entity.lcd.LcdBrightness;
import com.icetech.park.domain.entity.lcd.LcdConfig;
import com.icetech.park.domain.entity.lcd.LcdShow;
import com.icetech.park.domain.entity.lcd.LcdSound;
import com.icetech.park.domain.entity.lcd.LcdTips;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.handle.PncDownHandle;
import com.icetech.third.utils.RedisUtils;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class LcdsoundConfigServiceImpl
extends AbstractService
implements DownSendService {
    private static final Logger log = LoggerFactory.getLogger(LcdsoundConfigServiceImpl.class);
    @Resource
    private PncDownHandle downHandle;
    @Resource
    private LcdService lcdService;
    @Resource
    private ParkService parkService;
    @Resource
    private RedisUtils redisUtils;
    @Resource
    private ParkRegionDao parkRegionDao;

    public ObjectResponse send(SendRequest sendRequest) {
        String version = (String)this.redisUtils.hGet("pnc:version", String.valueOf(sendRequest.getParkId()), String.class);
        if (version == null) {
            return ObjectResponse.failed((String)"407", (String)TextConstant.getDefaultMessage((String)"2", (String)"\u627e\u4e0d\u5230\u8f66\u573a\u7248\u672c"));
        }
        if (PncVersionEnum.getIndex((String)version) < PncVersionEnum.\u7248\u672c5.getIndex()) {
            log.info("\u83b7\u53d6\u5230\u8f66\u573a[{}]\u7248\u672c: [{}] -> [{}]", new Object[]{sendRequest.getParkId(), version, PncVersionEnum.getIndex((String)version)});
            return ObjectResponse.failed((String)"407", (String)TextConstant.getVersionMessage((String)version, (String)PncVersionEnum.\u7248\u672c5.getVersion()));
        }
        Long parkId = sendRequest.getParkId();
        Long channelId = sendRequest.getServiceId();
        try {
            ObjectResponse channelResp = this.parkService.getInoutDeviceById(channelId);
            ObjectResponse.notError((Response)channelResp);
            ParkInoutdevice channel = (ParkInoutdevice)channelResp.getData();
            LcdConfigRequest request = this.buildRequest(channel);
            List<LcdConfigRequest.DisplayConfig> displayConfigs = this.buildDisplayConfig(channel);
            request.setLcdShow(displayConfigs);
            List<LcdConfigRequest.TipsConfig> tipsConfigs = this.buildTipsConfig(channelId);
            request.setLcdTips(tipsConfigs);
            List<LcdConfigRequest.SoundCodeConfig> soundCodeConfigs = this.buildSoundCodeConfig();
            request.setLcdSoundcode(soundCodeConfigs);
            List<LcdConfigRequest.SoundConfig> soundConfigs = this.buildSoundConfig(channelId, version);
            request.setLcdSound(soundConfigs);
            String messageId = this.downHandle.signAndSend(parkId, DownServiceEnum.LCD\u8bed\u97f3\u5c4f\u663e.getServiceName(), request, channelId);
            if (messageId == null) {
                return ObjectResponse.failed((String)"410", (String)TextConstant.getUnEstablishConnection());
            }
            return ObjectResponse.success();
        }
        catch (ResponseBodyException e) {
            log.warn("\u4e0b\u53d1LCD\u5c4f\u663e\u8bed\u97f3\u5931\u8d25: {}, {}", new Object[]{e.getErrCode(), e.getMessage(), e});
            return ObjectResponse.failed((String)"410", (String)TextConstant.getDefaultMessage((String)"2", (String)"\u4e0b\u53d1LCD\u5c4f\u663e\u8bed\u97f3\u5931\u8d25"));
        }
        catch (Exception e) {
            log.error("\u4e0b\u53d1LCD\u5c4f\u663e\u8bed\u97f3\u5931\u8d25", (Throwable)e);
            return ObjectResponse.failed((String)"410", (String)TextConstant.getUnEstablishConnection());
        }
    }

    private LcdConfigRequest buildRequest(ParkInoutdevice channel) {
        ObjectResponse lcdConfigResp = this.lcdService.getLcdConfigByChannel(channel.getId());
        LcdConfig lcdConfig = (LcdConfig)lcdConfigResp.getData();
        if (lcdConfig == null) {
            lcdConfig = (LcdConfig)this.lcdService.getLcdConfigByChannel(null).getData();
        }
        LcdConfigRequest request = new LcdConfigRequest();
        request.setInandoutCode(channel.getInandoutCode());
        request.setLineNum(lcdConfig.getLineNum());
        request.setRemainDaysMc(lcdConfig.getRemainDaysMc());
        request.setExpireDaysMc(lcdConfig.getExpireDaysMc());
        request.setExpireDaysMonth(lcdConfig.getExpireDaysMonth());
        request.setBlackCar(lcdConfig.getBlackCar());
        request.setEntranceFreeLayout(lcdConfig.getEntranceFreeLayout());
        request.setEnterLayout(lcdConfig.getEnterLayout());
        request.setExitFreeLayout(lcdConfig.getExitFreeLayout());
        request.setExitLayout(lcdConfig.getExitLayout());
        request.setRestoreDefaultTime(lcdConfig.getRestoreDefaultTime());
        request.setVolumeValue(lcdConfig.getVolumeValue());
        request.setQuietHoursSwitch(lcdConfig.getQuietHoursSwitch());
        request.setQuietStartTime(lcdConfig.formatQuietStartTime());
        request.setQuietEndTime(lcdConfig.formatQuietEndTime());
        request.setQuietVolumeValue(lcdConfig.getQuietVolumeValue());
        request.setLimitType(lcdConfig.getLimitType());
        request.setLimitDriveNum1(lcdConfig.getLimitDriveNum1());
        request.setLimitDriveNum2(lcdConfig.getLimitDriveNum2());
        request.setLimitDriveNum3(lcdConfig.getLimitDriveNum3());
        request.setLimitDriveNum4(lcdConfig.getLimitDriveNum4());
        request.setLimitDriveNum5(lcdConfig.getLimitDriveNum5());
        request.setLcdBrightness(this.buildBrightnessConfig(lcdConfig.getLcdBrightnessList()));
        if (lcdConfig.getRegionFreeSpace() == null || Integer.valueOf(0).equals(lcdConfig.getRegionFreeSpace())) {
            request.setRegionFreeSpace(String.valueOf(0));
        } else {
            ParkRegion parkRegion = (ParkRegion)this.parkRegionDao.selectById((Serializable)lcdConfig.getRegionFreeSpace());
            if (parkRegion != null) {
                request.setRegionFreeSpace(parkRegion.getRegionCode());
            } else {
                request.setRegionFreeSpace(String.valueOf(0));
            }
        }
        return request;
    }

    private List<LcdConfigRequest.BrightnessConfig> buildBrightnessConfig(List<LcdBrightness> brightnesses) {
        if (CollectionUtils.isEmpty(brightnesses)) {
            return null;
        }
        return brightnesses.stream().map(brightness -> {
            LcdConfigRequest.BrightnessConfig config = new LcdConfigRequest.BrightnessConfig();
            config.setStartTimePoint(brightness.getStartTimePoint());
            config.setEndTimePoint(brightness.getEndTimePoint());
            config.setBrightnessVal(brightness.getBrightnessVal());
            config.setSort(brightness.getSort());
            return config;
        }).collect(Collectors.toList());
    }

    private List<LcdConfigRequest.DisplayConfig> buildDisplayConfig(ParkInoutdevice channel) {
        Map lcdShowMap = this.lcdService.getLcdShowMapByChannel(channel.getId());
        if (lcdShowMap.isEmpty()) {
            return null;
        }
        int channelType = NumberUtils.toPrimitive((Integer)channel.getInandoutType());
        int otherChannelType = -1;
        String[] otherDisplayTypes = null;
        if (channelType == 1) {
            otherChannelType = 2;
            otherDisplayTypes = new String[]{String.valueOf(LcdShow.DisplayTypeEnum.\u51fa\u53e3\u7a7a\u95f2\u663e\u793a.type), String.valueOf(LcdShow.DisplayTypeEnum.\u51fa\u573a\u663e\u793a.type)};
        } else {
            otherChannelType = 1;
            otherDisplayTypes = new String[]{String.valueOf(LcdShow.DisplayTypeEnum.\u5165\u53e3\u7a7a\u95f2\u663e\u793a.type), String.valueOf(LcdShow.DisplayTypeEnum.\u5165\u573a\u663e\u793a.type)};
        }
        ObjectResponse otherChannels = this.parkService.getChannelByType(channel.getParkId(), Integer.valueOf(otherChannelType));
        Long otherChannelId = Optional.ofNullable(otherChannels).map(ObjectResponse::getData).filter(CollectionUtils::isNotEmpty).map(list -> (ParkInoutdevice)list.get(0)).map(ParkInoutdevice::getId).orElse(null);
        Map otherLcdMap = this.lcdService.getLcdShowMapByChannel(otherChannelId);
        for (int i = 0; i < otherDisplayTypes.length; ++i) {
            String otherDisplayType = otherDisplayTypes[i];
            lcdShowMap.put(otherDisplayType, otherLcdMap.get(otherDisplayType));
        }
        return lcdShowMap.values().stream().filter(Objects::nonNull).flatMap(Collection::stream).filter(Objects::nonNull).map(show -> {
            LcdConfigRequest.DisplayConfig config = new LcdConfigRequest.DisplayConfig();
            config.setDisplayType(show.getDisplayType());
            config.setRowNum(show.getRowNum());
            config.setRowColor(show.getRowColor());
            config.setDynamicContent(show.getDynamicContent());
            config.setCustomContent(show.getCustomContent());
            return config;
        }).collect(Collectors.toList());
    }

    private List<LcdConfigRequest.TipsConfig> buildTipsConfig(long channelId) {
        ObjectResponse lcdTipsResp = this.lcdService.getLcdTipsByChannel(Long.valueOf(channelId));
        LcdTips lcdTips = (LcdTips)lcdTipsResp.getData();
        if (lcdTips == null) {
            lcdTips = (LcdTips)this.lcdService.getLcdTipsByChannel(null).getData();
        }
        LcdConfigRequest.TipsConfig config = new LcdConfigRequest.TipsConfig();
        config.setEnterTmpSpecial(lcdTips.getEnterTmpSpecial());
        config.setEnterMonthVip(lcdTips.getEnterMonthVip());
        config.setEnterNotAllowTmpRun(lcdTips.getEnterNotAllowTmpRun());
        config.setEnterMultiParkCar(lcdTips.getEnterMultiParkCar());
        config.setEnterBlackCar(lcdTips.getEnterBlackCar());
        config.setEnterMonthExpire(lcdTips.getEnterMonthExpire());
        config.setEnterNoParkingSpace(lcdTips.getEnterNoParkingSpace());
        config.setEnterNotAllowNocarRun(lcdTips.getEnterNotAllowNocarRun());
        config.setExitPay(lcdTips.getExitPay());
        config.setExitOpenGate(lcdTips.getExitOpenGate());
        config.setExitNoEnterinfo(lcdTips.getExitNoEnterinfo());
        config.setExitNoCarplate(lcdTips.getExitNoCarplate());
        config.setExitNotAllowRun(lcdTips.getExitNotAllowRun());
        return Collections.singletonList(config);
    }

    private List<LcdConfigRequest.SoundCodeConfig> buildSoundCodeConfig() {
        ObjectResponse soundCodesResp = this.lcdService.getAllLcdSoundCodes();
        ObjectResponse.notError((Response)soundCodesResp);
        return ((List)soundCodesResp.getData()).stream().map(code -> {
            LcdConfigRequest.SoundCodeConfig config = new LcdConfigRequest.SoundCodeConfig();
            config.setSoundCode(code.getSoundCode());
            config.setContent(code.getContent());
            config.setType(code.getType());
            config.setIsCustom(code.getIsCustom());
            config.setCustomSoundPath(code.getCustomSoundPath());
            return config;
        }).collect(Collectors.toList());
    }

    private List<LcdConfigRequest.SoundConfig> buildSoundConfig(long channelId, String version) {
        Map lcdSoundMap = this.lcdService.getLcdSoundMapByChannel(Long.valueOf(channelId));
        if (MapUtils.isEmpty((Map)lcdSoundMap)) {
            lcdSoundMap = this.lcdService.getLcdSoundMapByChannel(null);
        }
        return lcdSoundMap.values().stream().filter(Objects::nonNull).flatMap(Collection::stream).filter(lcdSound -> PncVersionEnum.getIndex((String)version) >= PncVersionEnum.\u7248\u672c2500.getIndex() || LcdSound.SoundTypeEnum.\u5165\u53e3\u6b20\u8d39\u8865\u7f34.type != lcdSound.getSoundType() && LcdSound.SoundTypeEnum.\u51fa\u53e3\u6b20\u8d39\u8865\u7f34.type != lcdSound.getSoundType()).filter(Objects::nonNull).map(sound -> {
            LcdConfigRequest.SoundConfig config = new LcdConfigRequest.SoundConfig();
            config.setSoundType(sound.getSoundType());
            config.setContentPattern(sound.getContentPattern());
            return config;
        }).collect(Collectors.toList());
    }
}

