/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.down.pnc.impl;

import com.icetech.basics.constants.TextConstant;
import com.icetech.basics.dao.park.ParkRegionDao;
import com.icetech.basics.domain.entity.park.ParkRegion;
import com.icetech.cloudcenter.api.DownSendService;
import com.icetech.cloudcenter.domain.enumeration.DownServiceEnum;
import com.icetech.cloudcenter.domain.request.pnc.BatchDelBizRequest;
import com.icetech.cloudcenter.domain.request.pnc.CardStatusRequest;
import com.icetech.cloudcenter.domain.request.pnc.IssuedCardRequest;
import com.icetech.cloudcenter.domain.request.pnc.MonthPlot;
import com.icetech.common.domain.SendRequest;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.exception.ResponseBodyException;
import com.icetech.common.utils.DateUtils;
import com.icetech.common.utils.NumberUtils;
import com.icetech.fee.dao.monthcar.MonthProductDao;
import com.icetech.fee.dao.monthcar.MonthRecordDao;
import com.icetech.fee.dao.monthcar.MonthRelSpaceDao;
import com.icetech.fee.domain.entity.monthcar.MonthProduct;
import com.icetech.fee.domain.entity.monthcar.MonthRecord;
import com.icetech.park.service.down.pnc.impl.CardPauseRecoverServiceImpl;
import com.icetech.park.service.handle.PncDownHandle;
import com.icetech.third.utils.RedisUtils;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class IssuedCardServiceImpl
implements DownSendService {
    @Autowired
    private PncDownHandle downHandle;
    @Autowired
    private MonthRecordDao monthRecordDao;
    @Autowired
    private MonthProductDao monthProductDao;
    @Autowired
    private MonthRelSpaceDao monthRelSpaceDao;
    @Autowired
    private CardPauseRecoverServiceImpl cardPauseRecoverService;
    @Autowired
    private ParkRegionDao parkRegionDao;
    @Autowired
    private RedisUtils redisUtils;
    private static final int CARD_TYPE_2 = 2;
    private static final int PAUSE = 7;
    private static final int RECOVER = 8;

    public ObjectResponse send(SendRequest sendRequest) {
        String messageId;
        Long serviceId = sendRequest.getServiceId();
        MonthRecord monthRecord = (MonthRecord)this.monthRecordDao.selectById((Serializable)serviceId);
        if (monthRecord == null) {
            return ObjectResponse.failed((String)"410", (String)TextConstant.getDefaultMessage((String)"2", (String)"\u6708\u5361\u64cd\u4f5c\u8bb0\u5f55\u4e0d\u5b58\u5728"));
        }
        String version = (String)this.redisUtils.hGet("pnc:version", String.valueOf(sendRequest.getParkId()), String.class);
        boolean monthPlot = "spaceTime".equals(sendRequest.getInclude());
        if (version == null || version.startsWith("N")) {
            if (7 == monthRecord.getCardOpertype() || 8 == monthRecord.getCardOpertype()) {
                return this.cardPauseRecoverService.send(serviceId, monthRecord);
            }
            IssuedCardRequest issuedCardRequest = this.buildRequest(monthRecord, monthPlot);
            String regionId = monthRecord.getRegionId();
            if (StringUtils.isNotEmpty((CharSequence)regionId) && !regionId.equals("0")) {
                issuedCardRequest.setMcRange(Integer.valueOf(2));
                Map<String, String> parkRegion = this.getParkRegion(regionId);
                issuedCardRequest.setRegionCode(parkRegion.get("regionCodes"));
                issuedCardRequest.setRegionName(parkRegion.get("regionNames"));
            }
            messageId = this.downHandle.signAndSend(sendRequest.getParkId(), DownServiceEnum.\u6708\u5361.getServiceName(), issuedCardRequest, serviceId);
        } else {
            CardStatusRequest cardStatusRequest = this.buildNewRequest(monthRecord, monthPlot);
            messageId = this.downHandle.signAndSend(sendRequest.getParkId(), DownServiceEnum.\u6708\u5361.getServiceName(), cardStatusRequest, serviceId);
        }
        if (StringUtils.isEmpty((CharSequence)messageId)) {
            return ObjectResponse.failed((String)"410", (String)TextConstant.getUnEstablishConnection());
        }
        return ObjectResponse.success();
    }

    public ObjectResponse batchSend(List<SendRequest> sendRequestList, Long parkId, String parkCode) {
        List ids = sendRequestList.stream().map(SendRequest::getServiceId).collect(Collectors.toList());
        List list = this.monthRecordDao.selectBatchIds(ids);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return ObjectResponse.failed((String)"402");
        }
        List monthIdList = list.stream().map(MonthRecord::getMonthId).map(String::valueOf).collect(Collectors.toList());
        BatchDelBizRequest batchDelBizRequest = new BatchDelBizRequest();
        batchDelBizRequest.setServiceType(Integer.valueOf(2));
        batchDelBizRequest.setIdList(monthIdList);
        batchDelBizRequest.setServiceIds(ids);
        String messageId = this.downHandle.signAndSend(parkId, DownServiceEnum.\u6279\u91cf\u5220\u9664\u4e1a\u52a1\u6570\u636e.getServiceName(), batchDelBizRequest);
        if (StringUtils.isEmpty((CharSequence)messageId)) {
            throw new ResponseBodyException("500", "\u4e0b\u53d1\u5931\u8d25");
        }
        return ObjectResponse.success();
    }

    private Map<String, String> getParkRegion(String regionIds) {
        HashMap<String, String> retMap = new HashMap<String, String>();
        String regionCodes = "";
        String regionNames = "";
        String[] split = regionIds.split(",");
        for (int i = 0; i < split.length; ++i) {
            ParkRegion parkRegion = (ParkRegion)this.parkRegionDao.selectById((Serializable)Long.valueOf(split[i]));
            if (i == split.length - 1) {
                regionCodes = regionCodes + parkRegion.getRegionCode();
                regionNames = regionNames + parkRegion.getRegionName();
                continue;
            }
            regionCodes = regionCodes + parkRegion.getRegionCode() + ",";
            regionNames = regionNames + parkRegion.getRegionName() + ",";
        }
        retMap.put("regionCodes", regionCodes);
        retMap.put("regionNames", regionNames);
        return retMap;
    }

    private IssuedCardRequest buildRequest(MonthRecord monthRecord, boolean monthPlot) {
        IssuedCardRequest issuedCardRequest = new IssuedCardRequest();
        issuedCardRequest.setCardId(String.valueOf(monthRecord.getMonthId()));
        if (monthRecord.getPlateNum() != null) {
            issuedCardRequest.setPlateNum(monthRecord.getPlateNum().replaceAll(",", "/"));
        }
        issuedCardRequest.setPhone(monthRecord.getPhone());
        issuedCardRequest.setCardOwner(StringUtils.isBlank((CharSequence)monthRecord.getCardOwner()) ? "default" : monthRecord.getCardOwner());
        issuedCardRequest.setCardProperty(monthRecord.getCardProperty());
        if (monthRecord.getStartTime() == null || monthRecord.getEndTime() == null) {
            throw new ResponseBodyException("410", TextConstant.getDefaultMessage((String)"2", (String)"\u65e5\u671f\u4e0d\u5408\u6cd5"));
        }
        issuedCardRequest.setStartDate(DateFormatUtils.format((Date)monthRecord.getStartTime(), (String)"yyyy-MM-dd"));
        issuedCardRequest.setEndDate(DateFormatUtils.format((Date)monthRecord.getEndTime(), (String)"yyyy-MM-dd"));
        issuedCardRequest.setCardOperType(monthRecord.getCardOpertype());
        issuedCardRequest.setPlotCount(monthRecord.getPlotCount());
        if (monthRecord.getSpaceNum() != null) {
            issuedCardRequest.setPlotNum(monthRecord.getSpaceNum().replaceAll(",", "/"));
        }
        issuedCardRequest.setPayMoney(monthRecord.getPayMoney() == null ? "0.0" : monthRecord.getPayMoney().toString());
        issuedCardRequest.setOperAccount(monthRecord.getOperAccount());
        issuedCardRequest.setOperTime(Long.valueOf(monthRecord.getCreateTime().getTime() / 1000L));
        MonthProduct monthProduct = this.monthProductDao.selectById(monthRecord.getProductId().longValue());
        issuedCardRequest.setProdName(monthProduct.getName());
        issuedCardRequest.setProdDuration(Integer.valueOf(monthProduct.getDuration()));
        int cardType = monthProduct.getCardType();
        issuedCardRequest.setCardType(Integer.valueOf(cardType));
        if (cardType == 2) {
            issuedCardRequest.setStartTime(DateFormatUtils.format((Date)monthProduct.getStartTime(), (String)"HH:mm:ss"));
            issuedCardRequest.setEndTime(DateFormatUtils.format((Date)monthProduct.getEndTime(), (String)"HH:mm:ss"));
        }
        if (monthPlot) {
            issuedCardRequest.setPlotValidPeriod(this.buildMonthPlot(monthRecord.getMonthId()));
        }
        issuedCardRequest.setNotWorkdayCharge(Integer.valueOf(NumberUtils.toPrimitive((Integer)monthProduct.getNotWorkdayCharge(), (int)2)));
        return issuedCardRequest;
    }

    private CardStatusRequest buildNewRequest(MonthRecord monthRecord, boolean monthPlot) {
        String regionId;
        CardStatusRequest cardStatusRequest = new CardStatusRequest();
        Integer cardOpertype = monthRecord.getCardOpertype();
        if (cardOpertype == 1 || cardOpertype == 2 || cardOpertype == 3 || cardOpertype == 6 || cardOpertype == 8) {
            cardStatusRequest.setCardStatus(Integer.valueOf(1));
        } else {
            cardStatusRequest.setCardStatus(Integer.valueOf(2));
        }
        cardStatusRequest.setCardId(String.valueOf(monthRecord.getMonthId()));
        if (monthRecord.getPlateNum() != null) {
            cardStatusRequest.setPlateNum(monthRecord.getPlateNum().replaceAll(",", "/"));
        }
        cardStatusRequest.setPhone(monthRecord.getPhone());
        cardStatusRequest.setCardOwner(StringUtils.isBlank((CharSequence)monthRecord.getCardOwner()) ? "default" : monthRecord.getCardOwner());
        cardStatusRequest.setCardProperty(monthRecord.getCardProperty());
        cardStatusRequest.setStartDate(DateFormatUtils.format((Date)monthRecord.getStartTime(), (String)"yyyy-MM-dd"));
        cardStatusRequest.setEndDate(DateFormatUtils.format((Date)monthRecord.getEndTime(), (String)"yyyy-MM-dd"));
        cardStatusRequest.setPlotCount(monthRecord.getPlotCount());
        cardStatusRequest.setPlotNum(monthRecord.getSpaceNum());
        cardStatusRequest.setPayMoney(monthRecord.getPayMoney().toString());
        cardStatusRequest.setOperAccount(monthRecord.getOperAccount());
        cardStatusRequest.setOperTime(Long.valueOf(monthRecord.getCreateTime().getTime() / 1000L));
        MonthProduct monthProduct = this.monthProductDao.selectById(monthRecord.getProductId().longValue());
        int cardType = monthProduct.getCardType();
        cardStatusRequest.setCardType(Integer.valueOf(cardType));
        if (cardType == 2) {
            cardStatusRequest.setStartTime(DateFormatUtils.format((Date)monthProduct.getStartTime(), (String)"HH:mm:ss"));
            cardStatusRequest.setEndTime(DateFormatUtils.format((Date)monthProduct.getEndTime(), (String)"HH:mm:ss"));
        }
        if (StringUtils.isNotEmpty((CharSequence)(regionId = monthRecord.getRegionId())) && !regionId.equals("0")) {
            cardStatusRequest.setMcRange(Integer.valueOf(2));
            Map<String, String> parkRegion = this.getParkRegion(regionId);
            cardStatusRequest.setRegionCode(parkRegion.get("regionCodes"));
            cardStatusRequest.setRegionName(parkRegion.get("regionNames"));
        }
        if (monthPlot) {
            cardStatusRequest.setPlotValidPeriod(this.buildMonthPlot(monthRecord.getMonthId()));
        }
        return cardStatusRequest;
    }

    @Nullable
    private List<MonthPlot> buildMonthPlot(long monthId) {
        List monthRelSpaces = this.monthRelSpaceDao.getByMonthId(monthId);
        return CollectionUtils.isEmpty((Collection)monthRelSpaces) ? null : monthRelSpaces.stream().map(monthRelSpace -> new MonthPlot().setPlotNum(monthRelSpace.getSpaceNum()).setStartDate(monthRelSpace.getStartTime() == null ? null : monthRelSpace.getStartTime().format(DateUtils.DEFAULT_DATE_FORMAT)).setEndDate(monthRelSpace.getEndTime() == null ? null : monthRelSpace.getEndTime().format(DateUtils.DEFAULT_DATE_FORMAT))).collect(Collectors.toList());
    }
}

