/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.down.pnc.impl;

import cn.hutool.json.JSONUtil;
import com.icetech.basics.constants.TextConstant;
import com.icetech.cloudcenter.api.NotifyService;
import com.icetech.cloudcenter.domain.enumeration.DownServiceEnum;
import com.icetech.cloudcenter.domain.request.pnc.EtcPayStatusRequest;
import com.icetech.cloudcenter.domain.response.pnc.EtcPayStatusResponse;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.park.component.AsyncNotifyClient;
import com.icetech.park.service.handle.PncDownHandle;
import com.icetech.third.domain.entity.third.SendInfoRecord;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EtcPayStatusServiceImpl
implements NotifyService<EtcPayStatusRequest> {
    private static final Logger log = LoggerFactory.getLogger(EtcPayStatusServiceImpl.class);
    @Autowired
    private PncDownHandle downHandle;
    @Resource
    private AsyncNotifyClient asyncNotifyClient;

    public ObjectResponse<EtcPayStatusResponse> etcPayStatus(EtcPayStatusRequest request, Long parkId, String topic) {
        String messageId = this.downHandle.signAndSendAsyncResult(parkId, DownServiceEnum.ETC.getServiceName(), request, topic);
        if (messageId == null) {
            return ObjectResponse.failed((String)"410", (String)TextConstant.getUnEstablishConnection());
        }
        return ObjectResponse.failed((String)"12002", (String)messageId);
    }

    public void notify(String messageId, ObjectResponse<String> response, SendInfoRecord<EtcPayStatusRequest> sendInfoRecord) {
        log.info("[notify] messageId {},response {} sendInfoRecord {}", new Object[]{messageId, JSONUtil.toJsonStr(response), JSONUtil.toJsonStr(sendInfoRecord)});
        if (ObjectResponse.isSuccess(response)) {
            EtcPayStatusResponse computeDiscount = (EtcPayStatusResponse)JSONUtil.toBean((String)((String)response.getData()), EtcPayStatusResponse.class);
            this.asyncNotifyClient.callBack(messageId, sendInfoRecord.getTopic(), sendInfoRecord.getEnv(), ObjectResponse.success((Object)computeDiscount));
            return;
        }
        this.asyncNotifyClient.callBack(messageId, sendInfoRecord.getTopic(), sendInfoRecord.getEnv(), ObjectResponse.failed((String)response.getCode(), (String)response.getMsg()));
    }
}

