/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.down.pnc.impl;

import com.icetech.basics.constants.TextConstant;
import com.icetech.cloudcenter.api.DownSendService;
import com.icetech.cloudcenter.api.discount.MerchantDiscountService;
import com.icetech.cloudcenter.api.order.OrderDiscountService;
import com.icetech.cloudcenter.api.order.OrderService;
import com.icetech.cloudcenter.domain.enumeration.DownServiceEnum;
import com.icetech.cloudcenter.domain.request.pnc.DiscountInfoDownRequest;
import com.icetech.common.constants.DiscountTypeEnum;
import com.icetech.common.domain.SendRequest;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.Response;
import com.icetech.common.utils.StringUtils;
import com.icetech.fee.domain.entity.merchant.DiscountDay;
import com.icetech.order.domain.entity.OrderDiscount;
import com.icetech.order.domain.entity.OrderInfo;
import com.icetech.park.service.handle.PncDownHandle;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DiscountInfoServiceImpl
implements DownSendService {
    @Autowired
    private PncDownHandle downHandle;
    @Autowired
    private OrderService orderService;
    @Autowired
    private OrderDiscountService orderDiscountService;
    @Autowired
    private MerchantDiscountService merchantDiscountService;

    public ObjectResponse<Object> send(SendRequest sendRequest) {
        String messageId;
        Long serviceId = sendRequest.getServiceId();
        OrderDiscount orderDiscount = new OrderDiscount();
        orderDiscount.setId(serviceId);
        ObjectResponse one = this.orderDiscountService.findOne(orderDiscount);
        if (!ObjectResponse.isSuccess((Response)one)) {
            return ObjectResponse.failed((String)"410", (String)TextConstant.getDefaultMessage((String)"2", (String)"\u4f18\u60e0\u8bb0\u5f55\u672a\u627e\u5230"));
        }
        OrderDiscount data = (OrderDiscount)one.getData();
        DiscountInfoDownRequest discountInfoDownRequest = new DiscountInfoDownRequest();
        discountInfoDownRequest.setDiscountNo(data.getDiscountNo());
        discountInfoDownRequest.setDiscountNumber(data.getAmount());
        discountInfoDownRequest.setDiscountType(data.getType());
        discountInfoDownRequest.setFrom(data.getFrom());
        OrderInfo orderInfo = new OrderInfo();
        orderInfo.setParkId(data.getParkId());
        orderInfo.setOrderNum(data.getOrderNum());
        ObjectResponse byOrderInfo = this.orderService.findByOrderInfo(orderInfo);
        if (!ObjectResponse.isSuccess((Response)byOrderInfo)) {
            return ObjectResponse.failed((String)"410", (String)TextConstant.getDefaultMessage((String)"2", (String)"\u8ba2\u5355\u4fe1\u606f\u672a\u627e\u5230"));
        }
        ObjectResponse.notError((Response)byOrderInfo);
        OrderInfo orderInfoData = (OrderInfo)byOrderInfo.getData();
        discountInfoDownRequest.setOrderId(orderInfoData.getLocalOrderNum() != null ? orderInfoData.getLocalOrderNum() : orderInfoData.getOrderNum());
        discountInfoDownRequest.setPlateNum(((OrderInfo)byOrderInfo.getData()).getPlateNum());
        discountInfoDownRequest.setDiscountTime(Long.valueOf(data.getSendTime().getTime() / 1000L));
        discountInfoDownRequest.setStatus(data.getStatus());
        discountInfoDownRequest.setTradeNo(data.getTradeNo());
        discountInfoDownRequest.setExpireTime(data.getExpireTime() == null ? null : Long.valueOf(data.getExpireTime().getTime() / 1000L));
        if (data.getType().equals(DiscountTypeEnum.\u6309\u5929\u4f18\u514d.getType())) {
            ObjectResponse discountDayObjectResponse = this.merchantDiscountService.findDiscountDay(data.getDiscountNo(), data.getParkId());
            if (!ObjectResponse.isSuccess((Response)discountDayObjectResponse)) {
                return ObjectResponse.failed((String)"410", (String)TextConstant.getDefaultMessage((String)"2", (String)"\u4f18\u60e0\u4fe1\u606f\u672a\u627e\u5230"));
            }
            ObjectResponse.notError((Response)discountDayObjectResponse);
            DiscountDay discountDay = (DiscountDay)discountDayObjectResponse.getData();
            discountInfoDownRequest.setStartTime(Long.valueOf(discountDay.getStartTime().getTime() / 1000L));
            discountInfoDownRequest.setEndTime(Long.valueOf(discountDay.getEndTime().getTime() / 1000L));
        }
        if (StringUtils.isEmpty((CharSequence)(messageId = this.downHandle.signAndSend(sendRequest.getParkId(), DownServiceEnum.\u4f18\u60e0\u4e0b\u53d1.getServiceName(), discountInfoDownRequest, serviceId)))) {
            return ObjectResponse.failed((String)"410", (String)TextConstant.getUnEstablishConnection());
        }
        return ObjectResponse.success();
    }
}

