/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.down.pnc.impl;

import com.icetech.basics.constants.TextConstant;
import com.icetech.cloudcenter.api.DownSendService;
import com.icetech.cloudcenter.domain.enumeration.DownServiceEnum;
import com.icetech.cloudcenter.domain.request.pnc.DelNotPayRecordRequest;
import com.icetech.common.domain.SendRequest;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.utils.StringUtils;
import com.icetech.park.service.handle.PncDownHandle;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DelNotPayRecordServiceImpl
implements DownSendService {
    @Autowired
    private PncDownHandle downHandle;

    public ObjectResponse send(SendRequest request) {
        String orderIds = request.getInclude();
        if (StringUtils.isEmpty((CharSequence)orderIds)) {
            return ObjectResponse.failed((String)"410", (String)TextConstant.getDefaultMessage((String)"2", (String)"\u672a\u627e\u5230\u5220\u9664\u8bb0\u5f55"));
        }
        DelNotPayRecordRequest recordRequest = DelNotPayRecordRequest.builder().orderIds(orderIds).build();
        String messageId = this.downHandle.signAndSend(request.getParkId(), DownServiceEnum.\u6b20\u8d39\u8bb0\u5f55\u5220\u9664.getServiceName(), recordRequest);
        if (messageId == null) {
            return ObjectResponse.failed((String)"410", (String)TextConstant.getUnEstablishConnection());
        }
        return ObjectResponse.success();
    }

    public ObjectResponse<Void> sendDelMessage(String orderIds, Long parkId) {
        DelNotPayRecordRequest recordRequest = DelNotPayRecordRequest.builder().orderIds(orderIds).build();
        String messageId = this.downHandle.signAndSend(parkId, DownServiceEnum.\u6b20\u8d39\u8bb0\u5f55\u5220\u9664.getServiceName(), recordRequest);
        if (messageId == null) {
            return ObjectResponse.failed((String)"410", (String)"\u6b20\u8d39\u8bb0\u5f55\u5220\u9664\u63a5\u53e3\u4e0b\u53d1\u5931\u8d25");
        }
        return ObjectResponse.success();
    }
}

