/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.down.pnc.impl;

import com.icetech.basics.constants.TextConstant;
import com.icetech.basics.domain.entity.RegionChargeconfig;
import com.icetech.basics.domain.entity.park.ParkInoutdevice;
import com.icetech.basics.domain.entity.park.ParkRegion;
import com.icetech.cloudcenter.api.ConfigLssueService;
import com.icetech.cloudcenter.api.DownSendService;
import com.icetech.cloudcenter.api.fee.ChargeService;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.domain.enumeration.DownServiceEnum;
import com.icetech.cloudcenter.domain.request.LssueRequest;
import com.icetech.cloudcenter.domain.request.pnc.ParkRegionRequest;
import com.icetech.common.domain.SendRequest;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.Response;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.factory.SendServiceFactory;
import com.icetech.park.service.handle.PncDownHandle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ConfigLssueServiceImpl
extends AbstractService
implements ConfigLssueService {
    private static final Logger log = LoggerFactory.getLogger(ConfigLssueServiceImpl.class);
    @Autowired
    private PncDownHandle downHandle;
    @Autowired
    private ParkService parkService;
    @Autowired
    private ChargeService chargeService;

    public ObjectResponse Lssue(LssueRequest lssueRequest) {
        ObjectResponse byParkCode = this.parkService.findByParkCode(lssueRequest.getParkcode());
        if (ObjectResponse.isSuccess((Response)byParkCode)) {
            Park park = (Park)byParkCode.getData();
            Integer type = lssueRequest.getType();
            log.info("\u672c\u5730\u62c9\u53d6\u5e73\u53f0\u914d\u7f6e:{}", (Object)lssueRequest);
            if (type == 1) {
                this.lssueRegion(park.getId());
            } else if (type == 2) {
                this.lssueCharge(park.getId());
            } else if (type == 3) {
                this.lssuePassWay(park.getId());
            } else if (type == 4) {
                this.lssueParkConfig(park.getId());
            }
        } else {
            ObjectResponse.failed((String)"410", (String)TextConstant.getDefaultMessage((String)"TWO", (String)"\u8f66\u573a\u7f16\u53f7\u4e0d\u5b58\u5728"));
        }
        return ObjectResponse.success();
    }

    private void lssueRegion(Long parkId) {
        ObjectResponse listObjectResponse = this.parkService.selectRegionById(parkId);
        List regionList = (List)listObjectResponse.getData();
        for (int i = 0; i < regionList.size(); ++i) {
            ParkRegion data = (ParkRegion)regionList.get(i);
            ParkRegionRequest parkRegionRequest = new ParkRegionRequest();
            parkRegionRequest.setRegionCode(data.getRegionCode());
            parkRegionRequest.setRegionName(data.getRegionName());
            parkRegionRequest.setOperType(Integer.valueOf(1));
            if (data.getStatus() == 1) {
                parkRegionRequest.setOperType(Integer.valueOf(3));
            }
            parkRegionRequest.setRegionTotalPark(data.getRegionPark());
            parkRegionRequest.setFreeSpace(data.getFreePark());
            parkRegionRequest.setIsSonRegion(Integer.valueOf(data.getRegionType() == null ? 2 : data.getRegionType()));
            if (data.getFatherRelationId() == 0L) {
                parkRegionRequest.setRegionType(Integer.valueOf(0));
            } else {
                parkRegionRequest.setRegionType(Integer.valueOf(1));
                ObjectResponse parkRegionById1 = this.parkService.getParkRegionById(data.getFatherRelationId());
                if (ObjectResponse.isSuccess((Response)parkRegionById1)) {
                    ParkRegion data1 = (ParkRegion)parkRegionById1.getData();
                    parkRegionRequest.setParentCode(data1.getRegionCode());
                }
            }
            ObjectResponse configs = this.chargeService.getRegionConfigs(parkId);
            if (ObjectResponse.isSuccess((Response)configs)) {
                List list = (List)configs.getData();
                for (int j = 0; j < list.size(); ++j) {
                    RegionChargeconfig parkChargeconfig = (RegionChargeconfig)list.get(j);
                    if (parkChargeconfig.getLicensePlateType() == 3) {
                        parkRegionRequest.setBlueCarBill(parkChargeconfig.getBilltypecode());
                        continue;
                    }
                    if (parkChargeconfig.getLicensePlateType() == 1) {
                        parkRegionRequest.setNewEnergyCarBill(parkChargeconfig.getBilltypecode());
                        continue;
                    }
                    if (parkChargeconfig.getLicensePlateType() != 5) continue;
                    parkRegionRequest.setFixedCarBill(parkChargeconfig.getBilltypecode());
                }
            }
            log.info("<\u7aef\u7f51\u4e91> \u4e0b\u8f7d\u8f66\u573a\u533a\u57df\u4fe1\u606f\uff1a{}", (Object)parkRegionRequest);
            String string = this.downHandle.signAndSend(parkId, DownServiceEnum.\u533a\u57df\u4fe1\u606f\u548c\u8ba1\u8d39\u89c4\u5219\u5173\u8054\u5173\u7cfb.getServiceName(), parkRegionRequest, parkId);
        }
    }

    private void lssueCharge(Long parkId) {
        DownSendService sendService = SendServiceFactory.createSendService(DownServiceEnum.\u8ba1\u8d39\u89c4\u5219.getServiceType());
        SendRequest sendRequest = new SendRequest();
        sendRequest.setParkId(parkId);
        sendRequest.setServiceType(DownServiceEnum.\u8ba1\u8d39\u89c4\u5219.getServiceType());
        sendRequest.setServiceId(parkId);
        sendService.send(sendRequest);
    }

    private void lssuePassWay(Long parkId) {
        DownSendService sendService = SendServiceFactory.createSendService(DownServiceEnum.\u901a\u9053\u4fe1\u606f.getServiceType());
        ArrayList list = new ArrayList();
        try {
            ObjectResponse listResponse1 = this.parkService.getChannelByType(parkId, Integer.valueOf(1));
            ObjectResponse listResponse2 = this.parkService.getChannelByType(parkId, Integer.valueOf(2));
            if (ObjectResponse.isSuccess((Response)listResponse1)) {
                list.addAll((Collection)listResponse1.getData());
            }
            if (ObjectResponse.isSuccess((Response)listResponse2)) {
                list.addAll((Collection)listResponse2.getData());
            }
            for (int i = 0; i < list.size(); ++i) {
                ParkInoutdevice parkInoutdevice = (ParkInoutdevice)list.get(i);
                SendRequest sendRequest = new SendRequest();
                sendRequest.setParkId(parkId);
                sendRequest.setServiceType(DownServiceEnum.\u901a\u9053\u4fe1\u606f.getServiceType());
                sendRequest.setServiceId(parkInoutdevice.getId());
                sendService.send(sendRequest);
                Thread.sleep(1000L);
            }
        }
        catch (Exception e) {
            log.warn(String.valueOf(e.getMessage()), (Throwable)e);
        }
    }

    private void lssueParkConfig(Long parkId) {
        DownSendService sendService = SendServiceFactory.createSendService(DownServiceEnum.\u8f66\u573a\u914d\u7f6e.getServiceType());
        SendRequest sendRequest = new SendRequest();
        sendRequest.setParkId(parkId);
        sendRequest.setServiceType(DownServiceEnum.\u8f66\u573a\u914d\u7f6e.getServiceType());
        sendRequest.setServiceId(parkId);
        sendService.send(sendRequest);
    }
}

