/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.down.pnc.impl;

import com.github.pagehelper.util.StringUtil;
import com.icetech.basics.constants.TextConstant;
import com.icetech.basics.domain.entity.park.ParkChargeconfig;
import com.icetech.cloudcenter.api.DownSendService;
import com.icetech.cloudcenter.api.fee.ChargeService;
import com.icetech.cloudcenter.domain.charge.detail.Charge24HourDetail;
import com.icetech.cloudcenter.domain.charge.detail.ChargeDayNightDetail;
import com.icetech.cloudcenter.domain.charge.detail.ChargeNaturalDayDetail;
import com.icetech.cloudcenter.domain.charge.detail.ChargeTypeDetail;
import com.icetech.cloudcenter.domain.enumeration.DownServiceEnum;
import com.icetech.cloudcenter.domain.enumeration.PncVersionEnum;
import com.icetech.cloudcenter.domain.request.pnc.PncChargeRuleRequest;
import com.icetech.common.domain.SendRequest;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.Response;
import com.icetech.common.exception.ResponseBodyException;
import com.icetech.common.utils.StringUtils;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.handle.PncDownHandle;
import com.icetech.third.utils.RedisUtils;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ChargeRuleServiceImpl
extends AbstractService
implements DownSendService {
    private static final Logger log = LoggerFactory.getLogger(ChargeRuleServiceImpl.class);
    @Autowired
    private PncDownHandle downHandle;
    @Autowired
    private ChargeService chargeService;
    @Autowired
    private RedisUtils redisUtils;

    public ObjectResponse send(SendRequest sendRequest) {
        Long serviceId = sendRequest.getServiceId();
        String billCode = sendRequest.getInclude();
        String version = (String)this.redisUtils.hGet("pnc:version", String.valueOf(sendRequest.getParkId()), String.class);
        if (PncVersionEnum.getIndex((String)version) < PncVersionEnum.getIndex((String)PncVersionEnum.\u7248\u672c4.getVersion())) {
            return ObjectResponse.failed((String)"407", (String)TextConstant.getVersionMessage((String)version, (String)PncVersionEnum.\u7248\u672c4.getVersion()));
        }
        try {
            if (StringUtil.isNotEmpty((String)billCode)) {
                ObjectResponse configsBycode = this.chargeService.getConfigsBycodeWithoutDelFlag(sendRequest.getParkId(), billCode);
                if (ObjectResponse.isSuccess((Response)configsBycode)) {
                    ParkChargeconfig parkChargeconfig = (ParkChargeconfig)configsBycode.getData();
                    PncChargeRuleRequest pncChargeRuleRequest = new PncChargeRuleRequest();
                    if (parkChargeconfig.getStatus() == 1) {
                        pncChargeRuleRequest.setOperType(Integer.valueOf(3));
                        pncChargeRuleRequest.setBilltypecode(billCode);
                        pncChargeRuleRequest.setBilltype(parkChargeconfig.getBilltype());
                    } else {
                        pncChargeRuleRequest = this.buildRequest(parkChargeconfig);
                    }
                    String messageId = this.downHandle.signAndSend(sendRequest.getParkId(), DownServiceEnum.\u8ba1\u8d39\u89c4\u5219.getServiceName(), pncChargeRuleRequest, serviceId);
                    if (StringUtils.isEmpty((CharSequence)messageId)) {
                        return ObjectResponse.failed((String)"410", (String)TextConstant.getUnEstablishConnection());
                    }
                }
            } else {
                ObjectResponse configs = this.chargeService.getConfigs(sendRequest.getParkId());
                if (ObjectResponse.isSuccess((Response)configs)) {
                    List parkChargeconfigList = (List)configs.getData();
                    for (int i = 0; i < parkChargeconfigList.size(); ++i) {
                        ParkChargeconfig parkChargeconfig = (ParkChargeconfig)parkChargeconfigList.get(i);
                        PncChargeRuleRequest pncChargeRuleRequest = this.buildRequest(parkChargeconfig);
                        String messageId = this.downHandle.signAndSend(sendRequest.getParkId(), DownServiceEnum.\u8ba1\u8d39\u89c4\u5219.getServiceName(), pncChargeRuleRequest, serviceId);
                        if (!StringUtils.isEmpty((CharSequence)messageId)) continue;
                        return ObjectResponse.failed((String)"410", (String)TextConstant.getUnEstablishConnection());
                    }
                }
            }
        }
        catch (Exception e) {
            log.warn(String.valueOf(e.getMessage()), (Throwable)e);
            return ObjectResponse.failed((String)"410", (String)TextConstant.getDefaultMessage((String)"2", (String)"\u8ba1\u8d39\u89c4\u5219\u4e0b\u53d1\u5931\u8d25"));
        }
        return ObjectResponse.success();
    }

    /*
     * Enabled aggressive block sorting
     */
    private PncChargeRuleRequest buildRequest(ParkChargeconfig parkChargeconfig) {
        String billCode = parkChargeconfig.getBilltypecode();
        PncChargeRuleRequest pncChargeRuleRequest = new PncChargeRuleRequest();
        pncChargeRuleRequest.setBilltype(parkChargeconfig.getBilltype());
        pncChargeRuleRequest.setBilltypecode(parkChargeconfig.getBilltypecode());
        pncChargeRuleRequest.setIsDefault(parkChargeconfig.getDefaultCharge());
        String name = "";
        if (parkChargeconfig.getBilltype() == ParkChargeconfig.BilltypeEnum.\u901a\u7528\u81ea\u7136\u5929.type) {
            ObjectResponse naturaldayObjectResponse = this.chargeService.getNaturalday(parkChargeconfig.getBilltypecode());
            if (!ObjectResponse.isSuccess((Response)naturaldayObjectResponse)) {
                log.info("<\u7aef\u7f51\u4e91-\u8ba1\u8d39\u89c4\u5219\u4e0b\u53d1> \u6570\u636e\u4e0d\u5b8c\u6574\uff0c\u901a\u7528\u81ea\u7136\u5929\u8ba1\u8d39\u914d\u7f6e\u67e5\u8be2\u5931\u8d25\uff0cbillCode\uff1a{}", (Object)billCode);
                return null;
            }
            ChargeNaturalDayDetail chargeNaturalday = (ChargeNaturalDayDetail)naturaldayObjectResponse.getData();
            name = chargeNaturalday.getBilltypename();
            PncChargeRuleRequest.NaturalDayRule naturalDayRule = new PncChargeRuleRequest.NaturalDayRule();
            BeanUtils.copyProperties((Object)chargeNaturalday, (Object)naturalDayRule);
            naturalDayRule.setOneBillmethod(chargeNaturalday.getBillmethod());
            naturalDayRule.setIsSmallbigcarSet(chargeNaturalday.getIsSmallbigcarSet());
            naturalDayRule.setDaynightmaxfeetype(chargeNaturalday.getMaxFeeType());
            naturalDayRule.setDaynightmaxfeecounttype(chargeNaturalday.getCountType());
            naturalDayRule.setFirstConfig(this.onceDyrationDetail(chargeNaturalday.getWorkdayDetail()));
            if (chargeNaturalday.getIsspecialdaycharge() == 1) {
                naturalDayRule.setTwoBillmethod(chargeNaturalday.getNoworkBillmethod());
                naturalDayRule.setTwoConfig(this.onceDyrationDetail(chargeNaturalday.getHolidayDetail()));
            }
            pncChargeRuleRequest.setChargeRule((Object)naturalDayRule);
        } else if (parkChargeconfig.getBilltype() == ParkChargeconfig.BilltypeEnum.\u767d\u5929\u591c\u95f4\u6536\u8d39.type) {
            ObjectResponse chargeDaynightObjectResponse = this.chargeService.getDaynight(parkChargeconfig.getBilltypecode());
            if (!ObjectResponse.isSuccess((Response)chargeDaynightObjectResponse)) {
                log.info("<\u7aef\u7f51\u4e91-\u8ba1\u8d39\u89c4\u5219\u4e0b\u53d1> \u6570\u636e\u4e0d\u5b8c\u6574\uff0c\u767d\u5929\u591c\u95f4\u8ba1\u8d39\u914d\u7f6e\u67e5\u8be2\u5931\u8d25\uff0cbillCode\uff1a{}", (Object)billCode);
                return null;
            }
            ChargeDayNightDetail chargeDaynight = (ChargeDayNightDetail)chargeDaynightObjectResponse.getData();
            name = chargeDaynight.getBilltypename();
            PncChargeRuleRequest.DayNightRule dayNightRule = new PncChargeRuleRequest.DayNightRule();
            BeanUtils.copyProperties((Object)chargeDaynight, (Object)dayNightRule);
            dayNightRule.setDayBillmethod(chargeDaynight.getBillmethodday());
            dayNightRule.setNightBillmethod(chargeDaynight.getBillmethodnight());
            dayNightRule.setIsSmallbigcarSet(chargeDaynight.getIsSmallbigcarSet());
            dayNightRule.setDaynightmaxfeetype(chargeDaynight.getMaxFeeType());
            dayNightRule.setDaynightmaxfeecounttype(chargeDaynight.getCountType());
            dayNightRule.setDayConfig(this.onceDyrationDetail(chargeDaynight.getDailyDetail()));
            dayNightRule.setNightConfig(this.onceDyrationDetail(chargeDaynight.getNightlyDetail()));
            pncChargeRuleRequest.setChargeRule((Object)dayNightRule);
        } else if (parkChargeconfig.getBilltype() == ParkChargeconfig.BilltypeEnum.\u4e8c\u5341\u56db\u5c0f\u65f6\u8ba1\u8d39.type) {
            ObjectResponse charge24chargeObjectResponse = this.chargeService.get24Hours(parkChargeconfig.getBilltypecode());
            if (!ObjectResponse.isSuccess((Response)charge24chargeObjectResponse)) {
                log.info("<\u7aef\u7f51\u4e91-\u8ba1\u8d39\u89c4\u5219\u4e0b\u53d1> \u6570\u636e\u4e0d\u5b8c\u6574\uff0c24\u5c0f\u65f6\u8ba1\u8d39\u914d\u7f6e\u67e5\u8be2\u5931\u8d25\uff0cbillCode\uff1a{}", (Object)billCode);
                return null;
            }
            Charge24HourDetail charge24charge = (Charge24HourDetail)charge24chargeObjectResponse.getData();
            name = charge24charge.getBilltypename();
            PncChargeRuleRequest.Charge24Rule charge24Rule = new PncChargeRuleRequest.Charge24Rule();
            BeanUtils.copyProperties((Object)charge24charge, (Object)charge24Rule);
            charge24Rule.setIsSmallbigcarSet(charge24charge.getIsSmallbigcarSet());
            charge24Rule.setDaynightmaxfeetype(charge24charge.getMaxFeeType());
            charge24Rule.setDaynightmaxfeecounttype(charge24charge.getCountType());
            if (!CollectionUtils.isNotEmpty((Collection)charge24charge.getChargeDetails())) {
                log.info("<\u7aef\u7f51\u4e91-\u8ba1\u8d39\u89c4\u5219\u4e0b\u53d1> \u6570\u636e\u4e0d\u5b8c\u6574\uff0c24\u5c0f\u65f6\u8ba1\u8d39\u914d\u7f6e\u67e5\u8be2\u5931\u8d25\uff0cbillCode\uff1a{}", (Object)billCode);
                return null;
            }
            List charge24RuleDetails = charge24charge.getChargeDetails().stream().map(charge24chargeSet -> {
                PncChargeRuleRequest.Charge24RuleDetail charge24RuleDetail = new PncChargeRuleRequest.Charge24RuleDetail();
                charge24RuleDetail.setFeespantime(charge24chargeSet.getFeespantime());
                charge24RuleDetail.setFeespanrate(charge24chargeSet.getFeespanrate());
                charge24RuleDetail.setFeespanrateBig(charge24chargeSet.getFeespanrateBig());
                int recordStatus = charge24chargeSet.getFeespantime() % charge24charge.getDivisionTime() == 0 ? 1 : 0;
                charge24RuleDetail.setRecordStatus(Integer.valueOf(recordStatus));
                return charge24RuleDetail;
            }).collect(Collectors.toList());
            charge24Rule.setDetails(charge24RuleDetails);
            pncChargeRuleRequest.setChargeRule((Object)charge24Rule);
        }
        pncChargeRuleRequest.setBilltypename(name);
        return pncChargeRuleRequest;
    }

    private Object onceDyrationDetail(ChargeTypeDetail typeDetail) {
        if (typeDetail.getChargeType() == 1) {
            PncChargeRuleRequest.ChargeOnce chargeOnceVo = new PncChargeRuleRequest.ChargeOnce();
            if (typeDetail.getOnce() != null) {
                BeanUtils.copyProperties((Object)typeDetail.getOnce(), (Object)chargeOnceVo);
                return chargeOnceVo;
            }
            log.info("<\u7aef\u7f51\u4e91-\u8ba1\u8d39\u89c4\u5219\u4e0b\u53d1> \u6570\u636e\u4e0d\u5b8c\u6574\uff0c\u901a\u7528\u81ea\u7136\u5929\u6309\u6b21\u8ba1\u8d39\u67e5\u8be2\u5931\u8d25");
            throw new ResponseBodyException("404", "\u901a\u7528\u81ea\u7136\u5929\u6309\u6b21\u8ba1\u8d39\u67e5\u8be2\u5931\u8d25");
        }
        PncChargeRuleRequest.ChargeDyration chargeDyrationVo = new PncChargeRuleRequest.ChargeDyration();
        if (typeDetail.getDuration() != null) {
            BeanUtils.copyProperties((Object)typeDetail.getDuration(), (Object)chargeDyrationVo);
        }
        if (!CollectionUtils.isNotEmpty((Collection)typeDetail.getPeriodDurations())) {
            log.info("<\u7aef\u7f51\u4e91-\u8ba1\u8d39\u89c4\u5219\u4e0b\u53d1> \u6570\u636e\u4e0d\u5b8c\u6574\uff0c\u6309\u65f6\u957f\u8ba1\u8d39\u914d\u7f6e\u67e5\u8be2\u5931\u8d25");
            throw new ResponseBodyException("404", "\u6309\u65f6\u957f\u8ba1\u8d39\u914d\u7f6e\u67e5\u8be2\u5931\u8d25");
        }
        List stepChargeDetailList = typeDetail.getPeriodDurations().stream().map(duration -> {
            PncChargeRuleRequest.StepChargeDetail stepChargeDetail = new PncChargeRuleRequest.StepChargeDetail();
            BeanUtils.copyProperties((Object)duration, (Object)stepChargeDetail);
            return stepChargeDetail;
        }).collect(Collectors.toList());
        chargeDyrationVo.setStepChargeDetails(stepChargeDetailList);
        return chargeDyrationVo;
    }
}

