/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.down.pnc.impl;

import com.icetech.cloudcenter.api.NotifyService;
import com.icetech.cloudcenter.api.order.OrderService;
import com.icetech.cloudcenter.domain.enumeration.DataCollectionEnum;
import com.icetech.cloudcenter.domain.enumeration.DownServiceEnum;
import com.icetech.cloudcenter.domain.enumeration.EnexTypeEnum;
import com.icetech.cloudcenter.domain.request.CarEnterRequest;
import com.icetech.cloudcenter.domain.request.CarExitRequest;
import com.icetech.cloudcenter.domain.response.EnterCarInfoResponse;
import com.icetech.cloudcenter.domain.response.ExitCarInfoResponse;
import com.icetech.cloudcenter.domain.response.pnc.ChannelDataResponse;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.exception.ResponseBodyException;
import com.icetech.common.utils.CodeTools;
import com.icetech.common.utils.JsonUtils;
import com.icetech.common.utils.StringUtils;
import com.icetech.order.domain.entity.OrderInfo;
import com.icetech.oss.OssService;
import com.icetech.park.component.AsyncNotifyClient;
import com.icetech.park.handle.CacheHandle;
import com.icetech.park.service.handle.PncDownHandle;
import com.icetech.park.service.handle.PublicHandle;
import com.icetech.third.domain.entity.third.SendInfoRecord;
import com.icetech.third.utils.RedisUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ChannelDataServiceImpl
implements NotifyService<Map<String, Object>> {
    private static final Logger log = LoggerFactory.getLogger(ChannelDataServiceImpl.class);
    @Autowired
    private PncDownHandle downHandle;
    @Autowired
    private PublicHandle publicHandle;
    @Autowired
    private RedisUtils redisUtils;
    @Autowired
    private OssService ossService;
    @Autowired
    private OrderService orderService;
    @Resource
    private AsyncNotifyClient asyncNotifyClient;
    @Autowired
    private CacheHandle cacheHandle;

    public ObjectResponse<Void> execute(String channelId, String parkCode, String key, Long parkId, int dataType, String topic, Integer type) {
        HashMap<String, Object> paraMap = new HashMap<String, Object>();
        paraMap.put("channelId", channelId);
        paraMap.put("dataType", dataType);
        String messageId = this.downHandle.signAndSendAsyncResult(parkId, parkCode, key, DownServiceEnum.\u5b9e\u65f6\u901a\u9053\u6570\u636e.getServiceName(), paraMap, topic, String.valueOf(type));
        if (messageId == null) {
            return ObjectResponse.failed((String)"3005");
        }
        return ObjectResponse.failed((String)"12002", (String)messageId);
    }

    public void notify(String messageId, ObjectResponse<String> response, SendInfoRecord<Map<String, Object>> sendInfoRecord) {
        Integer type = Integer.valueOf(sendInfoRecord.getExtraInfo());
        if (ObjectResponse.isSuccess(response)) {
            EnterCarInfoResponse enexCarInfoBaseResponse;
            ChannelDataResponse channelDataResponse = (ChannelDataResponse)JsonUtils.parseObject((String)((String)response.getData()), ChannelDataResponse.class, (Class[])new Class[0]);
            if ("\u65e0\u724c\u8f66".equals(channelDataResponse.getPlateNum())) {
                channelDataResponse.setPlateNum(null);
            }
            if (channelDataResponse.getImage() == null) {
                String imgFileName = (String)this.redisUtils.get("PNC_FILEID_PROFILE_" + sendInfoRecord.getParkCode() + messageId, String.class);
                channelDataResponse.setImage(imgFileName);
            }
            ChannelDataResponse data = (ChannelDataResponse)JsonUtils.parseObject((String)((String)response.getData()), ChannelDataResponse.class, (Class[])new Class[0]);
            if (type.equals(EnexTypeEnum.\u5165\u573a.getType())) {
                CarEnterRequest entrace = new CarEnterRequest();
                BeanUtils.copyProperties((Object)data, (Object)entrace);
                entrace.setOrderNum(CodeTools.GenerateOrderNum());
                entrace.setMaxImage(data.getImage());
                if (data.getTime() != 0xFFFFFFFFL) {
                    entrace.setEnterTime(data.getTime());
                }
                enexCarInfoBaseResponse = this.getEntraceCarInfoResponse(entrace);
            } else {
                CarExitRequest exit = new CarExitRequest();
                BeanUtils.copyProperties((Object)data, (Object)exit);
                if (data.getOrderId() != null) {
                    try {
                        String orderNum = this.publicHandle.convert2OrderNum(sendInfoRecord.getParkId(), data.getOrderId());
                        exit.setOrderNum(orderNum);
                    }
                    catch (ResponseBodyException e) {
                        log.warn("[\u7aef\u7f51\u4e91\u5b9e\u65f6\u901a\u9053] \u672c\u5730\u8ba2\u5355\u53f7\u8f6c\u5e73\u53f0\u8ba2\u5355\u53f7\u5931\u8d25, \u7591\u4f3c\u65e0\u5165\u573a\u8bb0\u5f55, orderId[{}]", (Object)data.getOrderId());
                    }
                }
                exit.setMaxImage(data.getImage());
                if (data.getTime() != 0xFFFFFFFFL) {
                    exit.setExitTime(data.getTime());
                }
                enexCarInfoBaseResponse = this.getExitCarInfoResponse(sendInfoRecord.getParkId(), sendInfoRecord.getParkCode(), exit, data.getOrderId());
            }
            enexCarInfoBaseResponse.setDataCollection(DataCollectionEnum.\u7aef\u7f51\u4e91.getType());
            this.cacheHandle.setSoftImage(messageId, data.getImage());
            this.asyncNotifyClient.callBack(messageId, sendInfoRecord.getTopic(), sendInfoRecord.getEnv(), ObjectResponse.success((Object)enexCarInfoBaseResponse));
        } else {
            this.asyncNotifyClient.callBack(messageId, sendInfoRecord.getTopic(), sendInfoRecord.getEnv(), ObjectResponse.failed((String)"3005", (String)"\u6536\u8d39\u7cfb\u7edf\u54cd\u5e94\u9519\u8bef"));
        }
    }

    private EnterCarInfoResponse getEntraceCarInfoResponse(CarEnterRequest entrace) {
        EnterCarInfoResponse enterCarInfoResponse = new EnterCarInfoResponse();
        enterCarInfoResponse.setEnterNum(entrace.getPlateNum());
        enterCarInfoResponse.setCarType(entrace.getCarType());
        enterCarInfoResponse.setType(entrace.getType());
        enterCarInfoResponse.setOrderNum(entrace.getOrderNum());
        String maxImage = entrace.getMaxImage();
        if (maxImage != null) {
            enterCarInfoResponse.setImgUrl(this.ossService.getImageUrl(maxImage));
            enterCarInfoResponse.setImgPath(maxImage);
        }
        return enterCarInfoResponse;
    }

    protected ExitCarInfoResponse getExitCarInfoResponse(Long parkId, String parkCode, CarExitRequest carExitRequest, String localOrderNum) {
        ObjectResponse byOrderInfo;
        ExitCarInfoResponse exitCarInfoResponse = new ExitCarInfoResponse();
        String orderNum = carExitRequest.getOrderNum();
        exitCarInfoResponse.setExitNum(carExitRequest.getPlateNum());
        exitCarInfoResponse.setCarType(carExitRequest.getCarType());
        exitCarInfoResponse.setType(carExitRequest.getType());
        if (StringUtils.isNotBlank((CharSequence)orderNum)) {
            OrderInfo orderInfo = new OrderInfo();
            orderInfo.setOrderNum(orderNum);
            orderInfo.setParkId(parkId);
            byOrderInfo = this.orderService.findByOrderInfo(orderInfo);
            if (byOrderInfo.getCode().equals("200")) {
                OrderInfo data = (OrderInfo)byOrderInfo.getData();
                exitCarInfoResponse.setEnterTime(new Date(data.getEnterTime() * 1000L));
                exitCarInfoResponse.setEnterNum(data.getPlateNum());
                exitCarInfoResponse.setLocalOrderNum(data.getLocalOrderNum());
                exitCarInfoResponse.setNoneEnterFlag(data.getNoneEnterFlag());
            }
            exitCarInfoResponse.setOrderNum(carExitRequest.getOrderNum());
        } else {
            String plateNum = carExitRequest.getPlateNum();
            byOrderInfo = this.orderService.findInPark(plateNum, parkCode);
            if (byOrderInfo.getCode().equals("200")) {
                OrderInfo data = (OrderInfo)byOrderInfo.getData();
                exitCarInfoResponse.setEnterTime(new Date(data.getEnterTime() * 1000L));
                exitCarInfoResponse.setEnterNum(data.getPlateNum());
                exitCarInfoResponse.setOrderNum(data.getOrderNum());
                exitCarInfoResponse.setLocalOrderNum(data.getLocalOrderNum());
                exitCarInfoResponse.setNoneEnterFlag(data.getNoneEnterFlag());
            }
        }
        Long exitTime = carExitRequest.getExitTime();
        if (exitTime != null) {
            exitCarInfoResponse.setExitTime(new Date(exitTime * 1000L));
        } else {
            exitCarInfoResponse.setExitTime(new Date());
        }
        String maxImage = carExitRequest.getMaxImage();
        if (maxImage != null) {
            exitCarInfoResponse.setImgUrl(this.ossService.getImageUrl(maxImage));
            exitCarInfoResponse.setImgPath(maxImage);
        }
        if (exitCarInfoResponse.getOrderNum() == null && localOrderNum != null) {
            exitCarInfoResponse.setLocalOrderNum(localOrderNum);
            exitCarInfoResponse.setNoneEnterFlag(Integer.valueOf(1));
        }
        return exitCarInfoResponse;
    }
}

