/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.down.pnc.impl;

import com.icetech.basics.constants.TextConstant;
import com.icetech.basics.domain.SendMessage;
import com.icetech.cloudcenter.domain.enumeration.DownServiceEnum;
import com.icetech.cloudcenter.domain.request.pnc.CardPauseRecoverRequest;
import com.icetech.common.domain.SendRequest;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.exception.ResponseBodyException;
import com.icetech.common.utils.DateTools;
import com.icetech.common.utils.StringUtils;
import com.icetech.fee.dao.monthcar.MonthRecordDao;
import com.icetech.fee.domain.entity.monthcar.MonthRecord;
import com.icetech.park.service.handle.PncDownHandle;
import com.icetech.third.utils.JsonUtils;
import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CardPauseRecoverServiceImpl {
    private static final Logger log = LoggerFactory.getLogger(CardPauseRecoverServiceImpl.class);
    @Autowired
    private PncDownHandle downHandle;
    @Autowired
    private MonthRecordDao monthRecordDao;
    private static final int BEFORE_TIME = 300;
    private static final int RECOVER = 8;

    public ObjectResponse send(Long serviceId, MonthRecord monthRecord) {
        SendMessage sendMessage = SendMessage.builder().type("2").build();
        if (monthRecord.getCardstopStart() == null) {
            throw new ResponseBodyException("410", TextConstant.getDefaultMessage((String)"1", (String)"\u6708\u5361\u6682\u505c\u5b9e\u9645\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a"));
        }
        long pauseStartTime = monthRecord.getCardstopStart().getTime() / 1000L;
        if (pauseStartTime > DateTools.unixTimestamp()) {
            log.info("<\u7aef\u7f51\u4e91-\u6708\u5361\u6682\u505c\u6062\u590d\u4e0b\u53d1> \u672a\u5230\u6682\u505c\u5f00\u59cb\u65f6\u95f4\uff0c\u5ef6\u8fdf\u4e0b\u53d1\uff0c\u53c2\u6570:{}", (Object)monthRecord);
            Integer fireTime = (int)pauseStartTime - 300;
            sendMessage.setDescribes(Collections.singletonList(SendMessage.Describe.builder().failType("10000").fixedDisplay("\u6708\u5361\u672a\u5230\u6682\u505c\u5f00\u59cb\u65f6\u95f4").build()));
            return ObjectResponse.instance((String)"407", (String)JsonUtils.toJson((Object)sendMessage), (Object)fireTime);
        }
        CardPauseRecoverRequest cardPauseRecoverRequest = this.buildRequest(monthRecord);
        String messageId = this.downHandle.signAndSend(monthRecord.getParkId(), DownServiceEnum.\u6708\u5361\u6682\u505c\u6062\u590d.getServiceName(), cardPauseRecoverRequest, serviceId);
        sendMessage.setDescribes(Collections.singletonList(SendMessage.Describe.builder().failType("10006").build()));
        if (StringUtils.isEmpty((CharSequence)messageId)) {
            return ObjectResponse.failed((String)"410", (String)JsonUtils.toJson((Object)sendMessage));
        }
        return ObjectResponse.success();
    }

    public ObjectResponse send(SendRequest sendRequest) {
        Long serviceId = sendRequest.getServiceId();
        MonthRecord monthRecord = (MonthRecord)this.monthRecordDao.selectById((Serializable)serviceId);
        return this.send(serviceId, monthRecord);
    }

    private CardPauseRecoverRequest buildRequest(MonthRecord monthRecord) {
        CardPauseRecoverRequest cardPauseRecoverRequest = new CardPauseRecoverRequest();
        cardPauseRecoverRequest.setCardId(String.valueOf(monthRecord.getMonthId()));
        cardPauseRecoverRequest.setCardOperType(monthRecord.getCardOpertype());
        cardPauseRecoverRequest.setStartDate(DateFormatUtils.format((Date)monthRecord.getCardstopStart(), (String)"yyyy-MM-dd"));
        cardPauseRecoverRequest.setEndDate(DateFormatUtils.format((Date)monthRecord.getCardstopEnd(), (String)"yyyy-MM-dd"));
        if (monthRecord.getCardOpertype() == 8) {
            cardPauseRecoverRequest.setMonthEndDate(DateFormatUtils.format((Date)monthRecord.getEndTime(), (String)"yyyy-MM-dd"));
            cardPauseRecoverRequest.setEndDate(DateFormatUtils.format((Date)monthRecord.getCardstopRealyend(), (String)"yyyy-MM-dd"));
        }
        cardPauseRecoverRequest.setOperAccount(monthRecord.getOperAccount());
        cardPauseRecoverRequest.setOperTime(Long.valueOf(monthRecord.getCreateTime().getTime() / 1000L));
        return cardPauseRecoverRequest;
    }
}

