/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.down.pnc.impl;

import com.icetech.basics.api.BlacklistService;
import com.icetech.basics.constants.TextConstant;
import com.icetech.basics.domain.entity.Blacklist;
import com.icetech.cloudcenter.api.DownSendService;
import com.icetech.cloudcenter.domain.enumeration.DownServiceEnum;
import com.icetech.cloudcenter.domain.request.pnc.BatchDelBizRequest;
import com.icetech.cloudcenter.domain.request.pnc.BlwhlistRequest;
import com.icetech.common.domain.SendRequest;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.Response;
import com.icetech.common.exception.ResponseBodyException;
import com.icetech.common.utils.DateTools;
import com.icetech.common.utils.StringUtils;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.handle.PncDownHandle;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BlwhlistServiceImpl
extends AbstractService
implements DownSendService {
    @Autowired
    private PncDownHandle downHandle;
    @Autowired
    private BlacklistService blacklistService;
    private static final long DEFAULT_END_TIME = 4102329600L;

    public ObjectResponse send(SendRequest sendRequest) {
        Long serviceId = sendRequest.getServiceId();
        ObjectResponse blacklistResponse = this.blacklistService.getById(serviceId);
        if (!ObjectResponse.isSuccess((Response)blacklistResponse)) {
            return ObjectResponse.failed((String)"410", (String)TextConstant.getDefaultMessage((String)"2", (String)"\u9ed1\u540d\u5355\u6570\u636e\u4e0d\u5b58\u5728"));
        }
        Blacklist blacklist = (Blacklist)blacklistResponse.getData();
        BlwhlistRequest blwhlistRequest = new BlwhlistRequest();
        blwhlistRequest.setId(blacklist.getId());
        blwhlistRequest.setType(Integer.valueOf(0));
        Integer status = blacklist.getStatus();
        Integer type = blacklist.getType();
        if (status.equals(1)) {
            blwhlistRequest.setStatus(Integer.valueOf(9));
        } else if (type.equals(3)) {
            blwhlistRequest.setStatus(Integer.valueOf(0));
        } else {
            blwhlistRequest.setStatus(Integer.valueOf(1));
        }
        blwhlistRequest.setPlateNum(blacklist.getPlate());
        blwhlistRequest.setStartTime(Long.valueOf(DateTools.getParse((String)"yyyy-MM-dd HH:mm:ss", (String)blacklist.getCreateTime()).getTime() / 1000L));
        blwhlistRequest.setEndTime(Long.valueOf(4102329600L));
        String messageId = this.downHandle.signAndSend(sendRequest.getParkId(), DownServiceEnum.\u9ed1\u767d\u540d\u5355\u4e0b\u53d1.getServiceName(), blwhlistRequest, serviceId);
        if (StringUtils.isEmpty((CharSequence)messageId)) {
            return ObjectResponse.failed((String)"410", (String)TextConstant.getUnEstablishConnection());
        }
        return ObjectResponse.success();
    }

    public ObjectResponse batchSend(List<SendRequest> sendRequestList, Long parkId, String parkCode) {
        List ids = sendRequestList.stream().map(SendRequest::getServiceId).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(ids)) {
            return ObjectResponse.failed((String)"402");
        }
        BatchDelBizRequest batchDelBizRequest = new BatchDelBizRequest();
        batchDelBizRequest.setServiceType(Integer.valueOf(6));
        batchDelBizRequest.setIdList(ids.stream().map(Object::toString).collect(Collectors.toList()));
        batchDelBizRequest.setServiceIds(ids);
        String messageId = this.downHandle.signAndSend(parkId, DownServiceEnum.\u6279\u91cf\u5220\u9664\u4e1a\u52a1\u6570\u636e.getServiceName(), batchDelBizRequest);
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)messageId)) {
            throw new ResponseBodyException("500", "\u4e0b\u53d1\u5931\u8d25");
        }
        return ObjectResponse.success();
    }
}

