/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.down.pnc.impl;

import com.icetech.basics.api.BlacklistService;
import com.icetech.basics.constants.TextConstant;
import com.icetech.basics.domain.entity.Blacklist;
import com.icetech.cloudcenter.api.DownSendService;
import com.icetech.cloudcenter.domain.enumeration.DownServiceEnum;
import com.icetech.cloudcenter.domain.enumeration.PncVersionEnum;
import com.icetech.cloudcenter.domain.request.pnc.BatchDelBizRequest;
import com.icetech.cloudcenter.domain.request.pnc.PncBlacklistRequest;
import com.icetech.common.domain.SendRequest;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.Response;
import com.icetech.common.exception.ResponseBodyException;
import com.icetech.common.utils.StringUtils;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.down.pnc.impl.BlwhlistServiceImpl;
import com.icetech.park.service.handle.PncDownHandle;
import com.icetech.third.utils.RedisUtils;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BlacklistServiceImpl
extends AbstractService
implements DownSendService {
    private static final Logger log = LoggerFactory.getLogger(BlacklistServiceImpl.class);
    @Autowired
    private PncDownHandle downHandle;
    @Autowired
    private BlacklistService blacklistService;
    @Autowired
    private BlwhlistServiceImpl blwhlistService;
    @Autowired
    private RedisUtils redisUtils;

    public ObjectResponse send(SendRequest sendRequest) {
        Long serviceId = sendRequest.getServiceId();
        String version = (String)this.redisUtils.hGet("pnc:version", String.valueOf(sendRequest.getParkId()), String.class);
        log.info("\u7248\u672c[{}]", (Object)version);
        if (PncVersionEnum.\u7248\u672cFS.getVersion().equals(version)) {
            log.info("\u9ed1\u767d\u540d\u5355\u4e0b\u53d1[{}]", (Object)sendRequest);
            return this.blwhlistService.send(sendRequest);
        }
        ObjectResponse blacklistResponse = this.blacklistService.getById(serviceId);
        if (!ObjectResponse.isSuccess((Response)blacklistResponse)) {
            return ObjectResponse.failed((String)"410", (String)TextConstant.getDefaultMessage((String)"2", (String)"\u9ed1\u540d\u5355\u6570\u636e\u4e0d\u5b58\u5728"));
        }
        Blacklist blacklist = (Blacklist)blacklistResponse.getData();
        PncBlacklistRequest blacklistRequest = new PncBlacklistRequest();
        blacklistRequest.setBlackId(blacklist.getId());
        Integer status = blacklist.getStatus();
        if (status.equals(1)) {
            blacklistRequest.setType(Integer.valueOf(3));
        } else {
            blacklistRequest.setType(blacklist.getType());
        }
        blacklistRequest.setPlateNum(blacklist.getPlate());
        String messageId = this.downHandle.signAndSend(sendRequest.getParkId(), DownServiceEnum.\u9ed1\u540d\u5355\u4e0b\u53d1.getServiceName(), blacklistRequest, serviceId);
        if (StringUtils.isEmpty((CharSequence)messageId)) {
            return ObjectResponse.failed((String)"410", (String)TextConstant.getUnEstablishConnection());
        }
        return ObjectResponse.success();
    }

    public ObjectResponse batchSend(List<SendRequest> sendRequestList, Long parkId, String parkCode) {
        String version = (String)this.redisUtils.hGet("pnc:version", String.valueOf(parkId), String.class);
        if (PncVersionEnum.\u7248\u672cFS.getVersion().equals(version)) {
            return this.blwhlistService.batchSend(sendRequestList, parkId, parkCode);
        }
        List ids = sendRequestList.stream().map(SendRequest::getServiceId).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(ids)) {
            return ObjectResponse.failed((String)"402");
        }
        BatchDelBizRequest batchDelBizRequest = new BatchDelBizRequest();
        batchDelBizRequest.setServiceType(Integer.valueOf(6));
        batchDelBizRequest.setIdList(ids.stream().map(Object::toString).collect(Collectors.toList()));
        batchDelBizRequest.setServiceIds(ids);
        String messageId = this.downHandle.signAndSend(parkId, DownServiceEnum.\u6279\u91cf\u5220\u9664\u4e1a\u52a1\u6570\u636e.getServiceName(), batchDelBizRequest);
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)messageId)) {
            throw new ResponseBodyException("500", "\u4e0b\u53d1\u5931\u8d25");
        }
        return ObjectResponse.success();
    }
}

