/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.down.pnc.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.icetech.basics.constants.TextConstant;
import com.icetech.cloudcenter.api.third.SendInfoService;
import com.icetech.cloudcenter.domain.enumeration.DownServiceEnum;
import com.icetech.cloudcenter.domain.request.pnc.BatchDelBizRequest;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.Response;
import com.icetech.common.utils.AssertTools;
import com.icetech.common.utils.JsonUtils;
import com.icetech.common.utils.NumberUtils;
import com.icetech.common.utils.StringUtils;
import com.icetech.fee.dao.monthcar.MonthRecordDao;
import com.icetech.fee.domain.entity.monthcar.MonthRecord;
import com.icetech.park.service.handle.PncDownHandle;
import com.icetech.third.domain.entity.third.SendInfo;
import com.icetech.third.domain.entity.third.SendInfoRecord;
import java.util.Collection;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BatchDelBizServiceImpl {
    @Autowired
    private PncDownHandle downHandle;
    @Autowired
    private SendInfoService sendInfoService;
    @Autowired
    private MonthRecordDao monthRecordDao;

    public ObjectResponse batchSend(BatchDelBizRequest batchDelBizRequest, Long parkId) {
        String messageId = this.downHandle.signAndSend(parkId, DownServiceEnum.\u6279\u91cf\u5220\u9664\u4e1a\u52a1\u6570\u636e.getServiceName(), batchDelBizRequest);
        AssertTools.notNull((Object)messageId, (String)"500", (String)"\u4e0b\u53d1\u5931\u8d25");
        return ObjectResponse.success();
    }

    public ObjectResponse delResponse(SendInfoRecord sendinfoRecord, ObjectResponse retResponse) {
        BatchDelBizRequest batchDelBizRequest = (BatchDelBizRequest)JsonUtils.parseObject((String)JsonUtils.toString((Object)sendinfoRecord.getParams()), BatchDelBizRequest.class, (Class[])new Class[0]);
        if (batchDelBizRequest == null) {
            return ObjectResponse.failed((String)"\u6279\u91cf\u5220\u9664\u4e1a\u52a1\u6570\u636e\u54cd\u5e94\u5904\u7406\u5931\u8d25");
        }
        int serviceType = NumberUtils.toPrimitive((Integer)batchDelBizRequest.getServiceType());
        if (serviceType == 1) {
            serviceType = DownServiceEnum.\u8ba2\u5355\u4fee\u6539.getServiceType();
        } else if (serviceType == 2) {
            serviceType = DownServiceEnum.\u6708\u5361.getServiceType();
            LambdaUpdateWrapper updateWrapper = Wrappers.lambdaUpdate();
            updateWrapper.in(MonthRecord::getId, (Collection)batchDelBizRequest.getServiceIds());
            MonthRecord monthRecord = new MonthRecord();
            monthRecord.setSendStatus(Integer.valueOf(ObjectResponse.isSuccess((Response)retResponse) ? SendInfo.StatusEnum._SUCCESS.getCode() : SendInfo.StatusEnum._FAIL.getCode()));
            this.monthRecordDao.update((Object)monthRecord, (Wrapper)updateWrapper);
        } else if (serviceType == 3) {
            serviceType = DownServiceEnum.VIP\u8f66\u8f86\u4fe1\u606f.getServiceType();
        } else if (serviceType == 5) {
            serviceType = DownServiceEnum.\u8f66\u8f86\u9884\u7ea6.getServiceType();
        }
        if (ObjectResponse.isSuccess((Response)retResponse)) {
            this.sendInfoService.updateSuccessByServiceIds(batchDelBizRequest.getServiceIds(), Integer.valueOf(serviceType), TextConstant.getSuccessDefaultMessage((String)"2"));
        } else {
            this.sendInfoService.updateFailByServiceIds(batchDelBizRequest.getServiceIds(), Integer.valueOf(serviceType), TextConstant.getDefaultMessage((String)"2", (String)(StringUtils.isBlank((CharSequence)retResponse.getMsg()) ? "\u672a\u77e5\u9519\u8bef" : retResponse.getMsg())));
        }
        return ObjectResponse.success();
    }
}

