/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.down.p2r.impl;

import com.icetech.cloudcenter.domain.enumeration.P2rCmdEnum;
import com.icetech.cloudcenter.domain.request.p2r.PrintInfoRequest;
import com.icetech.common.constants.LogWarnTypeEnum;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.utils.StringUtils;
import com.icetech.park.service.handle.P2rMsgHandle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="p2rPrintInfoServiceImpl")
public class PrintInfoServiceImpl {
    private static final Logger log = LoggerFactory.getLogger(PrintInfoServiceImpl.class);
    @Autowired
    private P2rMsgHandle p2rMsgHandle;
    @Value(value="${web.url}")
    private String webUrl;

    public ObjectResponse downRedpack(String parkCode, String preId, Long parkId, String serialNumber, String orderNum) {
        PrintInfoRequest printInfoRequest = new PrintInfoRequest();
        printInfoRequest.setOrderNum(orderNum);
        printInfoRequest.setHeadMsg("\u5fae\u4fe1\u626b\u7801\u7535\u5b50\u7ea2\u5305\u627e\u96f6");
        printInfoRequest.setBottomMsg("\u63d0\u793a\uff1a\u627e\u96f6\u7ea2\u5305\u8bf7\u572824\u5c0f\u65f6\u5185\u9886\u53d6");
        printInfoRequest.setQrCodeUrl(this.webUrl + "/redpack/s?parkCode=" + parkCode + "&preId=" + preId);
        String messageId = this.p2rMsgHandle.send(parkId, serialNumber, P2rCmdEnum.\u6253\u5370\u673a\u4fe1\u606f\u4e0b\u53d1.getCmdType(), printInfoRequest);
        if (StringUtils.isNotBlank((CharSequence)messageId)) {
            log.info("[\u673a\u5668\u4eba\u8bed\u97f3\u5c4f\u663e\u4e0b\u53d1] \u6d88\u606fID\uff1a{}\uff0c\u54cd\u5e94\u6210\u529f", (Object)messageId);
            return ObjectResponse.success();
        }
        log.warn("[\u76d1\u63a7\u57cb\u70b9] alarmType:[{}],keyword1:[{}],keyword2:[{}]", new Object[]{LogWarnTypeEnum.\u673a\u5668\u4eba\u4e1a\u52a1\u5904\u7406\u5931\u8d25.name() + "-\u6253\u5370\u4fe1\u606f\u4e0b\u53d1", messageId + ", " + parkCode + ", " + printInfoRequest, null});
        return ObjectResponse.failed((String)"3003");
    }
}

