/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.down.p2c.impl;

import cn.hutool.core.thread.ThreadUtil;
import com.icetech.basics.constants.TextConstant;
import com.icetech.basics.domain.entity.park.ParkConfig;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.api.park.ParkVisitService;
import com.icetech.cloudcenter.domain.enumeration.P2cDownCmdEnum;
import com.icetech.cloudcenter.domain.request.p2c.ClearListRequest;
import com.icetech.cloudcenter.domain.request.p2c.QueryListRequest;
import com.icetech.cloudcenter.domain.request.p2c.VisitCardRequest;
import com.icetech.cloudcenter.domain.response.ParkVisitDto;
import com.icetech.cloudcenter.domain.response.p2c.P2cBaseResponse;
import com.icetech.common.domain.SendRequest;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.Response;
import com.icetech.common.exception.ResponseBodyException;
import com.icetech.park.dao.park.ParkVisitDao;
import com.icetech.park.domain.entity.park.ParkVisit;
import com.icetech.park.service.AbstractConfigDownService;
import com.icetech.park.service.down.p2c.DownService;
import com.icetech.park.service.down.p2c.ResponseService;
import com.icetech.park.service.down.p2c.SendMsgServiceImpl;
import com.icetech.park.service.handle.P2cDownHandle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="p2cVisitCardServiceImpl")
public class VisitCardServiceImpl
extends AbstractConfigDownService
implements DownService<List<VisitCardRequest>, Void>,
ResponseService<String> {
    private static final Logger log = LoggerFactory.getLogger(VisitCardServiceImpl.class);
    @Resource
    private P2cDownHandle p2cDownHandle;
    @Resource
    private SendMsgServiceImpl sendMsgService;
    @Resource
    private ParkVisitService parkVisitService;
    @Resource
    private ParkService parkService;
    @Resource
    private ParkVisitDao parkVisitDao;

    @Override
    public ObjectResponse<Void> send(SendRequest sendRequest, String parkCode) {
        if (StringUtils.isNotEmpty((CharSequence)sendRequest.getInclude()) && "2".equals(sendRequest.getInclude())) {
            return this.batchSend(Collections.singletonList(sendRequest), null, parkCode);
        }
        try {
            String[] stringArray;
            int n;
            int n2;
            ObjectResponse objectResponse = this.parkVisitService.selectVisitByid(sendRequest.getServiceId());
            if (!ObjectResponse.isSuccess((Response)objectResponse)) {
                return ObjectResponse.failed((String)objectResponse.getCode(), (String)objectResponse.getMsg());
            }
            ParkVisitDto parkVisitDto = (ParkVisitDto)objectResponse.getData();
            String[] split = parkVisitDto.getPlateNums().split(",");
            ObjectResponse parkConfig = this.parkService.getParkConfig(parkVisitDto.getParkCode());
            Integer visitIscharge = 0;
            if (ObjectResponse.isSuccess((Response)parkConfig)) {
                visitIscharge = ((ParkConfig)parkConfig.getData()).getVisitIscharge();
            }
            if ((n2 = 0) < (n = (stringArray = split).length)) {
                String s = stringArray[n2];
                VisitCardRequest visitCardRequest = new VisitCardRequest();
                visitCardRequest.setVisitId(parkVisitDto.getId());
                visitCardRequest.setIsCharge(visitIscharge);
                visitCardRequest.setIsInoutMore(parkVisitDto.getInoutMore());
                visitCardRequest.setPlateNum(s);
                visitCardRequest.setStartTime(parkVisitDto.getStartTime());
                visitCardRequest.setEndTime(parkVisitDto.getEndTime());
                ArrayList<VisitCardRequest> list = new ArrayList<VisitCardRequest>();
                list.add(visitCardRequest);
                return this.sendMsgService.send2Park(sendRequest, parkCode, list);
            }
        }
        catch (ResponseBodyException e) {
            log.warn(String.valueOf(e.getMessage()), (Throwable)e);
            return ObjectResponse.failed((String)e.getErrCode(), (String)TextConstant.getDefaultMessage((String)"1", (String)(e.getMessage() == null ? "\u8bbf\u5ba2\u8f66\u8f86\u4e0b\u53d1\u5931\u8d25" : e.getMessage())));
        }
        catch (Exception e) {
            log.warn(String.valueOf(e.getMessage()), (Throwable)e);
            return ObjectResponse.failed((String)"410", (String)TextConstant.getDefaultMessage((String)"1", (String)"\u8bbf\u5ba2\u8f66\u8f86\u4e0b\u53d1\u5931\u8d25"));
        }
        return ObjectResponse.failed((String)"410", (String)TextConstant.getDefaultMessage((String)"1", (String)"\u8bbf\u5ba2\u8f66\u8f86\u4e0b\u53d1\u5931\u8d25"));
    }

    @Override
    public void dealResponse(P2cBaseResponse<String> p2cBaseResponse, Long parkId, String parkCode, String deviceNo) {
        this.p2cDownHandle.dealResponse(p2cBaseResponse, parkId, P2cDownCmdEnum.\u8bbf\u5ba2\u8f66\u8f86.getCmdType());
    }

    @Override
    public ObjectResponse<Void> batchSend(List<SendRequest> sendRequestList, Long parkId, String parkCode) {
        List<Long> ids = sendRequestList.stream().map(SendRequest::getServiceId).filter(Objects::nonNull).collect(Collectors.toList());
        List<ParkVisit> lists = this.parkVisitDao.findAllByIds(ids, Boolean.TRUE);
        if (CollectionUtils.isEmpty(lists)) {
            return ObjectResponse.failed((String)"410", (String)TextConstant.getDefaultMessage((String)"1", (String)"\u5220\u9664\u8bbf\u5ba2\u8f66\u8f86\u4fe1\u606f\u4e0d\u5b58\u5728"));
        }
        Map map = lists.stream().collect(Collectors.toMap(ParkVisit::getId, Function.identity(), (key1, key2) -> key1));
        for (SendRequest sendRequest : sendRequestList) {
            ParkVisit parkVisit = (ParkVisit)map.get(sendRequest.getServiceId());
            if (parkVisit == null) continue;
            ClearListRequest request = ClearListRequest.builder().id(Integer.valueOf(parkVisit.getId().intValue())).dataType(Integer.valueOf(QueryListRequest.DataType.\u8bbf\u5ba2\u8f66\u8f86.getVal())).build();
            sendRequest.setReqServiceType(P2cDownCmdEnum.\u540d\u5355\u6570\u636e\u6e05\u7a7a.getCmdType());
            this.sendMsgService.send2Park(sendRequest, parkCode, request);
            ThreadUtil.sleep((long)200L);
        }
        return ObjectResponse.success();
    }
}

