/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.down.p2c.impl;

import cn.hutool.core.util.StrUtil;
import com.icetech.basics.constants.TextConstant;
import com.icetech.basics.domain.entity.park.ParkChargeconfig;
import com.icetech.cloudcenter.api.fee.ChargeService;
import com.icetech.cloudcenter.api.month.VipCarService;
import com.icetech.cloudcenter.api.month.VipRegionService;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.domain.enumeration.P2cDownCmdEnum;
import com.icetech.cloudcenter.domain.request.p2c.VipTypeRequest;
import com.icetech.cloudcenter.domain.response.VipTypeDto;
import com.icetech.cloudcenter.domain.response.p2c.P2cBaseResponse;
import com.icetech.common.domain.SendRequest;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.Response;
import com.icetech.common.utils.ToolsUtil;
import com.icetech.fee.domain.entity.vip.VipRegion;
import com.icetech.park.service.AbstractConfigDownService;
import com.icetech.park.service.down.Message;
import com.icetech.park.service.down.p2c.DownService;
import com.icetech.park.service.down.p2c.ResponseService;
import com.icetech.park.service.down.p2c.SendMsgServiceImpl;
import com.icetech.park.service.handle.P2cDownHandle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="p2cVipTypeServiceImpl")
public class VipTypeServiceImpl
extends AbstractConfigDownService
implements DownService<List<VipTypeRequest>, Void>,
ResponseService<String> {
    private static final Logger log = LoggerFactory.getLogger(VipTypeServiceImpl.class);
    @Autowired
    private P2cDownHandle p2cDownHandle;
    @Autowired
    private SendMsgServiceImpl sendMsgService;
    @Resource
    private VipCarService vipCarService;
    @Resource
    private VipRegionService vipRegionService;
    @Resource
    private ChargeService chargeService;
    @Resource
    private ParkService parkService;

    @Override
    public ObjectResponse<Void> send(SendRequest sendRequest, String parkCode) {
        Long vipTypeId = sendRequest.getServiceId();
        int type = Integer.parseInt(sendRequest.getInclude());
        VipTypeRequest request = new VipTypeRequest();
        if (type == 3) {
            request.setVipTypeId(Integer.valueOf(vipTypeId.intValue()));
        } else {
            ObjectResponse vipTypeResp = this.vipCarService.getVipTypeById(Integer.valueOf(vipTypeId.intValue()));
            if (!ObjectResponse.isSuccess((Response)vipTypeResp)) {
                return ObjectResponse.failed((String)"410", (String)TextConstant.getDefaultMessage((String)"1", (String)"vip\u7c7b\u672a\u627e\u5230"));
            }
            ObjectResponse.notError((Response)vipTypeResp);
            request = this.buildRequest((VipTypeDto)vipTypeResp.getData());
        }
        request.setOperType(Integer.valueOf(type));
        ArrayList<VipTypeRequest> list = new ArrayList<VipTypeRequest>();
        list.add(request);
        return this.sendMsgService.send2Park(sendRequest, parkCode, list);
    }

    private VipTypeRequest buildRequest(VipTypeDto vipType) {
        VipTypeRequest request = new VipTypeRequest();
        request.setVipTypeId(vipType.getId());
        request.setVipTypeName(vipType.getName());
        request.setDiscountType(vipType.getType());
        Integer discountType = vipType.getType();
        if (discountType != null && discountType == 3) {
            request.setDiscountNumber(Integer.valueOf((int)(Float.parseFloat(vipType.getAmount()) * 100.0f)));
        } else if (discountType != null && discountType == 4) {
            request.setDiscountNumber(Integer.valueOf((int)(Float.parseFloat(vipType.getAmount()) * 10.0f)));
        } else if (discountType != null && discountType == 2) {
            request.setDiscountNumber(Integer.valueOf(ToolsUtil.parseInt((Object)vipType.getAmount())));
        } else if (discountType != null && discountType == 1) {
            request.setDiscountNumber(Integer.valueOf(-1));
        }
        request.setBilltypecode(vipType.getBilltypecode() == null ? "" : vipType.getBilltypecode());
        List vipRegionList = this.vipRegionService.getVipRegionsListByVipTypeId(vipType.getId());
        if (CollectionUtils.isNotEmpty((Collection)vipRegionList)) {
            VipRegion vipRegion = vipRegionList.stream().filter(v -> v.getRegionId() == 0L).findFirst().orElse(null);
            if (vipRegion == null) {
                List billInfos = vipRegionList.stream().filter(Objects::nonNull).map(v -> {
                    ObjectResponse regionObjectResponse = this.parkService.getParkRegionById(v.getRegionId());
                    if (!ObjectResponse.isSuccess((Response)regionObjectResponse)) {
                        return null;
                    }
                    return VipTypeRequest.BillInfo.builder().regionId(v.getRegionId()).billtypecode(this.getParkChargeConfigCode(v.getBillId())).build();
                }).collect(Collectors.toList());
                request.setBillInfo(billInfos);
            } else {
                ArrayList<VipTypeRequest.BillInfo> billInfos = new ArrayList<VipTypeRequest.BillInfo>();
                VipTypeRequest.BillInfo billInfo = new VipTypeRequest.BillInfo();
                billInfo.setRegionId(vipRegion.getRegionId());
                billInfo.setBilltypecode(vipType.getBilltypecode() == null ? "" : vipType.getBilltypecode());
                billInfos.add(billInfo);
                request.setBillInfo(billInfos);
            }
        }
        return request;
    }

    @Override
    public void dealResponse(P2cBaseResponse<String> p2cBaseResponse, Long parkId, String parkCode, String deviceNo) {
        this.p2cDownHandle.dealResponse(p2cBaseResponse, parkId, P2cDownCmdEnum.VIP\u8f66\u8f86\u7c7b\u578b.getCmdType());
    }

    public boolean send(Long parkId, String parkCode, String serialNumber, String version, String filter) {
        ArrayList<VipTypeRequest> list = new ArrayList<VipTypeRequest>();
        if (StrUtil.isNotBlank((CharSequence)filter)) {
            ObjectResponse objectResponse = this.vipCarService.getVipTypeById(Integer.valueOf(Integer.parseInt(filter)));
            ObjectResponse.notError((Response)objectResponse);
            VipTypeRequest request = this.buildRequest((VipTypeDto)objectResponse.getData());
            request.setOperType(Integer.valueOf(1));
            list.add(request);
        } else {
            ObjectResponse listObjectResponse = this.vipCarService.getVipTypeByParkId(parkId);
            ObjectResponse.notError((Response)listObjectResponse);
            ((List)listObjectResponse.getData()).forEach(vipTypeDto -> {
                VipTypeRequest request = this.buildRequest((VipTypeDto)vipTypeDto);
                request.setOperType(Integer.valueOf(1));
                list.add(request);
            });
        }
        Message message = new Message(parkId, P2cDownCmdEnum.VIP\u8f66\u8f86\u7c7b\u578b.getCmdType(), list);
        String messageId = this.p2cDownHandle.send(parkCode, serialNumber, message);
        if (messageId == null) {
            log.info("[\u7aef\u4e91-VIP\u8f66\u8f86\u7c7b\u578b\u4e0b\u53d1] \u4e0b\u53d1\u5931\u8d25\uff0c\u53c2\u6570[{}]", message);
            return false;
        }
        return true;
    }

    public String getParkChargeConfigCode(Integer id) {
        ParkChargeconfig chargeConfig = this.chargeService.getParkChargeConfigById(id);
        if (chargeConfig == null || StringUtils.isEmpty((CharSequence)chargeConfig.getBilltypecode())) {
            return "";
        }
        return chargeConfig.getBilltypecode();
    }
}

