/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.down.p2c.impl;

import cn.hutool.core.thread.ThreadUtil;
import cn.hutool.core.util.StrUtil;
import com.icetech.basics.constants.TextConstant;
import com.icetech.basics.domain.entity.device.ParkDevice;
import com.icetech.basics.domain.entity.park.ParkInoutdevice;
import com.icetech.basics.domain.entity.park.ParkRegion;
import com.icetech.cloudcenter.api.month.VipCarService;
import com.icetech.cloudcenter.api.park.ParkDeviceService;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.domain.enumeration.P2cDownCmdEnum;
import com.icetech.cloudcenter.domain.enumeration.P2cVersionEnum;
import com.icetech.cloudcenter.domain.request.p2c.ClearListRequest;
import com.icetech.cloudcenter.domain.request.p2c.MonthCardRequest;
import com.icetech.cloudcenter.domain.request.p2c.QueryListRequest;
import com.icetech.cloudcenter.domain.request.p2c.VipInfoRequest;
import com.icetech.cloudcenter.domain.response.VipInfoDto;
import com.icetech.cloudcenter.domain.response.VipTypeDto;
import com.icetech.cloudcenter.domain.response.p2c.P2cBaseResponse;
import com.icetech.cloudcenter.domain.vo.BatchSendRepeatVO;
import com.icetech.cloudcenter.domain.vo.BatchSendVO;
import com.icetech.common.domain.SendRequest;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.Response;
import com.icetech.common.exception.ResponseBodyException;
import com.icetech.common.utils.DateTools;
import com.icetech.common.utils.StringUtils;
import com.icetech.common.utils.ToolsUtil;
import com.icetech.fee.dao.vip.VipRecordDao;
import com.icetech.fee.domain.entity.monthcar.MonthRecord;
import com.icetech.fee.domain.entity.vip.VipRecord;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.down.Message;
import com.icetech.park.service.down.p2c.DownService;
import com.icetech.park.service.down.p2c.ResponseService;
import com.icetech.park.service.down.p2c.SendMsgServiceImpl;
import com.icetech.park.service.handle.BatchDownBizHandle;
import com.icetech.park.service.handle.P2cDownHandle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="p2cVipInfoServiceImpl")
public class VipInfoServiceImpl
extends AbstractService
implements DownService<List<VipInfoRequest>, Void>,
ResponseService<String> {
    private static final Logger log = LoggerFactory.getLogger(VipInfoServiceImpl.class);
    @Autowired
    private P2cDownHandle p2cDownHandle;
    @Autowired
    private VipCarService vipCarService;
    @Autowired
    private VipRecordDao vipRecordDao;
    @Autowired
    private SendMsgServiceImpl sendMsgService;
    @Autowired
    private ParkService parkService;
    @Autowired
    private ParkDeviceService parkDeviceService;
    @Autowired
    private BatchDownBizHandle<VipInfoRequest> batchDownBizHandle;
    private static final String[] HEADERS = new String[]{"id", "vipId", "vipTypeName", "plateNum", "phone", "startDate", "endDate", "discountType", "discountNumber", "billtypecode", "vipTypeId"};

    @Override
    public ObjectResponse<Void> send(SendRequest sendRequest, String parkCode) {
        Long serviceId = sendRequest.getServiceId();
        ObjectResponse recordObjectResponse = this.vipCarService.getOperatorRecordById(serviceId);
        if (!ObjectResponse.isSuccess((Response)recordObjectResponse)) {
            return ObjectResponse.failed((String)"410", (String)TextConstant.getDefaultMessage((String)"1", (String)"vip\u64cd\u4f5c\u8bb0\u5f55\u4e0d\u5b58\u5728"));
        }
        VipRecord vipRecord = (VipRecord)recordObjectResponse.getData();
        ObjectResponse vipTypeObjectResponse = this.vipCarService.getVipTypeById(vipRecord.getTypeId());
        if (!ObjectResponse.isSuccess((Response)vipTypeObjectResponse)) {
            return ObjectResponse.failed((String)"410", (String)"\u672a\u627e\u5230\u7c7b\u578b\u4fe1\u606f");
        }
        VipTypeDto vipType = (VipTypeDto)vipTypeObjectResponse.getData();
        Integer operType = vipRecord.getOperType();
        if (operType == 3) {
            ClearListRequest clearListRequest = new ClearListRequest();
            clearListRequest.setDataType(Integer.valueOf(QueryListRequest.DataType.VIP.getVal()));
            clearListRequest.setId(vipRecord.getVipId());
            sendRequest.setReqServiceType(P2cDownCmdEnum.\u540d\u5355\u6570\u636e\u6e05\u7a7a.getCmdType());
            return this.sendMsgService.send2Park(sendRequest, parkCode, clearListRequest);
        }
        if (vipRecord.getStartTime() == null || vipRecord.getEndTime() == null) {
            throw new ResponseBodyException("410", TextConstant.getDefaultMessage((String)"1", (String)"\u65e5\u671f\u4e0d\u5408\u6cd5"));
        }
        ArrayList<VipInfoRequest> list = new ArrayList<VipInfoRequest>();
        VipInfoRequest vipInfoRequest = new VipInfoRequest();
        vipInfoRequest.setPlateNum(vipRecord.getPlateNum().replaceAll("\u3001", ","));
        vipInfoRequest.setVipId(Long.valueOf(vipRecord.getVipId().intValue()));
        vipInfoRequest.setVipTypeId(Long.valueOf(vipRecord.getTypeId().intValue()));
        vipInfoRequest.setPhone(StringUtils.isBlank((CharSequence)vipRecord.getPhone()) ? "123" : vipRecord.getPhone());
        vipInfoRequest.setStartDate(DateTools.getFormat((Date)vipRecord.getStartTime()));
        vipInfoRequest.setEndDate(DateTools.getFormat((String)"yyyy-MM-dd", (Date)vipRecord.getEndTime()) + " 23:59:59");
        vipInfoRequest.setDiscountType(vipType.getType());
        Integer discountType = vipType.getType();
        if (discountType != null && discountType == 3) {
            vipInfoRequest.setDiscountNumber(Integer.valueOf((int)(Float.parseFloat(vipType.getAmount()) * 100.0f)));
        } else if (discountType != null && discountType == 4) {
            vipInfoRequest.setDiscountNumber(Integer.valueOf((int)(Float.parseFloat(vipType.getAmount()) * 10.0f)));
        } else if (discountType != null && discountType == 2) {
            vipInfoRequest.setDiscountNumber(Integer.valueOf(ToolsUtil.parseInt((Object)vipType.getAmount())));
        } else if (discountType != null && discountType == 1) {
            vipInfoRequest.setDiscountNumber(Integer.valueOf(-1));
        }
        vipInfoRequest.setVipTypeName(vipType.getName());
        vipInfoRequest.setBilltypecode(vipType.getBilltypecode());
        list.add(vipInfoRequest);
        ObjectResponse parkObjectResponse = this.parkService.findByParkId(sendRequest.getParkId());
        Park park = (Park)parkObjectResponse.getData();
        if (park.getIsInterior() != null && park.getIsInterior() == 1) {
            ObjectResponse objectResponse;
            ObjectResponse listObjectResponse = this.parkDeviceService.getDeviceListByType(sendRequest.getParkId(), 1);
            ObjectResponse.notError((Response)listObjectResponse, (String)("\u8f66\u573aID[" + sendRequest.getParkId() + "]\u4e0b\u672a\u6dfb\u52a0\u8bbe\u5907"));
            List parkDevices = ((List)listObjectResponse.getData()).stream().filter(pd -> P2cVersionEnum.\u7248\u672c17.getIndex() > P2cVersionEnum.getIndex((String)pd.getProtocolVer())).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(parkDevices) && ObjectResponse.isSuccess((Response)(objectResponse = this.parkService.selectRegionById(sendRequest.getParkId())))) {
                List parkRegions = (List)objectResponse.getData();
                for (ParkRegion parkRegion : parkRegions) {
                    ObjectResponse deviceListObjectResponse = this.parkDeviceService.getDeviceListByParkRegionId(sendRequest.getParkId(), Integer.valueOf(parkRegion.getId().intValue()), 1);
                    if (!ObjectResponse.isSuccess((Response)deviceListObjectResponse)) continue;
                    List parkDeviceList = (List)deviceListObjectResponse.getData();
                    for (ParkDevice parkDevice : parkDeviceList) {
                        ParkInoutdevice parkInoutdevice;
                        ObjectResponse inoutdeviceObjectResponse;
                        Integer channelId = parkDevice.getChannelId();
                        if (channelId != null && ObjectResponse.isSuccess((Response)(inoutdeviceObjectResponse = this.parkService.getInoutDeviceById(Long.valueOf(parkDevice.getChannelId().longValue())))) && (parkInoutdevice = (ParkInoutdevice)inoutdeviceObjectResponse.getData()).getInandoutType() == 2 && parkInoutdevice.getIsMaster() == 1) continue;
                        String serialNumber = parkDevice.getSerialNumber();
                        Message message = new Message(sendRequest.getTaskId(), sendRequest.getParkId(), sendRequest.getServiceType(), sendRequest.getServiceId(), list);
                        this.p2cDownHandle.send(parkCode, serialNumber, message);
                    }
                }
                return ObjectResponse.success();
            }
        }
        return this.sendMsgService.send2Park(sendRequest, parkCode, list);
    }

    @Override
    public ObjectResponse<Void> batchSend(List<SendRequest> sendRequestList, Long parkId, String parkCode) {
        List ids = sendRequestList.stream().map(SendRequest::getServiceId).collect(Collectors.toList());
        List list = this.vipRecordDao.getRecordListByIds(ids);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return ObjectResponse.failed((String)"402");
        }
        Map<Integer, Integer> recordIdVipIdMap = list.stream().collect(Collectors.toMap(VipRecord::getId, VipRecord::getVipId, (a, b) -> a));
        sendRequestList.forEach(sendRequest -> {
            ClearListRequest clearListRequest = new ClearListRequest();
            Integer vipId = (Integer)recordIdVipIdMap.get(sendRequest.getServiceId().intValue());
            if (vipId != null) {
                clearListRequest.setId(vipId);
                clearListRequest.setDataType(Integer.valueOf(QueryListRequest.DataType.VIP.getVal()));
                sendRequest.setReqServiceType(P2cDownCmdEnum.\u540d\u5355\u6570\u636e\u6e05\u7a7a.getCmdType());
                this.sendMsgService.send2Park((SendRequest)sendRequest, parkCode, clearListRequest);
                ThreadUtil.sleep((long)200L);
            }
        });
        return ObjectResponse.success();
    }

    private MonthCardRequest buildRequest(VipRecord vipRecord) {
        String[] plates;
        Integer typeId = vipRecord.getTypeId();
        String plateNums = vipRecord.getPlateNum();
        MonthCardRequest monthCardRequest = new MonthCardRequest();
        Integer operType = vipRecord.getOperType();
        if (operType == 1) {
            monthCardRequest.setCardOperType(MonthRecord.CardOpertype.\u65b0\u589e.getType());
        } else if (operType == 2) {
            monthCardRequest.setCardOperType(MonthRecord.CardOpertype.\u4fee\u6539.getType());
        } else {
            monthCardRequest.setCardOperType(MonthRecord.CardOpertype.\u9000\u5361.getType());
        }
        ArrayList<MonthCardRequest.Details> list = new ArrayList<MonthCardRequest.Details>();
        for (String plateNum : plates = plateNums.split(",")) {
            MonthCardRequest.Details details = new MonthCardRequest.Details();
            details.setPlateNum(plateNum);
            details.setCardId(vipRecord.getVipId());
            details.setCardOwner("VIP\u8f66\u533a\u6216\u5185\u90e8\u8f66\u533a" + typeId);
            details.setStartDate(DateTools.getFormat((String)"yyyy-MM-dd HH:mm:ss", (Date)vipRecord.getStartTime()));
            details.setEndDate(DateTools.getFormat((String)"yyyy-MM-dd HH:mm:ss", (Date)vipRecord.getEndTime()));
            details.setPlotCount(Integer.valueOf(1));
            details.setCardType(Integer.valueOf(1));
            list.add(details);
        }
        monthCardRequest.setDetails(list);
        return monthCardRequest;
    }

    @Override
    public ObjectResponse<Void> batchSend(BatchSendVO vo) {
        Long parkId = vo.getParkId();
        String parkCode = vo.getParkCode();
        ObjectResponse vipInfoDtoRet = this.vipCarService.getValidByParkId(parkId);
        if (vipInfoDtoRet.getCode().equals("404")) {
            log.info("<\u6279\u91cfVIP\u4e0b\u53d1> \u6ca1\u6709\u7b26\u5408\u6279\u91cf\u4e0b\u53d1\u6761\u4ef6\u7684VIP\u8f66\uff0c\u5ffd\u7565\u4e0b\u53d1\uff0c\u8f66\u573a\u7f16\u53f7\uff1a{}", (Object)parkCode);
            return ObjectResponse.success();
        }
        if (ObjectResponse.isSuccess((Response)vipInfoDtoRet)) {
            List vipInfoDtos = (List)vipInfoDtoRet.getData();
            ArrayList<VipInfoRequest> list = new ArrayList<VipInfoRequest>();
            for (VipInfoDto vipInfoDto : vipInfoDtos) {
                VipInfoRequest vipInfoRequest = new VipInfoRequest();
                BeanUtils.copyProperties((Object)vipInfoDto, (Object)vipInfoRequest);
                vipInfoRequest.setPhone(StringUtils.isBlank((CharSequence)vipInfoDto.getPhone()) ? "123" : vipInfoDto.getPhone());
                Integer discountType = vipInfoDto.getDiscountType();
                if (discountType != null && discountType == 3) {
                    vipInfoRequest.setDiscountNumber(Integer.valueOf((int)(Float.parseFloat(vipInfoDto.getDiscountNumber()) * 100.0f)));
                } else if (discountType != null && discountType == 4) {
                    vipInfoRequest.setDiscountNumber(Integer.valueOf((int)(Float.parseFloat(vipInfoDto.getDiscountNumber()) * 10.0f)));
                } else if (discountType != null && discountType == 2) {
                    vipInfoRequest.setDiscountNumber(Integer.valueOf(ToolsUtil.parseInt((Object)vipInfoDto.getDiscountNumber())));
                }
                vipInfoRequest.setStartDate(vipInfoDto.getStartTime() + " 00:00:00");
                vipInfoRequest.setEndDate(vipInfoDto.getEndTime() + " 23:59:59");
                list.add(vipInfoRequest);
            }
            List<Object> collect = list.stream().map(VipInfoRequest::getVipId).collect(Collectors.toList());
            this.batchDownBizHandle.batchDown(vo, list, collect, HEADERS, P2cDownCmdEnum.VIP\u8f66\u8f86.getCmdType());
            return ObjectResponse.success();
        }
        return ObjectResponse.instance((String)vipInfoDtoRet.getCode(), (String)vipInfoDtoRet.getMsg(), null);
    }

    @Override
    public ObjectResponse<Void> batchSendRepeat(BatchSendRepeatVO vo) {
        String parkCode = vo.getParkCode();
        ObjectResponse vipInfoDtoRet = StrUtil.isNotBlank((CharSequence)vo.getFailIds()) ? this.vipCarService.getValidByIds(Arrays.asList(vo.getFailIds().split(","))) : this.vipCarService.getValidByParkId(vo.getParkId());
        if (vipInfoDtoRet.getCode().equals("404")) {
            log.info("<\u6279\u91cfVIP\u4e0b\u53d1> \u6ca1\u6709\u7b26\u5408\u6279\u91cf\u4e0b\u53d1\u6761\u4ef6\u7684VIP\u8f66\uff0c\u5ffd\u7565\u4e0b\u53d1\uff0c\u8f66\u573a\u7f16\u53f7\uff1a{}", (Object)parkCode);
            return ObjectResponse.success();
        }
        if (ObjectResponse.isSuccess((Response)vipInfoDtoRet)) {
            List vipInfoDtos = (List)vipInfoDtoRet.getData();
            ArrayList<VipInfoRequest> list = new ArrayList<VipInfoRequest>();
            for (VipInfoDto vipInfoDto : vipInfoDtos) {
                VipInfoRequest vipInfoRequest = new VipInfoRequest();
                BeanUtils.copyProperties((Object)vipInfoDto, (Object)vipInfoRequest);
                Integer discountType = vipInfoDto.getDiscountType();
                if (discountType != null && discountType == 3) {
                    vipInfoRequest.setDiscountNumber(Integer.valueOf((int)(Float.parseFloat(vipInfoDto.getDiscountNumber()) * 100.0f)));
                } else if (discountType != null && discountType == 4) {
                    vipInfoRequest.setDiscountNumber(Integer.valueOf((int)(Float.parseFloat(vipInfoDto.getDiscountNumber()) * 10.0f)));
                } else if (discountType != null && discountType == 2) {
                    vipInfoRequest.setDiscountNumber(Integer.valueOf(ToolsUtil.parseInt((Object)vipInfoDto.getDiscountNumber())));
                }
                vipInfoRequest.setStartDate(vipInfoDto.getStartTime() + " 00:00:00");
                vipInfoRequest.setEndDate(vipInfoDto.getEndTime() + " 23:59:59");
                list.add(vipInfoRequest);
            }
            List<Object> collect = list.stream().map(VipInfoRequest::getVipId).collect(Collectors.toList());
            this.batchDownBizHandle.repeatBatch(vo, list, collect, HEADERS, P2cDownCmdEnum.VIP\u8f66\u8f86.getCmdType());
            return ObjectResponse.success();
        }
        return ObjectResponse.instance((String)vipInfoDtoRet.getCode(), (String)vipInfoDtoRet.getMsg(), null);
    }

    private ObjectResponse<Void> send(SendRequest sendRequest, String parkCode, List<VipInfoRequest> list) {
        return this.sendMsgService.send2Park(sendRequest, parkCode, list);
    }

    @Override
    public void dealResponse(P2cBaseResponse<String> p2cBaseResponse, Long parkId, String parkCode, String deviceNo) {
        this.p2cDownHandle.dealResponse(p2cBaseResponse, parkId, P2cDownCmdEnum.VIP\u8f66\u8f86.getCmdType());
    }
}

