/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.down.p2c.impl;

import com.icetech.basics.constants.TextConstant;
import com.icetech.cloudcenter.domain.enumeration.P2cDownCmdEnum;
import com.icetech.cloudcenter.domain.request.p2c.MonthCardRequest;
import com.icetech.common.domain.SendRequest;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.utils.DateTools;
import com.icetech.fee.domain.entity.monthcar.MonthRecord;
import com.icetech.park.dao.vehicle.VehicleOperDao;
import com.icetech.park.dao.vehicle.VehiclePlateDao;
import com.icetech.park.domain.entity.vehicle.VehicleOper;
import com.icetech.park.domain.entity.vehicle.VehiclePlate;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.down.p2c.DownService;
import com.icetech.park.service.down.p2c.SendMsgServiceImpl;
import java.util.ArrayList;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="p2cVehicleDisableServiceImpl")
public class VehicleDisableServiceImpl
extends AbstractService
implements DownService<MonthCardRequest, Void> {
    @Autowired
    private VehicleOperDao vehicleOperDao;
    @Autowired
    private VehiclePlateDao vehiclePlateDao;
    @Autowired
    private SendMsgServiceImpl sendMsgService;

    @Override
    public ObjectResponse<Void> send(SendRequest sendRequest, String parkCode) {
        Long serviceId = sendRequest.getServiceId();
        VehicleOper vehicleOper = this.vehicleOperDao.selectById(serviceId);
        if (vehicleOper == null) {
            return ObjectResponse.failed((String)"410", (String)TextConstant.getDefaultMessage((String)"1", (String)"\u5185\u90e8\u8f66\u8f86\u8f66\u724c\u53f7\u64cd\u4f5c\u8bb0\u5f55\u4e0d\u5b58\u5728"));
        }
        MonthCardRequest monthCardRequest = this.buildRequest(vehicleOper);
        sendRequest.setReqServiceType(P2cDownCmdEnum.\u6708\u5361.getCmdType());
        return this.sendMsgService.send2Park(sendRequest, parkCode, monthCardRequest);
    }

    private MonthCardRequest buildRequest(VehicleOper vehicleOper) {
        String[] plates;
        Integer relId = vehicleOper.getRelId();
        String plateNums = vehicleOper.getPlateNums();
        MonthCardRequest monthCardRequest = new MonthCardRequest();
        monthCardRequest.setCardOperType(MonthRecord.CardOpertype.\u9000\u5361.getType());
        ArrayList<MonthCardRequest.Details> list = new ArrayList<MonthCardRequest.Details>();
        for (String plateNum : plates = plateNums.split(",")) {
            VehiclePlate vehiclePlate = this.vehiclePlateDao.select(relId, plateNum);
            if (vehiclePlate == null) continue;
            Long id = vehiclePlate.getId();
            MonthCardRequest.Details details = new MonthCardRequest.Details();
            details.setPlateNum(plateNum);
            details.setCardId(Integer.valueOf(id.intValue()));
            details.setCardOwner("park");
            details.setStartDate(DateTools.Date());
            details.setEndDate("2100-12-31 23:59:59");
            details.setPlotCount(Integer.valueOf(1));
            details.setCardType(Integer.valueOf(1));
            list.add(details);
        }
        monthCardRequest.setDetails(list);
        return monthCardRequest;
    }
}

