/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.down.p2c.impl;

import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.domain.enumeration.P2cDownCmdEnum;
import com.icetech.cloudcenter.domain.request.p2c.MonthCardRequest;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.utils.DateTools;
import com.icetech.fee.domain.entity.monthcar.MonthRecord;
import com.icetech.park.dao.vehicle.VehiclePlateDao;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.park.domain.entity.vehicle.VehiclePlate;
import com.icetech.park.service.down.Message;
import com.icetech.park.service.down.p2c.impl.ClearListServiceImpl;
import com.icetech.park.service.handle.P2cDownHandle;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="vehicleCheckServiceImpl")
public class VehicleCheckServiceImpl {
    private static final Logger log = LoggerFactory.getLogger(VehicleCheckServiceImpl.class);
    @Autowired
    private P2cDownHandle p2cDownHandle;
    @Autowired
    private VehiclePlateDao vehiclePlateDao;
    @Autowired
    private ClearListServiceImpl clearListService;
    @Autowired
    private ParkService parkService;

    public ObjectResponse<Void> check(String parkCode) {
        ObjectResponse parkObjectResponse = this.parkService.findByParkCode(parkCode);
        Park park = (Park)parkObjectResponse.getData();
        ObjectResponse<Void> objectResponse = this.clearListService.execute(park.getId(), parkCode, 1, null);
        if (ObjectResponse.isSuccess(objectResponse)) {
            log.info("<\u7aef\u4e91-\u7279\u6b8a\u8f66\u8f86-\u91cd\u65b0\u4e0b\u53d1> \u6e05\u9664\u76f8\u673a\u6570\u636e\u6210\u529f\uff0c\u8f66\u573a\u7f16\u53f7\uff1a{}", (Object)parkCode);
            List<VehiclePlate> vehiclePlates = this.vehiclePlateDao.selectAllValidVip(park.getId());
            if (vehiclePlates != null) {
                return this.buildRequest(vehiclePlates, park.getId(), parkCode);
            }
        }
        return ObjectResponse.failed((String)"500");
    }

    private ObjectResponse<Void> buildRequest(List<VehiclePlate> vehiclePlates, Long parkId, String parkCode) {
        MonthCardRequest monthCardRequest = new MonthCardRequest();
        monthCardRequest.setCardOperType(MonthRecord.CardOpertype.\u65b0\u589e.getType());
        int size = vehiclePlates.size();
        int sendCs = size % 10 == 0 ? size / 10 : size / 10 + 1;
        for (int k = 0; k < sendCs; ++k) {
            int iMax = 10 * (k + 1);
            if (iMax > size) {
                iMax = size;
            }
            ArrayList<MonthCardRequest.Details> list = new ArrayList<MonthCardRequest.Details>();
            for (int i = 10 * k; i < iMax; ++i) {
                VehiclePlate vehiclePlate = vehiclePlates.get(i);
                Long id = vehiclePlate.getId();
                MonthCardRequest.Details details = new MonthCardRequest.Details();
                details.setPlateNum(vehiclePlate.getPlateNum());
                details.setCardId(Integer.valueOf(id.intValue()));
                details.setCardOwner("park");
                details.setStartDate(DateTools.Date());
                details.setEndDate("2100-12-31 23:59:59");
                details.setPlotCount(Integer.valueOf(1));
                details.setCardType(Integer.valueOf(1));
                list.add(details);
            }
            monthCardRequest.setDetails(list);
            Message<MonthCardRequest> message = new Message<MonthCardRequest>(parkId, P2cDownCmdEnum.\u6708\u5361.getCmdType(), monthCardRequest);
            Object[] messageIdArr = this.p2cDownHandle.send2Park(parkCode, message);
            if (ArrayUtils.isEmpty((Object[])messageIdArr)) {
                log.info("<\u7aef\u4e91-\u7279\u6b8a\u8f66\u8f86-\u91cd\u65b0\u4e0b\u53d1> \u4e0b\u53d1\u5931\u8d25\uff0c\u53c2\u6570:{}", (Object)monthCardRequest);
                return ObjectResponse.failed((String)"3003");
            }
            try {
                Thread.sleep(2000L);
                continue;
            }
            catch (InterruptedException e) {
                log.warn(String.valueOf(e.getMessage()), (Throwable)e);
            }
        }
        return ObjectResponse.success();
    }
}

