/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.down.p2c.impl;

import com.icetech.cloudcenter.api.NotifyService;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.domain.enumeration.P2cDownCmdEnum;
import com.icetech.cloudcenter.domain.request.p2c.UpgradeRequest;
import com.icetech.cloudcenter.domain.response.p2c.P2cBaseResponse;
import com.icetech.common.domain.request.P2cBaseRequest;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.Response;
import com.icetech.common.utils.DateTools;
import com.icetech.common.utils.UUIDTools;
import com.icetech.common.validator.Validator;
import com.icetech.park.dao.FirmwareUpgradeDao;
import com.icetech.park.domain.entity.FirmwareUpgrade;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.down.Message;
import com.icetech.park.service.down.p2c.ResponseService;
import com.icetech.park.service.handle.P2cDownHandle;
import com.icetech.third.utils.RedisUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="p2cUpgradeServiceImpl")
public class UpgradeServiceImpl
extends AbstractService
implements ResponseService<String>,
NotifyService<String> {
    private static final Logger log = LoggerFactory.getLogger(UpgradeServiceImpl.class);
    @Autowired
    private P2cDownHandle p2cDownHandle;
    @Autowired
    private ParkService parkService;
    @Autowired
    private RedisUtils redisUtils;
    @Autowired
    private FirmwareUpgradeDao firmwareUpgradeDao;

    public ObjectResponse<Void> execute(UpgradeRequest upgradeRequest, String sn, Long parkId) {
        String messageId;
        if (!Validator.validate((Object)upgradeRequest)) {
            return ObjectResponse.failed((String)"400");
        }
        ObjectResponse parkObjectResponse = this.parkService.findByParkId(parkId);
        if (!ObjectResponse.isSuccess((Response)parkObjectResponse)) {
            return ObjectResponse.failed((String)"404", (String)"\u8f66\u573a\u4e0d\u5b58\u5728");
        }
        Park park = (Park)parkObjectResponse.getData();
        Message<UpgradeRequest> message = new Message<UpgradeRequest>(parkId, P2cDownCmdEnum.\u5347\u7ea7\u6307\u4ee4\u4e0b\u53d1.getCmdType(), upgradeRequest);
        if (Objects.nonNull(upgradeRequest.getUpgradeChannel()) && upgradeRequest.getUpgradeChannel() == 2) {
            Integer reqServiceType = message.getReqServiceType();
            UpgradeRequest payload = message.getPayload();
            P2cBaseRequest p2cBaseRequest = new P2cBaseRequest();
            p2cBaseRequest.setCmd(P2cDownCmdEnum.getCmd((Integer)reqServiceType));
            messageId = UUIDTools.getUuid();
            p2cBaseRequest.setMessageId(messageId);
            p2cBaseRequest.setTimestamp(Long.valueOf(DateTools.unixTimestamp()));
            p2cBaseRequest.setBizContent((Object)payload);
            this.p2cDownHandle.pushAll(sn, p2cBaseRequest, "ops");
        } else {
            messageId = this.p2cDownHandle.send(park.getParkCode(), sn, message);
        }
        if (messageId == null) {
            return ObjectResponse.failed((String)"3003", (String)"\u76f8\u673a\u672a\u8fde\u63a5");
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("sn", sn);
        hashMap.put("newFirmwareVer", upgradeRequest.getNewFirmwareVer());
        hashMap.put("sendTime", upgradeRequest.getSendTime());
        hashMap.put("step", 1);
        hashMap.put("stepStatus", 1);
        String key = "upgrade:task:" + upgradeRequest.getTaskId();
        this.redisUtils.hPutAll(key, hashMap);
        this.redisUtils.expire(key, 600L);
        this.redisUtils.set("upgrade:task:message:" + messageId, (Object)upgradeRequest.getTaskId(), 60L);
        FirmwareUpgrade firmwareUpgrade = new FirmwareUpgrade();
        firmwareUpgrade.setActionTime(new Date(upgradeRequest.getSendTime() * 1000L));
        firmwareUpgrade.setTaskId(upgradeRequest.getTaskId());
        firmwareUpgrade.setStatus(Integer.valueOf(FirmwareUpgrade.StatusEnum.\u5347\u7ea7\u4e2d.status));
        this.firmwareUpgradeDao.updateByTaskId(firmwareUpgrade);
        return ObjectResponse.success();
    }

    @Override
    public void dealResponse(P2cBaseResponse<String> p2cBaseResponse, Long parkId, String parkCode, String sn) {
        String taskId = (String)this.redisUtils.get("upgrade:task:message:" + p2cBaseResponse.getMessageId(), String.class);
        if (taskId != null) {
            Integer successCode = 200;
            String key = "upgrade:task:" + taskId;
            FirmwareUpgrade firmwareUpgrade = this.firmwareUpgradeDao.selectByTaskId(taskId);
            if (firmwareUpgrade == null) {
                log.warn("[\u8bbe\u5907\u5347\u7ea7\u6307\u4ee4\u4e0b\u53d1\u54cd\u5e94] \u672a\u67e5\u8be2\u5230\u4efb\u52a1ID[{}]", (Object)taskId);
                return;
            }
            if (successCode.equals(p2cBaseResponse.getCode())) {
                firmwareUpgrade.setStatus(Integer.valueOf(FirmwareUpgrade.StatusEnum.\u5347\u7ea7\u4e2d.status));
                this.redisUtils.hPut(key, "step", (Object)3);
                this.redisUtils.hPut(key, "updateTime", (Object)DateTools.Date());
            } else {
                firmwareUpgrade.setStatus(Integer.valueOf(FirmwareUpgrade.StatusEnum.\u5347\u7ea7\u5931\u8d25.status));
                firmwareUpgrade.setReason(p2cBaseResponse.getMsg());
                this.redisUtils.hPut(key, "stepStatus", (Object)3);
                this.redisUtils.hPut(key, "reason", (Object)p2cBaseResponse.getMsg());
                this.redisUtils.hPut(key, "updateTime", (Object)DateTools.Date());
            }
            firmwareUpgrade.setUpdateTime(new Date());
            this.firmwareUpgradeDao.updateById(firmwareUpgrade);
        } else {
            log.warn("[\u8bbe\u5907\u5347\u7ea7\u6307\u4ee4\u4e0b\u53d1\u54cd\u5e94] \u672a\u67e5\u8be2\u5230messageId[{}]\u5bf9\u5e94\u7684\u4efb\u52a1ID", (Object)p2cBaseResponse.getMessageId());
        }
    }
}

