/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.down.p2c.impl;

import com.icetech.cloudcenter.api.NotifyService;
import com.icetech.cloudcenter.domain.enumeration.DataCollectionEnum;
import com.icetech.cloudcenter.domain.enumeration.EnexTypeEnum;
import com.icetech.cloudcenter.domain.enumeration.P2cDownCmdEnum;
import com.icetech.cloudcenter.domain.request.p2c.SoftTriggerRequest;
import com.icetech.cloudcenter.domain.response.EnterCarInfoResponse;
import com.icetech.cloudcenter.domain.response.ExitCarInfoResponse;
import com.icetech.cloudcenter.domain.response.p2c.P2cBaseResponse;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.utils.CodeTools;
import com.icetech.common.utils.DateTools;
import com.icetech.common.utils.JsonUtils;
import com.icetech.oss.OssService;
import com.icetech.park.component.AsyncNotifyClient;
import com.icetech.park.handle.CacheHandle;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.down.Message;
import com.icetech.park.service.down.p2c.ResponseService;
import com.icetech.park.service.down.p2c.impl.SoftTriggerServiceImpl;
import com.icetech.park.service.handle.P2cDownHandle;
import com.icetech.third.domain.entity.third.SendInfoRecord;
import com.icetech.third.utils.RedisUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="p2cTakePicturesServiceImpl")
public class TakePicturesServiceImpl
extends AbstractService
implements ResponseService<String>,
NotifyService<Map<String, Object>> {
    private static final Logger log = LoggerFactory.getLogger(TakePicturesServiceImpl.class);
    @Autowired
    private P2cDownHandle p2cDownHandle;
    @Autowired
    private CacheHandle cacheHandle;
    @Resource
    private AsyncNotifyClient asyncNotifyClient;
    @Resource
    private OssService ossService;
    @Resource
    private SoftTriggerServiceImpl softTriggerService;
    @Resource
    private RedisUtils redisUtils;

    public ObjectResponse<String> execute(Long parkId, String parkCode, String sn) {
        Message<Object> message = new Message<Object>(parkId, P2cDownCmdEnum.\u56fe\u7247\u6293\u62cd.getCmdType(), null);
        String messageId = this.p2cDownHandle.send(parkCode, sn, message);
        if (messageId == null) {
            return ObjectResponse.failed((String)"3003", (String)"\u76f8\u673a\u672a\u8fde\u63a5");
        }
        this.cacheHandle.setSoftImage(messageId, "tmp/" + parkCode + "/" + messageId + ".jpg");
        return ObjectResponse.success((Object)messageId);
    }

    public ObjectResponse<Void> executeAsync(Long parkId, String parkCode, String sn, String channelCode, Integer type, String topic) {
        HashMap<String, Object> paraMap = new HashMap<String, Object>();
        paraMap.put("type", type);
        paraMap.put("parkCode", parkCode);
        paraMap.put("channelCode", channelCode);
        Message<Object> message = new Message<Object>(parkId, P2cDownCmdEnum.\u56fe\u7247\u6293\u62cd.getCmdType(), null);
        String messageId = this.p2cDownHandle.send(parkCode, sn, message, topic, JsonUtils.toString(paraMap));
        if (messageId == null) {
            return ObjectResponse.failed((String)"3003");
        }
        this.cacheHandle.setSoftImage(messageId, "tmp/" + parkCode + "/" + messageId + ".jpg");
        return ObjectResponse.failed((String)"12002", (String)messageId);
    }

    @Override
    public void dealResponse(P2cBaseResponse<String> p2cBaseResponse, Long parkId, String parkCode, String deviceNo) {
        this.p2cDownHandle.dealResponse(p2cBaseResponse, parkId, P2cDownCmdEnum.\u56fe\u7247\u6293\u62cd.getCmdType());
    }

    public void notify(String messageId, ObjectResponse<String> response, SendInfoRecord<Map<String, Object>> sendInfoRecord) {
        EnterCarInfoResponse enexCarInfoBaseResponse;
        Map extraInfo = JsonUtils.parseStringMap((String)sendInfoRecord.getExtraInfo());
        if (extraInfo == null || extraInfo.get("type") == null) {
            this.asyncNotifyClient.callBack(messageId, sendInfoRecord.getTopic(), sendInfoRecord.getEnv(), response);
            return;
        }
        String parkCode = (String)extraInfo.get("parkCode");
        String imagePath = "tmp/" + parkCode + "/" + messageId + ".jpg";
        if (!ObjectResponse.isSuccess(response)) {
            this.redisUtils.hPut("p2c:no:takepicture:func", sendInfoRecord.getTarget(), (Object)DateTools.unixTimestamp());
            log.info("\u6293\u62cd\u63a5\u53e3\u4e0d\u652f\u6301 \u8f6c\u8f6f\u89e6\u53d1\u63a5\u53e3\u5904\u7406 \u53c2\u6570{}", (Object)extraInfo);
            ObjectResponse<Void> objectResponse = this.softTriggerService.execute(sendInfoRecord.getParkId(), sendInfoRecord.getParkCode(), (String)extraInfo.get("channelCode"), sendInfoRecord.getTopic(), (SoftTriggerRequest)SoftTriggerRequest.GetCarInfo.builder().biz(SoftTriggerRequest.ExtraInfoEnum.GET_CAR_INFO.val).type(Integer.valueOf((String)extraInfo.get("type"))).channelCode((String)extraInfo.get("channelCode")).build());
            if (!"12002".equals(objectResponse.getCode()) && (imagePath = this.cacheHandle.getDataFromRedis("SOFT:IMAGE:PROFILE:" + objectResponse.getData(), 3000L, String.class)) == null) {
                return;
            }
        } else {
            this.redisUtils.hDelete("p2c:no:takepicture:func", new String[]{sendInfoRecord.getTarget()});
        }
        Integer type = Integer.parseInt((String)extraInfo.get("type"));
        if (EnexTypeEnum.\u5165\u573a.getType().equals(type)) {
            try {
                enexCarInfoBaseResponse = this.getEntranceCarInfoResponse(imagePath);
            }
            catch (Exception e) {
                log.error("\u6293\u62cd\u56fe\u5f02\u5e38, e=", (Throwable)e);
                return;
            }
        }
        try {
            enexCarInfoBaseResponse = this.getExitCarInfoResponse(imagePath);
        }
        catch (Exception e) {
            log.error("\u6293\u62cd\u56fe\u5f02\u5e38, e=", (Throwable)e);
            return;
        }
        enexCarInfoBaseResponse.setDataCollection(DataCollectionEnum.\u7aef\u4e91.getType());
        log.info("enexCarInfoBaseResponse:{}", (Object)enexCarInfoBaseResponse);
        this.asyncNotifyClient.callBack(messageId, sendInfoRecord.getTopic(), sendInfoRecord.getEnv(), ObjectResponse.success((Object)enexCarInfoBaseResponse));
    }

    protected EnterCarInfoResponse getEntranceCarInfoResponse(String imagePath) {
        EnterCarInfoResponse enterCarInfoResponse = new EnterCarInfoResponse();
        enterCarInfoResponse.setEnterNum("\u672a\u8bc6\u522b");
        enterCarInfoResponse.setCarType(Integer.valueOf(1));
        enterCarInfoResponse.setType(Integer.valueOf(1));
        enterCarInfoResponse.setOrderNum(CodeTools.GenerateOrderNum());
        if (imagePath != null) {
            enterCarInfoResponse.setImgUrl(this.ossService.getImageUrl(imagePath));
            enterCarInfoResponse.setImgPath(imagePath);
        }
        return enterCarInfoResponse;
    }

    private ExitCarInfoResponse getExitCarInfoResponse(String imagePath) {
        ExitCarInfoResponse exitCarInfoResponse = new ExitCarInfoResponse();
        exitCarInfoResponse.setExitNum("\u672a\u8bc6\u522b");
        exitCarInfoResponse.setCarType(Integer.valueOf(1));
        exitCarInfoResponse.setType(Integer.valueOf(1));
        exitCarInfoResponse.setExitTime(new Date());
        if (imagePath != null) {
            exitCarInfoResponse.setImgUrl(this.ossService.getImageUrl(imagePath));
            exitCarInfoResponse.setImgPath(imagePath);
        }
        return exitCarInfoResponse;
    }
}

