/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.down.p2c.impl;

import com.icetech.basics.constants.TextConstant;
import com.icetech.cloudcenter.api.store.StoreCardService;
import com.icetech.cloudcenter.domain.enumeration.P2cDownCmdEnum;
import com.icetech.cloudcenter.domain.request.p2c.StoredCardRequest;
import com.icetech.cloudcenter.domain.response.p2c.P2cBaseResponse;
import com.icetech.common.domain.SendRequest;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.Response;
import com.icetech.common.exception.ResponseBodyException;
import com.icetech.fee.domain.entity.storecard.StoreCard;
import com.icetech.fee.domain.entity.storecard.StoreCardRecord;
import com.icetech.park.service.AbstractConfigDownService;
import com.icetech.park.service.down.p2c.DownService;
import com.icetech.park.service.down.p2c.ResponseService;
import com.icetech.park.service.down.p2c.SendMsgServiceImpl;
import com.icetech.park.service.handle.P2cDownHandle;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="p2cStoredCardServiceImpl")
public class StoredCardServiceImpl
extends AbstractConfigDownService
implements DownService<List<StoredCardRequest>, Void>,
ResponseService<String> {
    private static final Logger log = LoggerFactory.getLogger(StoredCardServiceImpl.class);
    @Autowired
    private P2cDownHandle p2cDownHandle;
    @Resource
    private StoreCardService storeCardService;
    @Autowired
    private SendMsgServiceImpl sendMsgService;

    @Override
    public ObjectResponse<Void> send(SendRequest sendRequest, String parkCode) {
        Long serviceId = sendRequest.getServiceId();
        try {
            StoredCardRequest request = null;
            if ("use".equals(sendRequest.getInclude())) {
                return ObjectResponse.failed((String)"406");
            }
            ObjectResponse recordResp = this.storeCardService.getStoreCardRecordById(serviceId.longValue());
            if (!ObjectResponse.isSuccess((Response)recordResp)) {
                return ObjectResponse.failed((String)"410", (String)TextConstant.getDefaultMessage((String)"1", (String)"\u50a8\u503c\u5361\u8bb0\u5f55\u4e0d\u5b58\u5728"));
            }
            StoreCardRecord record = (StoreCardRecord)recordResp.getData();
            int operaType = this.convertOperaType(record.getCardOperType());
            ObjectResponse storeCardResp = this.storeCardService.getStoreCardDetail(Integer.valueOf(record.getCardId().intValue()));
            if (!ObjectResponse.isSuccess((Response)storeCardResp)) {
                return ObjectResponse.failed((String)"410", (String)TextConstant.getDefaultMessage((String)"1", (String)"\u50a8\u503c\u5361\u4fe1\u606f\u4e0d\u5b58\u5728"));
            }
            StoreCard storeCard = (StoreCard)storeCardResp.getData();
            request = this.buildRequest(storeCard);
            request.setOperType(Integer.valueOf(operaType));
            request.setCardId(record.getCardId());
            request.setPlateNums(record.getPlateNum() == null ? "" : record.getPlateNum().replace(",", "/"));
            ArrayList<StoredCardRequest> list = new ArrayList<StoredCardRequest>();
            list.add(request);
            return this.sendMsgService.send2Park(sendRequest, parkCode, list);
        }
        catch (ResponseBodyException e) {
            log.warn("[\u7aef\u4e91\u50a8\u503c\u5361\u4e0b\u53d1] \u4e0b\u53d1\u5931\u8d25, code[{}], msg[{}]", new Object[]{e.getErrCode(), e.getMessage(), e});
            return ObjectResponse.failed((String)e.getErrCode(), (String)TextConstant.getDefaultMessage((String)"1", (String)(e.getMessage() == null ? "\u7aef\u4e91\u50a8\u503c\u5361\u4e0b\u53d1\u5931\u8d25" : e.getMessage())));
        }
        catch (Exception e) {
            log.error("[\u7aef\u4e91\u50a8\u503c\u5361\u4e0b\u53d1] \u4e0b\u53d1\u50a8\u503c\u5361\u64cd\u4f5c\u8bb0\u5f55\u5931\u8d25", (Throwable)e);
            return ObjectResponse.failed((String)"410", (String)TextConstant.getDefaultMessage((String)"1", (String)"\u7aef\u4e91\u50a8\u503c\u5361\u4e0b\u53d1\u5931\u8d25"));
        }
    }

    private StoredCardRequest buildRequest(StoreCard storeCard) {
        StoredCardRequest request = new StoredCardRequest();
        request.setCardOwner(storeCard.getCardOwner());
        if (storeCard.getStartTime() == null || storeCard.getEndTime() == null) {
            throw new ResponseBodyException("410", TextConstant.getDefaultMessage((String)"1", (String)"\u65e5\u671f\u4e0d\u5408\u6cd5"));
        }
        request.setStartTime(DateFormatUtils.format((Date)storeCard.getStartTime(), (String)"yyyy-MM-dd") + " 00:00:00");
        request.setEndTime(DateFormatUtils.format((Date)storeCard.getEndTime(), (String)"yyyy-MM-dd") + " 23:59:59");
        return request;
    }

    private int convertOperaType(int operaType) {
        if (operaType == 3) {
            return 2;
        }
        if (operaType == 4) {
            return 3;
        }
        return operaType;
    }

    @Override
    public void dealResponse(P2cBaseResponse<String> p2cBaseResponse, Long parkId, String parkCode, String sn) {
        this.p2cDownHandle.dealResponse(p2cBaseResponse, parkId, P2cDownCmdEnum.\u50a8\u503c\u5361\u8f66\u8f86\u4fe1\u606f.getCmdType());
    }
}

