/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.down.p2c.impl;

import com.icetech.cloudcenter.api.order.CarOrderEnterService;
import com.icetech.cloudcenter.api.order.CarOrderExitService;
import com.icetech.cloudcenter.api.order.OrderService;
import com.icetech.cloudcenter.domain.enumeration.DataCollectionEnum;
import com.icetech.cloudcenter.domain.enumeration.EnexTypeEnum;
import com.icetech.cloudcenter.domain.enumeration.P2cDownCmdEnum;
import com.icetech.cloudcenter.domain.request.CarEnterRequest;
import com.icetech.cloudcenter.domain.request.CarExitRequest;
import com.icetech.cloudcenter.domain.request.DataEnterRequest;
import com.icetech.cloudcenter.domain.request.DataExitRequest;
import com.icetech.cloudcenter.domain.request.p2c.SoftTriggerRequest;
import com.icetech.cloudcenter.domain.response.EnterCarInfoResponse;
import com.icetech.cloudcenter.domain.response.ExitCarInfoResponse;
import com.icetech.cloudcenter.domain.response.QueryOrderFeeResponse;
import com.icetech.cloudcenter.domain.response.p2c.P2cBaseResponse;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.Response;
import com.icetech.common.utils.DateTools;
import com.icetech.common.utils.JsonUtils;
import com.icetech.common.utils.StringUtils;
import com.icetech.common.utils.UUIDTools;
import com.icetech.order.domain.entity.OrderInfo;
import com.icetech.oss.OssService;
import com.icetech.park.component.AsyncNotifyClient;
import com.icetech.park.handle.CacheHandle;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.down.CaptureService;
import com.icetech.park.service.down.Message;
import com.icetech.park.service.down.p2c.ResponseService;
import com.icetech.park.service.handle.P2cDownHandle;
import com.icetech.third.domain.entity.third.SendInfoRecord;
import com.icetech.third.utils.RedisUtils;
import java.util.Date;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="p2cSoftTriggerServiceImpl")
public class SoftTriggerServiceImpl
extends AbstractService
implements CaptureService,
ResponseService<String> {
    private static final Logger log = LoggerFactory.getLogger(SoftTriggerServiceImpl.class);
    @Autowired
    private CacheHandle cacheHandle;
    @Autowired
    private P2cDownHandle p2cDownHandle;
    @Autowired
    private RedisUtils redisUtils;
    @Autowired
    private OrderService orderService;
    @Autowired
    private OssService ossService;
    @Autowired
    private CarOrderEnterService carOrderEnterService;
    @Autowired
    private CarOrderExitService carOrderExitService;
    @Resource
    private AsyncNotifyClient asyncNotifyClient;
    public static final String LOCK_KEY = "softTrigger:";

    @Override
    public ObjectResponse<Void> execute(Long parkId, String parkCode, String channelId, String topic, SoftTriggerRequest extraInfo) {
        SoftTriggerRequest softTriggerRequest = new SoftTriggerRequest();
        String triggerNo = UUIDTools.getUuid();
        softTriggerRequest.setTriggerNo(triggerNo);
        String deviceNo = this.cacheHandle.getSerialNumber(parkCode, channelId);
        Message<SoftTriggerRequest> message = new Message<SoftTriggerRequest>(parkId, P2cDownCmdEnum.\u8f6f\u89e6\u53d1.getCmdType(), softTriggerRequest);
        if (this.redisUtils.tryLock(LOCK_KEY + deviceNo, deviceNo, 3000L)) {
            String messageId = this.p2cDownHandle.send(parkCode, deviceNo, message, topic, JsonUtils.toString((Object)extraInfo));
            if (messageId == null) {
                this.redisUtils.releaseLock(LOCK_KEY + deviceNo);
                return ObjectResponse.failed((String)"3003", (String)"\u76f8\u673a\u672a\u8fde\u63a5");
            }
            this.redisUtils.set("messageId:triggerNo:" + triggerNo, (Object)messageId, 10L);
            return ObjectResponse.failed((String)"12002", (String)triggerNo);
        }
        return ObjectResponse.failed((String)"405", (String)"\u64cd\u4f5c\u592a\u5feb\uff0c\u8bf7\u7a0d\u540e");
    }

    @Override
    public ObjectResponse<String> executeAsync(Long parkId, String parkCode, String channelId) {
        SoftTriggerRequest softTriggerRequest = new SoftTriggerRequest();
        String triggerNo = UUIDTools.getUuid();
        softTriggerRequest.setTriggerNo(triggerNo);
        String deviceNo = this.cacheHandle.getSerialNumber(parkCode, channelId);
        Message<SoftTriggerRequest> message = new Message<SoftTriggerRequest>(parkId, P2cDownCmdEnum.\u8f6f\u89e6\u53d1.getCmdType(), softTriggerRequest);
        String messageId = this.p2cDownHandle.send(parkCode, deviceNo, message);
        if (messageId == null) {
            return ObjectResponse.failed((String)"3003", (String)"\u76f8\u673a\u672a\u8fde\u63a5");
        }
        return ObjectResponse.success((Object)triggerNo);
    }

    @Override
    public void dealResponse(P2cBaseResponse<String> p2cBaseResponse, Long parkId, String parkCode, String deviceNo) {
        this.p2cDownHandle.dealResponse(p2cBaseResponse, parkId, P2cDownCmdEnum.\u8f6f\u89e6\u53d1.getCmdType());
    }

    public void notify(String triggerNo, Object object, SendInfoRecord<SoftTriggerRequest> sendInfoRecord) {
        log.debug("triggerNo:{}, object:{}, sendInfoRecord: {}", new Object[]{triggerNo, object, sendInfoRecord});
        Map extraInfo = JsonUtils.parseStringMap((String)sendInfoRecord.getExtraInfo());
        String biz = (String)extraInfo.get("biz");
        if (SoftTriggerRequest.ExtraInfoEnum.ALLOW_ENTER.val.equals(biz)) {
            CarEnterRequest entrance = (CarEnterRequest)object;
            entrance.setPlateNum((String)extraInfo.get("plateNum"));
            DataEnterRequest enterRequest = (DataEnterRequest)JsonUtils.parseObject((String)((String)extraInfo.get("requestVO")), DataEnterRequest.class, (Class[])new Class[0]);
            entrance.setType(enterRequest.getType());
            entrance.setCarType(enterRequest.getCarType());
            entrance.setCarDesc(enterRequest.getSpecialCar());
            entrance.setDebug(enterRequest.isDebug());
            entrance.setEnterTime(Long.valueOf(enterRequest.getEnterTime() == null ? DateTools.unixTimestamp() : enterRequest.getEnterTime()));
            entrance.setEnterWay(Integer.valueOf(entrance.getPlateNum().startsWith("\u4e34") ? 3 : 4));
            entrance.setOperaUser(enterRequest.getOperaUser());
            entrance.setRemark((String)extraInfo.get("remark"));
            entrance.setEnterTerminal(enterRequest.getEnterTerminal());
            ObjectResponse objectResponse = this.carOrderEnterService.enter(entrance);
            if (ObjectResponse.isSuccess((Response)objectResponse)) {
                this.cacheHandle.removeEntrace(sendInfoRecord.getParkCode(), entrance.getInandoutCode());
            }
            log.debug("topic: {}, triggerNo: {}", (Object)sendInfoRecord.getTopic(), (Object)triggerNo);
            this.asyncNotifyClient.callBack(triggerNo, sendInfoRecord.getTopic(), sendInfoRecord.getEnv(), objectResponse);
        } else if (SoftTriggerRequest.ExtraInfoEnum.GET_CAR_INFO.val.equals(biz)) {
            EnterCarInfoResponse enexCarInfoBaseResponse;
            Integer type = Integer.parseInt((String)extraInfo.get("type"));
            if (EnexTypeEnum.\u5165\u573a.getType().equals(type)) {
                try {
                    CarEnterRequest entrance = (CarEnterRequest)object;
                    enexCarInfoBaseResponse = this.getEntranceCarInfoResponse(entrance);
                }
                catch (ClassCastException e) {
                    CarExitRequest exit = (CarExitRequest)object;
                    CarEnterRequest entrance = new CarEnterRequest();
                    BeanUtils.copyProperties((Object)exit, (Object)entrance);
                    entrance.setEnterTime(exit.getExitTime());
                    enexCarInfoBaseResponse = this.getEntranceCarInfoResponse(entrance);
                }
                catch (Exception e) {
                    log.error("\u8f6f\u89e6\u53d1\u5904\u7406\u5f02\u5e38, e=", (Throwable)e);
                    return;
                }
            } else {
                try {
                    CarExitRequest exit = (CarExitRequest)object;
                    if (exit.getInandoutCode() != null) {
                        this.redisUtils.set("softTrigger:image:" + exit.getInandoutCode(), (Object)exit.getMaxImage(), 600L);
                    }
                    enexCarInfoBaseResponse = this.getExitCarInfoResponse(exit.getParkId(), exit.getParkCode(), exit);
                }
                catch (ClassCastException e) {
                    CarEnterRequest entrance = (CarEnterRequest)object;
                    CarExitRequest exit = new CarExitRequest();
                    BeanUtils.copyProperties((Object)entrance, (Object)exit);
                    exit.setExitTime(entrance.getEnterTime());
                    enexCarInfoBaseResponse = this.getExitCarInfoResponse(exit.getParkId(), exit.getParkCode(), exit);
                }
                catch (Exception e) {
                    log.error("\u8f6f\u89e6\u53d1\u5904\u7406\u5f02\u5e38, e=", (Throwable)e);
                    return;
                }
            }
            enexCarInfoBaseResponse.setDataCollection(DataCollectionEnum.\u7aef\u4e91.getType());
            log.debug("enexCarInfoBaseResponse:{}", (Object)enexCarInfoBaseResponse);
            this.asyncNotifyClient.callBack(triggerNo, sendInfoRecord.getTopic(), sendInfoRecord.getEnv(), ObjectResponse.success((Object)enexCarInfoBaseResponse));
        } else if (SoftTriggerRequest.ExtraInfoEnum.ALLOW_EXIT.val.equals(biz)) {
            ObjectResponse objectResponse;
            OrderInfo orderInfo;
            Long enterTime;
            String orderNum;
            ObjectResponse orderInfoObjectResponse;
            CarExitRequest exit = (CarExitRequest)object;
            String cacheOrderNum = exit.getOrderNum();
            DataExitRequest exitRequest = (DataExitRequest)JsonUtils.parseObject((String)((String)extraInfo.get("requestVO")), DataExitRequest.class, (Class[])new Class[0]);
            if (cacheOrderNum != null && !exitRequest.getOrderNum().equals(cacheOrderNum)) {
                log.warn("[\u5e73\u53f0\u79bb\u573a] \u8ba2\u5355\u4e0e\u7f13\u5b58\u4e2d\u7684\u5f02\u5e38\u8ba2\u5355\u4e0d\u5339\u914d\uff0c\u7f13\u5b58\u6570\u636e\u4e3a:{},\u8bf7\u6c42\u53c2\u6570\u4e3a:{}", (Object)exit, (Object)exitRequest);
            }
            if (ObjectResponse.isSuccess((Response)(orderInfoObjectResponse = this.orderService.findByOrderNum(orderNum = exitRequest.getOrderNum()))) && (enterTime = (orderInfo = (OrderInfo)orderInfoObjectResponse.getData()).getEnterTime()) > exitRequest.getExitTime().getTime() / 1000L) {
                exitRequest.setExitTime(new Date());
            }
            exit.setType(exitRequest.getType());
            exit.setInandoutCode(exitRequest.getAisleCode());
            exit.setCarType(exitRequest.getCarType() != null ? exitRequest.getCarType() : exit.getCarType());
            exit.setOrderNum(orderNum == null ? cacheOrderNum : orderNum);
            exit.setPlateNum(exitRequest.getPlateNum());
            exit.setExitTime(Long.valueOf(exit.getExitTime() != null ? exit.getExitTime() : exitRequest.getExitTime().getTime() / 1000L));
            if (exitRequest.getOperAccount() != null) {
                exit.setOperAccount(exitRequest.getOperAccount());
            }
            if (exitRequest.getExitWay() != null) {
                exit.setExitWay(exitRequest.getExitWay());
            }
            if (exitRequest.getExitTerminal() != null) {
                exit.setExitTerminal(exitRequest.getExitTerminal());
            }
            if (ObjectResponse.isSuccess((Response)(objectResponse = this.carOrderExitService.exit(exit)))) {
                this.cacheHandle.removeExit(exitRequest.getParkCode(), exitRequest.getAisleCode());
                this.cacheHandle.removeChannelFee(exitRequest.getParkCode(), exitRequest.getAisleCode());
            }
            log.debug("topic: {}, triggerNo: {}", (Object)sendInfoRecord.getTopic(), (Object)triggerNo);
            this.asyncNotifyClient.callBack(triggerNo, sendInfoRecord.getTopic(), sendInfoRecord.getEnv(), objectResponse);
        } else if (SoftTriggerRequest.ExtraInfoEnum.EXCEPTION_EXIT.val.equals(biz)) {
            CarExitRequest exit = (CarExitRequest)object;
            exit.setPlateNum((String)extraInfo.get("plateNum"));
            exit.setOrderNum((String)extraInfo.get("orderNum"));
            exit.setOperAccount((String)extraInfo.get("operAccount"));
            QueryOrderFeeResponse channelFee = this.cacheHandle.getChannelFee(exit.getParkCode(), exit.getInandoutCode());
            if (channelFee != null) {
                exit.setTotalAmount(channelFee.getTotalAmount());
                exit.setPaidAmount(channelFee.getPaidAmount());
                exit.setDiscountAmount(channelFee.getDiscountAmount());
            }
            exit.setExitWay(Integer.valueOf(4));
            if (extraInfo.get("operAccount") != null) {
                exit.setOperAccount((String)extraInfo.get("operAccount"));
            }
            if (extraInfo.get("exitTerminal") != null) {
                exit.setOperAccount((String)extraInfo.get("exitTerminal"));
            }
            this.carOrderExitService.exceptionExit(exit, extraInfo.get("reasonType") == null ? null : Integer.valueOf(Integer.parseInt((String)extraInfo.get("reasonType"))));
        } else if (SoftTriggerRequest.ExtraInfoEnum.CALL_VOICE_REPORT.val.equals(biz)) {
            int type = Integer.parseInt((String)extraInfo.get("type"));
            if (type == 2) {
                CarExitRequest exit = (CarExitRequest)object;
                exit.setPlateNum((String)extraInfo.get("plateNum"));
                exit.setOrderNum((String)extraInfo.get("orderNum"));
                exit.setOperAccount((String)extraInfo.get("operAccount"));
                this.cacheHandle.setExit(exit.getParkCode(), exit.getInandoutCode(), exit);
            } else {
                CarEnterRequest enterRequest = (CarEnterRequest)object;
                enterRequest.setPlateNum((String)extraInfo.get("plateNum"));
                enterRequest.setOrderNum((String)extraInfo.get("orderNum"));
                enterRequest.setOperaUser((String)extraInfo.get("operAccount"));
                this.cacheHandle.setEntrance(enterRequest.getParkCode(), enterRequest.getInandoutCode(), enterRequest);
            }
            this.asyncNotifyClient.callBack(triggerNo, sendInfoRecord.getTopic(), sendInfoRecord.getEnv(), ObjectResponse.failed((String)((String)extraInfo.get("code")), (String)((String)extraInfo.get("msg"))));
        }
    }

    protected EnterCarInfoResponse getEntranceCarInfoResponse(CarEnterRequest entrace) {
        EnterCarInfoResponse enterCarInfoResponse = new EnterCarInfoResponse();
        enterCarInfoResponse.setEnterNum(entrace.getPlateNum());
        enterCarInfoResponse.setCarType(entrace.getCarType());
        enterCarInfoResponse.setType(entrace.getType());
        enterCarInfoResponse.setOrderNum(entrace.getOrderNum());
        String maxImage = entrace.getMaxImage();
        if (maxImage != null) {
            enterCarInfoResponse.setImgUrl(this.ossService.getImageUrl(maxImage));
            enterCarInfoResponse.setImgPath(maxImage);
        }
        return enterCarInfoResponse;
    }

    private ExitCarInfoResponse getExitCarInfoResponse(Long parkId, String parkCode, CarExitRequest carExitRequest) {
        ObjectResponse byOrderInfo;
        ExitCarInfoResponse exitCarInfoResponse = new ExitCarInfoResponse();
        String orderNum = carExitRequest.getOrderNum();
        exitCarInfoResponse.setExitNum(carExitRequest.getPlateNum());
        exitCarInfoResponse.setCarType(carExitRequest.getCarType());
        exitCarInfoResponse.setType(carExitRequest.getType());
        if (StringUtils.isNotBlank((CharSequence)orderNum)) {
            OrderInfo orderInfo = new OrderInfo();
            orderInfo.setOrderNum(orderNum);
            orderInfo.setParkId(parkId);
            byOrderInfo = this.orderService.findByOrderInfo(orderInfo);
            if (byOrderInfo.getCode().equals("200")) {
                OrderInfo data = (OrderInfo)byOrderInfo.getData();
                exitCarInfoResponse.setEnterTime(new Date(data.getEnterTime() * 1000L));
                exitCarInfoResponse.setEnterNum(data.getPlateNum());
                exitCarInfoResponse.setLocalOrderNum(data.getLocalOrderNum());
                exitCarInfoResponse.setNoneEnterFlag(data.getNoneEnterFlag());
            }
            exitCarInfoResponse.setOrderNum(carExitRequest.getOrderNum());
        } else {
            String plateNum = carExitRequest.getPlateNum();
            byOrderInfo = this.orderService.findInPark(plateNum, parkCode);
            if (byOrderInfo.getCode().equals("200")) {
                OrderInfo data = (OrderInfo)byOrderInfo.getData();
                exitCarInfoResponse.setEnterTime(new Date(data.getEnterTime() * 1000L));
                exitCarInfoResponse.setEnterNum(data.getPlateNum());
                exitCarInfoResponse.setOrderNum(data.getOrderNum());
                exitCarInfoResponse.setLocalOrderNum(data.getLocalOrderNum());
                exitCarInfoResponse.setNoneEnterFlag(data.getNoneEnterFlag());
            }
        }
        Long exitTime = carExitRequest.getExitTime();
        if (exitTime != null) {
            exitCarInfoResponse.setExitTime(new Date(exitTime * 1000L));
        } else {
            exitCarInfoResponse.setExitTime(new Date());
        }
        String maxImage = carExitRequest.getMaxImage();
        if (maxImage != null) {
            exitCarInfoResponse.setImgUrl(this.ossService.getImageUrl(maxImage));
            exitCarInfoResponse.setImgPath(maxImage);
        }
        return exitCarInfoResponse;
    }
}

