/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.down.p2c.impl;

import com.icetech.cloudcenter.api.NotifyService;
import com.icetech.cloudcenter.domain.enumeration.P2cDownCmdEnum;
import com.icetech.cloudcenter.domain.request.p2c.QueryListRequest;
import com.icetech.cloudcenter.domain.response.p2c.P2cBaseResponse;
import com.icetech.cloudcenter.domain.response.p2c.QueryListResponse;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.utils.JsonUtils;
import com.icetech.park.handle.CacheHandle;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.down.Message;
import com.icetech.park.service.down.p2c.ResponseService;
import com.icetech.park.service.handle.P2cDownHandle;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="p2cQueryListServiceImpl")
public class QueryListServiceImpl
extends AbstractService
implements ResponseService<String>,
NotifyService<String> {
    @Autowired
    private P2cDownHandle p2cDownHandle;
    @Autowired
    private CacheHandle cacheHandle;

    public ObjectResponse<List<QueryListResponse>> execute(Long parkId, String parkCode, Integer dataType, String plateNum) {
        QueryListRequest queryListRequest = new QueryListRequest();
        queryListRequest.setDataType(dataType);
        queryListRequest.setPlateNum(plateNum);
        Message<QueryListRequest> message = new Message<QueryListRequest>(parkId, P2cDownCmdEnum.\u540d\u5355\u6570\u636e\u67e5\u8be2.getCmdType(), queryListRequest);
        Object[] messageIdArr = this.p2cDownHandle.send2Park(parkCode, message);
        if (ArrayUtils.isEmpty((Object[])messageIdArr)) {
            return ObjectResponse.failed((String)"3003");
        }
        if (messageIdArr == null) {
            return ObjectResponse.failed((String)"3003");
        }
        ArrayList<QueryListResponse> list = new ArrayList<QueryListResponse>();
        for (Object messageId : messageIdArr) {
            ObjectResponse<String> response = this.cacheHandle.getResponseFromRedis((String)messageId, 4000L);
            if (!ObjectResponse.isSuccess(response)) continue;
            QueryListResponse queryListResponse = this.getQueryListResponse(dataType, response);
            list.add(queryListResponse);
        }
        if (list.size() > 0) {
            return ObjectResponse.success(list);
        }
        return ObjectResponse.failed((String)"404");
    }

    public ObjectResponse queryByDeviceNo(Long parkId, String parkCode, Integer dataType, String plateNum, String deviceNo) {
        ObjectResponse<String> response;
        QueryListRequest queryListRequest = new QueryListRequest();
        queryListRequest.setDataType(dataType);
        queryListRequest.setPlateNum(plateNum);
        Message<QueryListRequest> message = new Message<QueryListRequest>(parkId, P2cDownCmdEnum.\u540d\u5355\u6570\u636e\u67e5\u8be2.getCmdType(), queryListRequest);
        String messageId = this.p2cDownHandle.send(parkCode, deviceNo, message);
        if (messageId == null) {
            return ObjectResponse.failed((String)"3003");
        }
        long timeOut = 4000L;
        if (dataType.intValue() == QueryListRequest.DataType.\u6708\u5361.getVal()) {
            timeOut = 6000L;
        }
        if (ObjectResponse.isSuccess(response = this.cacheHandle.getResponseFromRedis(messageId, timeOut))) {
            QueryListResponse queryListResponse = this.getQueryListResponse(dataType, response);
            return ObjectResponse.success((Object)queryListResponse);
        }
        if ("404".equals(response.getCode())) {
            return ObjectResponse.failed((String)"404");
        }
        return ObjectResponse.failed((String)"3003");
    }

    private QueryListResponse getQueryListResponse(Integer dataType, ObjectResponse<String> response) {
        boolean isArr = ((String)response.getData()).startsWith("[");
        QueryListResponse queryListResponse = new QueryListResponse();
        if (isArr) {
            queryListResponse.setDataType(dataType);
            queryListResponse.setDetails(response.getData());
        } else {
            queryListResponse = (QueryListResponse)JsonUtils.parseObject((String)((String)response.getData()), QueryListResponse.class, (Class[])new Class[0]);
        }
        return queryListResponse;
    }

    @Override
    public void dealResponse(P2cBaseResponse<String> p2CBaseResponse, Long parkId, String parkCode, String deviceNo) {
        this.p2cDownHandle.dealResponse(p2CBaseResponse, parkId, P2cDownCmdEnum.\u540d\u5355\u6570\u636e\u67e5\u8be2.getCmdType());
    }
}

