/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.down.p2c.impl;

import com.icetech.cloudcenter.api.NotifyService;
import com.icetech.cloudcenter.domain.enumeration.P2cDownCmdEnum;
import com.icetech.cloudcenter.domain.request.p2c.QueryInparkRequest;
import com.icetech.cloudcenter.domain.response.p2c.P2cBaseResponse;
import com.icetech.cloudcenter.domain.response.p2c.QueryInparkResponse;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.utils.JsonUtils;
import com.icetech.park.handle.CacheHandle;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.down.Message;
import com.icetech.park.service.down.p2c.ResponseService;
import com.icetech.park.service.handle.P2cDownHandle;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="p2cQueryInparkServiceImpl")
public class QueryInparkServiceImpl
extends AbstractService
implements ResponseService<String>,
NotifyService<String> {
    @Autowired
    private P2cDownHandle p2cDownHandle;
    @Autowired
    private CacheHandle cacheHandle;

    public ObjectResponse<List<QueryInparkResponse>> execute(Long parkId, String parkCode, String plateNum) {
        QueryInparkRequest queryInparkRequest = new QueryInparkRequest();
        queryInparkRequest.setPlateNum(plateNum);
        Message<QueryInparkRequest> message = new Message<QueryInparkRequest>(parkId, P2cDownCmdEnum.\u5728\u573a\u8f66\u8f86\u67e5\u8be2.getCmdType(), queryInparkRequest);
        Object[] messageIdArr = this.p2cDownHandle.send2Park(parkCode, message);
        if (ArrayUtils.isEmpty((Object[])messageIdArr)) {
            return ObjectResponse.failed((String)"3003");
        }
        if (messageIdArr == null) {
            return ObjectResponse.failed((String)"3003");
        }
        ArrayList list = new ArrayList();
        for (Object messageId : messageIdArr) {
            ObjectResponse<String> response = this.cacheHandle.getResponseFromRedis((String)messageId, 5000L);
            if (!ObjectResponse.isSuccess(response)) continue;
            list.addAll(JsonUtils.parseArray((String)((String)response.getData()), QueryInparkResponse.class, (Class[])new Class[0]));
        }
        if (list.size() > 0) {
            return ObjectResponse.success(list);
        }
        return ObjectResponse.failed((String)"404");
    }

    public ObjectResponse<List<QueryInparkResponse>> queryByDeviceNo(Long parkId, String parkCode, String plateNum, String serialNumber) {
        QueryInparkRequest queryInparkRequest = new QueryInparkRequest();
        queryInparkRequest.setPlateNum(plateNum);
        Message<QueryInparkRequest> message = new Message<QueryInparkRequest>(parkId, P2cDownCmdEnum.\u5728\u573a\u8f66\u8f86\u67e5\u8be2.getCmdType(), queryInparkRequest);
        String messageId = this.p2cDownHandle.send(parkCode, serialNumber, message);
        if (messageId == null) {
            return ObjectResponse.failed((String)"3003");
        }
        ObjectResponse<String> response = this.cacheHandle.getResponseFromRedis(messageId, 4000L);
        if (ObjectResponse.isSuccess(response)) {
            return ObjectResponse.success((Object)JsonUtils.parseArray((String)((String)response.getData()), QueryInparkResponse.class, (Class[])new Class[0]));
        }
        return ObjectResponse.failed((String)"3003");
    }

    @Override
    public void dealResponse(P2cBaseResponse<String> p2cBaseResponse, Long parkId, String parkCode, String deviceNo) {
        this.p2cDownHandle.dealResponse(p2cBaseResponse, parkId, P2cDownCmdEnum.\u5728\u573a\u8f66\u8f86\u67e5\u8be2.getCmdType());
    }
}

