/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.down.p2c.impl;

import com.icetech.cloudcenter.domain.enumeration.P2cDownCmdEnum;
import com.icetech.cloudcenter.domain.request.p2c.PropertySetRequest;
import com.icetech.cloudcenter.domain.response.p2c.P2cBaseResponse;
import com.icetech.cloudcenter.domain.vo.p2c.TokenDeviceVo;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.park.handle.CacheHandle;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.down.Message;
import com.icetech.park.service.down.p2c.DownService;
import com.icetech.park.service.down.p2c.ResponseService;
import com.icetech.park.service.handle.P2cDownHandle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="p2cPropertySetServiceImpl")
public class PropertySetServiceImpl
extends AbstractService
implements ResponseService<String>,
DownService<PropertySetRequest, Void> {
    private static final Logger log = LoggerFactory.getLogger(PropertySetServiceImpl.class);
    @Autowired
    private P2cDownHandle p2cDownHandle;
    @Autowired
    private CacheHandle cacheHandle;

    @Override
    public ObjectResponse<Void> send(PropertySetRequest propertySetRequest, String sn) {
        TokenDeviceVo deviceInfo = this.cacheHandle.getDeviceInfo(sn);
        if (deviceInfo == null) {
            return ObjectResponse.failed((String)"3003");
        }
        Message<PropertySetRequest> message = new Message<PropertySetRequest>(deviceInfo.getParkId(), P2cDownCmdEnum.\u5c5e\u6027\u914d\u7f6e\u4e0b\u53d1.getCmdType(), propertySetRequest);
        String messageId = this.p2cDownHandle.send(deviceInfo.getParkCode(), sn, message);
        if (messageId == null) {
            log.info("[\u7aef\u4e91-\u5c5e\u6027\u914d\u7f6e\u4e0b\u53d1] \u4e0b\u53d1\u5931\u8d25\uff0c\u53c2\u6570:{}", (Object)propertySetRequest);
            return ObjectResponse.failed((String)"3003");
        }
        return ObjectResponse.success();
    }

    @Override
    public void dealResponse(P2cBaseResponse<String> p2cBaseResponse, Long parkId, String parkCode, String sn) {
        this.p2cDownHandle.dealResponse(p2cBaseResponse, parkId, P2cDownCmdEnum.\u5c5e\u6027\u914d\u7f6e\u4e0b\u53d1.getCmdType());
    }
}

