/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.down.p2c.impl;

import com.icetech.cloudcenter.domain.enumeration.P2cDownCmdEnum;
import com.icetech.cloudcenter.domain.request.p2c.PropertyInfoRequest;
import com.icetech.cloudcenter.domain.response.p2c.P2cBaseResponse;
import com.icetech.cloudcenter.domain.vo.p2c.TokenDeviceVo;
import com.icetech.common.domain.AsyncNotifyInterface;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.utils.LockPoolUtils;
import com.icetech.park.handle.CacheHandle;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.down.Message;
import com.icetech.park.service.down.p2c.DownService;
import com.icetech.park.service.down.p2c.ResponseService;
import com.icetech.park.service.handle.P2cDownHandle;
import com.icetech.third.utils.RedisUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="p2cPropertyGetServiceImpl")
public class PropertyGetServiceImpl
extends AbstractService
implements ResponseService<String>,
DownService<Void, Void> {
    private static final Logger log = LoggerFactory.getLogger(PropertyGetServiceImpl.class);
    @Autowired
    private P2cDownHandle p2cDownHandle;
    @Autowired
    private CacheHandle cacheHandle;
    @Autowired
    private RedisUtils redisUtils;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ObjectResponse<PropertyInfoRequest> send(String sn, String topic) {
        TokenDeviceVo deviceInfo = this.cacheHandle.getDeviceInfo(sn);
        if (deviceInfo == null) {
            return ObjectResponse.failed((String)"3003");
        }
        Message<Object> message = new Message<Object>(deviceInfo.getParkId(), P2cDownCmdEnum.\u5c5e\u6027\u83b7\u53d6.getCmdType(), null);
        String messageId = this.p2cDownHandle.send(deviceInfo.getParkCode(), sn, message);
        if (messageId == null) {
            log.info("[\u7aef\u4e91-\u5c5e\u6027\u83b7\u53d6] \u4e0b\u53d1\u5931\u8d25, sn[{}}]", (Object)sn);
            return ObjectResponse.failed((String)"3003");
        }
        this.redisUtils.set("p2c:property:get:flag:" + sn, (Object)(messageId + "/" + AsyncNotifyInterface.getTopic()), 8L);
        LockPoolUtils.add((String)messageId);
        String string = messageId;
        synchronized (string) {
            try {
                messageId.wait(4000L);
            }
            catch (InterruptedException e) {
                log.error("messageId {} wait error:", (Object)messageId, (Object)e);
            }
        }
        LockPoolUtils.remove((String)messageId);
        PropertyInfoRequest data = (PropertyInfoRequest)this.redisUtils.get("p2c:property:get:info:" + sn, PropertyInfoRequest.class);
        if (data == null) {
            return ObjectResponse.failed((String)"3005");
        }
        return ObjectResponse.success((Object)data);
    }

    @Override
    public void dealResponse(P2cBaseResponse<String> p2cBaseResponse, Long parkId, String parkCode, String sn) {
        this.p2cDownHandle.dealResponse(p2cBaseResponse, parkId, P2cDownCmdEnum.\u5c5e\u6027\u83b7\u53d6.getCmdType());
    }
}

