/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.down.p2c.impl;

import com.icetech.basics.constants.TextConstant;
import com.icetech.basics.domain.entity.device.ParkDevice;
import com.icetech.basics.domain.entity.park.ParkInoutdevice;
import com.icetech.cloudcenter.api.order.OrderPayService;
import com.icetech.cloudcenter.api.order.OrderService;
import com.icetech.cloudcenter.api.park.ParkDeviceService;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.domain.charge.dto.OrderSumFeeDto;
import com.icetech.cloudcenter.domain.enumeration.P2cDownCmdEnum;
import com.icetech.cloudcenter.domain.request.CarExitRequest;
import com.icetech.cloudcenter.domain.request.NoplateExitRequest;
import com.icetech.cloudcenter.domain.request.p2c.PrepaySyncRequest;
import com.icetech.cloudcenter.domain.response.p2c.P2cBaseResponse;
import com.icetech.common.domain.SendRequest;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.Response;
import com.icetech.common.exception.ResponseBodyException;
import com.icetech.common.utils.MoneyTool;
import com.icetech.common.utils.StringUtils;
import com.icetech.order.domain.entity.OrderInfo;
import com.icetech.order.domain.entity.OrderPay;
import com.icetech.park.handle.CacheHandle;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.down.p2c.DownService;
import com.icetech.park.service.down.p2c.ResponseService;
import com.icetech.park.service.down.p2c.SendMsgServiceImpl;
import com.icetech.park.service.down.p2c.impl.P2cNoplateExitServiceImpl;
import com.icetech.park.service.handle.P2cDownHandle;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="p2cPrepaySyncServiceImpl")
public class PrepaySyncServiceImpl
extends AbstractService
implements ResponseService<String>,
DownService<PrepaySyncRequest, Void> {
    private static final Logger log = LoggerFactory.getLogger(PrepaySyncServiceImpl.class);
    @Autowired
    private OrderPayService orderPayService;
    @Autowired
    private OrderService orderService;
    @Autowired
    private P2cDownHandle p2cDownHandle;
    @Autowired
    private SendMsgServiceImpl sendMsgService;
    @Autowired
    private CacheHandle cacheHandle;
    @Autowired
    private P2cNoplateExitServiceImpl p2cNoplateExitService;
    @Autowired
    private ParkService parkService;
    @Autowired
    private ParkDeviceService parkDeviceService;

    @Override
    public ObjectResponse<Void> send(SendRequest sendRequest, String parkCode) {
        String channelId;
        Long serviceId = sendRequest.getServiceId();
        OrderPay orderPay = new OrderPay();
        orderPay.setId(serviceId);
        ObjectResponse objectResponse = this.orderPayService.findOne(orderPay);
        if (!ObjectResponse.isSuccess((Response)objectResponse)) {
            return ObjectResponse.failed((String)"410", (String)TextConstant.getDefaultMessage((String)"1", (String)"\u652f\u4ed8\u5355\u8bb0\u5f55\u4e0d\u5b58\u5728"));
        }
        ObjectResponse.notError((Response)objectResponse);
        OrderPay orderPayRes = (OrderPay)objectResponse.getData();
        PrepaySyncRequest prepaySyncRequest = this.buildRequest(orderPayRes, parkCode);
        CarExitRequest cacheExitOrder = this.cacheHandle.getExitByOrderNum(parkCode, orderPayRes.getOrderNum());
        if (StringUtils.isBlank((CharSequence)orderPayRes.getChannelId()) && cacheExitOrder != null) {
            this.cacheHandle.removeExitOrder(parkCode, orderPayRes.getOrderNum());
            String inandoutCode = cacheExitOrder.getInandoutCode();
            CarExitRequest cacheExit = this.cacheHandle.getExit(parkCode, inandoutCode);
            if (cacheExit != null && cacheExit.getOrderNum() != null && cacheExit.getOrderNum().equals(orderPayRes.getOrderNum())) {
                Long exitTime = cacheExitOrder.getExitTime();
                log.info("<\u7aef\u4e91-\u9884\u7f34\u8d39\u4e0b\u53d1> \u7f13\u5b58\u4e2d\u7684\u79bb\u573a\u65f6\u95f4\u4e0e\u5f53\u524d\u65f6\u95f4\u76f8\u5dee{}s", (Object)(System.currentTimeMillis() / 1000L - exitTime));
                NoplateExitRequest noplateExitRequest = new NoplateExitRequest();
                noplateExitRequest.setParkCode(parkCode);
                noplateExitRequest.setChannelId(cacheExitOrder.getInandoutCode());
                noplateExitRequest.setExitTime(exitTime);
                noplateExitRequest.setPlateNum(cacheExitOrder.getPlateNum());
                noplateExitRequest.setOrderNum(orderPayRes.getOrderNum());
                this.p2cNoplateExitService.noplateExit(noplateExitRequest);
            }
        }
        if ((channelId = orderPayRes.getChannelId()) != null) {
            ObjectResponse inoutdeviceObjectResponse = this.parkService.getInOutDeviceByCode(orderPayRes.getParkId(), channelId);
            ObjectResponse.notError((Response)inoutdeviceObjectResponse);
            ParkInoutdevice parkInoutdevice = (ParkInoutdevice)inoutdeviceObjectResponse.getData();
            if (parkInoutdevice != null && parkInoutdevice.getIsMaster() != null && parkInoutdevice.getIsMaster() == 0) {
                String devices = this.getSonExit(sendRequest.getParkId());
                if (StringUtils.isNotBlank((CharSequence)devices)) {
                    return this.sendMsgService.send2Devices(devices, sendRequest, parkCode, prepaySyncRequest);
                }
                return ObjectResponse.failed((String)"406", (String)"\u6ca1\u6709\u6ee1\u8db3\u4e0b\u53d1\u6761\u4ef6\u7684\u8bbe\u5907");
            }
        }
        return this.sendMsgService.send2Exit(sendRequest, parkCode, prepaySyncRequest);
    }

    private PrepaySyncRequest buildRequest(OrderPay orderPay, String parkCode) {
        PrepaySyncRequest prepaySyncRequest = new PrepaySyncRequest();
        prepaySyncRequest.setOrderNum(orderPay.getOrderNum());
        ObjectResponse objectResponse = this.orderService.findByOrderNum(orderPay.getOrderNum());
        if (!"200".equals(objectResponse.getCode())) {
            log.info("Dubbo\u6839\u636e\u8ba2\u5355\u53f7\u67e5\u8be2\u672a\u627e\u5230\u8bb0\u5f55\uff0c\u8ba2\u5355\u53f7\uff1a{}\uff0c\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)orderPay.getOrderNum(), (Object)objectResponse);
            throw new ResponseBodyException(objectResponse.getCode(), "\u8ba2\u5355\u53f7\u4e0d\u5b58\u5728");
        }
        OrderInfo orderInfo = (OrderInfo)objectResponse.getData();
        prepaySyncRequest.setPlateNum(orderInfo.getPlateNum());
        prepaySyncRequest.setTradeNo(orderPay.getTradeNo());
        prepaySyncRequest.setTotalPrice(orderPay.getTotalPrice());
        prepaySyncRequest.setPrepay(orderPay.getPaidPrice());
        prepaySyncRequest.setDiscountPrice(orderPay.getDiscountPrice());
        prepaySyncRequest.setPayTime(orderPay.getPayTime());
        ObjectResponse sumFeeDtoObjectResponse = this.orderPayService.getSumFee(parkCode, orderPay.getOrderNum());
        ObjectResponse.notError((Response)sumFeeDtoObjectResponse);
        OrderSumFeeDto sumFeeDto = (OrderSumFeeDto)sumFeeDtoObjectResponse.getData();
        prepaySyncRequest.setPrepayFen(Integer.valueOf(Integer.parseInt(MoneyTool.fromYuanToFen((String)String.valueOf(sumFeeDto.getPaidPrice())))));
        prepaySyncRequest.setDiscountPriceFen(Integer.valueOf(Integer.parseInt(MoneyTool.fromYuanToFen((String)String.valueOf(sumFeeDto.getDiscountPrice())))));
        return prepaySyncRequest;
    }

    private String getSonExit(Long parkId) {
        ObjectResponse objectResponse = this.parkService.getChannelByType(parkId, Integer.valueOf(2));
        ObjectResponse.notError((Response)objectResponse);
        StringBuilder sendDevices = new StringBuilder();
        List inoutdevices = (List)objectResponse.getData();
        for (ParkInoutdevice inoutdevice : inoutdevices) {
            if (inoutdevice.getIsMaster() == null || inoutdevice.getIsMaster() != 0) continue;
            ObjectResponse deviceListResponse = this.parkDeviceService.getDeviceListByParkChannelId(parkId, Integer.valueOf(inoutdevice.getId().intValue()), 1);
            if (ObjectResponse.isSuccess((Response)deviceListResponse)) {
                List parkDevices = (List)deviceListResponse.getData();
                for (ParkDevice parkDevice : parkDevices) {
                    String serialNumber = parkDevice.getSerialNumber();
                    sendDevices.append(serialNumber).append(";");
                }
                continue;
            }
            log.info("\u901a\u9053{}\u4e0b\u5c1a\u672a\u6dfb\u52a0\u8bbe\u5907", (Object)inoutdevice.getInandoutCode());
        }
        return sendDevices.toString();
    }

    @Override
    public void dealResponse(P2cBaseResponse<String> p2cBaseResponse, Long parkId, String parkCode, String deviceNo) {
        this.p2cDownHandle.dealResponse(p2cBaseResponse, parkId, P2cDownCmdEnum.\u9884\u7f34\u8d39.getCmdType());
    }
}

