/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.down.p2c.impl;

import com.icetech.cloudcenter.api.AlarmService;
import com.icetech.cloudcenter.api.NotifyService;
import com.icetech.cloudcenter.domain.enumeration.P2cDownCmdEnum;
import com.icetech.cloudcenter.domain.enumeration.P2cVersionEnum;
import com.icetech.cloudcenter.domain.request.CarEnterRequest;
import com.icetech.cloudcenter.domain.request.CarExitRequest;
import com.icetech.cloudcenter.domain.request.CloseBrakeRequest;
import com.icetech.cloudcenter.domain.request.OpenBrakeRequest;
import com.icetech.cloudcenter.domain.request.OpeningDtoRequest;
import com.icetech.cloudcenter.domain.request.p2c.RemoteSwitchRequest;
import com.icetech.cloudcenter.domain.response.p2c.P2cBaseResponse;
import com.icetech.cloudcenter.domain.response.p2c.RemoteSwitchResponse;
import com.icetech.cloudcenter.domain.vo.p2c.TokenDeviceVo;
import com.icetech.common.constants.LogWarnTypeEnum;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.Response;
import com.icetech.common.exception.ResponseBodyException;
import com.icetech.common.utils.DateTools;
import com.icetech.common.utils.JsonUtils;
import com.icetech.park.component.AsyncNotifyClient;
import com.icetech.park.domain.entity.ChannelAlarm;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.park.service.down.Message;
import com.icetech.park.service.down.RemoteOperaCommon;
import com.icetech.park.service.down.RemoteOperaService;
import com.icetech.park.service.down.p2c.ResponseService;
import com.icetech.park.service.flow.p2c.FlowCondition;
import com.icetech.park.service.handle.P2cDownHandle;
import com.icetech.park.service.makeup.WsRepeatPush;
import com.icetech.third.domain.entity.third.SendInfoRecord;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import javax.annotation.Resource;
import org.apache.commons.lang3.RandomUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="p2cRemoteSwitchServiceImpl")
public class P2cRemoteSwitchServiceImpl
extends RemoteOperaCommon
implements RemoteOperaService,
ResponseService<String>,
NotifyService<RemoteSwitchRequest> {
    private static final Logger log = LoggerFactory.getLogger(P2cRemoteSwitchServiceImpl.class);
    @Autowired
    private P2cDownHandle downHandle;
    @Resource
    private AsyncNotifyClient asyncNotifyClient;
    @Autowired
    private ScheduledThreadPoolExecutor asyncMethodScheduler;
    @Autowired
    private AlarmService alarmService;

    @Override
    public ObjectResponse<RemoteSwitchResponse> execute(Integer switchType, String parkCode, String channelId, String plateNum) {
        ObjectResponse parkObjectResponse = this.parkService.findByParkCode(parkCode);
        if (ObjectResponse.isSuccess((Response)parkObjectResponse)) {
            String deviceNo;
            Long parkId = ((Park)parkObjectResponse.getData()).getId();
            try {
                deviceNo = this.cacheHandle.getSerialNumber(parkCode, channelId);
            }
            catch (ResponseBodyException e) {
                return ObjectResponse.failed((String)"3003");
            }
            return this.execute(switchType, parkId, parkCode, deviceNo, plateNum);
        }
        return ObjectResponse.failed((String)"400");
    }

    @Override
    public ObjectResponse<RemoteSwitchResponse> execute(Integer switchType, Long parkId, String parkCode, String serialNumber, String plateNum) {
        int sequenceId = RandomUtils.nextInt((int)100000, (int)1000000);
        String messageId = this.open(switchType, parkId, parkCode, serialNumber, plateNum, sequenceId, null);
        if (messageId == null) {
            TokenDeviceVo tokenInfo2 = this.cacheHandle.getDeviceInfo(serialNumber);
            if (tokenInfo2 != null) {
                this.alarmService.switchFailHandler(parkCode, parkId, tokenInfo2.getInandoutCode());
            }
            return ObjectResponse.failed((String)"3003");
        }
        RemoteSwitchResponse remoteSwitchResponse = this.cacheHandle.getRemoteSwitch(messageId);
        if (remoteSwitchResponse != null) {
            Long executeTime = remoteSwitchResponse.getExecuteTime();
            TokenDeviceVo tokenInfo2 = this.cacheHandle.getDeviceInfo(serialNumber);
            if (tokenInfo2 != null && tokenInfo2.getVersion().equals(P2cVersionEnum.\u7248\u672c1.getVersion())) {
                remoteSwitchResponse.setExecuteTime(Long.valueOf(DateTools.getUnixTime((long)executeTime)));
            }
            if (Integer.valueOf(3).equals(remoteSwitchResponse.getResult())) {
                log.warn("alarmType:[{}],keyword1:[{}],keyword2:[{}]", new Object[]{LogWarnTypeEnum.\u5f00\u95f8\u5931\u8d25.name() + "-\u76f8\u673a\u8d85\u65f6\u672a\u5904\u7406", "parkCode: " + parkCode + ", serialNumber: " + serialNumber + ", plateNum: " + plateNum, remoteSwitchResponse});
                if (tokenInfo2 != null) {
                    this.alarmService.switchFailHandler(parkCode, parkId, tokenInfo2.getInandoutCode());
                }
            }
            return ObjectResponse.success((Object)remoteSwitchResponse);
        }
        log.warn("[\u76d1\u63a7\u57cb\u70b9] alarmType:[{}],keyword1:[{}],keyword2:[{}]", new Object[]{LogWarnTypeEnum.\u5f00\u95f8\u5931\u8d25.name() + "-\u7aef\u4e91", "parkCode: " + parkCode + ", serialNumber: " + serialNumber + ", plateNum: " + plateNum, remoteSwitchResponse});
        TokenDeviceVo tokenInfo2 = this.cacheHandle.getDeviceInfo(serialNumber);
        if (tokenInfo2 != null) {
            String channelCode = tokenInfo2.getInandoutCode();
            new WsRepeatPush(this.downHandle, parkCode, serialNumber).push(this.asyncMethodScheduler, () -> {
                String msgId = this.open(switchType, parkId, parkCode, serialNumber, plateNum, sequenceId, null);
                if (msgId != null) {
                    boolean success;
                    RemoteSwitchResponse response = this.cacheHandle.getRemoteSwitch(msgId);
                    log.info("msgId\uff1a{} \u54cd\u5e94\uff1a{}", (Object)msgId, (Object)response);
                    boolean bl = success = response != null && response.getResult() == 1;
                    if (!success) {
                        this.alarmService.switchFailHandler(parkCode, parkId, channelCode);
                    }
                    return success;
                }
                this.alarmService.switchFailHandler(parkCode, parkId, channelCode);
                return false;
            });
        }
        return ObjectResponse.failed((String)"3002");
    }

    @Override
    public ObjectResponse<Void> execute(Integer switchType, String parkCode, String serialNumber, String plateNum, String topic, RemoteSwitchRequest.ExtraInfo extraInfo) {
        ObjectResponse parkObjectResponse = this.parkService.findByParkCode(parkCode);
        if (!ObjectResponse.isSuccess((Response)parkObjectResponse)) {
            throw new ResponseBodyException("402", "\u8f66\u573a\u4e0d\u5b58\u5728");
        }
        Long parkId = ((Park)parkObjectResponse.getData()).getId();
        RemoteSwitchRequest remoteSwitchRequest = new RemoteSwitchRequest();
        remoteSwitchRequest.setSequenceId(Integer.valueOf(RandomUtils.nextInt((int)100000, (int)1000000)));
        remoteSwitchRequest.setSwitchType(switchType);
        remoteSwitchRequest.setPlateNum(plateNum);
        Long sendTime = DateTools.unixTimestamp();
        remoteSwitchRequest.setTime(sendTime);
        Message<RemoteSwitchRequest> message = new Message<RemoteSwitchRequest>(parkId, P2cDownCmdEnum.\u8fdc\u7a0b\u5f00\u5173\u95f8.getCmdType(), remoteSwitchRequest);
        String messageId = this.downHandle.send(parkCode, serialNumber, message, topic, JsonUtils.toString((Object)extraInfo));
        if (messageId == null) {
            return ObjectResponse.failed((String)"3002");
        }
        return ObjectResponse.failed((String)"12002", (String)messageId);
    }

    @Override
    public String open(Integer switchType, Long parkId, String parkCode, String serialNumber, String plateNum) {
        return this.open(switchType, parkId, parkCode, serialNumber, plateNum, RandomUtils.nextInt((int)100000, (int)1000000), null);
    }

    @Override
    public String open(Integer switchType, Long parkId, String parkCode, String serialNumber, String plateNum, String topic) {
        return this.open(switchType, parkId, parkCode, serialNumber, plateNum, RandomUtils.nextInt((int)100000, (int)1000000), topic);
    }

    @Override
    public String open(Integer switchType, Long parkId, String parkCode, String serialNumber, String plateNum, Integer sequenceId, String topic) {
        RemoteSwitchRequest remoteSwitchRequest = new RemoteSwitchRequest();
        remoteSwitchRequest.setSequenceId(sequenceId);
        remoteSwitchRequest.setSwitchType(switchType);
        remoteSwitchRequest.setPlateNum(plateNum);
        Long sendTime = DateTools.unixTimestamp();
        remoteSwitchRequest.setTime(sendTime);
        Message<RemoteSwitchRequest> message = new Message<RemoteSwitchRequest>(parkId, P2cDownCmdEnum.\u8fdc\u7a0b\u5f00\u5173\u95f8.getCmdType(), remoteSwitchRequest);
        return this.downHandle.send(parkCode, serialNumber, message);
    }

    @Override
    public ObjectResponse<RemoteSwitchResponse> secondOpen(RemoteSwitchRequest remoteSwitchRequest, Long parkId, String parkCode, String serialNumber) {
        Message<RemoteSwitchRequest> message = new Message<RemoteSwitchRequest>(parkId, P2cDownCmdEnum.\u8fdc\u7a0b\u5f00\u5173\u95f8.getCmdType(), remoteSwitchRequest);
        String messageId = this.downHandle.send(parkCode, serialNumber, message);
        RemoteSwitchResponse remoteSwitchResponse = this.cacheHandle.getRemoteSwitch(messageId);
        if (remoteSwitchResponse != null) {
            Long executeTime = remoteSwitchResponse.getExecuteTime();
            TokenDeviceVo tokenInfo2 = this.cacheHandle.getDeviceInfo(serialNumber);
            if (tokenInfo2 != null && tokenInfo2.getVersion().equals(P2cVersionEnum.\u7248\u672c1.getVersion())) {
                remoteSwitchResponse.setExecuteTime(Long.valueOf(DateTools.getUnixTime((long)executeTime)));
            }
            return ObjectResponse.success((Object)remoteSwitchResponse);
        }
        return ObjectResponse.failed((String)"3002");
    }

    @Override
    public void dealResponse(P2cBaseResponse<String> p2cBaseResponse, Long parkId, String parkCode, String deviceNo) {
        this.downHandle.dealResponse(p2cBaseResponse, parkId, P2cDownCmdEnum.\u8fdc\u7a0b\u5f00\u5173\u95f8.getCmdType());
    }

    public void notify(String messageId, ObjectResponse<String> response, SendInfoRecord<RemoteSwitchRequest> sendInfoRecord) {
        RemoteSwitchResponse remoteSwitchResponse = null;
        if ("405".equals(response.getCode())) {
            remoteSwitchResponse = new RemoteSwitchResponse();
            remoteSwitchResponse.setResult(Integer.valueOf(1));
            remoteSwitchResponse.setExecuteTime(Long.valueOf(DateTools.unixTimestamp()));
            remoteSwitchResponse.setImage(null);
        } else if (StringUtils.isNotBlank((CharSequence)((CharSequence)response.getData()))) {
            remoteSwitchResponse = (RemoteSwitchResponse)JsonUtils.parseObject((String)((String)response.getData()), RemoteSwitchResponse.class, (Class[])new Class[0]);
        }
        String serialNumber = sendInfoRecord.getTarget();
        TokenDeviceVo tokenInfo2 = this.cacheHandle.getDeviceInfo(serialNumber);
        RemoteSwitchRequest request = (RemoteSwitchRequest)sendInfoRecord.getParams();
        if (remoteSwitchResponse == null) {
            log.warn("[\u76d1\u63a7\u57cb\u70b9] alarmType:[{}],keyword1:[{}],keyword2:[{}]", new Object[]{LogWarnTypeEnum.\u5f00\u95f8\u5931\u8d25.name() + "-\u7aef\u4e91", "parkCode: " + sendInfoRecord.getParkCode() + ", serialNumber: " + serialNumber + ", plateNum: " + request.getPlateNum(), remoteSwitchResponse});
            if (tokenInfo2 != null && tokenInfo2.getInandoutType() != null) {
                this.alarmService.switchFailHandler(sendInfoRecord.getParkCode(), sendInfoRecord.getParkId(), tokenInfo2.getInandoutCode());
            }
            this.asyncNotifyClient.callBack(messageId, sendInfoRecord.getTopic(), sendInfoRecord.getEnv(), ObjectResponse.failed((String)"3002"));
            return;
        }
        Long executeTime = remoteSwitchResponse.getExecuteTime();
        if (tokenInfo2 != null && tokenInfo2.getVersion().equals(P2cVersionEnum.\u7248\u672c1.getVersion())) {
            remoteSwitchResponse.setExecuteTime(Long.valueOf(DateTools.getUnixTime((long)executeTime)));
        }
        if (Integer.valueOf(3).equals(remoteSwitchResponse.getResult())) {
            log.warn("alarmType:[{}],keyword1:[{}],keyword2:[{}]", new Object[]{LogWarnTypeEnum.\u5f00\u95f8\u5931\u8d25.name() + "-\u76f8\u673a\u8d85\u65f6\u672a\u5904\u7406", "parkCode: " + sendInfoRecord.getParkCode() + ", serialNumber: " + serialNumber + ", plateNum: " + request.getPlateNum(), remoteSwitchResponse});
            if (tokenInfo2 != null && tokenInfo2.getInandoutType() != null) {
                this.alarmService.switchFailHandler(sendInfoRecord.getParkCode(), sendInfoRecord.getParkId(), tokenInfo2.getInandoutCode());
            }
            if (sendInfoRecord.getTopic() != null) {
                this.asyncNotifyClient.callBack(messageId, sendInfoRecord.getTopic(), sendInfoRecord.getEnv(), ObjectResponse.failed((String)"3002", (String)"\u76f8\u673a\u65f6\u949f\u6709\u504f\u5dee"));
            }
            return;
        }
        if (sendInfoRecord.getExtraInfo() == null) {
            return;
        }
        RemoteSwitchRequest.ExtraInfo extraInfo = (RemoteSwitchRequest.ExtraInfo)JsonUtils.parseObject((String)sendInfoRecord.getExtraInfo(), RemoteSwitchRequest.ExtraInfo.class, (Class[])new Class[0]);
        if (RemoteSwitchRequest.ExtraInfoEnum.OPEN.val.equals(extraInfo.getBiz())) {
            OpenBrakeRequest openBrakeRequest = (OpenBrakeRequest)JsonUtils.parseObject((String)JsonUtils.toString((Object)extraInfo.getRequestVO()), OpenBrakeRequest.class, (Class[])new Class[0]);
            if (openBrakeRequest.getRecordType() == 1) {
                CarEnterRequest enterRequest = new CarEnterRequest();
                enterRequest.setEnterTime(Long.valueOf(System.currentTimeMillis() / 1000L));
                enterRequest.setType(Integer.valueOf(3));
                enterRequest.setCarType(Integer.valueOf(1));
                enterRequest.setInandoutCode(openBrakeRequest.getAisleCode());
                enterRequest.setParkCode(openBrakeRequest.getParkCode());
                enterRequest.setPlateNum(openBrakeRequest.getPlateNum());
                enterRequest.setProperty(Integer.valueOf(2));
                enterRequest.setOpenFlag(Integer.valueOf(1));
                enterRequest.setOrderNum(openBrakeRequest.getOrderNum());
                this.carOrderEnterService.sendWebsocketMessage(enterRequest, Integer.valueOf(1));
            } else {
                CarExitRequest exitRequest = new CarExitRequest();
                exitRequest.setType(Integer.valueOf(3));
                exitRequest.setCarType(Integer.valueOf(1));
                exitRequest.setExitTime(Long.valueOf(System.currentTimeMillis()));
                exitRequest.setInandoutCode(openBrakeRequest.getAisleCode());
                exitRequest.setParkCode(openBrakeRequest.getParkCode());
                exitRequest.setPlateNum(openBrakeRequest.getPlateNum());
                exitRequest.setOrderNum(openBrakeRequest.getOrderNum());
                exitRequest.setOpenFlag(Integer.valueOf(1));
                this.carOrderExitService.sendWebsocketMessage(exitRequest, "5", FlowCondition.YES, FlowCondition.NO);
            }
            ChannelAlarm channelAlarm = new ChannelAlarm();
            channelAlarm.setParkId(sendInfoRecord.getParkId());
            channelAlarm.setChannelCode(openBrakeRequest.getAisleCode());
            channelAlarm.setStatus(Integer.valueOf(ChannelAlarm.Status.\u5df2\u5904\u7406.getStatus()));
            this.channelAlarmDao.update(channelAlarm);
            if (this.delRemoteSwitchResponse(openBrakeRequest, sendInfoRecord.getParkCode(), remoteSwitchResponse, sendInfoRecord.getParkId())) {
                this.asyncNotifyClient.callBack(messageId, sendInfoRecord.getTopic(), sendInfoRecord.getEnv(), ObjectResponse.success());
            } else {
                this.asyncNotifyClient.callBack(messageId, sendInfoRecord.getTopic(), sendInfoRecord.getEnv(), ObjectResponse.failed((String)"3002"));
            }
        } else if (RemoteSwitchRequest.ExtraInfoEnum.CLOSE.val.equals(extraInfo.getBiz())) {
            CloseBrakeRequest closeBrakeRequest = (CloseBrakeRequest)JsonUtils.parseObject((String)JsonUtils.toString((Object)extraInfo.getRequestVO()), CloseBrakeRequest.class, (Class[])new Class[0]);
            OpeningDtoRequest openingDtoRequest = new OpeningDtoRequest();
            BeanUtils.copyProperties((Object)closeBrakeRequest, (Object)openingDtoRequest);
            openingDtoRequest.setImgUrl(closeBrakeRequest.getImagePath() == null ? remoteSwitchResponse.getImage() : closeBrakeRequest.getImagePath() + "," + remoteSwitchResponse.getImage());
            openingDtoRequest.setExecuteTime(executeTime);
            openingDtoRequest.setSourcegate(Integer.valueOf(4));
            this.parkService.saveOpeningRecord(openingDtoRequest);
            this.asyncNotifyClient.callBack(messageId, sendInfoRecord.getTopic(), sendInfoRecord.getEnv(), ObjectResponse.success());
        }
    }

    @Override
    protected void addOpeningRecord(Object openBrakeRequest, String image, Long executeTime, String imagePath, Long parkId) {
        OpeningDtoRequest openingDtoRequest = new OpeningDtoRequest();
        BeanUtils.copyProperties((Object)openBrakeRequest, (Object)openingDtoRequest);
        openingDtoRequest.setImgUrl(imagePath == null ? image : imagePath + "," + image);
        openingDtoRequest.setExecuteTime(executeTime);
        this.parkService.saveOpeningRecord(openingDtoRequest);
    }
}

