/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.down.p2c.impl;

import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.domain.enumeration.P2cDownCmdEnum;
import com.icetech.cloudcenter.domain.request.p2c.P2cParkRegionRequest;
import com.icetech.cloudcenter.domain.response.p2c.P2cBaseResponse;
import com.icetech.common.domain.SendRequest;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.Response;
import com.icetech.common.utils.NumberUtils;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.down.p2c.DownService;
import com.icetech.park.service.down.p2c.ResponseService;
import com.icetech.park.service.down.p2c.SendMsgServiceImpl;
import com.icetech.park.service.handle.P2cDownHandle;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="p2cParkRegionServiceImpl")
public class P2cParkRegionServiceImpl
extends AbstractService
implements ResponseService<String>,
DownService<List<P2cParkRegionRequest>, Void> {
    private static final Logger log = LoggerFactory.getLogger(P2cParkRegionServiceImpl.class);
    @Resource
    private SendMsgServiceImpl sendMsgService;
    @Resource
    private ParkService parkService;
    @Resource
    private P2cDownHandle p2cDownHandle;

    @Override
    public ObjectResponse<Void> send(SendRequest sendRequest, String parkCode) {
        Long parkId = sendRequest.getParkId();
        List<P2cParkRegionRequest> requestList = this.buildRequest(parkId);
        return this.sendMsgService.send2Park(sendRequest, parkCode, requestList);
    }

    public ObjectResponse<Void> send(Long parkId, String parkCode, String sn) {
        List<P2cParkRegionRequest> requestList = this.buildRequest(parkId);
        SendRequest sendRequest = new SendRequest();
        sendRequest.setParkId(parkId);
        sendRequest.setServiceType(P2cDownCmdEnum.\u533a\u57df\u4fe1\u606f.getCmdType());
        return this.sendMsgService.send2Devices(sn, sendRequest, parkCode, requestList);
    }

    private List<P2cParkRegionRequest> buildRequest(Long parkId) {
        ObjectResponse listObjectResponse = this.parkService.selectRegionById(parkId);
        ObjectResponse.notError((Response)listObjectResponse, (String)("\u67e5\u8be2\u8f66\u573aID[" + parkId + "]\u7684\u533a\u57df\u5217\u8868\u5931\u8d25"));
        List parkRegions = (List)listObjectResponse.getData();
        return parkRegions.stream().map(parkRegion -> P2cParkRegionRequest.builder().regionId(parkRegion.getId()).regionName(parkRegion.getRegionName()).regionType(Integer.valueOf(Long.valueOf(0L).equals(parkRegion.getFatherRelationId()) ? 1 : 2)).parentRegionId(Long.valueOf(NumberUtils.toPrimitive((Long)parkRegion.getFatherRelationId()))).build()).collect(Collectors.toList());
    }

    @Override
    public void dealResponse(P2cBaseResponse<String> p2cBaseResponse, Long parkId, String parkCode, String deviceNo) {
        this.p2cDownHandle.dealResponse(p2cBaseResponse, parkId, P2cDownCmdEnum.\u533a\u57df\u4fe1\u606f.getCmdType());
    }
}

