/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.down.p2c.impl;

import com.icetech.cloudcenter.api.NoplateExitService;
import com.icetech.cloudcenter.api.order.OrderService;
import com.icetech.cloudcenter.domain.enumeration.SwitchTypeEnum;
import com.icetech.cloudcenter.domain.request.DataExitRequest;
import com.icetech.cloudcenter.domain.request.NoplateExitRequest;
import com.icetech.cloudcenter.domain.request.p2c.RemoteSwitchRequest;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.Response;
import com.icetech.order.domain.entity.OrderInfo;
import com.icetech.park.handle.CacheHandle;
import com.icetech.park.handle.DeviceDownServiceFactory;
import com.icetech.park.service.impl.ManageServiceImpl;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class P2cNoplateExitServiceImpl
implements NoplateExitService {
    private static final Logger log = LoggerFactory.getLogger(P2cNoplateExitServiceImpl.class);
    @Autowired
    private ManageServiceImpl manageService;
    @Autowired
    private OrderService orderService;
    @Autowired
    private DeviceDownServiceFactory deviceDownServiceFactory;
    @Autowired
    private CacheHandle cacheHandle;

    public ObjectResponse<Void> noplateExit(NoplateExitRequest noplateExitRequest) {
        String plateNum = noplateExitRequest.getPlateNum();
        String parkCode = noplateExitRequest.getParkCode();
        DataExitRequest exitRequest = new DataExitRequest();
        exitRequest.setOffLine(noplateExitRequest.isOffLine());
        exitRequest.setAisleCode(noplateExitRequest.getChannelId());
        String orderNum = noplateExitRequest.getOrderNum();
        ObjectResponse inPark = orderNum != null ? this.orderService.findByOrderNum(noplateExitRequest.getOrderNum()) : this.orderService.findInPark(plateNum, parkCode);
        if (!ObjectResponse.isSuccess((Response)inPark)) {
            log.info("[\u8f66\u8f86\u79bb\u573a] \u672a\u627e\u5230\u5728\u573a\u8bb0\u5f55\uff0c\u5355\u72ec\u6267\u884c\u5f00\u95f8\uff0c\u8f66\u724c\u53f7[{}]", (Object)plateNum);
            if (noplateExitRequest.isOffLine()) {
                return ObjectResponse.success();
            }
            String serialNumber = this.cacheHandle.getSerialNumber(parkCode, noplateExitRequest.getChannelId());
            return this.deviceDownServiceFactory.buildRemoteOperaService(parkCode).execute(SwitchTypeEnum.\u5f00\u95f8.getType(), parkCode, serialNumber, noplateExitRequest.getPlateNum(), noplateExitRequest.getTopic(), RemoteSwitchRequest.ExtraInfo.builder().biz(RemoteSwitchRequest.ExtraInfoEnum.STANDARD.val).build());
        }
        OrderInfo orderInfo = (OrderInfo)inPark.getData();
        exitRequest.setCarType(orderInfo.getCarType());
        exitRequest.setType(orderInfo.getType());
        exitRequest.setOrderNum(orderInfo.getOrderNum());
        exitRequest.setEnterTime(new Date(orderInfo.getEnterTime() * 1000L));
        exitRequest.setParkCode(parkCode);
        exitRequest.setPlateNum(plateNum);
        exitRequest.setExitTime(new Date(noplateExitRequest.getExitTime() * 1000L));
        exitRequest.setTopic(noplateExitRequest.getTopic());
        exitRequest.setExitWay(noplateExitRequest.getExitWay());
        exitRequest.setOperAccount(noplateExitRequest.getOperAccount());
        exitRequest.setExitTerminal(noplateExitRequest.getExitTerminal());
        return this.manageService.allowExit(exitRequest);
    }
}

