/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.down.p2c.impl;

import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.domain.enumeration.P2cDownCmdEnum;
import com.icetech.cloudcenter.domain.request.p2c.OssConfigRequest;
import com.icetech.cloudcenter.domain.vo.BatchSendVO;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.Response;
import com.icetech.oss.OSSProperties;
import com.icetech.park.config.OssProxyProperties;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.down.Message;
import com.icetech.park.service.down.p2c.DownService;
import com.icetech.park.service.down.p2c.ResponseService;
import com.icetech.park.service.handle.P2cDownHandle;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="p2cOssConfigServiceImpl")
public class OssConfigServiceImpl
extends AbstractService
implements ResponseService<String>,
DownService<OssConfigRequest, Void> {
    private static final Logger log = LoggerFactory.getLogger(OssConfigServiceImpl.class);
    @Autowired
    private OSSProperties ossProperties;
    @Autowired
    private OssProxyProperties ossProxyProperties;
    @Autowired
    private ParkService parkService;
    @Autowired
    private P2cDownHandle p2cDownHandle;

    @Override
    public ObjectResponse<Void> batchSend(BatchSendVO vo) {
        String parkCode = vo.getParkCode();
        List subTaskInfos = vo.getSubTaskInfos();
        subTaskInfos.forEach(subTaskInfo -> this.send(parkCode, subTaskInfo.getSn()));
        return ObjectResponse.success();
    }

    public boolean send(String parkCode, String deviceNo) {
        ObjectResponse byParkCode = this.parkService.findByParkCode(parkCode);
        ObjectResponse.notError((Response)byParkCode);
        Park data = (Park)byParkCode.getData();
        Long parkId = data.getId();
        OssConfigRequest ossConfigRequest = new OssConfigRequest();
        if ("CTYUN".equals(this.ossProperties.getType())) {
            ossConfigRequest.setOssType(Integer.valueOf(8));
        } else {
            ossConfigRequest.setOssType(Integer.valueOf(1));
        }
        if (this.ossProxyProperties != null && this.ossProxyProperties.isEnable()) {
            ossConfigRequest.setAccessKeyId(this.ossProxyProperties.getAccessKeyId());
            ossConfigRequest.setAccessKeySecret(this.ossProxyProperties.getAccessKeySecret());
            ossConfigRequest.setBucketName(this.ossProxyProperties.getBucketName());
            ossConfigRequest.setEndpoint(this.ossProxyProperties.getEndpoint());
        } else {
            ossConfigRequest.setAccessKeyId(this.ossProperties.getAccessKeyId());
            ossConfigRequest.setAccessKeySecret(this.ossProperties.getAccessKeySecret());
            ossConfigRequest.setBucketName(this.ossProperties.getBucketName());
            ossConfigRequest.setEndpoint(this.ossProperties.getEndpoint());
        }
        Message<OssConfigRequest> message = new Message<OssConfigRequest>(parkId, P2cDownCmdEnum.OSS\u914d\u7f6e\u4e0b\u53d1.getCmdType(), ossConfigRequest);
        String messageId = this.p2cDownHandle.send(parkCode, deviceNo, message);
        if (messageId == null) {
            log.info("[\u7aef\u4e91-OSS\u914d\u7f6e\u4e0b\u53d1] \u4e0b\u53d1\u5931\u8d25\uff0c\u53c2\u6570[{}]", (Object)ossConfigRequest);
            return false;
        }
        return true;
    }
}

