/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.down.p2c.impl;

import com.icetech.basics.constants.TextConstant;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.domain.enumeration.P2cDownCmdEnum;
import com.icetech.cloudcenter.domain.request.p2c.MonthCardRequest;
import com.icetech.cloudcenter.domain.response.p2c.P2cBaseResponse;
import com.icetech.common.domain.SendRequest;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.utils.StringUtils;
import com.icetech.park.dao.more.MoreMonthInfoMapper;
import com.icetech.park.domain.entity.more.MoreMonthInfo;
import com.icetech.park.domain.entity.more.MoreMonthPark;
import com.icetech.park.domain.entity.more.MoreMonthPlate;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.down.p2c.DownService;
import com.icetech.park.service.down.p2c.ResponseService;
import com.icetech.park.service.down.p2c.SendMsgServiceImpl;
import com.icetech.park.service.handle.P2cDownHandle;
import com.icetech.park.service.more.MoreMonthParkService;
import com.icetech.park.service.more.MoreMonthPlateService;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Service;

@Service(value="p2cMoreMonthCardServiceImpl")
@RefreshScope
public class MoreMonthCardServiceImpl
extends AbstractService
implements ResponseService<String>,
DownService<MonthCardRequest, Long> {
    private static final Logger log = LoggerFactory.getLogger(MoreMonthCardServiceImpl.class);
    @Autowired
    private P2cDownHandle p2cDownHandle;
    @Autowired
    private MoreMonthInfoMapper moreMonthInfoMapper;
    @Autowired
    private MoreMonthPlateService moreMonthPlateService;
    @Autowired
    private MoreMonthParkService moreMonthParkService;
    @Autowired
    private SendMsgServiceImpl sendMsgService;
    @Autowired
    private ParkService parkService;

    @Override
    public ObjectResponse<Long> send(SendRequest sendRequest, String parkCode) {
        Long serviceId = sendRequest.getServiceId();
        MoreMonthInfo moreMonthInfo = (MoreMonthInfo)this.moreMonthInfoMapper.selectById(serviceId);
        if (moreMonthInfo == null) {
            return ObjectResponse.failed((String)"410", (String)TextConstant.getDefaultMessage((String)"1", (String)"\u96c6\u56e2\u6708\u5361\u4e0d\u5b58\u5728"));
        }
        List<MoreMonthPark> monthParks = this.moreMonthParkService.getMonthParkByMoreMonthId(serviceId);
        if (CollectionUtils.isEmpty(monthParks)) {
            return ObjectResponse.failed((String)"410", (String)TextConstant.getDefaultMessage((String)"2", (String)"\u591a\u8f66\u573a\u6708\u5361\u6ca1\u6709\u5173\u8054\u8f66\u573a"));
        }
        monthParks.forEach(monthPark -> {
            Park park = (Park)this.parkService.findByParkId(monthPark.getParkId()).getData();
            MonthCardRequest monthCardRequest = this.buildRequest(sendRequest, moreMonthInfo, 1);
            sendRequest.setServiceType(P2cDownCmdEnum.\u6708\u5361.getCmdType());
            sendRequest.setParkId(monthPark.getParkId());
            this.sendMsgService.send2Park(sendRequest, park.getParkCode(), monthCardRequest);
        });
        return ObjectResponse.success();
    }

    private MonthCardRequest buildRequest(SendRequest sendRequest, MoreMonthInfo moreMonthInfo, int cardType) {
        Long serviceId = sendRequest.getServiceId();
        MonthCardRequest monthCardRequest = new MonthCardRequest();
        monthCardRequest.setCardOperType(Integer.valueOf(1));
        if (StringUtils.isNotEmpty((CharSequence)sendRequest.getInclude())) {
            monthCardRequest.setCardOperType(Integer.valueOf(4));
        }
        List<MoreMonthPlate> moreMonthPlates = this.moreMonthPlateService.getMoreMonthPlateByMoreMonthId(serviceId);
        String plateNums = moreMonthPlates.stream().map(MoreMonthPlate::getPlateNum).filter(Objects::nonNull).collect(Collectors.joining(","));
        ArrayList<MonthCardRequest.Details> list = new ArrayList<MonthCardRequest.Details>();
        MonthCardRequest.Details details = new MonthCardRequest.Details();
        details.setPlateNum(plateNums);
        details.setCardId(Integer.valueOf(moreMonthInfo.getId().intValue()));
        details.setCardOwner(StringUtils.isBlank((CharSequence)moreMonthInfo.getCardOwner()) ? "default" : moreMonthInfo.getCardOwner());
        details.setStartDate(DateFormatUtils.format((Date)moreMonthInfo.getStartTime(), (String)"yyyy-MM-dd 00:00:00"));
        details.setEndDate(DateFormatUtils.format((Date)moreMonthInfo.getEndTime(), (String)"yyyy-MM-dd 23:59:59"));
        details.setPlotCount(moreMonthInfo.getPlotCount());
        details.setRegionIds("0");
        details.setCardType(Integer.valueOf(cardType));
        list.add(details);
        monthCardRequest.setDetails(list);
        return monthCardRequest;
    }

    @Override
    public void dealResponse(P2cBaseResponse<String> p2cBaseResponse, Long parkId, String parkCode, String deviceNo) {
        this.p2cDownHandle.dealResponse(p2cBaseResponse, parkId, P2cDownCmdEnum.\u96c6\u56e2\u6708\u5361.getCmdType());
    }
}

