/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.down.p2c.impl;

import cn.hutool.core.thread.ThreadUtil;
import cn.hutool.core.util.StrUtil;
import com.github.pagehelper.util.StringUtil;
import com.icetech.basics.constants.TextConstant;
import com.icetech.basics.domain.SendMessage;
import com.icetech.basics.domain.entity.device.ParkDevice;
import com.icetech.basics.domain.entity.park.ParkInoutdevice;
import com.icetech.cloudcenter.api.month.MonthCarService;
import com.icetech.cloudcenter.api.order.OrderService;
import com.icetech.cloudcenter.api.park.ParkDeviceService;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.domain.enumeration.P2cDownCmdEnum;
import com.icetech.cloudcenter.domain.enumeration.P2cVersionEnum;
import com.icetech.cloudcenter.domain.request.p2c.ClearListRequest;
import com.icetech.cloudcenter.domain.request.p2c.MonthCardRequest;
import com.icetech.cloudcenter.domain.request.p2c.QueryListRequest;
import com.icetech.cloudcenter.domain.response.MonthCardDto;
import com.icetech.cloudcenter.domain.response.p2c.P2cBaseResponse;
import com.icetech.cloudcenter.domain.vo.BatchSendRepeatVO;
import com.icetech.cloudcenter.domain.vo.BatchSendVO;
import com.icetech.common.domain.SendRequest;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.Response;
import com.icetech.common.exception.ResponseBodyException;
import com.icetech.common.utils.DateTools;
import com.icetech.common.utils.StringUtils;
import com.icetech.fee.dao.monthcar.MonthProductDao;
import com.icetech.fee.dao.monthcar.MonthRecordDao;
import com.icetech.fee.domain.entity.monthcar.MonthInfo;
import com.icetech.fee.domain.entity.monthcar.MonthProduct;
import com.icetech.fee.domain.entity.monthcar.MonthRecord;
import com.icetech.order.domain.entity.OrderInfo;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.down.Message;
import com.icetech.park.service.down.p2c.DownService;
import com.icetech.park.service.down.p2c.ResponseService;
import com.icetech.park.service.down.p2c.SendMsgServiceImpl;
import com.icetech.park.service.down.p2c.impl.ClearListServiceImpl;
import com.icetech.park.service.handle.BatchDownBizHandle;
import com.icetech.park.service.handle.P2cDownHandle;
import com.icetech.third.utils.JsonUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Service;

@Service(value="p2cMonthCardServiceImpl")
@RefreshScope
public class MonthCardServiceImpl
extends AbstractService
implements ResponseService<String>,
DownService<MonthCardRequest, Long> {
    private static final Logger log = LoggerFactory.getLogger(MonthCardServiceImpl.class);
    @Autowired
    private P2cDownHandle p2cDownHandle;
    @Autowired
    private MonthRecordDao monthRecordDao;
    @Autowired
    private MonthProductDao monthProductDao;
    @Autowired
    private MonthCarService monthCarService;
    @Autowired
    private SendMsgServiceImpl sendMsgService;
    @Autowired
    private OrderService orderService;
    @Autowired
    private ParkDeviceService parkDeviceService;
    @Autowired
    private ClearListServiceImpl clearListService;
    @Autowired
    private ParkService parkService;
    @Autowired
    private BatchDownBizHandle<MonthCardDto> batchDownBizHandle;
    @Value(value="${monthcard.down.alwaysDownParks}")
    private String alwaysDownParks;
    private static final int CARD_TYPE_2 = 2;
    private static final int BEFORE_TIME = 3600;
    private static final int OPEN_IN_PARK_DELAY_TIME = 3600;
    private static final String[] MONTHCARD_HEADERS = new String[]{"id", "cardId", "plateNum", "cardOwner", "plotCount", "cardType", "startDate", "endDate", "startTime", "endTime"};

    @Override
    public ObjectResponse<Long> send(SendRequest sendRequest, String parkCode) {
        Long serviceId = sendRequest.getServiceId();
        SendMessage message = SendMessage.builder().type("1").build();
        MonthRecord monthRecord = (MonthRecord)this.monthRecordDao.selectById((Serializable)serviceId);
        if (monthRecord == null) {
            return ObjectResponse.failed((String)"410", (String)TextConstant.getDefaultMessage((String)"1", (String)"\u6708\u5361\u64cd\u4f5c\u8bb0\u5f55\u4e0d\u5b58\u5728"));
        }
        MonthProduct monthProduct = this.monthProductDao.selectById(monthRecord.getProductId().longValue());
        int cardType = monthProduct.getCardType();
        if (cardType == 2) {
            throw new ResponseBodyException("406", TextConstant.getDefaultMessage((String)"1", (String)"\u9519\u65f6\u6708\u5361\uff0c\u5f53\u524d\u6570\u636e\u65e0\u9700\u8fdb\u884c\u4e0b\u53d1"));
        }
        List<String> parkCodeList = Arrays.asList(this.alwaysDownParks.split(","));
        boolean alwaysDown = parkCodeList.contains(parkCode);
        if (alwaysDown) {
            Long fireTime = this.pauseValidate(monthRecord);
            if (fireTime != null) {
                message.setDescribes(Collections.singletonList(SendMessage.Describe.builder().failType("10002").build()));
                return ObjectResponse.instance((String)"407", (String)JsonUtils.toJson((Object)message), (Object)fireTime);
            }
            try {
                MonthCardRequest monthCardRequest = this.buildRequest(monthRecord, cardType);
                String regionIds = monthRecord.getRegionId();
                return this.send(sendRequest, parkCode, monthCardRequest, regionIds, true, monthProduct.getDiffWorkday());
            }
            catch (ResponseBodyException re) {
                return ObjectResponse.failed((String)re.getErrCode(), (String)re.getMessage());
            }
        }
        if (monthRecord.getStartTime() == null) {
            throw new ResponseBodyException("406", TextConstant.getDefaultMessage((String)"1", (String)"\u751f\u6548\u65e5\u671f\u4e0d\u5408\u6cd5"));
        }
        long startTime = monthRecord.getStartTime().getTime() / 1000L;
        if (startTime - 3600L > DateTools.unixTimestamp()) {
            log.info("<\u7aef\u4e91-\u6708\u5361\u4e0b\u53d1> \u672a\u5230\u6708\u5361\u6709\u6548\u671f\u5ef6\u8fdf\u4e0b\u53d1, \u53c2\u6570:{}", (Object)monthRecord);
            long fireTime = startTime - 3600L;
            message.setDescribes(Collections.singletonList(SendMessage.Describe.builder().failType("10001").build()));
            return ObjectResponse.instance((String)"407", (String)JsonUtils.toJson((Object)message), (Object)fireTime);
        }
        Long fireTime = this.pauseValidate(monthRecord);
        if (fireTime != null) {
            message.setDescribes(Collections.singletonList(SendMessage.Describe.builder().failType("10002").build()));
            return ObjectResponse.instance((String)"407", (String)JsonUtils.toJson((Object)message), (Object)fireTime);
        }
        try {
            MonthCardRequest monthCardRequest = this.buildRequest(monthRecord, cardType);
            String regionIds = monthRecord.getRegionId();
            return this.send(sendRequest, parkCode, monthCardRequest, regionIds, monthProduct.getDiffWorkday());
        }
        catch (ResponseBodyException re) {
            return ObjectResponse.failed((String)re.getErrCode(), (String)re.getMessage());
        }
    }

    private Long pauseValidate(MonthRecord monthRecord) {
        long pauseStartTime;
        if (monthRecord.getCardOpertype() == 7 && monthRecord.getCardstopStart() != null && (pauseStartTime = monthRecord.getCardstopStart().getTime() / 1000L) - 3600L > DateTools.unixTimestamp()) {
            log.info("<\u7aef\u4e91-\u6708\u5361\u4e0b\u53d1> \u672a\u5230\u6708\u5361\u6682\u505c\u5f00\u59cb\u65f6\u95f4\u5ef6\u8fdf\u4e0b\u53d1\uff0c\u53c2\u6570:{}", (Object)monthRecord);
            return pauseStartTime - 3600L;
        }
        return null;
    }

    @Override
    public ObjectResponse<Long> batchSend(List<SendRequest> sendRequestList, Long parkId, String parkCode) {
        List ids = sendRequestList.stream().map(SendRequest::getServiceId).collect(Collectors.toList());
        List list = this.monthRecordDao.selectBatchIds(ids);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return ObjectResponse.failed((String)"402");
        }
        Map<Long, Long> recordIdMonthIdMap = list.stream().collect(Collectors.toMap(MonthRecord::getId, MonthRecord::getMonthId, (a, b) -> a));
        sendRequestList.forEach(sendRequest -> {
            ClearListRequest clearListRequest = new ClearListRequest();
            Long monthId = (Long)recordIdMonthIdMap.get(sendRequest.getServiceId());
            if (monthId != null) {
                clearListRequest.setId(Integer.valueOf(monthId.intValue()));
                clearListRequest.setDataType(Integer.valueOf(QueryListRequest.DataType.\u6708\u5361.getVal()));
                sendRequest.setReqServiceType(P2cDownCmdEnum.\u540d\u5355\u6570\u636e\u6e05\u7a7a.getCmdType());
                this.sendMsgService.send2Park((SendRequest)sendRequest, parkCode, clearListRequest);
                ThreadUtil.sleep((long)200L);
            }
        });
        return ObjectResponse.success();
    }

    private ObjectResponse<Long> send(SendRequest sendRequest, String parkCode, MonthCardRequest monthCardRequest, String regionIds, Integer diffWorkday) {
        return this.send(sendRequest, parkCode, monthCardRequest, regionIds, false, diffWorkday);
    }

    private ObjectResponse<Long> send(SendRequest sendRequest, String parkCode, MonthCardRequest monthCardRequest, String regionIds, boolean alwaysDown, Integer diffWorkday) {
        SendMessage sendMessage = SendMessage.builder().type("1").build();
        List details = monthCardRequest.getDetails();
        if (!alwaysDown && monthCardRequest.getCardOperType() == 1) {
            for (MonthCardRequest.Details mp : details) {
                OrderInfo orderInfo;
                String plateNum = mp.getPlateNum();
                ObjectResponse infoObjectResponse = this.orderService.findInPark(plateNum, parkCode);
                if (!ObjectResponse.isSuccess((Response)infoObjectResponse) || DateTools.getParse((String)mp.getStartDate()).getTime() / 1000L <= ((OrderInfo)infoObjectResponse.getData()).getEnterTime() || 4 == (orderInfo = (OrderInfo)infoObjectResponse.getData()).getServiceStatus() && (orderInfo.getExitTime() == null || DateTools.unixTimestamp() - orderInfo.getExitTime() > 86400L)) continue;
                sendMessage.setDescribes(Collections.singletonList(SendMessage.Describe.builder().failType("10000").fixedDisplay("\u573a\u5185\u529e\u5361-\u5f85\u79bb\u573a\u540e\u4e0b\u53d1").build()));
                return ObjectResponse.instance((String)"407", (String)JsonUtils.toJson((Object)sendMessage), (Object)(DateTools.unixTimestamp() + 3600L));
            }
        }
        ObjectResponse parkObjectResponse = this.parkService.findByParkId(sendRequest.getParkId());
        Integer isInterior = ((Park)parkObjectResponse.getData()).getIsInterior();
        if (Integer.valueOf(1).equals(isInterior) && StringUtil.isNotEmpty((String)regionIds) && !"0".equals(regionIds)) {
            String[] regionIdArr = regionIds.split(",");
            ObjectResponse listObjectResponse = this.parkDeviceService.getDeviceListByParkRegionId(sendRequest.getParkId(), Integer.valueOf(regionIdArr[0]), 1);
            ObjectResponse.notError((Response)listObjectResponse, (String)("\u533a\u57dfID[" + regionIdArr[0] + "]\u4e0b\u672a\u6dfb\u52a0\u8bbe\u5907"));
            List parkDevices = ((List)listObjectResponse.getData()).stream().filter(pd -> P2cVersionEnum.\u7248\u672c17.getIndex() > P2cVersionEnum.getIndex((String)pd.getProtocolVer())).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(parkDevices)) {
                ObjectResponse<Void> objectResponse = this.clearListService.execute(sendRequest.getParkId(), parkCode, QueryListRequest.DataType.\u6708\u5361.getVal(), ((MonthCardRequest.Details)details.get(0)).getCardId());
                log.info("[\u5206\u533a\u6708\u5361\u4e0b\u53d1] \u5df2\u6e05\u9664[{}]\uff0c\u54cd\u5e94\uff1a{}", (Object)((MonthCardRequest.Details)details.get(0)).getCardId(), objectResponse);
                for (int i = 0; i < regionIdArr.length; ++i) {
                    String regionId = regionIdArr[i];
                    if (i != 0) {
                        listObjectResponse = this.parkDeviceService.getDeviceListByParkRegionId(sendRequest.getParkId(), Integer.valueOf(regionId), 1);
                    }
                    if (!ObjectResponse.isSuccess((Response)listObjectResponse)) continue;
                    List parkDeviceList = (List)listObjectResponse.getData();
                    for (ParkDevice parkDevice : parkDeviceList) {
                        ParkInoutdevice parkInoutdevice;
                        ObjectResponse inoutdeviceObjectResponse;
                        Integer channelId = parkDevice.getChannelId();
                        if (channelId == null || !ObjectResponse.isSuccess((Response)(inoutdeviceObjectResponse = this.parkService.getInoutDeviceById(Long.valueOf(parkDevice.getChannelId().longValue())))) || (parkInoutdevice = (ParkInoutdevice)inoutdeviceObjectResponse.getData()).getInandoutType() == 2 && parkInoutdevice.getIsMaster() == 1) continue;
                        String serialNumber = parkDevice.getSerialNumber();
                        Message<MonthCardRequest> message = new Message<MonthCardRequest>(sendRequest.getTaskId(), sendRequest.getParkId(), sendRequest.getServiceType(), sendRequest.getServiceId(), monthCardRequest);
                        this.p2cDownHandle.send(parkCode, serialNumber, message);
                    }
                }
                return ObjectResponse.success();
            }
        }
        ObjectResponse objectResponse = Integer.valueOf(1).equals(diffWorkday) ? this.sendMsgService.send2ExcludeMasterExit(sendRequest, parkCode, monthCardRequest) : this.sendMsgService.send2Park(sendRequest, parkCode, monthCardRequest);
        return ObjectResponse.instance((String)objectResponse.getCode(), (String)objectResponse.getMsg(), null);
    }

    private MonthCardRequest buildRequest(MonthRecord monthRecord, int cardType) {
        Integer cardOpertype = monthRecord.getCardOpertype();
        MonthInfo monthInfo = this.monthCarService.selectMonthInfotById(Integer.valueOf(monthRecord.getMonthId().intValue()));
        if (monthInfo == null) {
            throw new ResponseBodyException("406", TextConstant.getDefaultMessage((String)"1", (String)"\u672a\u627e\u5230\u6708\u5361\u4fe1\u606f"));
        }
        if (Integer.valueOf(1).equals(monthInfo.getDeleteStatus()) && cardOpertype != 9) {
            throw new ResponseBodyException("406", TextConstant.getDefaultMessage((String)"1", (String)"\u5f53\u524d\u6708\u5361\u5df2\u88ab\u5220\u9664\uff0c\u65e0\u9700\u4e0b\u53d1"));
        }
        if (Integer.valueOf(0).equals(monthInfo.getDeleteStatus())) {
            int cardStatus = monthInfo.getCardStatus();
            if (Arrays.asList(3, 4, 5, 6).contains(cardStatus) && Arrays.asList(1, 2, 3, 6, 8).contains(cardOpertype)) {
                log.info("\u6708\u5361\u64cd\u4f5c\u548c\u5f53\u524d\u72b6\u6001\u4e0d\u5bf9\u5e94, \u64cd\u4f5c\u8bb0\u5f55[{}], \u6708\u5361\u4fe1\u606f[{}]", (Object)monthRecord, (Object)monthInfo);
                throw new ResponseBodyException("406", TextConstant.getDefaultMessage((String)"1", (String)"\u5f53\u524d\u6708\u5361\u5df2\u5931\u6548\uff0c\u65e0\u9700\u4e0b\u53d1"));
            }
        }
        MonthCardRequest monthCardRequest = new MonthCardRequest();
        if (cardOpertype == 6 || cardOpertype == 8) {
            monthCardRequest.setCardOperType(Integer.valueOf(1));
        } else if (cardOpertype == 5 || cardOpertype == 7) {
            monthCardRequest.setCardOperType(Integer.valueOf(4));
        } else {
            monthCardRequest.setCardOperType(cardOpertype);
        }
        ArrayList<MonthCardRequest.Details> list = new ArrayList<MonthCardRequest.Details>();
        MonthCardRequest.Details details = new MonthCardRequest.Details();
        details.setPlateNum(monthRecord.getPlateNum());
        details.setCardId(Integer.valueOf(monthRecord.getMonthId().intValue()));
        details.setCardOwner(StringUtils.isBlank((CharSequence)monthRecord.getCardOwner()) ? "default" : monthRecord.getCardOwner());
        details.setStartDate(DateFormatUtils.format((Date)monthRecord.getStartTime(), (String)"yyyy-MM-dd 00:00:00"));
        details.setEndDate(DateFormatUtils.format((Date)monthRecord.getEndTime(), (String)"yyyy-MM-dd 23:59:59"));
        details.setPlotCount(monthRecord.getPlotCount());
        details.setRegionIds(StringUtils.isBlank((CharSequence)monthRecord.getRegionId()) ? "0" : monthRecord.getRegionId());
        details.setCardType(Integer.valueOf(cardType));
        list.add(details);
        monthCardRequest.setDetails(list);
        return monthCardRequest;
    }

    @Override
    public void dealResponse(P2cBaseResponse<String> p2cBaseResponse, Long parkId, String parkCode, String deviceNo) {
        this.p2cDownHandle.dealResponse(p2cBaseResponse, parkId, P2cDownCmdEnum.\u6708\u5361.getCmdType());
    }

    @Override
    public ObjectResponse<Long> batchSend(BatchSendVO vo) {
        String parkCode = vo.getParkCode();
        Long parkId = vo.getParkId();
        ObjectResponse mothCardDtoRet = this.monthCarService.getValidByParkId(parkId);
        if (mothCardDtoRet.getCode().equals("404")) {
            log.info("[\u6279\u91cf\u6708\u5361\u4e0b\u53d1] \u6ca1\u6709\u7b26\u5408\u6761\u4ef6\u7684\u6708\u5361,\u5ffd\u7565\u4e0b\u53d1,\u8f66\u573a\u7f16\u53f7[{}]", (Object)parkCode);
            return ObjectResponse.success();
        }
        if (!ObjectResponse.isSuccess((Response)mothCardDtoRet)) {
            return ObjectResponse.failed((String)mothCardDtoRet.getCode(), (String)mothCardDtoRet.getMsg());
        }
        List monthCardDtos = (List)mothCardDtoRet.getData();
        for (MonthCardDto monthCardDto2 : monthCardDtos) {
            if (!StringUtils.isBlank((CharSequence)monthCardDto2.getCardOwner())) continue;
            monthCardDto2.setCardOwner("default");
        }
        boolean hasDiffWorkday = monthCardDtos.stream().anyMatch(mcd -> Integer.valueOf(1).equals(mcd.getDiffWorkday()));
        if (hasDiffWorkday) {
            List subTaskInfos = vo.getSubTaskInfos();
            Map<Long, List<BatchSendVO.SubTaskInfo>> channelIdMap = subTaskInfos.stream().collect(Collectors.groupingBy(BatchSendVO.SubTaskInfo::getChannelId));
            List channelIds = subTaskInfos.stream().map(BatchSendVO.SubTaskInfo::getChannelId).collect(Collectors.toList());
            List parkInoutDevices = this.parkService.getInoutDeviceByIds(channelIds);
            BatchSendVO vo1 = new BatchSendVO();
            BeanUtils.copyProperties((Object)vo, (Object)vo1);
            ArrayList notMasterExitSubTask = new ArrayList();
            parkInoutDevices.stream().filter(p -> p.getIsMaster() != 1 || p.getInandoutType() != 2).forEach(p -> notMasterExitSubTask.addAll((Collection)channelIdMap.get(p.getId())));
            if (CollectionUtils.isNotEmpty(notMasterExitSubTask)) {
                vo1.setSubTaskInfos(notMasterExitSubTask);
                List<Object> collect = monthCardDtos.stream().map(MonthCardDto::getCardId).collect(Collectors.toList());
                this.batchDownBizHandle.batchDown(vo1, monthCardDtos, collect, MONTHCARD_HEADERS, P2cDownCmdEnum.\u6708\u5361.getCmdType());
            }
            BatchSendVO vo2 = new BatchSendVO();
            BeanUtils.copyProperties((Object)vo, (Object)vo2);
            ArrayList masterExitSubTask = new ArrayList();
            parkInoutDevices.stream().filter(p -> p.getIsMaster() == 1 && p.getInandoutType() == 2).forEach(p -> masterExitSubTask.addAll((Collection)channelIdMap.get(p.getId())));
            if (CollectionUtils.isNotEmpty(masterExitSubTask)) {
                vo2.setSubTaskInfos(masterExitSubTask);
                List monthCardDtos2 = monthCardDtos.stream().filter(monthCardDto -> !Integer.valueOf(1).equals(monthCardDto.getDiffWorkday())).collect(Collectors.toList());
                if (CollectionUtils.isEmpty(monthCardDtos2)) {
                    log.info("\u533a\u5206\u5de5\u4f5c\u65e5\u975e\u4f5c\u65e5\u6708\u5361\u8fc7\u6ee4\u540e\u65e0\u5f85\u4e0b\u53d1\u6570\u636e, \u53c2\u6570[{}]", (Object)vo);
                    return ObjectResponse.success();
                }
                List<Object> collect2 = monthCardDtos2.stream().map(MonthCardDto::getCardId).collect(Collectors.toList());
                this.batchDownBizHandle.batchDown(vo2, monthCardDtos2, collect2, MONTHCARD_HEADERS, P2cDownCmdEnum.\u6708\u5361.getCmdType());
            }
        } else {
            List<Object> collect = monthCardDtos.stream().map(MonthCardDto::getCardId).collect(Collectors.toList());
            this.batchDownBizHandle.batchDown(vo, monthCardDtos, collect, MONTHCARD_HEADERS, P2cDownCmdEnum.\u6708\u5361.getCmdType());
        }
        return ObjectResponse.success();
    }

    @Override
    public ObjectResponse<Long> batchSendRepeat(BatchSendRepeatVO vo) {
        String failIds = vo.getFailIds();
        String parkCode = vo.getParkCode();
        ObjectResponse monthCardDtoRet = StrUtil.isNotBlank((CharSequence)vo.getFailIds()) ? this.monthCarService.getValidByIds(Arrays.asList(failIds.split(","))) : this.monthCarService.getValidByParkId(vo.getParkId());
        if (monthCardDtoRet.getCode().equals("404")) {
            log.info("[\u6279\u91cf\u6708\u5361\u4e0b\u53d1-\u91cd\u53d1] \u6ca1\u6709\u7b26\u5408\u6761\u4ef6\u7684\u6708\u5361,\u5ffd\u7565\u4e0b\u53d1,\u8f66\u573a\u7f16\u53f7[{}]", (Object)parkCode);
            return ObjectResponse.success();
        }
        if (!ObjectResponse.isSuccess((Response)monthCardDtoRet)) {
            return ObjectResponse.instance((String)monthCardDtoRet.getCode(), (String)monthCardDtoRet.getMsg(), null);
        }
        List monthCardDtos = (List)monthCardDtoRet.getData();
        boolean hasDiffWorkday = monthCardDtos.stream().anyMatch(mcd -> Integer.valueOf(1).equals(mcd.getDiffWorkday()));
        if (hasDiffWorkday) {
            ObjectResponse objectResponse = this.parkService.getInoutDeviceById(vo.getChannelId());
            if (!ObjectResponse.isSuccess((Response)objectResponse)) {
                return ObjectResponse.failed((String)"404", (String)"\u901a\u9053ID\u4e0d\u5b58\u5728");
            }
            ParkInoutdevice data = (ParkInoutdevice)objectResponse.getData();
            if (data.getIsMaster() == 1 && data.getInandoutType() == 2) {
                monthCardDtos = monthCardDtos.stream().filter(monthCardDto -> !Integer.valueOf(1).equals(monthCardDto.getDiffWorkday())).collect(Collectors.toList());
            }
            if (CollectionUtils.isEmpty((Collection)monthCardDtos)) {
                log.info("\u533a\u5206\u5de5\u4f5c\u65e5\u975e\u4f5c\u65e5\u6708\u5361\u8fc7\u6ee4\u540e\u65e0\u5f85\u4e0b\u53d1\u6570\u636e, \u53c2\u6570[{}]", (Object)vo);
                return ObjectResponse.success();
            }
        }
        List<Object> collect = monthCardDtos.stream().map(MonthCardDto::getCardId).collect(Collectors.toList());
        this.batchDownBizHandle.repeatBatch(vo, monthCardDtos, collect, MONTHCARD_HEADERS, P2cDownCmdEnum.\u6708\u5361.getCmdType());
        return ObjectResponse.success();
    }
}

