/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.down.p2c.impl;

import com.fasterxml.jackson.core.type.TypeReference;
import com.icetech.basics.config.GrayProperties;
import com.icetech.basics.constants.TextConstant;
import com.icetech.basics.dao.park.ParkInoutdeviceDao;
import com.icetech.basics.dao.park.ParkRegionDao;
import com.icetech.basics.domain.entity.device.ParkDevice;
import com.icetech.basics.domain.entity.park.ParkConfig;
import com.icetech.basics.domain.entity.park.ParkInoutdevice;
import com.icetech.basics.domain.entity.park.ParkRegion;
import com.icetech.cloudcenter.api.lcd.LedService;
import com.icetech.cloudcenter.api.park.ParkDeviceService;
import com.icetech.cloudcenter.api.park.ParkFreeSpaceService;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.domain.enumeration.P2cDownCmdEnum;
import com.icetech.cloudcenter.domain.request.p2c.LedsoundConfigRequest;
import com.icetech.cloudcenter.domain.response.LedShowDto;
import com.icetech.cloudcenter.domain.response.LedSoundDto;
import com.icetech.cloudcenter.domain.response.p2c.P2cBaseResponse;
import com.icetech.cloudcenter.domain.vo.BatchSendRepeatVO;
import com.icetech.cloudcenter.domain.vo.BatchSendVO;
import com.icetech.cloudcenter.domain.vo.p2c.TokenDeviceVo;
import com.icetech.common.domain.SendRequest;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.Response;
import com.icetech.common.exception.ResponseBodyException;
import com.icetech.common.utils.NumberUtils;
import com.icetech.park.domain.dto.LedConfigDTO;
import com.icetech.park.domain.entity.led.LedConfig;
import com.icetech.park.domain.entity.led.LedShow;
import com.icetech.park.domain.entity.led.LedSound;
import com.icetech.park.domain.entity.led.LedTips;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.park.domain.entity.park.ParkFreespace;
import com.icetech.park.handle.CacheHandle;
import com.icetech.park.service.AbstractConfigDownService;
import com.icetech.park.service.down.Message;
import com.icetech.park.service.down.p2c.DownService;
import com.icetech.park.service.down.p2c.ResponseService;
import com.icetech.park.service.down.p2c.SendMsgServiceImpl;
import com.icetech.park.service.flow.p2c.FlowCondition;
import com.icetech.park.service.handle.BatchDownConfigHandle;
import com.icetech.park.service.handle.P2cDownHandle;
import com.icetech.park.service.handle.showsay.LedShowHandle;
import com.icetech.redis.handle.RedisHandle;
import com.icetech.third.utils.JsonUtils;
import com.icetech.third.utils.RedisUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Service;

@Service(value="p2cLedsoundConfigServiceImpl")
@RefreshScope
public class LedsoundConfigServiceImpl
extends AbstractConfigDownService
implements ResponseService<String>,
DownService<LedsoundConfigRequest, Void> {
    private static final Logger log = LoggerFactory.getLogger(LedsoundConfigServiceImpl.class);
    @Autowired
    private LedService ledService;
    @Autowired
    private ParkService parkService;
    @Autowired
    private P2cDownHandle p2cDownHandle;
    @Autowired
    private ParkFreeSpaceService parkFreeSpaceService;
    @Autowired
    private LedShowHandle ledShowHandle;
    @Autowired
    private RedisUtils redisUtils;
    @Autowired
    private CacheHandle cacheHandle;
    @Autowired
    private SendMsgServiceImpl sendMsgService;
    @Value(value="${web.url}")
    private String webUrl;
    @Autowired
    private BatchDownConfigHandle<Object> batchDownConfigHandle;
    private List<String> IGNORE = Arrays.asList("\\{12\\}");
    @Value(value="${model.config}")
    private String modelConfig;
    @Resource
    private RedisHandle redisHandle;
    @Autowired
    private GrayProperties grayProperties;
    @Autowired
    private ParkInoutdeviceDao parkInoutdeviceDao;
    @Autowired
    private ParkDeviceService parkDeviceService;
    @Autowired
    private ParkRegionDao parkRegionDao;

    @Override
    public ObjectResponse<Void> send(SendRequest sendRequest, String parkCode) {
        ObjectResponse byParkCode = this.parkService.findByParkCode(parkCode);
        if (!ObjectResponse.isSuccess((Response)byParkCode)) {
            return ObjectResponse.failed((String)"410", (String)TextConstant.getDefaultMessage((String)"1", (String)"\u8f66\u573a\u4fe1\u606f\u4e0d\u5b58\u5728"));
        }
        Park park = (Park)byParkCode.getData();
        Long channelId = sendRequest.getServiceId();
        ObjectResponse channelResp = this.parkService.getInoutDeviceById(channelId);
        if (!ObjectResponse.isSuccess((Response)channelResp)) {
            return ObjectResponse.failed((String)"410", (String)TextConstant.getDefaultMessage((String)"1", (String)"\u901a\u9053\u4fe1\u606f\u4e0d\u5b58\u5728"));
        }
        ParkInoutdevice channel = (ParkInoutdevice)channelResp.getData();
        LedsoundConfigRequest ledsoundConfigRequest = this.generateRequest(park, channel);
        return this.sendMsgService.send2Channel(sendRequest, parkCode, channel.getInandoutCode(), ledsoundConfigRequest);
    }

    public boolean send(String parkCode, ParkInoutdevice channel, String serialNumber, String version) {
        ObjectResponse byParkCode = this.parkService.findByParkCode(parkCode);
        ObjectResponse.notError((Response)byParkCode);
        Park park = (Park)byParkCode.getData();
        Long parkId = park.getId();
        LedsoundConfigRequest ledsoundConfigRequest = this.generateRequest(park, channel);
        TokenDeviceVo deviceInfo = this.cacheHandle.getDeviceInfo(serialNumber);
        if (version == null) {
            version = deviceInfo.getVersion();
        }
        ledsoundConfigRequest.buildByVersion(version);
        Message<LedsoundConfigRequest> message = new Message<LedsoundConfigRequest>(parkId, P2cDownCmdEnum.\u81ea\u5b9a\u4e49\u8bed\u97f3\u5c4f\u663e\u914d\u7f6e.getCmdType(), ledsoundConfigRequest);
        String messageId = this.p2cDownHandle.send(parkCode, serialNumber, message);
        return messageId != null;
    }

    private LedsoundConfigRequest generateRequest(Park park, ParkInoutdevice channel) {
        Long parkId = park.getId();
        int channelType = NumberUtils.toPrimitive((Integer)channel.getInandoutType());
        int reverseChannelType = channelType == 1 ? 2 : 1;
        ObjectResponse otherChannels = this.parkService.getChannelByType(parkId, Integer.valueOf(reverseChannelType));
        Long reverseChannelId = Optional.ofNullable(otherChannels).map(ObjectResponse::getData).filter(CollectionUtils::isNotEmpty).map(list -> (ParkInoutdevice)list.get(0)).map(ParkInoutdevice::getId).orElse(null);
        return this.generateRequest(park, channel, reverseChannelId);
    }

    private LedsoundConfigRequest generateRequest(Park park, ParkInoutdevice channel, Long reverseChannelId) {
        Long parkId = park.getId();
        Long channelId = channel.getId();
        Map ledDtoMap = this.ledService.getLedShowDtoMapByChannel(channelId);
        Map reverseLedDtoMap = this.ledService.getLedShowDtoMapByChannel(reverseChannelId);
        Map enterLedDtoMap = null;
        Map exitLedDtoMap = null;
        if (channel.getInandoutType() == 1) {
            enterLedDtoMap = ledDtoMap;
            exitLedDtoMap = reverseLedDtoMap;
        } else {
            enterLedDtoMap = reverseLedDtoMap;
            exitLedDtoMap = ledDtoMap;
        }
        LedShowDto entranceFree = (LedShowDto)enterLedDtoMap.get(LedShow.DisplayTypeEnum.\u5165\u53e3\u7a7a\u95f2\u663e\u793a.type);
        LedShowDto enterShow = (LedShowDto)enterLedDtoMap.get(LedShow.DisplayTypeEnum.\u5165\u573a\u663e\u793a.type);
        LedShowDto exitFree = (LedShowDto)exitLedDtoMap.get(LedShow.DisplayTypeEnum.\u51fa\u53e3\u7a7a\u95f2\u663e\u793a.type);
        LedShowDto exitShow = (LedShowDto)exitLedDtoMap.get(LedShow.DisplayTypeEnum.\u51fa\u573a\u663e\u793a.type);
        ObjectResponse ledsoundConfigObjectResponse = this.ledService.getLedConfigByChannel(channelId);
        LedConfig ledsoundConfig = (LedConfig)ledsoundConfigObjectResponse.getData();
        LedsoundConfigRequest ledsoundConfigRequest = new LedsoundConfigRequest();
        if (channel.getLedcardType() == null || channel.getTtsType() == null) {
            log.info("<\u81ea\u5b9a\u4e49\u8bed\u97f3\u5c4f\u663e> \u672a\u914d\u7f6e\u63a7\u5236\u5361\u7c7b\u578b\u548c\u662f\u5426\u652f\u6301TTS, \u8f66\u573a\u7f16\u53f7\uff1a{}, \u901a\u9053\u7f16\u53f7: {}", (Object)park.getParkCode(), (Object)channel.getInandoutCode());
            throw new ResponseBodyException("400", "\u8bf7\u5148\u914d\u7f6e\u63a7\u5236\u5361\u7c7b\u578b\u548c\u662f\u5426\u652f\u6301TTS");
        }
        ledsoundConfigRequest.setLedcardType(channel.getLedcardType());
        ledsoundConfigRequest.setSupportTTS(channel.getTtsType());
        if (StringUtils.isNotBlank((CharSequence)this.modelConfig)) {
            List data;
            List ledConfigDTOS = (List)JsonUtils.fromJson((String)this.modelConfig, (TypeReference)new TypeReference<List<LedConfigDTO>>(){});
            ObjectResponse devices = this.parkDeviceService.getDeviceListByChannelId(channelId, Integer.valueOf(1));
            if (ObjectResponse.isSuccess((Response)devices) && CollectionUtils.isNotEmpty((Collection)(data = (List)devices.getData()))) {
                Set productModels = data.stream().map(ParkDevice::getProductModel).filter(Objects::nonNull).collect(Collectors.toSet());
                for (LedConfigDTO dto : ledConfigDTOS) {
                    if (!productModels.contains(dto.getModel())) continue;
                    ledsoundConfigRequest.setLedcardType(dto.getValue());
                    ledsoundConfigRequest.setSupportTTS(dto.getTtsType());
                    if (channelId == null || channel.getLedcardType().equals(dto.getValue()) && channel.getTtsType().equals(dto.getTtsType())) continue;
                    log.info("[\u8bbe\u5907\u5c5e\u6027\u4e0a\u62a5\u63a5\u53e3]\u63a7\u5236\u5361\u7c7b\u578b\u548ctts\u6709\u5176\u4e2d\u4e00\u4e0d\u4e00\u81f4, id[{}]", (Object)channel);
                    ParkInoutdevice update = new ParkInoutdevice();
                    update.setId(channelId);
                    update.setLedcardType(dto.getValue());
                    update.setTtsType(dto.getTtsType());
                    this.parkInoutdeviceDao.updateById((Object)update);
                    String deleteKey = "park:channel:id:" + channelId;
                    String deleteCode = "park:channel:code:" + channel.getInandoutCode();
                    if (this.grayProperties.isCacheEnable()) {
                        deleteKey = "gray:" + deleteKey;
                        deleteCode = "gray:" + deleteCode;
                    }
                    this.redisHandle.delete(deleteKey);
                    this.redisHandle.delete(deleteCode);
                    break;
                }
            }
        }
        ledsoundConfigRequest.setStyle(ledsoundConfig.getStyle());
        if (channel.getInandoutType() == 1) {
            ledsoundConfigRequest.setFreePerLineColor(entranceFree.getLedColor());
            ledsoundConfigRequest.setBusyPerLineColor(enterShow.getLedColor());
        } else {
            ledsoundConfigRequest.setFreePerLineColor(exitFree.getLedColor());
            ledsoundConfigRequest.setBusyPerLineColor(exitShow.getLedColor());
        }
        ledsoundConfigRequest.setLedQrcodeRule(ledsoundConfig.getLedQrcodeRule());
        if (ledsoundConfig.getLedQrcodeRule() != null && ledsoundConfig.getLedQrcodeRule() == 1) {
            ledsoundConfigRequest.setDynamicQR(this.webUrl + "/h5/pay/exitDynamicQR");
        }
        ArrayList<Object> ledConfig = new ArrayList<Object>();
        ArrayList<LedsoundConfigRequest.SoundConfig> soundConfig = new ArrayList<LedsoundConfigRequest.SoundConfig>();
        LedsoundConfigRequest.LedConfig ledConfig_entranceFree = new LedsoundConfigRequest.LedConfig();
        String entranceFreeContent = entranceFree.getContent();
        ledConfig_entranceFree.setShowScene(Integer.valueOf(LedsoundConfigRequest.SceneEnum.\u5165\u53e3\u7a7a\u95f2\u663e\u793a.scene));
        ledConfig_entranceFree.setContent(entranceFreeContent);
        ledConfig.add(ledConfig_entranceFree);
        LedsoundConfigRequest.LedConfig ledConfig_exitFree = new LedsoundConfigRequest.LedConfig();
        String exitFreeContent = exitFree.getContent();
        ledConfig_exitFree.setShowScene(Integer.valueOf(LedsoundConfigRequest.SceneEnum.\u51fa\u53e3\u7a7a\u95f2\u663e\u793a.scene));
        ledConfig_exitFree.setContent(exitFreeContent);
        ledConfig.add(ledConfig_exitFree);
        int[] showSceneEnterArr = new int[]{LedsoundConfigRequest.SceneEnum.\u6708\u5361\u8f66\u5165\u573a.scene, LedsoundConfigRequest.SceneEnum.\u5176\u4ed6\u5141\u8bb8\u7684\u5165\u573a.scene, LedsoundConfigRequest.SceneEnum.\u4e34\u65f6\u8f66\u5165\u573a\u4e0d\u5141\u8bb8\u4e34\u65f6\u8f66\u8fdb.scene, LedsoundConfigRequest.SceneEnum.\u9ed1\u540d\u5355\u8f66\u8f86\u5165\u573a.scene, LedsoundConfigRequest.SceneEnum.\u5176\u4ed6\u4e0d\u5141\u8bb8\u5165\u573a\u7684\u8f66\u8f86.scene, LedsoundConfigRequest.SceneEnum.\u591a\u4f4d\u591a\u8f66\u5165\u573a\u8f66\u4f4d\u5360\u7528.scene, LedsoundConfigRequest.SceneEnum.\u5165\u573a\u6708\u5361\u8fc7\u671f.scene, LedsoundConfigRequest.SceneEnum.\u5165\u573a\u865a\u5047\u8f66\u724c.scene};
        FlowCondition.ResultCode[] resultCodeEnterArr = new FlowCondition.ResultCode[]{FlowCondition.ResultCode.\u6708\u5361\u8f66, FlowCondition.ResultCode.\u6709\u724c\u8f66\u5141\u8bb8\u4e34\u65f6\u8f66\u8fdb\u5165, FlowCondition.ResultCode.\u6709\u724c\u8f66\u4e0d\u5141\u8bb8\u4e34\u65f6\u8f66\u8fdb\u5165, FlowCondition.ResultCode.\u9ed1\u540d\u5355\u8f66, FlowCondition.ResultCode.\u9ec4\u724c\u8f66\u7981\u6b62\u5165\u573a, FlowCondition.ResultCode.\u8f66\u4f4d\u5df2\u5360, FlowCondition.ResultCode.\u8fc7\u671f\u5361, FlowCondition.ResultCode.\u865a\u5047\u8f66\u724c};
        int[] showSceneExitArr = new int[]{LedsoundConfigRequest.SceneEnum.\u6708\u5361\u8f66\u79bb\u573a.scene, LedsoundConfigRequest.SceneEnum.\u5176\u4ed6\u65e0\u9700\u7f34\u8d39\u7684\u79bb\u573a.scene, LedsoundConfigRequest.SceneEnum.\u9ed1\u540d\u5355\u8f66\u51fa\u573a.scene, LedsoundConfigRequest.SceneEnum.\u65e0\u724c\u8f66\u51fa\u573a.scene, LedsoundConfigRequest.SceneEnum.\u51fa\u573a\u9700\u7f34\u8d39.scene, LedsoundConfigRequest.SceneEnum.\u51fa\u573a\u65e0\u5165\u573a\u8bb0\u5f55.scene, LedsoundConfigRequest.SceneEnum.\u51fa\u573a\u865a\u5047\u8f66\u724c.scene};
        FlowCondition.ResultCode[] resultCodeExitArr = new FlowCondition.ResultCode[]{FlowCondition.ResultCode.\u6708\u5361\u8f66, FlowCondition.ResultCode.\u65e0\u9700\u7f34\u8d39, FlowCondition.ResultCode.\u9ed1\u540d\u5355\u8f66, FlowCondition.ResultCode.\u65e0\u724c\u8f66\u5141\u8bb8\u8fdb\u51fa, FlowCondition.ResultCode.\u9700\u7f34\u8d39, FlowCondition.ResultCode.\u65e0\u5165\u573a\u8bb0\u5f55, FlowCondition.ResultCode.\u865a\u5047\u8f66\u724c};
        String enterContent = enterShow.getContent();
        for (String node : this.IGNORE) {
            enterContent = enterContent.replaceAll(node, "");
        }
        ObjectResponse specialLedResp = this.ledService.getLedTipsByChannel(channelId);
        LedTips ledTips = (LedTips)specialLedResp.getData();
        for (int i = 0; i < showSceneEnterArr.length; ++i) {
            LedsoundConfigRequest.LedConfig ledConfigItem = new LedsoundConfigRequest.LedConfig();
            ledConfigItem.setShowScene(Integer.valueOf(showSceneEnterArr[i]));
            ledConfigItem.setContent(this.showReplaceOther(enterContent, ledTips, resultCodeEnterArr[i]));
            ledConfig.add(ledConfigItem);
        }
        String exitContent = exitShow.getContent();
        for (String node : this.IGNORE) {
            exitContent = exitContent.replaceAll(node, "");
        }
        for (int i = 0; i < showSceneExitArr.length; ++i) {
            LedsoundConfigRequest.LedConfig ledConfigItem = new LedsoundConfigRequest.LedConfig();
            ledConfigItem.setShowScene(Integer.valueOf(showSceneExitArr[i]));
            ledConfigItem.setContent(this.showReplaceOther(exitContent, ledTips, resultCodeExitArr[i]));
            ledConfig.add(ledConfigItem);
        }
        int[] saySceneArr = new int[]{LedsoundConfigRequest.SceneEnum.\u6708\u5361\u8f66\u5165\u573a.scene, LedsoundConfigRequest.SceneEnum.\u5176\u4ed6\u5141\u8bb8\u7684\u5165\u573a.scene, LedsoundConfigRequest.SceneEnum.\u6708\u5361\u8f66\u79bb\u573a.scene, LedsoundConfigRequest.SceneEnum.\u5176\u4ed6\u65e0\u9700\u7f34\u8d39\u7684\u79bb\u573a.scene, LedsoundConfigRequest.SceneEnum.\u4e34\u65f6\u8f66\u5165\u573a\u4e0d\u5141\u8bb8\u4e34\u65f6\u8f66\u8fdb.scene, LedsoundConfigRequest.SceneEnum.\u9ed1\u540d\u5355\u8f66\u8f86\u5165\u573a.scene, LedsoundConfigRequest.SceneEnum.\u5176\u4ed6\u4e0d\u5141\u8bb8\u5165\u573a\u7684\u8f66\u8f86.scene, LedsoundConfigRequest.SceneEnum.\u591a\u4f4d\u591a\u8f66\u5165\u573a\u8f66\u4f4d\u5360\u7528.scene, LedsoundConfigRequest.SceneEnum.\u5165\u573a\u6708\u5361\u8fc7\u671f.scene, LedsoundConfigRequest.SceneEnum.\u5165\u573a\u865a\u5047\u8f66\u724c.scene, LedsoundConfigRequest.SceneEnum.\u9ed1\u540d\u5355\u8f66\u51fa\u573a.scene, LedsoundConfigRequest.SceneEnum.\u65e0\u724c\u8f66\u51fa\u573a.scene, LedsoundConfigRequest.SceneEnum.\u51fa\u573a\u9700\u7f34\u8d39.scene, LedsoundConfigRequest.SceneEnum.\u51fa\u573a\u65e0\u5165\u573a\u8bb0\u5f55.scene, LedsoundConfigRequest.SceneEnum.\u51fa\u573a\u865a\u5047\u8f66\u724c.scene};
        int[] soundTypeArr = new int[]{LedSound.SoundTypeEnum.\u5165\u573a\u6708\u5361\u8f66_\u5185\u90e8\u8f66\u8f86.type, LedSound.SoundTypeEnum.\u5165\u573a\u4e34\u65f6\u8f66.type, LedSound.SoundTypeEnum.\u51fa\u573a\u6708\u5361\u8f66.type, LedSound.SoundTypeEnum.\u51fa\u573a\u514d\u8d39\u8f66\u8f86_\u4e34\u65f6\u7279\u6b8a.type, LedSound.SoundTypeEnum.\u4e34\u65f6\u8f66\u7981\u6b62\u901a\u884c.type, LedSound.SoundTypeEnum.\u9ed1\u540d\u5355\u8f66\u8f86\u8fdb\u51fa\u573a.type, LedSound.SoundTypeEnum.\u4e34\u65f6\u8f66\u7981\u6b62\u901a\u884c.type, LedSound.SoundTypeEnum.\u591a\u4f4d\u591a\u8f66\u8f66\u4f4d\u5360\u7528.type, LedSound.SoundTypeEnum.\u5165\u573a\u4e34\u65f6\u8f66.type, LedSound.SoundTypeEnum.\u5165\u53e3\u865a\u5047\u8f66\u724c.type, LedSound.SoundTypeEnum.\u9ed1\u540d\u5355\u8f66\u8f86\u8fdb\u51fa\u573a.type, LedSound.SoundTypeEnum.\u51fa\u573a\u65e0\u724c\u8f66.type, LedSound.SoundTypeEnum.\u51fa\u573a\u6536\u8d39\u8f66\u8f86.type, LedSound.SoundTypeEnum.\u51fa\u573a\u65e0\u5165\u573a\u8bb0\u5f55.type, LedSound.SoundTypeEnum.\u51fa\u53e3\u865a\u5047\u8f66\u724c.type};
        boolean containsLimit = false;
        Map soundDtoMap = this.ledService.getLedSoundDtoMapByChannel(channelId);
        for (int i = 0; i < soundTypeArr.length; ++i) {
            LedSoundDto soundVo = (LedSoundDto)soundDtoMap.get(soundTypeArr[i]);
            LedsoundConfigRequest.SoundConfig soundConfig_monthEnter = new LedsoundConfigRequest.SoundConfig();
            soundConfig_monthEnter.setSayScene(Integer.valueOf(saySceneArr[i]));
            soundConfig_monthEnter.setContent(soundVo.getContent());
            soundConfig.add(soundConfig_monthEnter);
            if (!soundVo.getContent().contains("{2}")) continue;
            containsLimit = true;
        }
        ledsoundConfigRequest.setLedConfig(ledConfig);
        ledsoundConfigRequest.setSoundConfig(soundConfig);
        ledsoundConfigRequest.setLedRestoreDefaultTime(ledsoundConfig.getLedRestoreDefaultTime());
        ledsoundConfigRequest.setVolumeValue(ledsoundConfig.getVolumeValue());
        ledsoundConfigRequest.setQuietHoursSwitch(ledsoundConfig.getQuietHoursSwitch());
        if (entranceFreeContent.contains("{2}") || exitFreeContent.contains("{2}") || containsLimit) {
            ledsoundConfigRequest.setLimitType(Integer.valueOf(ledsoundConfig.getLimitType() == null ? 1 : ledsoundConfig.getLimitType()));
            if (ledsoundConfig.getLimitType() != null && ledsoundConfig.getLimitType() == 0) {
                ledsoundConfigRequest.setLimitDriveNum1(ledsoundConfig.getLimitDriveNum1());
                ledsoundConfigRequest.setLimitDriveNum2(ledsoundConfig.getLimitDriveNum2());
                ledsoundConfigRequest.setLimitDriveNum3(ledsoundConfig.getLimitDriveNum3());
                ledsoundConfigRequest.setLimitDriveNum4(ledsoundConfig.getLimitDriveNum4());
                ledsoundConfigRequest.setLimitDriveNum5(ledsoundConfig.getLimitDriveNum5());
            }
        }
        if (ledsoundConfig.getRegionFreeSpace() == null || ledsoundConfig.getRegionFreeSpace() == 0L) {
            ParkFreespace parkFreespace = (ParkFreespace)this.parkFreeSpaceService.getSpaceByPark(parkId.longValue()).getData();
            ledsoundConfigRequest.setFreeSpace(Integer.valueOf(parkFreespace == null ? 0 : parkFreespace.getFreeSpace()));
            ledsoundConfigRequest.setRealFreeSpace(Integer.valueOf(parkFreespace == null ? 0 : parkFreespace.getRealFreeSpace()));
            ledsoundConfigRequest.setTotalSpace(Integer.valueOf(parkFreespace == null ? 0 : parkFreespace.getTotalNum()));
        } else {
            ParkRegion parkRegion = (ParkRegion)this.parkRegionDao.selectById((Serializable)ledsoundConfig.getRegionFreeSpace());
            if (parkRegion == null) {
                ParkFreespace parkFreespace = (ParkFreespace)this.parkFreeSpaceService.getSpaceByPark(parkId.longValue()).getData();
                ledsoundConfigRequest.setFreeSpace(Integer.valueOf(parkFreespace == null ? 0 : parkFreespace.getFreeSpace()));
                ledsoundConfigRequest.setRealFreeSpace(Integer.valueOf(parkFreespace == null ? 0 : parkFreespace.getRealFreeSpace()));
                ledsoundConfigRequest.setTotalSpace(Integer.valueOf(parkFreespace == null ? 0 : parkFreespace.getTotalNum()));
            } else {
                ledsoundConfigRequest.setFreeSpace(Integer.valueOf(parkRegion.getFreePark() == null ? 0 : parkRegion.getFreePark()));
                ledsoundConfigRequest.setRealFreeSpace(Integer.valueOf(parkRegion.getRealFreePark() == null ? 0 : parkRegion.getRealFreePark()));
                ledsoundConfigRequest.setTotalSpace(Integer.valueOf(parkRegion.getRegionPark() == null ? 0 : parkRegion.getRegionPark()));
            }
        }
        if (ledsoundConfig.getLedExpireDaysMc() == null) {
            ledsoundConfigRequest.setLedExpireDaysMc(Integer.valueOf(0));
        } else {
            ledsoundConfigRequest.setLedExpireDaysMc(ledsoundConfig.getLedExpireDaysMc());
        }
        if (ledsoundConfig.getLedExpireDaysMc() != null && ledsoundConfig.getLedExpireDaysMc() > 0) {
            ObjectResponse configObjectResponse = this.parkService.getParkConfig(parkId);
            ledsoundConfigRequest.setIsExpireMc(((ParkConfig)configObjectResponse.getData()).getIsExpireMc());
        }
        if (ledsoundConfig.getQuietHoursSwitch() == 1) {
            ledsoundConfigRequest.setQuietStartTime(ledsoundConfig.formatQuietStartTime());
            ledsoundConfigRequest.setQuietEndTime(ledsoundConfig.formatQuietEndTime());
            ledsoundConfigRequest.setQuietVolumeValue(ledsoundConfig.getQuietVolumeValue());
        }
        if (enterContent.contains("{6}") || exitContent.contains("{6}") || entranceFreeContent.contains("{6}") || exitFreeContent.contains("{6}")) {
            ledsoundConfigRequest.setParkName(park.getParkName());
        }
        if (ledsoundConfig.getLedRemainDaysMc() > 0) {
            ledsoundConfigRequest.setLedRemainDaysMc(ledsoundConfig.getLedRemainDaysMc());
        }
        ledsoundConfigRequest.setShowLanguage(Integer.valueOf(1));
        ledsoundConfigRequest.setVoiceLanguage(Integer.valueOf(1));
        return ledsoundConfigRequest;
    }

    private String showReplaceOther(String content, LedTips ledTips, FlowCondition.ResultCode resultCode) {
        if (content.contains("{8}")) {
            content = content.replace("{8}", this.ledShowHandle.enterTips(ledTips, resultCode));
        } else if (content.contains("{9}")) {
            content = content.replace("{9}", this.ledShowHandle.exitTips(ledTips, resultCode, null));
        }
        return content;
    }

    @Override
    public void dealResponse(P2cBaseResponse<String> p2cBaseResponse, Long parkId, String parkCode, String deviceNo) {
        Integer subTaskId = (Integer)this.redisUtils.get("batchdown:msgid:" + p2cBaseResponse.getMessageId(), Integer.class);
        if (subTaskId != null) {
            this.batchDownConfigHandle.dealBatchResponse(p2cBaseResponse, subTaskId, parkId);
        }
        this.p2cDownHandle.dealResponse(p2cBaseResponse, parkId, P2cDownCmdEnum.\u81ea\u5b9a\u4e49\u8bed\u97f3\u5c4f\u663e\u914d\u7f6e.getCmdType());
    }

    @Override
    public ObjectResponse<Void> batchSend(BatchSendVO vo, BatchSendVO.SubTaskInfo subTaskInfo) {
        ParkInoutdevice channel2;
        ObjectResponse byParkCode = this.parkService.findByParkCode(vo.getParkCode());
        ObjectResponse.notError((Response)byParkCode);
        Park park = (Park)byParkCode.getData();
        ObjectResponse channelsResp = this.parkService.getInoutByParkId(vo.getParkId());
        List channels = (List)channelsResp.getData();
        Long enterChannelId = null;
        Long exitChannelId = null;
        for (ParkInoutdevice channel2 : channels) {
            if (channel2.getInandoutType() == 1 && enterChannelId == null) {
                enterChannelId = channel2.getId();
                continue;
            }
            if (channel2.getInandoutType() != 2 || exitChannelId != null) continue;
            exitChannelId = channel2.getId();
        }
        ObjectResponse channelResp = this.parkService.getInoutDeviceById(subTaskInfo.getChannelId());
        channel2 = (ParkInoutdevice)channelResp.getData();
        Long reverseChannelId = channel2.getInandoutType() == 1 ? exitChannelId : enterChannelId;
        LedsoundConfigRequest ledsoundConfigRequest = this.generateRequest(park, channel2, reverseChannelId);
        this.batchDownConfigHandle.batchDown(vo, ledsoundConfigRequest, P2cDownCmdEnum.\u81ea\u5b9a\u4e49\u8bed\u97f3\u5c4f\u663e\u914d\u7f6e.getCmdType());
        return ObjectResponse.success();
    }

    @Override
    public ObjectResponse<Void> batchSendRepeat(BatchSendRepeatVO vo) {
        ObjectResponse byParkCode = this.parkService.findByParkCode(vo.getParkCode());
        ObjectResponse.notError((Response)byParkCode);
        Park park = (Park)byParkCode.getData();
        ObjectResponse channelResp = this.parkService.getInoutDeviceById(vo.getChannelId());
        ParkInoutdevice channel = (ParkInoutdevice)channelResp.getData();
        LedsoundConfigRequest ledsoundConfigRequest = this.generateRequest(park, channel);
        this.batchDownConfigHandle.repeatBatch(vo, ledsoundConfigRequest, P2cDownCmdEnum.\u81ea\u5b9a\u4e49\u8bed\u97f3\u5c4f\u663e\u914d\u7f6e.getCmdType());
        return ObjectResponse.success();
    }
}

