/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.down.p2c.impl;

import com.icetech.cloudcenter.api.NotifyService;
import com.icetech.cloudcenter.domain.enumeration.P2cDownCmdEnum;
import com.icetech.cloudcenter.domain.request.p2c.LcdHintRequest;
import com.icetech.cloudcenter.domain.response.p2c.P2cBaseResponse;
import com.icetech.common.constants.LogWarnTypeEnum;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.park.handle.CacheHandle;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.down.Message;
import com.icetech.park.service.down.p2c.ResponseService;
import com.icetech.park.service.handle.P2cDownHandle;
import com.icetech.park.service.makeup.WsRepeatPush;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="p2cLcdHintServiceImpl")
public class LcdHintServiceImpl
extends AbstractService
implements ResponseService<String>,
NotifyService<String> {
    private static final Logger log = LoggerFactory.getLogger(LcdHintServiceImpl.class);
    @Autowired
    private P2cDownHandle p2cDownHandle;
    @Autowired
    private CacheHandle cacheHandle;
    @Autowired
    private ScheduledThreadPoolExecutor asyncMethodScheduler;

    public ObjectResponse<Void> execute(Long parkId, String parkCode, String serialNumber, LcdHintRequest hintRequest) {
        String messageId = this.showAndSay(parkId, parkCode, serialNumber, hintRequest);
        if (messageId == null) {
            return ObjectResponse.failed((String)"3003");
        }
        ObjectResponse<String> response = this.cacheHandle.getResponseFromRedis(messageId, 4000L);
        if (ObjectResponse.isSuccess(response)) {
            log.info("\u6d88\u606fID\uff1a{}\uff0c\u54cd\u5e94\u6210\u529f", (Object)messageId);
        } else {
            log.warn("[\u76d1\u63a7\u57cb\u70b9] alarmType:[{}],keyword1:[{}],keyword2:[{}]", new Object[]{LogWarnTypeEnum.\u5c4f\u663e\u8bed\u97f3\u5931\u8d25.name() + "-\u7aef\u4e91LCD", messageId + ", " + parkCode + ", " + hintRequest, response});
            new WsRepeatPush(this.p2cDownHandle, parkCode, serialNumber).push(this.asyncMethodScheduler, () -> {
                String msgId = this.showAndSay(parkId, parkCode, serialNumber, hintRequest);
                if (msgId != null) {
                    ObjectResponse<String> response1 = this.cacheHandle.getResponseFromRedis(msgId, 4000L);
                    log.info("msgId\uff1a{} \u54cd\u5e94\uff1a{}", (Object)msgId, response1);
                    return ObjectResponse.isSuccess(response1);
                }
                return false;
            });
            log.info("\u6d88\u606fID\uff1a{}\uff0c\u54cd\u5e94\u8d85\u65f6", (Object)messageId);
        }
        return ObjectResponse.success();
    }

    public String showAndSay(Long parkId, String parkCode, String serialNumber, LcdHintRequest hintRequest) {
        Message<LcdHintRequest> message = new Message<LcdHintRequest>(parkId, P2cDownCmdEnum.LCD\u5c4f\u663e\u8bed\u97f3\u4fe1\u606f.getCmdType(), hintRequest);
        return this.p2cDownHandle.send(parkCode, serialNumber, message);
    }

    @Override
    public void dealResponse(P2cBaseResponse<String> p2cBaseResponse, Long parkId, String parkCode, String serialNumber) {
        this.p2cDownHandle.dealResponse(p2cBaseResponse, parkId, P2cDownCmdEnum.LCD\u5c4f\u663e\u8bed\u97f3\u4fe1\u606f.getCmdType());
    }
}

