/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.down.p2c.impl;

import com.icetech.basics.constants.TextConstant;
import com.icetech.basics.dao.park.ParkRegionDao;
import com.icetech.basics.domain.entity.park.ParkConfig;
import com.icetech.basics.domain.entity.park.ParkInoutdevice;
import com.icetech.basics.domain.entity.park.ParkRegion;
import com.icetech.cloudcenter.api.lcd.LcdService;
import com.icetech.cloudcenter.api.park.ParkFreeSpaceService;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.domain.enumeration.P2cDownCmdEnum;
import com.icetech.cloudcenter.domain.request.p2c.LcdConfigRequest;
import com.icetech.cloudcenter.domain.response.LcdDto;
import com.icetech.cloudcenter.domain.response.LedSoundDto;
import com.icetech.cloudcenter.domain.response.p2c.P2cBaseResponse;
import com.icetech.cloudcenter.domain.vo.BatchSendRepeatVO;
import com.icetech.cloudcenter.domain.vo.BatchSendVO;
import com.icetech.common.domain.SendRequest;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.Response;
import com.icetech.common.utils.NumberUtils;
import com.icetech.common.utils.StringUtils;
import com.icetech.park.domain.entity.lcd.LcdBrightness;
import com.icetech.park.domain.entity.lcd.LcdConfig;
import com.icetech.park.domain.entity.led.LedShow;
import com.icetech.park.domain.entity.led.LedSound;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.park.domain.entity.park.ParkFreespace;
import com.icetech.park.service.AbstractConfigDownService;
import com.icetech.park.service.down.Message;
import com.icetech.park.service.down.p2c.DownService;
import com.icetech.park.service.down.p2c.ResponseService;
import com.icetech.park.service.down.p2c.SendMsgServiceImpl;
import com.icetech.park.service.flow.p2c.FlowCondition;
import com.icetech.park.service.handle.BatchDownConfigHandle;
import com.icetech.park.service.handle.P2cDownHandle;
import com.icetech.park.service.handle.showsay.LcdShowHandle;
import com.icetech.third.utils.RedisUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="p2cLcdConfigServiceImpl")
public class LcdConfigServiceImpl
extends AbstractConfigDownService
implements ResponseService<String>,
DownService<LcdConfigRequest, Void> {
    @Autowired
    private LcdService lcdService;
    @Autowired
    private ParkService parkService;
    @Autowired
    private P2cDownHandle p2cDownHandle;
    @Autowired
    private ParkFreeSpaceService parkFreeSpaceService;
    @Autowired
    private LcdShowHandle lcdShowHandle;
    @Autowired
    private RedisUtils redisUtils;
    @Value(value="${web.url}")
    private String webUrl;
    @Autowired
    private SendMsgServiceImpl sendMsgService;
    @Autowired
    private BatchDownConfigHandle<Object> batchDownConfigHandle;
    @Autowired
    private ParkRegionDao parkRegionDao;
    private List<String> IGNORE = Arrays.asList("\\{12\\}");

    @Override
    public ObjectResponse<Void> send(SendRequest sendRequest, String parkCode) {
        Long channelId = sendRequest.getServiceId();
        ObjectResponse channelResp = this.parkService.getInoutDeviceById(channelId);
        if (!ObjectResponse.isSuccess((Response)channelResp)) {
            return ObjectResponse.failed((String)"410", (String)TextConstant.getDefaultMessage((String)"1", (String)"\u901a\u9053\u4fe1\u606f\u4e0d\u5b58\u5728"));
        }
        ParkInoutdevice channel = (ParkInoutdevice)channelResp.getData();
        LcdConfigRequest lcdConfigRequest = this.generateRequest(sendRequest.getParkId(), channel);
        return this.sendMsgService.send2Channel(sendRequest, parkCode, channel.getInandoutCode(), lcdConfigRequest);
    }

    @Override
    public ObjectResponse<Void> batchSend(BatchSendVO vo, BatchSendVO.SubTaskInfo subTaskInfo) {
        ParkInoutdevice channel2;
        Long parkId = vo.getParkId();
        ObjectResponse channelsResp = this.parkService.getInoutByParkId(parkId);
        List channels = (List)channelsResp.getData();
        Long enterChannelId = null;
        Long exitChannelId = null;
        for (ParkInoutdevice channel2 : channels) {
            if (channel2.getInandoutType() == 1 && enterChannelId == null) {
                enterChannelId = channel2.getId();
                continue;
            }
            if (channel2.getInandoutType() != 2 || exitChannelId != null) continue;
            exitChannelId = channel2.getId();
        }
        ObjectResponse channelResp = this.parkService.getInoutDeviceById(subTaskInfo.getChannelId());
        channel2 = (ParkInoutdevice)channelResp.getData();
        Long reverseChannelId = channel2.getInandoutType() == 1 ? exitChannelId : enterChannelId;
        LcdConfigRequest lcdConfigRequest = this.generateRequest(parkId, channel2, reverseChannelId);
        this.batchDownConfigHandle.batchDown(vo, lcdConfigRequest, P2cDownCmdEnum.LCD\u81ea\u5b9a\u4e49\u8bed\u97f3\u5c4f\u663e\u914d\u7f6e.getCmdType());
        return ObjectResponse.success();
    }

    @Override
    public ObjectResponse<Void> batchSendRepeat(BatchSendRepeatVO vo) {
        Long parkId = vo.getParkId();
        ObjectResponse channelResp = this.parkService.getInoutDeviceById(vo.getChannelId());
        ParkInoutdevice channel = (ParkInoutdevice)channelResp.getData();
        LcdConfigRequest lcdConfigRequest = this.generateRequest(parkId, channel);
        this.batchDownConfigHandle.repeatBatch(vo, lcdConfigRequest, P2cDownCmdEnum.LCD\u81ea\u5b9a\u4e49\u8bed\u97f3\u5c4f\u663e\u914d\u7f6e.getCmdType());
        return ObjectResponse.success();
    }

    public boolean send(String parkCode, ParkInoutdevice channel, String serialNumber) {
        ObjectResponse parkObjectResponse = this.parkService.findByParkCode(parkCode);
        ObjectResponse.notError((Response)parkObjectResponse);
        Park park = (Park)parkObjectResponse.getData();
        Long parkId = park.getId();
        LcdConfigRequest lcdConfigRequest = this.generateRequest(park.getId(), channel);
        Message<LcdConfigRequest> message = new Message<LcdConfigRequest>(parkId, P2cDownCmdEnum.LCD\u81ea\u5b9a\u4e49\u8bed\u97f3\u5c4f\u663e\u914d\u7f6e.getCmdType(), lcdConfigRequest);
        String messageId = this.p2cDownHandle.send(parkCode, serialNumber, message);
        return messageId != null;
    }

    private LcdConfigRequest generateRequest(Long parkId, ParkInoutdevice channel) {
        int channelType = NumberUtils.toPrimitive((Integer)channel.getInandoutType());
        int reverseChannelType = channelType == 1 ? 2 : 1;
        ObjectResponse otherChannels = this.parkService.getChannelByType(parkId, Integer.valueOf(reverseChannelType));
        Long reverseChannelId = Optional.ofNullable(otherChannels).map(ObjectResponse::getData).filter(CollectionUtils::isNotEmpty).map(list -> (ParkInoutdevice)list.get(0)).map(ParkInoutdevice::getId).orElse(null);
        return this.generateRequest(parkId, channel, reverseChannelId);
    }

    private LcdConfigRequest generateRequest(Long parkId, ParkInoutdevice channel, Long reverseChannelId) {
        Long channelId = channel.getId();
        int channelType = NumberUtils.toPrimitive((Integer)channel.getInandoutType());
        Map lcdDtoMap = this.lcdService.getLcdShowDtoMapByChannel(channelId);
        Map otherLcdDtoMap = this.lcdService.getLcdShowDtoMapByChannel(reverseChannelId);
        Map enterLcdDtoMap = null;
        Map exitLcdDtoMap = null;
        if (channelType == 1) {
            enterLcdDtoMap = lcdDtoMap;
            exitLcdDtoMap = otherLcdDtoMap;
        } else {
            enterLcdDtoMap = otherLcdDtoMap;
            exitLcdDtoMap = lcdDtoMap;
        }
        LcdDto entranceFree = (LcdDto)enterLcdDtoMap.get(LedShow.DisplayTypeEnum.\u5165\u53e3\u7a7a\u95f2\u663e\u793a.type);
        LcdDto enterShow = (LcdDto)enterLcdDtoMap.get(LedShow.DisplayTypeEnum.\u5165\u573a\u663e\u793a.type);
        LcdDto exitFree = (LcdDto)exitLcdDtoMap.get(LedShow.DisplayTypeEnum.\u51fa\u53e3\u7a7a\u95f2\u663e\u793a.type);
        LcdDto exitShow = (LcdDto)exitLcdDtoMap.get(LedShow.DisplayTypeEnum.\u51fa\u573a\u663e\u793a.type);
        ObjectResponse lcdConfigObjectResponse = this.lcdService.getLcdConfigByChannel(channelId);
        LcdConfig lcdConfig = (LcdConfig)lcdConfigObjectResponse.getData();
        LcdConfigRequest lcdConfigRequest = new LcdConfigRequest();
        lcdConfigRequest.setLineNum(lcdConfig.getLineNum());
        lcdConfigRequest.setBlackCar(lcdConfig.getBlackCar());
        lcdConfigRequest.setEntraceFreePerLineColor(entranceFree.getLedColor());
        lcdConfigRequest.setEnterPerLineColor(enterShow.getLedColor());
        lcdConfigRequest.setExitFreePerLineColor(exitFree.getLedColor());
        lcdConfigRequest.setExitPerLineColor(exitShow.getLedColor());
        lcdConfigRequest.setEntraceFreeShowType(lcdConfig.getEntranceFreeLayout());
        lcdConfigRequest.setEnterShowType(lcdConfig.getEnterLayout());
        lcdConfigRequest.setExitFreeShowType(lcdConfig.getExitFreeLayout());
        lcdConfigRequest.setExitShowType(lcdConfig.getExitLayout());
        lcdConfigRequest.setDynamicQR(this.webUrl + "/h5/pay/exitDynamicQR");
        ArrayList<Object> showConfig = new ArrayList<Object>();
        ArrayList<LcdConfigRequest.SoundConfig> soundConfig = new ArrayList<LcdConfigRequest.SoundConfig>();
        LcdConfigRequest.ShowConfig ledConfigEntranceFree = new LcdConfigRequest.ShowConfig();
        String entranceFreeContent = entranceFree.getContent();
        ledConfigEntranceFree.setShowScene(Integer.valueOf(LcdConfigRequest.SceneEnum.\u5165\u53e3\u7a7a\u95f2\u663e\u793a.scene));
        ledConfigEntranceFree.setContent(entranceFreeContent);
        showConfig.add(ledConfigEntranceFree);
        LcdConfigRequest.ShowConfig ledConfigExitFree = new LcdConfigRequest.ShowConfig();
        String exitFreeContent = exitFree.getContent();
        ledConfigExitFree.setShowScene(Integer.valueOf(LcdConfigRequest.SceneEnum.\u51fa\u53e3\u7a7a\u95f2\u663e\u793a.scene));
        ledConfigExitFree.setContent(exitFreeContent);
        showConfig.add(ledConfigExitFree);
        int[] showSceneEnterArr = new int[]{LcdConfigRequest.SceneEnum.\u6708\u5361\u8f66\u5165\u573a.scene, LcdConfigRequest.SceneEnum.\u5176\u4ed6\u5141\u8bb8\u7684\u5165\u573a.scene, LcdConfigRequest.SceneEnum.\u4e34\u65f6\u8f66\u5165\u573a\u4e0d\u5141\u8bb8\u4e34\u65f6\u8f66\u8fdb.scene, LcdConfigRequest.SceneEnum.\u9ed1\u540d\u5355\u8f66\u8f86\u5165\u573a.scene, LcdConfigRequest.SceneEnum.\u5176\u4ed6\u4e0d\u5141\u8bb8\u5165\u573a\u7684\u8f66\u8f86.scene, LcdConfigRequest.SceneEnum.\u591a\u4f4d\u591a\u8f66\u5165\u573a\u8f66\u4f4d\u5360\u7528.scene, LcdConfigRequest.SceneEnum.\u5165\u573a\u6708\u5361\u8fc7\u671f.scene, LcdConfigRequest.SceneEnum.\u5165\u573a\u865a\u5047\u8f66\u724c.scene};
        FlowCondition.ResultCode[] resultCodeEnterArr = new FlowCondition.ResultCode[]{FlowCondition.ResultCode.\u6708\u5361\u8f66, FlowCondition.ResultCode.\u6709\u724c\u8f66\u5141\u8bb8\u4e34\u65f6\u8f66\u8fdb\u5165, FlowCondition.ResultCode.\u6709\u724c\u8f66\u4e0d\u5141\u8bb8\u4e34\u65f6\u8f66\u8fdb\u5165, FlowCondition.ResultCode.\u9ed1\u540d\u5355\u8f66, FlowCondition.ResultCode.\u9ec4\u724c\u8f66\u7981\u6b62\u5165\u573a, FlowCondition.ResultCode.\u8f66\u4f4d\u5df2\u5360, FlowCondition.ResultCode.\u8fc7\u671f\u5361, FlowCondition.ResultCode.\u865a\u5047\u8f66\u724c};
        int[] showSceneExitArr = new int[]{LcdConfigRequest.SceneEnum.\u6708\u5361\u8f66\u79bb\u573a.scene, LcdConfigRequest.SceneEnum.\u5176\u4ed6\u65e0\u9700\u7f34\u8d39\u7684\u79bb\u573a.scene, LcdConfigRequest.SceneEnum.\u9ed1\u540d\u5355\u8f66\u51fa\u573a.scene, LcdConfigRequest.SceneEnum.\u65e0\u724c\u8f66\u51fa\u573a.scene, LcdConfigRequest.SceneEnum.\u51fa\u573a\u9700\u7f34\u8d39.scene, LcdConfigRequest.SceneEnum.\u51fa\u573a\u65e0\u5165\u573a\u8bb0\u5f55.scene, LcdConfigRequest.SceneEnum.\u51fa\u573a\u865a\u5047\u8f66\u724c.scene};
        FlowCondition.ResultCode[] resultCodeExitArr = new FlowCondition.ResultCode[]{FlowCondition.ResultCode.\u6708\u5361\u8f66, FlowCondition.ResultCode.\u65e0\u9700\u7f34\u8d39, FlowCondition.ResultCode.\u9ed1\u540d\u5355\u8f66, FlowCondition.ResultCode.\u65e0\u724c\u8f66\u5141\u8bb8\u8fdb\u51fa, FlowCondition.ResultCode.\u9700\u7f34\u8d39, FlowCondition.ResultCode.\u65e0\u5165\u573a\u8bb0\u5f55, FlowCondition.ResultCode.\u865a\u5047\u8f66\u724c};
        String enterContent = enterShow.getContent();
        for (String node : this.IGNORE) {
            enterContent = enterContent.replaceAll(node, "");
        }
        for (int i = 0; i < showSceneEnterArr.length; ++i) {
            LcdConfigRequest.ShowConfig ledConfigItem = new LcdConfigRequest.ShowConfig();
            ledConfigItem.setShowScene(Integer.valueOf(showSceneEnterArr[i]));
            ledConfigItem.setContent(this.showReplaceOther(enterContent, parkId, channelId, resultCodeEnterArr[i]));
            showConfig.add(ledConfigItem);
        }
        String exitContent = exitShow.getContent();
        for (String node : this.IGNORE) {
            exitContent = exitContent.replaceAll(node, "");
        }
        for (int i = 0; i < showSceneExitArr.length; ++i) {
            LcdConfigRequest.ShowConfig ledConfigItem = new LcdConfigRequest.ShowConfig();
            ledConfigItem.setShowScene(Integer.valueOf(showSceneExitArr[i]));
            ledConfigItem.setContent(this.showReplaceOther(exitContent, parkId, channelId, resultCodeExitArr[i]));
            showConfig.add(ledConfigItem);
        }
        int[] saySceneArr = new int[]{LcdConfigRequest.SceneEnum.\u6708\u5361\u8f66\u5165\u573a.scene, LcdConfigRequest.SceneEnum.\u5176\u4ed6\u5141\u8bb8\u7684\u5165\u573a.scene, LcdConfigRequest.SceneEnum.\u6708\u5361\u8f66\u79bb\u573a.scene, LcdConfigRequest.SceneEnum.\u5176\u4ed6\u65e0\u9700\u7f34\u8d39\u7684\u79bb\u573a.scene, LcdConfigRequest.SceneEnum.\u4e34\u65f6\u8f66\u5165\u573a\u4e0d\u5141\u8bb8\u4e34\u65f6\u8f66\u8fdb.scene, LcdConfigRequest.SceneEnum.\u9ed1\u540d\u5355\u8f66\u8f86\u5165\u573a.scene, LcdConfigRequest.SceneEnum.\u5176\u4ed6\u4e0d\u5141\u8bb8\u5165\u573a\u7684\u8f66\u8f86.scene, LcdConfigRequest.SceneEnum.\u591a\u4f4d\u591a\u8f66\u5165\u573a\u8f66\u4f4d\u5360\u7528.scene, LcdConfigRequest.SceneEnum.\u5165\u573a\u6708\u5361\u8fc7\u671f.scene, LcdConfigRequest.SceneEnum.\u9ed1\u540d\u5355\u8f66\u51fa\u573a.scene, LcdConfigRequest.SceneEnum.\u65e0\u724c\u8f66\u51fa\u573a.scene, LcdConfigRequest.SceneEnum.\u51fa\u573a\u9700\u7f34\u8d39.scene, LcdConfigRequest.SceneEnum.\u51fa\u573a\u65e0\u5165\u573a\u8bb0\u5f55.scene};
        int[] soundTypeArr = new int[]{LedSound.SoundTypeEnum.\u5165\u573a\u6708\u5361\u8f66_\u5185\u90e8\u8f66\u8f86.type, LedSound.SoundTypeEnum.\u5165\u573a\u4e34\u65f6\u8f66.type, LedSound.SoundTypeEnum.\u51fa\u573a\u6708\u5361\u8f66.type, LedSound.SoundTypeEnum.\u51fa\u573a\u514d\u8d39\u8f66\u8f86_\u4e34\u65f6\u7279\u6b8a.type, LedSound.SoundTypeEnum.\u4e34\u65f6\u8f66\u7981\u6b62\u901a\u884c.type, LedSound.SoundTypeEnum.\u9ed1\u540d\u5355\u8f66\u8f86\u8fdb\u51fa\u573a.type, LedSound.SoundTypeEnum.\u4e34\u65f6\u8f66\u7981\u6b62\u901a\u884c.type, LedSound.SoundTypeEnum.\u591a\u4f4d\u591a\u8f66\u8f66\u4f4d\u5360\u7528.type, LedSound.SoundTypeEnum.\u5165\u573a\u4e34\u65f6\u8f66.type, LedSound.SoundTypeEnum.\u9ed1\u540d\u5355\u8f66\u8f86\u8fdb\u51fa\u573a.type, LedSound.SoundTypeEnum.\u51fa\u573a\u65e0\u724c\u8f66.type, LedSound.SoundTypeEnum.\u51fa\u573a\u6536\u8d39\u8f66\u8f86.type, LedSound.SoundTypeEnum.\u51fa\u573a\u65e0\u5165\u573a\u8bb0\u5f55.type};
        boolean containsLimit = false;
        Map soundDtoMap = this.lcdService.getSoundDtoMapByChannel(channelId);
        for (int i = 0; i < soundTypeArr.length; ++i) {
            LedSoundDto soundVo = (LedSoundDto)soundDtoMap.get(soundTypeArr[i]);
            LcdConfigRequest.SoundConfig soundConfigMonthEnter = new LcdConfigRequest.SoundConfig();
            soundConfigMonthEnter.setSayScene(Integer.valueOf(saySceneArr[i]));
            soundConfigMonthEnter.setContent(this.replaceSoundContent(soundVo.getContent()));
            soundConfig.add(soundConfigMonthEnter);
            if (!soundVo.getContent().contains("{2}")) continue;
            containsLimit = true;
        }
        lcdConfigRequest.setShowConfig(showConfig);
        lcdConfigRequest.setSoundConfig(soundConfig);
        lcdConfigRequest.setRestoreDefaultTime(lcdConfig.getRestoreDefaultTime());
        lcdConfigRequest.setVolumeValue(lcdConfig.getVolumeValue());
        lcdConfigRequest.setQuietHoursSwitch(lcdConfig.getQuietHoursSwitch());
        if (entranceFreeContent.contains("{2}") || exitFreeContent.contains("{2}") || containsLimit) {
            lcdConfigRequest.setLimitType(Integer.valueOf(lcdConfig.getLimitType() == null ? 1 : lcdConfig.getLimitType()));
            if (lcdConfig.getLimitType() != null && lcdConfig.getLimitType() == 0) {
                lcdConfigRequest.setLimitDriveNum1(lcdConfig.getLimitDriveNum1());
                lcdConfigRequest.setLimitDriveNum2(lcdConfig.getLimitDriveNum2());
                lcdConfigRequest.setLimitDriveNum3(lcdConfig.getLimitDriveNum3());
                lcdConfigRequest.setLimitDriveNum4(lcdConfig.getLimitDriveNum4());
                lcdConfigRequest.setLimitDriveNum5(lcdConfig.getLimitDriveNum5());
            }
        }
        if (lcdConfig.getRegionFreeSpace() == null || lcdConfig.getRegionFreeSpace() == 0L) {
            ParkFreespace parkFreespace = (ParkFreespace)this.parkFreeSpaceService.getSpaceByPark(parkId.longValue()).getData();
            lcdConfigRequest.setFreeSpace(parkFreespace.getFreeSpace());
            lcdConfigRequest.setRealFreeSpace(parkFreespace.getRealFreeSpace());
            lcdConfigRequest.setTotalSpace(parkFreespace.getTotalNum());
        } else {
            ParkRegion parkRegion = (ParkRegion)this.parkRegionDao.selectById((Serializable)lcdConfig.getRegionFreeSpace());
            if (parkRegion == null) {
                ParkFreespace parkFreespace = (ParkFreespace)this.parkFreeSpaceService.getSpaceByPark(parkId.longValue()).getData();
                lcdConfigRequest.setFreeSpace(parkFreespace.getFreeSpace());
                lcdConfigRequest.setRealFreeSpace(parkFreespace.getRealFreeSpace());
                lcdConfigRequest.setTotalSpace(parkFreespace.getTotalNum());
            } else {
                lcdConfigRequest.setFreeSpace(Integer.valueOf(parkRegion.getFreePark() == null ? 0 : parkRegion.getFreePark()));
                lcdConfigRequest.setRealFreeSpace(Integer.valueOf(parkRegion.getRealFreePark() == null ? 0 : parkRegion.getRealFreePark()));
                lcdConfigRequest.setTotalSpace(Integer.valueOf(parkRegion.getRegionPark() == null ? 0 : parkRegion.getRegionPark()));
            }
        }
        lcdConfigRequest.setExpireDaysMc(lcdConfig.getExpireDaysMc());
        if (lcdConfig.getExpireDaysMc() != null && lcdConfig.getExpireDaysMc() > 0) {
            ObjectResponse configObjectResponse = this.parkService.getParkConfig(parkId);
            lcdConfigRequest.setIsExpireMc(((ParkConfig)configObjectResponse.getData()).getIsExpireMc());
        }
        if (NumberUtils.toPrimitive((Integer)lcdConfig.getQuietHoursSwitch()) == 1) {
            lcdConfigRequest.setQuietStartTime(lcdConfig.formatQuietStartTime());
            lcdConfigRequest.setQuietEndTime(lcdConfig.formatQuietEndTime());
            lcdConfigRequest.setQuietVolumeValue(lcdConfig.getQuietVolumeValue());
        }
        if (enterContent.contains("{6}") || exitContent.contains("{6}") || entranceFreeContent.contains("{6}") || exitFreeContent.contains("{6}")) {
            ObjectResponse parkObjectResponse = this.parkService.findByParkId(parkId);
            lcdConfigRequest.setParkName(((Park)parkObjectResponse.getData()).getParkName());
        }
        if (lcdConfig.getRemainDaysMc() > 0) {
            lcdConfigRequest.setRemainDaysMc(lcdConfig.getRemainDaysMc());
        }
        List lcdBrightnessList = lcdConfig.getLcdBrightnessList();
        ArrayList<LcdConfigRequest.BrightnessControl> brightnessControls = new ArrayList<LcdConfigRequest.BrightnessControl>();
        if (lcdBrightnessList != null && lcdBrightnessList.size() > 0) {
            for (LcdBrightness lcdBrightness : lcdBrightnessList) {
                LcdConfigRequest.BrightnessControl brightnessControl = new LcdConfigRequest.BrightnessControl();
                BeanUtils.copyProperties((Object)lcdBrightness, (Object)brightnessControl);
                brightnessControls.add(brightnessControl);
            }
        }
        lcdConfigRequest.setBrightnessControl(brightnessControls);
        return lcdConfigRequest;
    }

    private String showReplaceOther(String content, Long parkId, Long channelId, FlowCondition.ResultCode resultCode) {
        if (content.contains("{8}")) {
            content = content.replace("{8}", this.lcdShowHandle.enterTips(parkId, channelId, resultCode));
        } else if (content.contains("{9}")) {
            content = content.replace("{9}", this.lcdShowHandle.exitTips(parkId, channelId, resultCode, null));
        }
        return content;
    }

    private String replaceSoundContent(String content) {
        StringBuilder lineModules = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)content)) {
            String[] split1Arr;
            for (String part : split1Arr = content.split(" ")) {
                lineModules.append("{").append(part).append("}").append(" ");
            }
        }
        return lineModules.toString().trim();
    }

    @Override
    public void dealResponse(P2cBaseResponse<String> p2cBaseResponse, Long parkId, String parkCode, String deviceNo) {
        Integer subTaskId = (Integer)this.redisUtils.get("batchdown:msgid:" + p2cBaseResponse.getMessageId(), Integer.class);
        if (subTaskId != null) {
            this.batchDownConfigHandle.dealBatchResponse(p2cBaseResponse, subTaskId, parkId);
        }
        this.p2cDownHandle.dealResponse(p2cBaseResponse, parkId, P2cDownCmdEnum.LCD\u81ea\u5b9a\u4e49\u8bed\u97f3\u5c4f\u663e\u914d\u7f6e.getCmdType());
    }
}

