/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.down.p2c.impl;

import com.icetech.basics.domain.entity.park.ParkInoutdevice;
import com.icetech.cloudcenter.api.ParkRemoteConfigService;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.domain.enumeration.KeyCodeEnum;
import com.icetech.cloudcenter.domain.enumeration.KeyValueEnum;
import com.icetech.cloudcenter.domain.enumeration.P2cDownCmdEnum;
import com.icetech.cloudcenter.domain.request.p2c.KeyValueRequest;
import com.icetech.cloudcenter.domain.response.p2c.P2cBaseResponse;
import com.icetech.common.domain.SendRequest;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.Response;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.park.domain.entity.park.ParkRemoteConfig;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.down.Message;
import com.icetech.park.service.down.p2c.DownService;
import com.icetech.park.service.down.p2c.ResponseService;
import com.icetech.park.service.handle.P2cDownHandle;
import java.lang.reflect.Field;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="p2cKeyValueServiceImpl")
public class KeyValueServiceImpl
extends AbstractService
implements ResponseService<String>,
DownService<KeyValueRequest, Void> {
    private static final Logger log = LoggerFactory.getLogger(KeyValueServiceImpl.class);
    @Autowired
    private P2cDownHandle p2cDownHandle;
    @Autowired
    private ParkService parkService;
    @Resource
    private ParkRemoteConfigService parkRemoteConfigService;

    public boolean send(String parkCode, String deviceNo) {
        ObjectResponse byParkCode = this.parkService.findByParkCode(parkCode);
        ObjectResponse.notError((Response)byParkCode);
        Park data = (Park)byParkCode.getData();
        Long parkId = data.getId();
        ObjectResponse channelInfoResponse = this.parkService.getChannelInfo(parkId, deviceNo);
        String code = channelInfoResponse.getCode();
        if (code.equals("200")) {
            ParkInoutdevice parkInoutdevice = (ParkInoutdevice)channelInfoResponse.getData();
            List parkRemoteConfigs = this.parkRemoteConfigService.selectByParkId(parkId.longValue(), parkInoutdevice.getInandoutType().intValue());
            if (parkRemoteConfigs == null || parkRemoteConfigs.size() == 0) {
                log.info("\u9065\u63a7\u5668\u952e\u503c\u5173\u7cfb\u672a\u914d\u7f6e\uff0c\u65e0\u9700\u4e0b\u53d1\uff0c\u8f66\u573a\uff1a{}", (Object)parkCode);
                return false;
            }
            KeyValueRequest keyValueRequest = new KeyValueRequest();
            keyValueRequest.setRemoteType(parkInoutdevice.getInandoutType());
            for (ParkRemoteConfig parkRemoteconfig : parkRemoteConfigs) {
                String keyName = parkRemoteconfig.getKeyName();
                Integer remoteVal = parkRemoteconfig.getRemoteVal();
                String key = KeyValueEnum.getKey((Integer)remoteVal);
                this.setFieldValueByFieldName(KeyCodeEnum.getKey((String)keyName), keyValueRequest, key);
            }
            Message<KeyValueRequest> message = new Message<KeyValueRequest>(parkId, P2cDownCmdEnum.\u9065\u63a7\u5668\u5bf9\u5e94\u5173\u7cfb.getCmdType(), keyValueRequest);
            String messageId = this.p2cDownHandle.send(parkCode, deviceNo, message);
            if (messageId == null) {
                log.info("<\u7aef\u4e91-\u9065\u63a7\u5668\u5bf9\u5e94\u5173\u7cfb> \u4e0b\u53d1\u5931\u8d25\uff0c\u53c2\u6570:{}", (Object)keyValueRequest);
                return false;
            }
            return true;
        }
        return false;
    }

    public KeyValueRequest getRequest(Long parkId, Integer enexType) {
        List parkRemoteConfigs = this.parkRemoteConfigService.selectByParkId(parkId.longValue(), enexType.intValue());
        KeyValueRequest keyValueRequest = new KeyValueRequest();
        keyValueRequest.setRemoteType(enexType);
        for (int i = 0; parkRemoteConfigs != null && i < parkRemoteConfigs.size(); ++i) {
            ParkRemoteConfig parkRemoteconfig = (ParkRemoteConfig)parkRemoteConfigs.get(i);
            String keyName = parkRemoteconfig.getKeyName();
            Integer remoteVal = parkRemoteconfig.getRemoteVal();
            String key = KeyValueEnum.getKey((Integer)remoteVal);
            this.setFieldValueByFieldName(KeyCodeEnum.getKey((String)keyName), keyValueRequest, key);
        }
        return keyValueRequest;
    }

    @Override
    public ObjectResponse<Void> send(SendRequest sendRequest, String parkCode) {
        KeyValueRequest enterRequest = this.getRequest(sendRequest.getParkId(), 1);
        Message<KeyValueRequest> message = new Message<KeyValueRequest>(sendRequest.getTaskId(), sendRequest.getParkId(), sendRequest.getServiceType(), sendRequest.getServiceId(), enterRequest);
        String[] messageId1 = this.p2cDownHandle.send2Enter(parkCode, message);
        KeyValueRequest exitRequest = this.getRequest(sendRequest.getParkId(), 2);
        message.setPayload(exitRequest);
        String[] messageId2 = this.p2cDownHandle.send2Exit(parkCode, message);
        if (messageId1 != null && messageId1.length == 0 || messageId2 != null && messageId2.length == 0) {
            log.info("<\u7aef\u4e91-\u9065\u63a7\u5668\u5bf9\u5e94\u5173\u7cfb> \u4e0b\u53d1\u5931\u8d25\uff0cparkCode\uff1a{}", (Object)parkCode);
            return ObjectResponse.failed((String)"3003");
        }
        return ObjectResponse.success();
    }

    private void setFieldValueByFieldName(String fieldName, Object object, String value) {
        try {
            Class<?> c = object.getClass();
            Field f = c.getDeclaredField(fieldName);
            f.setAccessible(true);
            f.set(object, value);
        }
        catch (Exception e) {
            log.error(String.valueOf(e.getMessage()), (Throwable)e);
        }
    }

    @Override
    public void dealResponse(P2cBaseResponse<String> p2cBaseResponse, Long parkId, String parkCode, String deviceNo) {
        this.p2cDownHandle.dealResponse(p2cBaseResponse, parkId, P2cDownCmdEnum.\u9065\u63a7\u5668\u5bf9\u5e94\u5173\u7cfb.getCmdType());
    }
}

