/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.down.p2c.impl;

import com.icetech.basics.constants.TextConstant;
import com.icetech.basics.dao.park.ParkRegionDao;
import com.icetech.basics.domain.entity.park.ParkConfig;
import com.icetech.basics.domain.entity.park.ParkInoutdevice;
import com.icetech.basics.domain.entity.park.ParkRegion;
import com.icetech.cloudcenter.api.lcd.LcdService;
import com.icetech.cloudcenter.api.lcd.LedService;
import com.icetech.cloudcenter.api.park.ParkFreeSpaceService;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.domain.enumeration.P2cDownCmdEnum;
import com.icetech.cloudcenter.domain.enumeration.P2cVersionEnum;
import com.icetech.cloudcenter.domain.request.p2c.FreeSpaceRequest;
import com.icetech.cloudcenter.domain.response.p2c.P2cBaseResponse;
import com.icetech.cloudcenter.domain.vo.p2c.ParkConnectedDeviceVo;
import com.icetech.cloudcenter.domain.vo.p2c.TokenDeviceVo;
import com.icetech.common.domain.SendRequest;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.Response;
import com.icetech.common.utils.AssertTools;
import com.icetech.common.utils.DateTools;
import com.icetech.common.utils.NumberUtils;
import com.icetech.park.domain.entity.lcd.LcdConfig;
import com.icetech.park.domain.entity.led.LedConfig;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.park.domain.entity.park.ParkFreespace;
import com.icetech.park.handle.CacheHandle;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.down.FreeSpaceSyncService;
import com.icetech.park.service.down.itc.impl.ItcFreeSpaceServiceImpl;
import com.icetech.park.service.down.p2c.DownService;
import com.icetech.park.service.down.p2c.ResponseService;
import com.icetech.park.service.down.p2c.SendMsgServiceImpl;
import com.icetech.park.service.down.p2c.impl.ChannelRulesServiceImpl;
import com.icetech.park.service.handle.ItcCacheHandle;
import com.icetech.park.service.handle.P2cDownHandle;
import com.icetech.third.utils.RedisUtils;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="p2cFreeSpaceServiceImpl")
public class FreeSpaceServiceImpl
extends AbstractService
implements FreeSpaceSyncService,
ResponseService<String>,
DownService<FreeSpaceRequest, Void> {
    private static final Logger log = LoggerFactory.getLogger(FreeSpaceServiceImpl.class);
    @Autowired
    private ParkService parkService;
    @Autowired
    private P2cDownHandle p2cDownHandle;
    @Autowired
    private ParkFreeSpaceService parkFreeSpaceService;
    @Autowired
    private SendMsgServiceImpl sendMsgService;
    @Autowired
    private RedisUtils redisUtils;
    @Autowired
    private ChannelRulesServiceImpl channelRulesService;
    @Autowired
    private CacheHandle cacheHandle;
    @Autowired
    private ItcCacheHandle itcCacheHandle;
    @Autowired
    private ItcFreeSpaceServiceImpl itcFreeSpaceService;
    @Autowired
    private ParkRegionDao parkRegionDao;
    @Resource
    private LedService ledService;
    @Resource
    private LcdService lcdService;

    @Override
    public ObjectResponse<Void> send2Park(SendRequest sendRequest, Long parkId, String parkCode) {
        ObjectResponse parkObjectResponse = this.parkService.findByParkId(parkId);
        ObjectResponse.notError((Response)parkObjectResponse);
        Park park = (Park)parkObjectResponse.getData();
        if (NumberUtils.toPrimitive((Integer)park.getIsInterior()) == 0) {
            ParkFreespace parkFreespace = (ParkFreespace)this.parkFreeSpaceService.getSpaceByPark(parkId.longValue()).getData();
            if (parkFreespace == null) {
                return ObjectResponse.failed((String)"410", (String)TextConstant.getDefaultMessage((String)"1", (String)"\u65e0\u8f66\u4f4d\u6570\u636e"));
            }
            ParkRegion parkRegion = this.parkRegionDao.selectOutByParkid(parkId);
            if (parkRegion != null) {
                if (NumberUtils.toPrimitive((Integer)parkRegion.getIsFullForbidenter()) == 0 && NumberUtils.toPrimitive((Integer)parkRegion.getIsFullForbidMonthEnter()) == 0 && NumberUtils.toPrimitive((Integer)parkRegion.getIsFullForbidVIPEnter()) == 0 && NumberUtils.toPrimitive((Integer)parkRegion.getIsFullForbidReservEnter()) == 0 && NumberUtils.toPrimitive((Integer)parkRegion.getIsFullForbidStoreEnter()) == 0) {
                    log.info("[\u7a7a\u8f66\u4f4d\u4e0b\u53d1\u63a5\u53e3] \u6ca1\u6709\u914d\u7f6e\u8f66\u4f4d\u6ee1\u7981\u6b62\u5165\u573a, \u65e0\u9700\u4e0b\u53d1\u4e34\u65f6\u8f66\u6743\u9650, parkCode[{}]", (Object)parkCode);
                } else {
                    this.handleChannelRule(parkCode, parkId, parkFreespace.getRealFreeSpace(), parkRegion);
                }
            }
            FreeSpaceRequest freeSpaceRequest = new FreeSpaceRequest();
            freeSpaceRequest.setFreeSpace(parkFreespace.getFreeSpace());
            freeSpaceRequest.setRealFreeSpace(parkFreespace.getRealFreeSpace());
            freeSpaceRequest.setShowFreeSpace(parkFreespace.getFreeSpace());
            freeSpaceRequest.setTotalSpace(parkFreespace.getTotalNum());
            freeSpaceRequest.setTime(Long.valueOf(DateTools.unixTimestamp()));
            sendRequest.setServiceType(P2cDownCmdEnum.\u5269\u4f59\u7a7a\u8f66\u4f4d.getCmdType());
            ObjectResponse objectResponse = this.sendMsgService.send2MasterChannel(sendRequest, parkCode, freeSpaceRequest);
            this.downItc(parkId, parkCode, null, freeSpaceRequest);
            return objectResponse;
        }
        ObjectResponse listResponse = this.parkService.getAllChannel(parkId);
        ObjectResponse.notError((Response)listResponse);
        List inOutDeviceList = (List)listResponse.getData();
        HashMap<Long, ParkFreespace> freeSpaceMap = new HashMap<Long, ParkFreespace>();
        HashMap<Long, String> freeSpaceNameMap = new HashMap<Long, String>();
        for (ParkInoutdevice inoutdevice : inOutDeviceList) {
            Long regionId;
            ObjectResponse objectResponse;
            if (inoutdevice.getLedLcdSource() == 1) {
                objectResponse = this.ledService.getLedConfigByChannel(inoutdevice.getId());
                if (!ObjectResponse.isSuccess((Response)objectResponse)) continue;
                regionId = ((LedConfig)objectResponse.getData()).getRegionFreeSpace();
            } else {
                objectResponse = this.lcdService.getLcdConfigByChannel(inoutdevice.getId());
                if (!ObjectResponse.isSuccess((Response)objectResponse)) continue;
                regionId = ((LcdConfig)objectResponse.getData()).getRegionFreeSpace();
            }
            regionId = regionId == null ? 0L : regionId;
            ParkFreespace parkFreespace = (ParkFreespace)freeSpaceMap.get(regionId);
            if (parkFreespace == null) {
                if (regionId == 0L) {
                    parkFreespace = (ParkFreespace)this.parkFreeSpaceService.getSpaceByPark(parkId.longValue()).getData();
                } else {
                    ParkRegion parkRegion1 = (ParkRegion)this.parkRegionDao.selectById((Serializable)regionId);
                    if (parkRegion1 == null) {
                        freeSpaceMap.put(regionId, null);
                        continue;
                    }
                    parkFreespace = new ParkFreespace();
                    parkFreespace.setFreeSpace(parkRegion1.getFreePark());
                    parkFreespace.setRealFreeSpace(parkRegion1.getRealFreePark());
                    parkFreespace.setTotalNum(parkRegion1.getRegionPark());
                    freeSpaceNameMap.put(regionId, parkRegion1.getRegionName());
                }
                freeSpaceMap.put(regionId, parkFreespace);
            }
            if (inoutdevice.getRegionId() != null) {
                ParkRegion parkRegion = (ParkRegion)this.parkRegionDao.selectById((Serializable)inoutdevice.getRegionId());
                if (NumberUtils.toPrimitive((Integer)parkRegion.getIsFullForbidenter()) == 0 && NumberUtils.toPrimitive((Integer)parkRegion.getIsFullForbidMonthEnter()) == 0 && NumberUtils.toPrimitive((Integer)parkRegion.getIsFullForbidVIPEnter()) == 0 && NumberUtils.toPrimitive((Integer)parkRegion.getIsFullForbidReservEnter()) == 0 && NumberUtils.toPrimitive((Integer)parkRegion.getIsFullForbidStoreEnter()) == 0) {
                    log.info("[\u7a7a\u8f66\u4f4d\u4e0b\u53d1\u63a5\u53e3] \u6ca1\u6709\u914d\u7f6e\u8f66\u4f4d\u6ee1\u7981\u6b62\u5165\u573a, \u65e0\u9700\u4e0b\u53d1\u4e34\u65f6\u8f66\u6743\u9650, parkCode[{}]", (Object)parkCode);
                } else {
                    this.handleRuleByChannel(parkCode, parkId, NumberUtils.toPrimitive((Integer)parkRegion.getFreePark()), inoutdevice, parkRegion);
                }
            }
            FreeSpaceRequest freeSpaceRequest = new FreeSpaceRequest();
            freeSpaceRequest.setFreeSpace(parkFreespace.getFreeSpace());
            freeSpaceRequest.setRealFreeSpace(parkFreespace.getRealFreeSpace());
            freeSpaceRequest.setTotalSpace(parkFreespace.getTotalNum());
            freeSpaceRequest.setShowFreeSpace(parkFreespace.getFreeSpace());
            if (regionId != 0L) {
                freeSpaceRequest.setShowFreeSpaceName((String)freeSpaceNameMap.get(regionId));
            }
            freeSpaceRequest.setTime(Long.valueOf(DateTools.unixTimestamp()));
            sendRequest.setServiceType(P2cDownCmdEnum.\u5269\u4f59\u7a7a\u8f66\u4f4d.getCmdType());
            this.sendMsgService.send2Channel(sendRequest, parkCode, inoutdevice.getInandoutCode(), freeSpaceRequest);
            this.downItc2Channel(parkId, parkCode, inoutdevice.getInandoutCode(), freeSpaceRequest);
        }
        return ObjectResponse.success();
    }

    @Override
    public void send2Region(SendRequest sendRequest, Long parkId, String parkCode, Long regionId) {
        ParkRegion parkRegion = (ParkRegion)this.parkRegionDao.selectById((Serializable)regionId);
        AssertTools.notNull((Object)parkRegion, (String)"404", (String)"\u65e0\u8f66\u4f4d\u6570\u636e");
        if (NumberUtils.toPrimitive((Integer)parkRegion.getIsFullForbidenter()) == 0 && NumberUtils.toPrimitive((Integer)parkRegion.getIsFullForbidMonthEnter()) == 0 && NumberUtils.toPrimitive((Integer)parkRegion.getIsFullForbidVIPEnter()) == 0 && NumberUtils.toPrimitive((Integer)parkRegion.getIsFullForbidReservEnter()) == 0 && NumberUtils.toPrimitive((Integer)parkRegion.getIsFullForbidStoreEnter()) == 0) {
            log.info("[\u7a7a\u8f66\u4f4d\u4e0b\u53d1\u63a5\u53e3] \u6ca1\u6709\u914d\u7f6e\u8f66\u4f4d\u6ee1\u7981\u6b62\u5165\u573a, \u65e0\u9700\u4e0b\u53d1\u4e34\u65f6\u8f66\u6743\u9650, parkCode[{}]", (Object)parkCode);
        } else {
            this.handleChannelRule(parkCode, parkId, NumberUtils.toPrimitive((Integer)parkRegion.getFreePark()), parkRegion);
        }
        ObjectResponse listResponse = this.parkService.getAllChannel(parkId);
        ObjectResponse.notError((Response)listResponse);
        List inOutDeviceList = ((List)listResponse.getData()).stream().filter(inoutdevice -> inoutdevice.getRegionId() != null && inoutdevice.getRegionId().equals(regionId)).collect(Collectors.toList());
        HashMap<Long, ParkFreespace> freeSpaceMap = new HashMap<Long, ParkFreespace>();
        HashMap<Long, String> freeSpaceNameMap = new HashMap<Long, String>();
        for (ParkInoutdevice inoutdevice2 : inOutDeviceList) {
            Long regionId2;
            ObjectResponse objectResponse;
            if (inoutdevice2.getLedLcdSource() == 1) {
                objectResponse = this.ledService.getLedConfigByChannel(inoutdevice2.getId());
                if (!ObjectResponse.isSuccess((Response)objectResponse)) continue;
                regionId2 = ((LedConfig)objectResponse.getData()).getRegionFreeSpace();
            } else {
                objectResponse = this.lcdService.getLcdConfigByChannel(inoutdevice2.getId());
                if (!ObjectResponse.isSuccess((Response)objectResponse)) continue;
                regionId2 = ((LcdConfig)objectResponse.getData()).getRegionFreeSpace();
            }
            regionId2 = regionId2 == null ? 0L : regionId2;
            ParkFreespace parkFreespace = (ParkFreespace)freeSpaceMap.get(regionId2);
            if (parkFreespace == null) {
                if (regionId2 == 0L) {
                    parkFreespace = (ParkFreespace)this.parkFreeSpaceService.getSpaceByPark(parkId.longValue()).getData();
                } else {
                    ParkRegion parkRegion1 = (ParkRegion)this.parkRegionDao.selectById((Serializable)regionId2);
                    if (parkRegion1 == null) {
                        freeSpaceMap.put(regionId2, null);
                        continue;
                    }
                    parkFreespace = new ParkFreespace();
                    parkFreespace.setFreeSpace(parkRegion1.getFreePark());
                    parkFreespace.setRealFreeSpace(parkRegion1.getRealFreePark());
                    parkFreespace.setTotalNum(parkRegion1.getRegionPark());
                    freeSpaceNameMap.put(regionId2, parkRegion1.getRegionName());
                }
                freeSpaceMap.put(regionId2, parkFreespace);
            }
            FreeSpaceRequest freeSpaceRequest = new FreeSpaceRequest();
            freeSpaceRequest.setFreeSpace(parkFreespace.getFreeSpace());
            freeSpaceRequest.setRealFreeSpace(parkFreespace.getRealFreeSpace());
            freeSpaceRequest.setTotalSpace(parkFreespace.getTotalNum());
            freeSpaceRequest.setShowFreeSpace(parkFreespace.getFreeSpace());
            if (regionId2 != 0L) {
                freeSpaceRequest.setShowFreeSpaceName((String)freeSpaceNameMap.get(regionId2));
            }
            freeSpaceRequest.setTime(Long.valueOf(DateTools.unixTimestamp()));
            sendRequest.setServiceType(P2cDownCmdEnum.\u5269\u4f59\u7a7a\u8f66\u4f4d.getCmdType());
            this.sendMsgService.send2Channel(sendRequest, parkCode, inoutdevice2.getInandoutCode(), freeSpaceRequest);
            this.downItc(parkId, parkCode, regionId, freeSpaceRequest);
        }
    }

    private void handleChannelRule(String parkCode, Long parkId, int realFreeSpace, ParkRegion parkRegion) {
        boolean ret;
        int fullEmptynum;
        ObjectResponse listResponse = this.parkService.getChannelByType(parkId, Integer.valueOf(1));
        if (!ObjectResponse.isSuccess((Response)listResponse)) {
            return;
        }
        List<ParkInoutdevice> collect = ((List)listResponse.getData()).stream().filter(parkInoutdevice -> parkInoutdevice.getRegionId() != null && parkInoutdevice.getRegionId().equals(parkRegion.getParkId())).collect(Collectors.toList());
        ObjectResponse configObjectResponse = this.parkService.getParkConfig(parkId);
        ObjectResponse.notError((Response)configObjectResponse);
        ParkConfig parkConfig = (ParkConfig)configObjectResponse.getData();
        String key = "PARK_FULL_" + parkCode + "_" + parkRegion.getId();
        int n = fullEmptynum = parkRegion.getFullEmptynum() == null ? 0 : parkRegion.getFullEmptynum();
        if (realFreeSpace <= fullEmptynum && !this.redisUtils.exists(key)) {
            boolean ret2 = this.downChannelRule(parkCode, collect, parkConfig, 0);
            if (ret2) {
                this.redisUtils.set(key, (Object)1);
            }
        } else if (realFreeSpace > fullEmptynum && this.redisUtils.exists(key) && (ret = this.downChannelRule(parkCode, collect, parkConfig, 1))) {
            this.redisUtils.remove(key);
        }
    }

    private void handleRuleByChannel(String parkCode, Long parkId, int realFreeSpace, ParkInoutdevice parkInoutdevice, ParkRegion parkRegion) {
        boolean ret;
        int fullEmptynum;
        ObjectResponse configObjectResponse = this.parkService.getParkConfig(parkId);
        ObjectResponse.notError((Response)configObjectResponse);
        ParkConfig parkConfig = (ParkConfig)configObjectResponse.getData();
        String key = "PARK_FULL_" + parkCode + "_" + parkRegion.getId();
        int n = fullEmptynum = parkRegion.getFullEmptynum() == null ? 0 : parkRegion.getFullEmptynum();
        if (realFreeSpace <= fullEmptynum && !this.redisUtils.exists(key)) {
            boolean ret2 = this.downRuleOneChannel(parkCode, parkConfig, 0, parkInoutdevice);
            if (ret2) {
                this.redisUtils.set(key, (Object)1);
            }
        } else if (realFreeSpace > fullEmptynum && this.redisUtils.exists(key) && (ret = this.downRuleOneChannel(parkCode, parkConfig, 1, parkInoutdevice))) {
            this.redisUtils.remove(key);
        }
    }

    private boolean downChannelRule(String parkCode, List<ParkInoutdevice> listResponse, ParkConfig parkConfig, Integer isAllowTempCarRun) {
        boolean ret = true;
        for (ParkInoutdevice parkInoutdevice : listResponse) {
            ret = ret && this.downRuleOneChannel(parkCode, parkConfig, isAllowTempCarRun, parkInoutdevice);
        }
        return ret;
    }

    private boolean downRuleOneChannel(String parkCode, ParkConfig parkConfig, Integer isAllowTempCarRun, ParkInoutdevice parkInoutdevice) {
        String serialNumber = this.cacheHandle.getSerialNumber(parkCode, parkInoutdevice.getInandoutCode());
        if (serialNumber == null) {
            return false;
        }
        TokenDeviceVo deviceInfo = this.cacheHandle.getDeviceInfo(serialNumber);
        if (deviceInfo == null) {
            return false;
        }
        if (P2cVersionEnum.getIndex((String)deviceInfo.getVersion()) >= P2cVersionEnum.\u7248\u672c10.getIndex()) {
            return false;
        }
        parkInoutdevice.setIsAllowTempcarrun(isAllowTempCarRun);
        return this.channelRulesService.send2Channel(parkCode, P2cDownCmdEnum.\u901a\u9053\u6743\u9650\u4e0b\u53d1.getCmdType(), parkConfig, parkInoutdevice);
    }

    private void downItc(Long parkId, String parkCode, Long regionId, FreeSpaceRequest freeSpaceRequest) {
        List<ParkConnectedDeviceVo> parkConnectList = this.itcCacheHandle.getParkConnectList(parkCode);
        if (CollectionUtils.isEmpty(parkConnectList)) {
            return;
        }
        log.info("\u51c6\u5907\u4e0b\u53d1\u7a7a\u8f66\u4f4d\u7ed9[{}]\u8f66\u573a\u7684\u5bf9\u8bb2\u67f1\u5217\u8868{}", (Object)parkCode, parkConnectList);
        parkConnectList.stream().filter(vo -> regionId == null || regionId.equals(vo.getRegionId())).forEach(vo -> this.itcFreeSpaceService.send(parkId, vo.getDeviceNo(), freeSpaceRequest));
    }

    private void downItc2Channel(Long parkId, String parkCode, String channelCode, FreeSpaceRequest freeSpaceRequest) {
        List<ParkConnectedDeviceVo> parkConnectList = this.itcCacheHandle.getParkConnectList(parkCode);
        if (CollectionUtils.isEmpty(parkConnectList)) {
            return;
        }
        log.info("\u51c6\u5907\u4e0b\u53d1\u7a7a\u8f66\u4f4d\u7ed9[{}]\u8f66\u573a\u7684\u5bf9\u8bb2\u67f1\u5217\u8868{}", (Object)parkCode, parkConnectList);
        parkConnectList.stream().filter(vo -> channelCode == null || channelCode.equals(vo.getInandoutCode())).forEach(vo -> this.itcFreeSpaceService.send(parkId, vo.getDeviceNo(), freeSpaceRequest));
    }

    @Override
    public void dealResponse(P2cBaseResponse<String> p2cBaseResponse, Long parkId, String parkCode, String deviceNo) {
        this.p2cDownHandle.dealResponse(p2cBaseResponse, parkId, P2cDownCmdEnum.\u5269\u4f59\u7a7a\u8f66\u4f4d.getCmdType());
    }
}

