/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.down.p2c.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.icetech.basics.domain.entity.device.FleetModeLog;
import com.icetech.cloudcenter.api.park.FleetModeLogService;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.domain.enumeration.P2cDownCmdEnum;
import com.icetech.cloudcenter.domain.enumeration.P2cVersionEnum;
import com.icetech.cloudcenter.domain.request.p2c.FleetModeRequest;
import com.icetech.cloudcenter.domain.response.p2c.P2cBaseResponse;
import com.icetech.cloudcenter.domain.vo.p2c.TokenDeviceVo;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.Response;
import com.icetech.common.validator.Validator;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.park.handle.CacheHandle;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.down.Message;
import com.icetech.park.service.down.p2c.DownService;
import com.icetech.park.service.down.p2c.ResponseService;
import com.icetech.park.service.handle.P2cDownHandle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="p2cFleetModeServiceImpl")
public class FleetModeServiceImpl
extends AbstractService
implements ResponseService<String>,
DownService<FleetModeRequest, String> {
    private static final Logger log = LoggerFactory.getLogger(FleetModeServiceImpl.class);
    @Autowired
    private P2cDownHandle p2cDownHandle;
    @Autowired
    private ParkService parkService;
    @Autowired
    private CacheHandle cacheHandle;
    @Autowired
    private FleetModeLogService fleetModeLogService;

    public ObjectResponse<Void> send(FleetModeRequest request, String sn, Long parkId) {
        if (!Validator.validate((Object)request)) {
            return ObjectResponse.failed((String)"400");
        }
        TokenDeviceVo deviceInfo = this.cacheHandle.getDeviceInfo(sn);
        if (deviceInfo == null) {
            return ObjectResponse.failed((String)"3003");
        }
        if (P2cVersionEnum.getIndex((String)deviceInfo.getVersion()) < P2cVersionEnum.\u7248\u672c19.getIndex()) {
            return ObjectResponse.failed((String)"404", (String)"\u5f53\u524d\u8bbe\u5907\u7248\u672c\u4e0d\u652f\u6301");
        }
        ObjectResponse parkObjectResponse = this.parkService.findByParkId(parkId);
        if (!ObjectResponse.isSuccess((Response)parkObjectResponse)) {
            return ObjectResponse.failed((String)"404", (String)"\u8f66\u573a\u4e0d\u5b58\u5728");
        }
        Park park = (Park)parkObjectResponse.getData();
        Message<FleetModeRequest> message = new Message<FleetModeRequest>(parkId, P2cDownCmdEnum.\u8f66\u961f\u6a21\u5f0f\u4e0b\u53d1.getCmdType(), request);
        String messageId = this.p2cDownHandle.send(park.getParkCode(), sn, message);
        if (messageId == null) {
            return ObjectResponse.failed((String)"3005");
        }
        log.info("[\u8f66\u961f\u6a21\u5f0f]\u4e0b\u53d1\u6210\u529f");
        ObjectResponse<String> responseObj = this.cacheHandle.getResponseFromRedis(messageId, 4000L);
        log.info("[\u8f66\u961f\u6a21\u5f0f]\u4e0b\u53d1\u54cd\u5e94\u7ed3\u679c:{}", responseObj);
        if (ObjectResponse.isSuccess(responseObj)) {
            FleetModeLog fleetModeLog = (FleetModeLog)this.fleetModeLogService.selectLimitOne((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(FleetModeLog.class).eq(FleetModeLog::getParkId, (Object)parkId)).eq(FleetModeLog::getChannelCode, (Object)deviceInfo.getInandoutCode())).eq(FleetModeLog::getDeleted, (Object)Boolean.FALSE));
            if (fleetModeLog == null) {
                this.fleetModeLogService.addFleetModeLog(FleetModeLog.builder().parkId(parkId).channelCode(deviceInfo.getInandoutCode()).messageId(messageId).type(request.getEnable()).deleted(Boolean.FALSE).build());
            } else {
                fleetModeLog.setMessageId(messageId);
                fleetModeLog.setType(request.getEnable());
                this.fleetModeLogService.modifyFleetModeLog(fleetModeLog);
            }
        }
        return ObjectResponse.success();
    }

    @Override
    public void dealResponse(P2cBaseResponse<String> p2cBaseResponse, Long parkId, String parkCode, String sn) {
        this.p2cDownHandle.dealResponse(p2cBaseResponse, parkId, P2cDownCmdEnum.\u8f66\u961f\u6a21\u5f0f\u4e0b\u53d1.getCmdType());
    }
}

