/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.down.p2c.impl;

import com.icetech.basics.constants.TextConstant;
import com.icetech.basics.domain.entity.park.ParkInoutdevice;
import com.icetech.basics.domain.entity.park.ParkRegion;
import com.icetech.cloudcenter.api.NotifyService;
import com.icetech.cloudcenter.api.order.OrderCarInfoService;
import com.icetech.cloudcenter.api.order.OrderService;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.domain.enumeration.P2cDownCmdEnum;
import com.icetech.cloudcenter.domain.request.p2c.ExitSyncRequest;
import com.icetech.cloudcenter.domain.response.p2c.P2cBaseResponse;
import com.icetech.common.domain.SendRequest;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.Response;
import com.icetech.common.exception.ResponseBodyException;
import com.icetech.order.dao.OrderSonCarInfoDao;
import com.icetech.order.domain.entity.OrderCarInfo;
import com.icetech.order.domain.entity.OrderInfo;
import com.icetech.order.domain.entity.OrderSonCarInfo;
import com.icetech.order.domain.entity.OrderSonInfo;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.park.handle.CacheHandle;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.down.p2c.DownService;
import com.icetech.park.service.down.p2c.ResponseService;
import com.icetech.park.service.down.p2c.SendMsgServiceImpl;
import com.icetech.park.service.handle.P2cDownHandle;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="p2cExitSyncServiceImpl")
public class ExitSyncServiceImpl
extends AbstractService
implements ResponseService<String>,
DownService<ExitSyncRequest, Void>,
NotifyService<String> {
    @Autowired
    private P2cDownHandle p2cDownHandle;
    @Autowired
    private OrderService orderService;
    @Autowired
    private CacheHandle cacheHandle;
    @Autowired
    private OrderCarInfoService orderCarInfoService;
    @Autowired
    private SendMsgServiceImpl sendMsgService;
    @Autowired
    private ParkService parkService;
    @Autowired
    private OrderSonCarInfoDao orderSonCarInfoDao;

    @Override
    public ObjectResponse<Void> send(SendRequest sendRequest, String parkCode) {
        String deviceNo;
        Long parkId = sendRequest.getParkId();
        OrderInfo orderInfo = new OrderInfo();
        orderInfo.setParkId(parkId);
        orderInfo.setId(sendRequest.getServiceId());
        ObjectResponse byOrderInfo = this.orderService.findByOrderInfo(orderInfo);
        if (!ObjectResponse.isSuccess((Response)byOrderInfo)) {
            return ObjectResponse.failed((String)"410", (String)TextConstant.getDefaultMessage((String)"1", (String)"\u8ba2\u5355\u4fe1\u606f\u672a\u627e\u5230"));
        }
        OrderInfo infoData = (OrderInfo)byOrderInfo.getData();
        ExitSyncRequest exitSyncRequest = new ExitSyncRequest();
        exitSyncRequest.setType(infoData.getType());
        exitSyncRequest.setPlateNum(infoData.getPlateNum());
        exitSyncRequest.setOrderNum(infoData.getOrderNum());
        exitSyncRequest.setEnterTime(infoData.getEnterTime());
        exitSyncRequest.setExitTime(infoData.getExitTime());
        ObjectResponse carInfoResponse = this.orderCarInfoService.getCarInfo(infoData.getOrderNum(), parkId);
        ObjectResponse.notError((Response)carInfoResponse);
        OrderCarInfo carInfo = (OrderCarInfo)carInfoResponse.getData();
        String channelId = carInfo.getExitChannelId();
        try {
            deviceNo = this.cacheHandle.getSerialNumber(parkCode, channelId);
        }
        catch (ResponseBodyException e) {
            return ObjectResponse.failed((String)"3003");
        }
        ObjectResponse objectResponse = this.parkService.getInOutDeviceByCode(infoData.getParkId(), channelId);
        if (ObjectResponse.isSuccess((Response)objectResponse)) {
            ParkInoutdevice inoutDevice = (ParkInoutdevice)objectResponse.getData();
            exitSyncRequest.setRegionId(inoutDevice.getRegionId());
            exitSyncRequest.setIsMaster(inoutDevice.getIsMaster());
            ObjectResponse regionObjectResponse = this.parkService.getParkRegionById(inoutDevice.getRegionId());
            if (ObjectResponse.isSuccess((Response)regionObjectResponse)) {
                ParkRegion parkRegion = (ParkRegion)regionObjectResponse.getData();
                exitSyncRequest.setRegionType(Integer.valueOf(Long.valueOf(0L).equals(parkRegion.getFatherRelationId()) ? 1 : 2));
            }
        }
        return this.sendMsgService.send2OtherMasterExit(deviceNo, sendRequest, parkCode, exitSyncRequest);
    }

    public ObjectResponse<?> send(SendRequest sendRequest, String parkCode, Object content) {
        String deviceNo;
        OrderSonCarInfo orderCarInfo;
        OrderInfo infoData;
        if (P2cDownCmdEnum.\u51fa\u573a\u6570\u636e\u540c\u6b65.getCmdType().equals(sendRequest.getServiceType())) {
            infoData = (OrderInfo)content;
            orderCarInfo = (OrderCarInfo)this.orderCarInfoService.getCarInfo(infoData.getOrderNum(), infoData.getParkId()).getData();
        } else {
            infoData = (OrderSonInfo)content;
            orderCarInfo = this.orderSonCarInfoDao.selectByOrderSonId(infoData.getId().longValue());
        }
        if (infoData.getExitTime() == null) {
            infoData.setExitTime(infoData.getEnterTime());
        }
        ExitSyncRequest exitSyncRequest = new ExitSyncRequest();
        exitSyncRequest.setType(infoData.getType());
        exitSyncRequest.setPlateNum(infoData.getPlateNum());
        exitSyncRequest.setOrderNum(infoData.getOrderNum());
        exitSyncRequest.setEnterTime(infoData.getEnterTime());
        exitSyncRequest.setExitTime(infoData.getExitTime());
        if (orderCarInfo == null) {
            return ObjectResponse.success((Object)"406");
        }
        String channelId = orderCarInfo.getExitChannelId();
        try {
            deviceNo = this.cacheHandle.getSerialNumber(parkCode, channelId);
        }
        catch (ResponseBodyException e) {
            return ObjectResponse.failed((String)"3003");
        }
        ObjectResponse objectResponse = this.parkService.findByParkId(sendRequest.getParkId());
        ObjectResponse.notError((Response)objectResponse, (String)("\u8f66\u573aID[" + sendRequest.getParkId() + "]\u4e0d\u5b58\u5728"));
        if (Integer.valueOf(1).equals(((Park)objectResponse.getData()).getIsInterior())) {
            ObjectResponse inoutDeviceObjectResponse = this.parkService.getInOutDeviceByCode(infoData.getParkId(), channelId);
            ObjectResponse.notError((Response)inoutDeviceObjectResponse, (String)("\u901a\u9053\u7f16\u53f7[" + channelId + "]\u4e0d\u5b58\u5728"));
            ParkInoutdevice inoutDevice = (ParkInoutdevice)inoutDeviceObjectResponse.getData();
            exitSyncRequest.setRegionId(inoutDevice.getRegionId());
            exitSyncRequest.setIsMaster(inoutDevice.getIsMaster());
            ObjectResponse regionObjectResponse = this.parkService.getParkRegionById(inoutDevice.getRegionId());
            ObjectResponse.notError((Response)regionObjectResponse, (String)("\u533a\u57dfID[" + inoutDevice.getRegionId() + "]\u4e0d\u5b58\u5728"));
            ParkRegion parkRegion = (ParkRegion)regionObjectResponse.getData();
            exitSyncRequest.setRegionType(Integer.valueOf(Long.valueOf(0L).equals(parkRegion.getFatherRelationId()) ? 1 : 2));
        }
        return this.sendMsgService.send2OtherMasterExit(deviceNo, sendRequest, parkCode, exitSyncRequest);
    }

    @Override
    public void dealResponse(P2cBaseResponse<String> p2cBaseResponse, Long parkId, String parkCode, String deviceNo) {
        this.p2cDownHandle.dealResponse(p2cBaseResponse, parkId, P2cDownCmdEnum.\u51fa\u573a\u6570\u636e\u540c\u6b65.getCmdType());
    }
}

