/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.down.p2c.impl;

import com.icetech.basics.domain.entity.park.ParkInoutdevice;
import com.icetech.basics.domain.entity.park.ParkRegion;
import com.icetech.cloudcenter.api.NotifyService;
import com.icetech.cloudcenter.api.order.OrderCarInfoService;
import com.icetech.cloudcenter.api.order.OrderService;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.domain.enumeration.P2cDownCmdEnum;
import com.icetech.cloudcenter.domain.request.p2c.EnterSyncRequest;
import com.icetech.cloudcenter.domain.response.p2c.P2cBaseResponse;
import com.icetech.common.domain.SendRequest;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.Response;
import com.icetech.order.dao.OrderSonCarInfoDao;
import com.icetech.order.domain.entity.OrderCarInfo;
import com.icetech.order.domain.entity.OrderInfo;
import com.icetech.order.domain.entity.OrderSonCarInfo;
import com.icetech.order.domain.entity.OrderSonInfo;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.down.p2c.DownService;
import com.icetech.park.service.down.p2c.ResponseService;
import com.icetech.park.service.down.p2c.SendMsgServiceImpl;
import com.icetech.park.service.handle.P2cDownHandle;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="p2cEnterSyncServiceImpl")
public class EnterSyncServiceImpl
extends AbstractService
implements ResponseService<String>,
DownService<EnterSyncRequest, Void>,
NotifyService<String> {
    private static final Logger log = LoggerFactory.getLogger(EnterSyncServiceImpl.class);
    @Autowired
    private P2cDownHandle p2cDownHandle;
    @Autowired
    private SendMsgServiceImpl sendMsgService;
    @Autowired
    private OrderService orderService;
    @Resource
    private OrderCarInfoService orderCarInfoService;
    @Resource
    private ParkService parkService;
    @Resource
    private OrderSonCarInfoDao orderSonCarInfoDao;

    @Override
    public ObjectResponse<Void> send(SendRequest sendRequest, String parkCode) {
        Long parkId = sendRequest.getParkId();
        OrderInfo orderInfo = new OrderInfo();
        orderInfo.setParkId(parkId);
        orderInfo.setId(sendRequest.getServiceId());
        orderInfo.setServiceStatus(Integer.valueOf(1));
        ObjectResponse byOrderInfo = this.orderService.findByOrderInfo(orderInfo);
        if (byOrderInfo == null) {
            log.info("[\u7aef\u4e91-\u5165\u573a\u540c\u6b65\u5230\u51fa\u53e3] \u67e5\u8be2\u5931\u8d25, order\u8868id[{}], \u7ed3\u679c[{}]", (Object)sendRequest.getServiceId(), (Object)byOrderInfo);
            return ObjectResponse.failed((String)"500");
        }
        if (byOrderInfo.getCode().equals("404")) {
            log.info("[\u7aef\u4e91-\u5165\u573a\u540c\u6b65\u5230\u51fa\u53e3] \u672a\u627e\u5230\u5165\u573a\u8bb0\u5f55\u6216\u8f66\u573a\u5df2\u51fa\u573a\uff0corder\u8868id[{}]", (Object)sendRequest.getServiceId());
            return ObjectResponse.failed((String)"406", (String)"\u672a\u627e\u5230\u5728\u573a\u8ba2\u5355");
        }
        if (byOrderInfo.getData() == null) {
            log.info("[\u7aef\u4e91-\u5165\u573a\u540c\u6b65\u5230\u51fa\u53e3] \u67e5\u8be2\u5931\u8d25, order\u8868id[{}], \u7ed3\u679c[{}]", (Object)sendRequest.getServiceId(), (Object)byOrderInfo);
            return ObjectResponse.failed((String)byOrderInfo.getCode(), (String)byOrderInfo.getMsg());
        }
        OrderInfo infoData = (OrderInfo)byOrderInfo.getData();
        EnterSyncRequest enterSyncRequest = new EnterSyncRequest();
        enterSyncRequest.setOrderNum(infoData.getOrderNum());
        enterSyncRequest.setPlateNum(infoData.getPlateNum());
        enterSyncRequest.setEnterTime(infoData.getEnterTime());
        enterSyncRequest.setType(infoData.getType());
        ObjectResponse infoObjectResponse = this.orderCarInfoService.getCarInfo(infoData.getOrderNum(), infoData.getParkId());
        if (ObjectResponse.isSuccess((Response)infoObjectResponse) && ((OrderCarInfo)infoObjectResponse.getData()).getEnterChannelId() != null) {
            String enterChannelId = ((OrderCarInfo)infoObjectResponse.getData()).getEnterChannelId();
            ObjectResponse objectResponse = this.parkService.getInOutDeviceByCode(infoData.getParkId(), enterChannelId);
            if (ObjectResponse.isSuccess((Response)objectResponse)) {
                ParkInoutdevice inoutDevice = (ParkInoutdevice)objectResponse.getData();
                enterSyncRequest.setRegionId(inoutDevice.getRegionId());
                enterSyncRequest.setIsMaster(inoutDevice.getIsMaster());
                ObjectResponse regionObjectResponse = this.parkService.getParkRegionById(inoutDevice.getRegionId());
                if (ObjectResponse.isSuccess((Response)regionObjectResponse)) {
                    ParkRegion parkRegion = (ParkRegion)regionObjectResponse.getData();
                    enterSyncRequest.setRegionType(Integer.valueOf(Long.valueOf(0L).equals(parkRegion.getFatherRelationId()) ? 1 : 2));
                }
            }
        }
        return this.sendMsgService.send2MasterExit(sendRequest, parkCode, enterSyncRequest);
    }

    public ObjectResponse<Void> send(SendRequest sendRequest, String parkCode, Object content) {
        OrderInfo infoData;
        OrderSonCarInfo orderCarInfo = null;
        if (P2cDownCmdEnum.\u5165\u573a\u6570\u636e\u540c\u6b65.getCmdType().equals(sendRequest.getServiceType())) {
            infoData = (OrderInfo)content;
            ObjectResponse objectResponse = this.parkService.findByParkId(sendRequest.getParkId());
            if (ObjectResponse.isSuccess((Response)objectResponse)) {
                Integer isInterior = ((Park)objectResponse.getData()).getIsInterior();
                if (Integer.valueOf(1).equals(isInterior)) {
                    orderCarInfo = (OrderCarInfo)this.orderCarInfoService.getCarInfo(infoData.getOrderNum(), infoData.getParkId()).getData();
                }
            }
        } else {
            infoData = (OrderSonInfo)content;
            orderCarInfo = this.orderSonCarInfoDao.selectByOrderSonId(infoData.getId().longValue());
        }
        if (orderCarInfo == null) {
            return ObjectResponse.failed((String)"406");
        }
        EnterSyncRequest enterSyncRequest = new EnterSyncRequest();
        enterSyncRequest.setOrderNum(infoData.getOrderNum());
        enterSyncRequest.setPlateNum(infoData.getPlateNum());
        enterSyncRequest.setEnterTime(infoData.getEnterTime());
        enterSyncRequest.setType(infoData.getType());
        if (orderCarInfo.getEnterChannelId() != null) {
            String enterChannelId = orderCarInfo.getEnterChannelId();
            ObjectResponse objectResponse = this.parkService.getInOutDeviceByCode(infoData.getParkId(), enterChannelId);
            if (ObjectResponse.isSuccess((Response)objectResponse)) {
                ParkInoutdevice inoutDevice = (ParkInoutdevice)objectResponse.getData();
                enterSyncRequest.setRegionId(inoutDevice.getRegionId());
                enterSyncRequest.setIsMaster(inoutDevice.getIsMaster());
                ObjectResponse regionObjectResponse = this.parkService.getParkRegionById(inoutDevice.getRegionId());
                if (ObjectResponse.isSuccess((Response)regionObjectResponse)) {
                    ParkRegion parkRegion = (ParkRegion)regionObjectResponse.getData();
                    enterSyncRequest.setRegionType(Integer.valueOf(Long.valueOf(0L).equals(parkRegion.getFatherRelationId()) ? 1 : 2));
                }
            }
        }
        return this.sendMsgService.send2MasterExit(sendRequest, parkCode, enterSyncRequest);
    }

    @Override
    public void dealResponse(P2cBaseResponse<String> p2cBaseResponse, Long parkId, String parkCode, String deviceNo) {
        this.p2cDownHandle.dealResponse(p2cBaseResponse, parkId, P2cDownCmdEnum.\u5165\u573a\u6570\u636e\u540c\u6b65.getCmdType());
    }
}

