/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.down.p2c.impl;

import com.icetech.cloudcenter.api.NotifyService;
import com.icetech.cloudcenter.domain.enumeration.P2cDownCmdEnum;
import com.icetech.cloudcenter.domain.request.p2c.ClearListRequest;
import com.icetech.cloudcenter.domain.response.p2c.P2cBaseResponse;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.down.Message;
import com.icetech.park.service.down.p2c.ResponseService;
import com.icetech.park.service.handle.P2cDownHandle;
import javax.annotation.Resource;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="p2cClearListServiceImpl")
public class ClearListServiceImpl
extends AbstractService
implements ResponseService<String>,
NotifyService<String> {
    private static final Logger log = LoggerFactory.getLogger(ClearListServiceImpl.class);
    @Resource
    private P2cDownHandle p2cDownHandle;

    public ObjectResponse<Void> execute(Long parkId, String parkCode, Integer dataType, Integer id) {
        ClearListRequest clearListRequest = new ClearListRequest();
        clearListRequest.setDataType(dataType);
        clearListRequest.setId(id);
        Message<ClearListRequest> message = new Message<ClearListRequest>(parkId, P2cDownCmdEnum.\u540d\u5355\u6570\u636e\u6e05\u7a7a.getCmdType(), clearListRequest);
        Object[] messageIdArr = this.p2cDownHandle.send2Park(parkCode, message);
        if (ArrayUtils.isEmpty((Object[])messageIdArr)) {
            return ObjectResponse.failed((String)"410", (String)"\u8bc6\u522b\u76f8\u673a\u4e0d\u5728\u7ebf");
        }
        return ObjectResponse.success();
    }

    @Override
    public void dealResponse(P2cBaseResponse<String> p2cBaseResponse, Long parkId, String parkCode, String deviceNo) {
        this.p2cDownHandle.dealResponse(p2cBaseResponse, parkId, P2cDownCmdEnum.\u540d\u5355\u6570\u636e\u6e05\u7a7a.getCmdType());
    }
}

