/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.down.p2c.impl;

import com.icetech.cloudcenter.api.NotifyService;
import com.icetech.cloudcenter.domain.enumeration.P2cDownCmdEnum;
import com.icetech.cloudcenter.domain.request.p2c.ClearInparkRequest;
import com.icetech.cloudcenter.domain.response.p2c.P2cBaseResponse;
import com.icetech.common.domain.SendRequest;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.utils.StringUtils;
import com.icetech.order.dao.OrderModifyRecordDao;
import com.icetech.order.domain.entity.OrderModifyRecord;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.down.Message;
import com.icetech.park.service.down.p2c.DownService;
import com.icetech.park.service.down.p2c.ResponseService;
import com.icetech.park.service.down.p2c.SendMsgServiceImpl;
import com.icetech.park.service.handle.P2cDownHandle;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="p2cClearInparkServiceImpl")
public class ClearInparkServiceImpl
extends AbstractService
implements ResponseService<String>,
DownService<ClearInparkRequest, Void>,
NotifyService<String> {
    private static final Logger log = LoggerFactory.getLogger(ClearInparkServiceImpl.class);
    @Autowired
    private P2cDownHandle p2CDownHandle;
    @Autowired
    private OrderModifyRecordDao orderModifyRecordDao;
    @Autowired
    private SendMsgServiceImpl sendMsgService;

    @Override
    public ObjectResponse<Void> send(SendRequest sendRequest, String parkCode) {
        OrderModifyRecord orderModifyRecord = this.orderModifyRecordDao.selectOneById(sendRequest.getServiceId());
        if (orderModifyRecord == null) {
            return ObjectResponse.failed((String)"406", (String)"\u672a\u627e\u5230\u64cd\u4f5c\u8bb0\u5f55");
        }
        if (orderModifyRecord.getAction() == 1) {
            return ObjectResponse.failed((String)"406", (String)"\u4fee\u6539\u8ba2\u5355\u65e0\u9700\u4e0b\u53d1\u76f8\u673a");
        }
        ClearInparkRequest clearInparkRequest = new ClearInparkRequest();
        clearInparkRequest.setOrderNum(orderModifyRecord.getOrderNum());
        return this.sendMsgService.send2Park(sendRequest, parkCode, clearInparkRequest);
    }

    @Override
    public ObjectResponse<Void> batchSend(List<SendRequest> sendRequestList, Long parkId, String parkCode) {
        List ids = sendRequestList.stream().map(SendRequest::getServiceId).collect(Collectors.toList());
        List list = this.orderModifyRecordDao.selectBatchIds(ids);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return ObjectResponse.failed((String)"402");
        }
        Map<Long, String> idOrderNumMap = list.stream().collect(Collectors.toMap(OrderModifyRecord::getId, OrderModifyRecord::getOrderNum, (a, b) -> a));
        sendRequestList.forEach(sendRequest -> {
            ClearInparkRequest clearInparkRequest = new ClearInparkRequest();
            String orderNum = (String)idOrderNumMap.get(sendRequest.getServiceId());
            if (StringUtils.isNotBlank((CharSequence)orderNum)) {
                clearInparkRequest.setOrderNum(orderNum);
                this.sendMsgService.send2Park((SendRequest)sendRequest, parkCode, clearInparkRequest);
            }
        });
        return ObjectResponse.success();
    }

    public ObjectResponse<Void> execute(Long parkId, String parkCode, String orderNum) {
        ClearInparkRequest clearInparkRequest = new ClearInparkRequest();
        clearInparkRequest.setOrderNum(orderNum);
        Message<ClearInparkRequest> message = new Message<ClearInparkRequest>(parkId, P2cDownCmdEnum.\u5728\u573a\u8f66\u8f86\u6e05\u9664.getCmdType(), clearInparkRequest);
        String[] messageIdArr = this.p2CDownHandle.send2Park(parkCode, message);
        if (messageIdArr == null || messageIdArr[0] == null) {
            return ObjectResponse.failed((String)"3003");
        }
        return ObjectResponse.success();
    }

    public ObjectResponse<Void> clearByDeviceNo(Long parkId, String parkCode, String orderNum, String serialNumber) {
        ClearInparkRequest clearInparkRequest = new ClearInparkRequest();
        clearInparkRequest.setOrderNum(orderNum);
        Message<ClearInparkRequest> message = new Message<ClearInparkRequest>(parkId, P2cDownCmdEnum.\u5728\u573a\u8f66\u8f86\u6e05\u9664.getCmdType(), clearInparkRequest);
        String messageId = this.p2CDownHandle.send(parkCode, serialNumber, message);
        if (messageId == null) {
            return ObjectResponse.failed((String)"3003");
        }
        return ObjectResponse.success();
    }

    @Override
    public void dealResponse(P2cBaseResponse<String> p2cBaseResponse, Long parkId, String parkCode, String deviceNo) {
        this.p2CDownHandle.dealResponse(p2cBaseResponse, parkId, P2cDownCmdEnum.\u5728\u573a\u8f66\u8f86\u6e05\u9664.getCmdType());
    }
}

