/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.down.p2c.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.icetech.basics.domain.entity.park.ParkChargeconfig;
import com.icetech.basics.domain.entity.park.ParkConfig;
import com.icetech.cloudcenter.api.fee.ChargeService;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.domain.charge.detail.Charge24HourDetail;
import com.icetech.cloudcenter.domain.charge.detail.ChargeDayNightDetail;
import com.icetech.cloudcenter.domain.charge.detail.ChargeNaturalDayDetail;
import com.icetech.cloudcenter.domain.charge.detail.ChargeTypeDetail;
import com.icetech.cloudcenter.domain.enumeration.P2cDownCmdEnum;
import com.icetech.cloudcenter.domain.request.p2c.ChargeRuleRequest;
import com.icetech.cloudcenter.domain.response.p2c.P2cBaseResponse;
import com.icetech.cloudcenter.domain.vo.BatchSendRepeatVO;
import com.icetech.cloudcenter.domain.vo.BatchSendVO;
import com.icetech.common.domain.SendRequest;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.Response;
import com.icetech.common.exception.ResponseBodyException;
import com.icetech.common.thread.ThreadUtils;
import com.icetech.common.utils.NumberUtils;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.park.service.AbstractConfigDownService;
import com.icetech.park.service.down.Message;
import com.icetech.park.service.down.p2c.DownService;
import com.icetech.park.service.down.p2c.ResponseService;
import com.icetech.park.service.down.p2c.SendMsgServiceImpl;
import com.icetech.park.service.down.p2c.impl.ChannelRulesServiceImpl;
import com.icetech.park.service.handle.BatchDownConfigHandle;
import com.icetech.park.service.handle.P2cDownHandle;
import com.icetech.third.utils.RedisUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="p2cChargeRuleServiceImpl")
public class ChargeRuleServiceImpl
extends AbstractConfigDownService
implements ResponseService<String>,
DownService<List<ChargeRuleRequest>, Void> {
    private static final Logger log = LoggerFactory.getLogger(ChargeRuleServiceImpl.class);
    @Autowired
    private P2cDownHandle p2cDownHandle;
    @Autowired
    private ChargeService chargeService;
    @Autowired
    private ParkService parkService;
    @Autowired
    private SendMsgServiceImpl sendMsgService;
    @Autowired
    private RedisUtils redisUtils;
    @Autowired
    private BatchDownConfigHandle<List<ChargeRuleRequest>> batchDownConfigHandle;
    @Autowired
    private ChannelRulesServiceImpl channelRulesService;
    @Autowired
    private ThreadPoolExecutor asyncExecutor;

    public boolean send(String parkCode, String deviceNo, String version) {
        ObjectResponse byParkCode = this.parkService.findByParkCode(parkCode);
        ObjectResponse.notError((Response)byParkCode);
        Park data = (Park)byParkCode.getData();
        Long parkId = data.getId();
        List<ChargeRuleRequest> chargeRuleRequests = this.buildRequest(parkId);
        Message<List<ChargeRuleRequest>> message = new Message<List<ChargeRuleRequest>>(parkId, P2cDownCmdEnum.\u8ba1\u8d39\u89c4\u5219.getCmdType(), chargeRuleRequests);
        String messageId = this.p2cDownHandle.send(parkCode, deviceNo, message);
        if (messageId == null) {
            log.info("<\u7aef\u4e91-\u8ba1\u8d39\u89c4\u5219\u4e0b\u53d1> \u4e0b\u53d1\u5931\u8d25\uff0c\u53c2\u6570:{}", chargeRuleRequests);
            return false;
        }
        return true;
    }

    @Override
    public ObjectResponse<Void> send(SendRequest sendRequest, String parkCode) {
        List<ChargeRuleRequest> chargeRuleRequests = this.buildRequest(sendRequest.getParkId());
        this.syncChannelRules(sendRequest.getParkId(), parkCode);
        return this.sendMsgService.send2Park(sendRequest, parkCode, chargeRuleRequests);
    }

    @Override
    public void dealResponse(P2cBaseResponse<String> p2cBaseResponse, Long parkId, String parkCode, String sn) {
        Integer subTaskId = (Integer)this.redisUtils.get("batchdown:msgid:" + p2cBaseResponse.getMessageId(), Integer.class);
        if (subTaskId != null) {
            this.batchDownConfigHandle.dealBatchResponse(p2cBaseResponse, subTaskId, parkId);
        }
        this.p2cDownHandle.dealResponse(p2cBaseResponse, parkId, P2cDownCmdEnum.\u8ba1\u8d39\u89c4\u5219.getCmdType());
    }

    @Override
    public ObjectResponse<Void> batchSend(BatchSendVO vo) {
        Long parkId = vo.getParkId();
        List<ChargeRuleRequest> chargeRuleRequests = this.buildRequest(parkId);
        this.batchDownConfigHandle.batchDown(vo, chargeRuleRequests, P2cDownCmdEnum.\u8ba1\u8d39\u89c4\u5219.getCmdType());
        return ObjectResponse.success();
    }

    @Override
    public ObjectResponse<Void> batchSendRepeat(BatchSendRepeatVO vo) {
        Long parkId = vo.getParkId();
        List<ChargeRuleRequest> chargeRuleRequests = this.buildRequest(parkId);
        this.batchDownConfigHandle.repeatBatch(vo, chargeRuleRequests, P2cDownCmdEnum.\u8ba1\u8d39\u89c4\u5219.getCmdType());
        return ObjectResponse.success();
    }

    /*
     * Enabled aggressive block sorting
     */
    private List<ChargeRuleRequest> buildRequest(Long parkId) {
        ObjectResponse objectResponse = this.chargeService.getConfigs(parkId);
        ObjectResponse parkConfigObjectResponse = this.parkService.getParkConfig(parkId);
        ObjectResponse.notError((Response)objectResponse, (String)"\u672a\u627e\u5230\u8ba1\u8d39\u89c4\u5219");
        ObjectResponse.notError((Response)parkConfigObjectResponse, (String)"\u672a\u627e\u5230\u9ad8\u7ea7\u914d\u7f6e");
        List parkChargeconfigs = (List)objectResponse.getData();
        ArrayList<ChargeRuleRequest> list = new ArrayList<ChargeRuleRequest>(parkChargeconfigs.size());
        Iterator iterator = parkChargeconfigs.iterator();
        while (true) {
            ChargeRuleRequest chargeRuleRequest;
            block22: {
                if (!iterator.hasNext()) {
                    return list;
                }
                ParkChargeconfig parkChargeconfig = (ParkChargeconfig)iterator.next();
                String billCode = parkChargeconfig.getBilltypecode();
                chargeRuleRequest = new ChargeRuleRequest();
                chargeRuleRequest.setBilltype(parkChargeconfig.getBilltype());
                chargeRuleRequest.setBilltypecode(parkChargeconfig.getBilltypecode());
                chargeRuleRequest.setBilltypename(parkChargeconfig.getBilltypename());
                chargeRuleRequest.setIsDefault(parkChargeconfig.getDefaultCharge());
                if (parkChargeconfig.getBilltype() == ParkChargeconfig.BilltypeEnum.\u901a\u7528\u81ea\u7136\u5929.type) {
                    ObjectResponse naturaldayObjectResponse = this.chargeService.getNaturalday(parkChargeconfig.getBilltypecode());
                    if (ObjectResponse.isSuccess((Response)naturaldayObjectResponse)) {
                        ChargeNaturalDayDetail naturalDayDetail = (ChargeNaturalDayDetail)naturaldayObjectResponse.getData();
                        ChargeRuleRequest.NaturalDayRule naturalDayRule = new ChargeRuleRequest.NaturalDayRule();
                        BeanUtil.copyProperties((Object)naturalDayDetail, (Object)naturalDayRule, (CopyOptions)CopyOptions.create().setIgnoreNullValue(true));
                        if (naturalDayDetail.getIsFreetimeOnce() == null || naturalDayDetail.getIsFreetimeOnce() >= 0) {
                            naturalDayRule.setFreetime(Integer.valueOf(0));
                        } else if (Integer.valueOf(1).equals(((ParkConfig)parkConfigObjectResponse.getData()).getBillPrecision())) {
                            naturalDayRule.setFreetime(Integer.valueOf(NumberUtils.toPrimitive((Integer)naturalDayRule.getFreetime()) <= 0 ? 0 : naturalDayRule.getFreetime() - 1));
                        }
                        naturalDayRule.setOneBillmethod(naturalDayDetail.getBillmethod());
                        naturalDayRule.setFirstConfig(this.onceDyrationDetail(naturalDayDetail.getWorkdayDetail()));
                        if (naturalDayDetail.getIsspecialdaycharge() == 1) {
                            naturalDayRule.setTwoBillmethod(naturalDayDetail.getNoworkBillmethod());
                            naturalDayRule.setTwoConfig(this.onceDyrationDetail(naturalDayDetail.getHolidayDetail()));
                        }
                        chargeRuleRequest.setChargeRule((Object)naturalDayRule);
                        break block22;
                    } else {
                        log.info("<\u7aef\u4e91-\u8ba1\u8d39\u89c4\u5219\u4e0b\u53d1> \u6570\u636e\u4e0d\u5b8c\u6574\uff0c\u901a\u7528\u81ea\u7136\u5929\u8ba1\u8d39\u914d\u7f6e\u67e5\u8be2\u5931\u8d25\uff0cbillCode\uff1a{}", (Object)billCode);
                        continue;
                    }
                }
                if (parkChargeconfig.getBilltype() == ParkChargeconfig.BilltypeEnum.\u767d\u5929\u591c\u95f4\u6536\u8d39.type) {
                    ObjectResponse chargeDaynightObjectResponse = this.chargeService.getDaynight(parkChargeconfig.getBilltypecode());
                    if (ObjectResponse.isSuccess((Response)chargeDaynightObjectResponse)) {
                        ChargeDayNightDetail dayNightDetail = (ChargeDayNightDetail)chargeDaynightObjectResponse.getData();
                        ChargeRuleRequest.DayNightRule dayNightRule = new ChargeRuleRequest.DayNightRule();
                        BeanUtil.copyProperties((Object)dayNightDetail, (Object)dayNightRule, (CopyOptions)CopyOptions.create().setIgnoreNullValue(true));
                        if (dayNightDetail.getIsFreetimeOnce() == null || dayNightDetail.getIsFreetimeOnce() >= 0) {
                            dayNightRule.setFreetime(Integer.valueOf(0));
                        } else if (Integer.valueOf(1).equals(((ParkConfig)parkConfigObjectResponse.getData()).getBillPrecision())) {
                            dayNightRule.setFreetime(Integer.valueOf(NumberUtils.toPrimitive((Integer)dayNightRule.getFreetime()) <= 0 ? 0 : dayNightRule.getFreetime() - 1));
                        }
                        dayNightRule.setDayBillmethod(dayNightDetail.getBillmethodday());
                        dayNightRule.setNightBillmethod(dayNightDetail.getBillmethodnight());
                        dayNightRule.setDayConfig(this.onceDyrationDetail(dayNightDetail.getDailyDetail()));
                        dayNightRule.setNightConfig(this.onceDyrationDetail(dayNightDetail.getNightlyDetail()));
                        chargeRuleRequest.setChargeRule((Object)dayNightRule);
                        break block22;
                    } else {
                        log.info("<\u7aef\u4e91-\u8ba1\u8d39\u89c4\u5219\u4e0b\u53d1> \u6570\u636e\u4e0d\u5b8c\u6574\uff0c\u767d\u5929\u591c\u95f4\u8ba1\u8d39\u914d\u7f6e\u67e5\u8be2\u5931\u8d25\uff0cbillCode\uff1a{}", (Object)billCode);
                        continue;
                    }
                }
                if (parkChargeconfig.getBilltype() == ParkChargeconfig.BilltypeEnum.\u4e8c\u5341\u56db\u5c0f\u65f6\u8ba1\u8d39.type) {
                    ObjectResponse charge24chargeObjectResponse = this.chargeService.get24Hours(parkChargeconfig.getBilltypecode());
                    if (ObjectResponse.isSuccess((Response)charge24chargeObjectResponse)) {
                        Charge24HourDetail hourDetail = (Charge24HourDetail)charge24chargeObjectResponse.getData();
                        ChargeRuleRequest.Charge24Rule charge24Rule = new ChargeRuleRequest.Charge24Rule();
                        BeanUtil.copyProperties((Object)hourDetail, (Object)charge24Rule, (CopyOptions)CopyOptions.create().setIgnoreNullValue(true));
                        if (hourDetail.getIsFreetimeOnce() == null || hourDetail.getIsFreetimeOnce() >= 0) {
                            charge24Rule.setFreetime(Integer.valueOf(0));
                        } else if (Integer.valueOf(1).equals(((ParkConfig)parkConfigObjectResponse.getData()).getBillPrecision())) {
                            charge24Rule.setFreetime(Integer.valueOf(NumberUtils.toPrimitive((Integer)charge24Rule.getFreetime()) <= 0 ? 0 : charge24Rule.getFreetime() - 1));
                        }
                        List charge24chargeSets = hourDetail.getChargeDetails();
                        if (CollectionUtils.isNotEmpty((Collection)charge24chargeSets)) {
                            ArrayList charge24RuleDetails = new ArrayList();
                            charge24chargeSets.forEach(charge24chargeSet -> {
                                ChargeRuleRequest.Charge24RuleDetail charge24RuleDetail = new ChargeRuleRequest.Charge24RuleDetail();
                                charge24RuleDetail.setFeespantime(charge24chargeSet.getFeespantime());
                                charge24RuleDetail.setFeespanrate(charge24chargeSet.getFeespanrate());
                                charge24RuleDetail.setFeespanrateBig(charge24chargeSet.getFeespanrateBig());
                                int recordStatus = charge24chargeSet.getFeespantime() % hourDetail.getDivisionTime() == 0 ? 1 : 0;
                                charge24RuleDetail.setRecordStatus(Integer.valueOf(recordStatus));
                                charge24RuleDetails.add(charge24RuleDetail);
                            });
                            charge24Rule.setDetails(charge24RuleDetails);
                            chargeRuleRequest.setChargeRule((Object)charge24Rule);
                            break block22;
                        } else {
                            log.info("<\u7aef\u4e91-\u8ba1\u8d39\u89c4\u5219\u4e0b\u53d1> \u6570\u636e\u4e0d\u5b8c\u6574\uff0c24\u5c0f\u65f6\u8ba1\u8d39\u914d\u7f6e\u67e5\u8be2\u5931\u8d25\uff0cbillCode\uff1a{}", (Object)billCode);
                            continue;
                        }
                    }
                    log.info("<\u7aef\u4e91-\u8ba1\u8d39\u89c4\u5219\u4e0b\u53d1> \u6570\u636e\u4e0d\u5b8c\u6574\uff0c24\u5c0f\u65f6\u8ba1\u8d39\u914d\u7f6e\u67e5\u8be2\u5931\u8d25\uff0cbillCode\uff1a{}", (Object)billCode);
                    continue;
                }
            }
            list.add(chargeRuleRequest);
        }
    }

    private void syncChannelRules(Long parkId, String parkCode) {
        if (parkCode != null) {
            this.asyncExecutor.execute(ThreadUtils.wrapTrace(() -> {
                SendRequest sendRequest = new SendRequest();
                sendRequest.setParkId(parkId);
                sendRequest.setServiceType(P2cDownCmdEnum.\u8f66\u573a\u6743\u9650\u4e0b\u53d1.getCmdType());
                sendRequest.setServiceId(parkId);
                this.channelRulesService.send(sendRequest, parkCode);
            }));
        }
    }

    private Object onceDyrationDetail(ChargeTypeDetail typeDetail) {
        if (typeDetail.getChargeType() == 1) {
            ChargeRuleRequest.ChargeOnce chargeOnceVo = new ChargeRuleRequest.ChargeOnce();
            if (typeDetail.getOnce() != null) {
                BeanUtil.copyProperties((Object)typeDetail.getOnce(), (Object)chargeOnceVo, (CopyOptions)CopyOptions.create().setIgnoreNullValue(true));
                return chargeOnceVo;
            }
            log.warn("<\u7aef\u4e91-\u8ba1\u8d39\u89c4\u5219\u4e0b\u53d1> \u6570\u636e\u4e0d\u5b8c\u6574\uff0c\u901a\u7528\u81ea\u7136\u5929\u6309\u6b21\u8ba1\u8d39\u67e5\u8be2\u5931\u8d25");
            throw new ResponseBodyException("404", "\u901a\u7528\u81ea\u7136\u5929\u6309\u6b21\u8ba1\u8d39\u67e5\u8be2\u5931\u8d25");
        }
        ChargeRuleRequest.ChargeDyration chargeDyrationVo = new ChargeRuleRequest.ChargeDyration();
        if (typeDetail.getDuration() != null) {
            BeanUtil.copyProperties((Object)typeDetail.getDuration(), (Object)chargeDyrationVo, (CopyOptions)CopyOptions.create().setIgnoreNullValue(true));
        }
        if (!CollectionUtils.isNotEmpty((Collection)typeDetail.getPeriodDurations())) {
            log.warn("<\u7aef\u4e91-\u8ba1\u8d39\u89c4\u5219\u4e0b\u53d1> \u6570\u636e\u4e0d\u5b8c\u6574\uff0c\u6309\u65f6\u957f\u8ba1\u8d39\u914d\u7f6e\u67e5\u8be2\u5931\u8d25");
            throw new ResponseBodyException("404", "\u6309\u65f6\u957f\u8ba1\u8d39\u914d\u7f6e\u67e5\u8be2\u5931\u8d25");
        }
        List stepChargeDetailList = typeDetail.getPeriodDurations().stream().map(duration -> {
            ChargeRuleRequest.StepChargeDetail stepChargeDetail = new ChargeRuleRequest.StepChargeDetail();
            BeanUtil.copyProperties((Object)duration, (Object)stepChargeDetail, (CopyOptions)CopyOptions.create().setIgnoreNullValue(true));
            return stepChargeDetail;
        }).collect(Collectors.toList());
        chargeDyrationVo.setStepChargeDetails(stepChargeDetailList);
        return chargeDyrationVo;
    }
}

