/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.down.p2c.impl;

import com.icetech.basics.constants.TextConstant;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.domain.enumeration.P2cDownCmdEnum;
import com.icetech.cloudcenter.domain.request.p2c.ChargePlatetypeRelRequest;
import com.icetech.cloudcenter.domain.response.p2c.P2cBaseResponse;
import com.icetech.common.domain.SendRequest;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.Response;
import com.icetech.park.service.AbstractConfigDownService;
import com.icetech.park.service.down.p2c.DownService;
import com.icetech.park.service.down.p2c.ResponseService;
import com.icetech.park.service.down.p2c.SendMsgServiceImpl;
import com.icetech.park.service.handle.P2cDownHandle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="p2cChargePlatetypeRelServiceImpl")
public class ChargePlatetypeRelServiceImpl
extends AbstractConfigDownService
implements DownService<List<ChargePlatetypeRelRequest>, Void>,
ResponseService<String> {
    private static final Logger log = LoggerFactory.getLogger(ChargePlatetypeRelServiceImpl.class);
    @Autowired
    private P2cDownHandle p2cDownHandle;
    @Autowired
    private SendMsgServiceImpl sendMsgService;
    @Resource
    private ParkService parkService;

    @Override
    public ObjectResponse<Void> send(SendRequest sendRequest, String parkCode) {
        try {
            ObjectResponse listObjectResponse = this.parkService.selectRegionChargeconfigByParkId(sendRequest.getParkId());
            if (!ObjectResponse.isSuccess((Response)listObjectResponse) || CollectionUtils.isEmpty((Collection)((Collection)listObjectResponse.getData()))) {
                return ObjectResponse.failed((String)"410", (String)TextConstant.getDefaultMessage((String)"1", (String)"\u533a\u57df\u8ba1\u8d39\u89c4\u5219\u4e0d\u5b58\u5728"));
            }
            List list = (List)listObjectResponse.getData();
            ArrayList retList = new ArrayList();
            list.forEach(regionChargeconfig -> {
                ChargePlatetypeRelRequest chargePlatetypeRelRequest = new ChargePlatetypeRelRequest();
                chargePlatetypeRelRequest.setPlateType(regionChargeconfig.getLicensePlateType());
                chargePlatetypeRelRequest.setBilltypecode(regionChargeconfig.getBilltypecode());
                chargePlatetypeRelRequest.setRegionId(regionChargeconfig.getRegionId());
                retList.add(chargePlatetypeRelRequest);
            });
            return this.sendMsgService.send2Park(sendRequest, parkCode, retList);
        }
        catch (Exception e) {
            log.warn(String.valueOf(e.getMessage()), (Throwable)e);
            return ObjectResponse.failed((String)"410", (String)TextConstant.getDefaultMessage((String)"1", (String)"\u533a\u57df\u8ba1\u8d39\u89c4\u5219\u4e0b\u53d1\u5931\u8d25"));
        }
    }

    @Override
    public void dealResponse(P2cBaseResponse<String> p2cBaseResponse, Long parkId, String parkCode, String deviceNo) {
        this.p2cDownHandle.dealResponse(p2cBaseResponse, parkId, P2cDownCmdEnum.\u8ba1\u8d39\u89c4\u5219\u4e0e\u8f66\u724c\u7c7b\u578b\u5bf9\u5e94\u5173\u7cfb.getCmdType());
    }
}

