/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.down.p2c.impl;

import com.icetech.basics.constants.TextConstant;
import com.icetech.basics.dao.VipTypeDao;
import com.icetech.basics.dao.park.ParkRegionDao;
import com.icetech.basics.domain.entity.device.ParkDevice;
import com.icetech.basics.domain.entity.park.ParkConfig;
import com.icetech.basics.domain.entity.park.ParkInoutdevice;
import com.icetech.basics.domain.entity.park.ParkRegion;
import com.icetech.cloudcenter.api.park.ParkDeviceService;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.api.third.ThirdInfoService;
import com.icetech.cloudcenter.domain.constants.DingZhiFuncConstants;
import com.icetech.cloudcenter.domain.enumeration.P2cDownCmdEnum;
import com.icetech.cloudcenter.domain.enumeration.P2cVersionEnum;
import com.icetech.cloudcenter.domain.request.p2c.ChannelRulesRequest;
import com.icetech.cloudcenter.domain.request.p2c.PropertyInfoRequest;
import com.icetech.cloudcenter.domain.request.p2c.PropertySetRequest;
import com.icetech.cloudcenter.domain.response.VipTypeDto;
import com.icetech.cloudcenter.domain.response.p2c.P2cBaseResponse;
import com.icetech.cloudcenter.domain.vo.BatchSendRepeatVO;
import com.icetech.cloudcenter.domain.vo.BatchSendVO;
import com.icetech.cloudcenter.domain.vo.p2c.TokenDeviceVo;
import com.icetech.common.constants.DiscountTypeEnum;
import com.icetech.common.domain.SendRequest;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.Response;
import com.icetech.common.exception.ResponseBodyException;
import com.icetech.common.thread.ThreadUtils;
import com.icetech.common.utils.AssertTools;
import com.icetech.common.utils.NumberUtils;
import com.icetech.common.utils.StringUtils;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.park.domain.vo.ParkRecoveryVo;
import com.icetech.park.handle.CacheHandle;
import com.icetech.park.service.AbstractConfigDownService;
import com.icetech.park.service.down.itc.impl.ItcPropertySetServiceImpl;
import com.icetech.park.service.down.p2c.DownService;
import com.icetech.park.service.down.p2c.ResponseService;
import com.icetech.park.service.down.p2c.SendMsgServiceImpl;
import com.icetech.park.service.down.p2c.impl.PropertyGetServiceImpl;
import com.icetech.park.service.down.p2c.impl.PropertySetServiceImpl;
import com.icetech.park.service.handle.BatchDownConfigHandle;
import com.icetech.park.service.handle.ItcCacheHandle;
import com.icetech.park.service.handle.P2cDownHandle;
import com.icetech.park.service.park.ParkRecoveryService;
import com.icetech.third.utils.RedisUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="p2cChannelRulesServiceImpl")
public class ChannelRulesServiceImpl
extends AbstractConfigDownService
implements ResponseService<String>,
DownService<ChannelRulesRequest, Void> {
    private static final Logger log = LoggerFactory.getLogger(ChannelRulesServiceImpl.class);
    @Autowired
    private P2cDownHandle p2cDownHandle;
    @Autowired
    private ParkService parkService;
    @Autowired
    private RedisUtils redisUtils;
    @Autowired
    private SendMsgServiceImpl sendMsgService;
    @Autowired
    private CacheHandle cacheHandle;
    @Autowired
    private ItcCacheHandle itcCacheHandle;
    @Autowired
    private PropertySetServiceImpl propertySetService;
    @Autowired
    private PropertyGetServiceImpl propertyGetService;
    @Autowired
    private ItcPropertySetServiceImpl itcPropertySetService;
    @Autowired
    private BatchDownConfigHandle<ChannelRulesRequest> batchDownConfigHandle;
    @Autowired
    private ParkDeviceService parkDeviceService;
    @Autowired
    private VipTypeDao vipTypeDao;
    @Autowired
    private ThreadPoolExecutor asyncExecutor;
    @Autowired
    private ParkRecoveryService parkRecoveryService;
    @Autowired
    private ParkRegionDao parkRegionDao;
    @Value(value="${web.url}")
    private String webUrl;
    @Value(value="${custom.repeatEx.enable:false}")
    private boolean customRepeatExEnable;
    @Value(value="${custom.repeatEx.parkCodes:P}")
    private String customRepeatExParkCodes;
    @Autowired
    private ThirdInfoService thirdInfoService;

    public boolean send2Channel(String parkCode, Integer serviceType, ParkConfig parkConfig, ParkInoutdevice parkInoutdevice) {
        ChannelRulesRequest channelRulesRequest = this.getChannelRulesRequest(parkConfig, parkInoutdevice, parkCode);
        SendRequest sendRequest = new SendRequest();
        sendRequest.setParkId(parkConfig.getParkId());
        sendRequest.setServiceType(serviceType);
        ObjectResponse objectResponse = this.sendMsgService.send2Channel(sendRequest, parkCode, parkInoutdevice.getInandoutCode(), channelRulesRequest);
        return ObjectResponse.isSuccess(objectResponse);
    }

    public boolean send(String parkCode, String serialNumber) {
        ObjectResponse byParkCode = this.parkService.findByParkCode(parkCode);
        ObjectResponse.notError((Response)byParkCode);
        Park data = (Park)byParkCode.getData();
        Long parkId = data.getId();
        ParkConfig parkConfig = this.getParkConfig(parkId);
        ObjectResponse channelInfoResponse = this.parkService.getChannelInfo(parkId, serialNumber);
        if (ObjectResponse.isSuccess((Response)channelInfoResponse)) {
            return this.send2Device(parkCode, P2cDownCmdEnum.\u901a\u9053\u6743\u9650\u4e0b\u53d1.getCmdType(), parkConfig, (ParkInoutdevice)channelInfoResponse.getData(), serialNumber);
        }
        return false;
    }

    private boolean send2Device(String parkCode, Integer serviceType, ParkConfig parkConfig, ParkInoutdevice parkInoutdevice, String deviceNo) {
        ChannelRulesRequest channelRulesRequest = this.getChannelRulesRequest(parkConfig, parkInoutdevice, parkCode);
        SendRequest sendRequest = new SendRequest();
        sendRequest.setParkId(parkConfig.getParkId());
        sendRequest.setServiceType(serviceType);
        ObjectResponse objectResponse = this.sendMsgService.send2Devices(deviceNo, sendRequest, parkCode, channelRulesRequest);
        return ObjectResponse.isSuccess(objectResponse);
    }

    @Override
    public ObjectResponse<Void> send(SendRequest sendRequest, String parkCode) {
        ParkConfig parkConfig = this.getParkConfig(sendRequest.getParkId());
        if (sendRequest.getServiceType().equals(P2cDownCmdEnum.\u901a\u9053\u6743\u9650\u4e0b\u53d1.getCmdType())) {
            ChannelRulesRequest channelRulesRequest;
            ObjectResponse inoutDeviceResponse = this.parkService.getInoutDeviceById(sendRequest.getServiceId());
            if (!ObjectResponse.isSuccess((Response)inoutDeviceResponse)) {
                return ObjectResponse.failed((String)"410", (String)TextConstant.getDefaultMessage((String)"1", (String)"\u51fa\u5165\u53e3\u901a\u9053\u672a\u627e\u5230"));
            }
            ParkInoutdevice parkInoutdevice = (ParkInoutdevice)inoutDeviceResponse.getData();
            try {
                channelRulesRequest = this.getChannelRulesRequest(parkConfig, parkInoutdevice, parkCode);
            }
            catch (ResponseBodyException e) {
                return ObjectResponse.failed((String)"410", (String)TextConstant.getDefaultMessage((String)"1", (String)"\u901a\u9053\u8bbe\u5907\u672a\u627e\u5230"));
            }
            this.asyncDownChannel(parkCode, parkInoutdevice, parkConfig);
            return this.sendMsgService.send2Channel(sendRequest, parkCode, parkInoutdevice.getInandoutCode(), channelRulesRequest);
        }
        ObjectResponse listResponse = this.parkService.getAllChannel(parkConfig.getParkId());
        if (!ObjectResponse.isSuccess((Response)listResponse)) {
            return ObjectResponse.failed((String)"410", (String)TextConstant.getDefaultMessage((String)"1", (String)"\u51fa\u5165\u53e3\u901a\u9053\u672a\u627e\u5230"));
        }
        List data = (List)listResponse.getData();
        boolean success = true;
        for (int i = 0; data != null && i < data.size(); ++i) {
            ChannelRulesRequest channelRulesRequest;
            ParkInoutdevice parkInoutdevice = (ParkInoutdevice)data.get(i);
            try {
                channelRulesRequest = this.getChannelRulesRequest(parkConfig, parkInoutdevice, parkCode);
            }
            catch (ResponseBodyException e) {
                return ObjectResponse.failed((String)"410", (String)TextConstant.getDefaultMessage((String)"1", (String)"\u901a\u9053\u8bbe\u5907\u672a\u627e\u5230"));
            }
            sendRequest.setTaskId(null);
            ObjectResponse objectResponse = this.sendMsgService.send2Channel(sendRequest, parkCode, parkInoutdevice.getInandoutCode(), channelRulesRequest);
            success = success && ObjectResponse.isSuccess(objectResponse);
        }
        this.asyncDownPark(parkCode, data, parkConfig);
        if (!success) {
            return ObjectResponse.failed((String)"410", (String)"\u8f66\u573a\u6743\u9650\u4fee\u6539\u4e0b\u53d1\u5931\u8d25");
        }
        return ObjectResponse.success();
    }

    private void asyncDownPark(String parkCode, List<ParkInoutdevice> parkInoutdevices, ParkConfig parkConfig) {
        for (int i = 0; parkInoutdevices != null && i < parkInoutdevices.size(); ++i) {
            ParkInoutdevice parkInoutdevice = parkInoutdevices.get(i);
            this.asyncExecutor.execute(ThreadUtils.wrapTrace(() -> {
                String serialNumber = this.cacheHandle.getSerialNumber(parkCode, parkInoutdevice.getInandoutCode());
                if (serialNumber == null) {
                    return;
                }
                TokenDeviceVo deviceInfo = this.cacheHandle.getDeviceInfo(serialNumber);
                if (deviceInfo == null) {
                    return;
                }
                if (P2cVersionEnum.getIndex((String)deviceInfo.getVersion()) < P2cVersionEnum.\u7248\u672c12.getIndex()) {
                    return;
                }
                PropertySetRequest propertySetRequest = new PropertySetRequest();
                propertySetRequest.setRetentionAlarm(Integer.valueOf(1));
                propertySetRequest.setRetentionAlarmMethod(Integer.valueOf(NumberUtils.toPrimitive((Integer)parkConfig.getRetentionAlarmMethod(), (int)1)));
                propertySetRequest.setRetentionTimeThreshold(Integer.valueOf(NumberUtils.toPrimitive((Integer)parkConfig.getCarenexTimelong()) * 60 < 30 ? 60 : parkConfig.getCarenexTimelong() * 60));
                propertySetRequest.setRetentionIntervalTime(Integer.valueOf(NumberUtils.toPrimitive((Integer)parkConfig.getRetentionIntervalTime(), (int)600)));
                if (P2cVersionEnum.getIndex((String)deviceInfo.getVersion()) >= P2cVersionEnum.\u7248\u672c18.getIndex()) {
                    List<ParkRecoveryVo> recoverys = this.parkRecoveryService.getOpenParkRecoveryByParkIds(Collections.singletonList(deviceInfo.getParkId()));
                    if (CollectionUtils.isNotEmpty(recoverys)) {
                        propertySetRequest.setEnableShamPlate(parkConfig.getEnableShamPlate());
                        propertySetRequest.setShamPlateMethod(parkConfig.getShamPlateMethod());
                    } else {
                        ObjectResponse<PropertyInfoRequest> response = this.propertyGetService.send(serialNumber, (String)null);
                        if (ObjectResponse.isSuccess(response)) {
                            PropertyInfoRequest data = (PropertyInfoRequest)response.getData();
                            propertySetRequest.setEnableShamPlate(data.getEnableShamPlate());
                            propertySetRequest.setShamPlateMethod(data.getShamPlateMethod());
                        }
                    }
                }
                this.propertySetService.send(propertySetRequest, serialNumber);
                String itcSn = this.itcCacheHandle.getSerialNumber(parkCode, parkInoutdevice.getInandoutCode());
                if (itcSn == null) {
                    return;
                }
                TokenDeviceVo itcDev = this.itcCacheHandle.getDeviceInfo(itcSn);
                if (itcDev == null) {
                    return;
                }
                if (itcDev.getInandoutType().equals(parkInoutdevice.getInandoutType())) {
                    return;
                }
                if (itcDev.getRegionId().equals(parkInoutdevice.getRegionId())) {
                    return;
                }
                itcDev.setInandoutType(parkInoutdevice.getInandoutType());
                itcDev.setInandoutName(parkInoutdevice.getInandoutName());
                itcDev.setRegionId(parkInoutdevice.getRegionId());
                this.itcCacheHandle.updateDeviceInfo(itcSn, itcDev);
                com.icetech.cloudcenter.domain.request.itc.PropertySetRequest itcPsq = new com.icetech.cloudcenter.domain.request.itc.PropertySetRequest();
                itcPsq.setEnexType(parkInoutdevice.getInandoutType());
                if (parkConfig.getCarenexTimelong() != null) {
                    itcPsq.setRetentionAlarm(Integer.valueOf(parkConfig.getCarenexTimelong() != null ? 1 : 0));
                    itcPsq.setRetentionTimeThreshold(Integer.valueOf(NumberUtils.toPrimitive((Integer)parkConfig.getCarenexTimelong()) * 60 < 30 ? 60 : parkConfig.getCarenexTimelong() * 60));
                }
                this.itcPropertySetService.send(itcPsq, itcSn);
            }));
        }
    }

    private void asyncDownChannel(String parkCode, ParkInoutdevice parkInoutdevice, ParkConfig parkConfig) {
        this.asyncExecutor.execute(ThreadUtils.wrapTrace(() -> {
            String itcSn;
            String serialNumber = this.cacheHandle.getSerialNumber(parkCode, parkInoutdevice.getInandoutCode());
            if (serialNumber == null) {
                return;
            }
            TokenDeviceVo deviceInfo = this.cacheHandle.getDeviceInfo(serialNumber);
            if (deviceInfo == null) {
                return;
            }
            if (P2cVersionEnum.getIndex((String)deviceInfo.getVersion()) < P2cVersionEnum.\u7248\u672c8.getIndex()) {
                return;
            }
            PropertySetRequest propertySetRequest = new PropertySetRequest();
            Integer inandoutType = deviceInfo.getInandoutType();
            if (!(parkInoutdevice.getInandoutType().equals(inandoutType) && parkInoutdevice.getInandoutName().equals(deviceInfo.getInandoutName()) && parkInoutdevice.getRegionId().equals(deviceInfo.getRegionId()))) {
                deviceInfo.setInandoutType(parkInoutdevice.getInandoutType());
                deviceInfo.setInandoutName(parkInoutdevice.getInandoutName());
                deviceInfo.setRegionId(parkInoutdevice.getRegionId());
                this.cacheHandle.updateDeviceInfo(serialNumber, deviceInfo);
                propertySetRequest.setEnexType(parkInoutdevice.getInandoutType());
                this.propertySetService.send(propertySetRequest, serialNumber);
            }
            if ((itcSn = this.itcCacheHandle.getSerialNumber(parkCode, parkInoutdevice.getInandoutCode())) == null) {
                return;
            }
            TokenDeviceVo itcDev = this.itcCacheHandle.getDeviceInfo(itcSn);
            if (itcDev == null) {
                return;
            }
            if (itcDev.getInandoutType().equals(parkInoutdevice.getInandoutType())) {
                return;
            }
            if (itcDev.getRegionId().equals(parkInoutdevice.getRegionId())) {
                return;
            }
            itcDev.setInandoutType(parkInoutdevice.getInandoutType());
            itcDev.setInandoutName(parkInoutdevice.getInandoutName());
            itcDev.setRegionId(parkInoutdevice.getRegionId());
            this.itcCacheHandle.updateDeviceInfo(itcSn, itcDev);
            com.icetech.cloudcenter.domain.request.itc.PropertySetRequest itcPsq = new com.icetech.cloudcenter.domain.request.itc.PropertySetRequest();
            itcPsq.setEnexType(parkInoutdevice.getInandoutType());
            if (parkConfig.getCarenexTimelong() != null) {
                itcPsq.setRetentionAlarm(Integer.valueOf(parkConfig.getCarenexTimelong() != null ? 1 : 0));
                itcPsq.setRetentionTimeThreshold(Integer.valueOf(NumberUtils.toPrimitive((Integer)parkConfig.getCarenexTimelong()) * 60 < 30 ? 60 : parkConfig.getCarenexTimelong() * 60));
            }
            this.itcPropertySetService.send(itcPsq, itcSn);
        }));
    }

    @Override
    public ObjectResponse<Void> batchSend(BatchSendVO vo) {
        String parkCode = vo.getParkCode();
        Long parkId = vo.getParkId();
        List subTaskInfos = vo.getSubTaskInfos();
        Long[] channelIds = (Long[])subTaskInfos.stream().map(BatchSendVO.SubTaskInfo::getChannelId).distinct().toArray(Long[]::new);
        ObjectResponse listObjectResponse = this.parkService.getChannelsByIds(channelIds);
        List inoutdeviceList = (List)listObjectResponse.getData();
        Map<Long, List<ParkInoutdevice>> listMap = inoutdeviceList.stream().collect(Collectors.groupingBy(ParkInoutdevice::getId));
        for (BatchSendVO.SubTaskInfo subTaskInfo : subTaskInfos) {
            ChannelRulesRequest channelRulesRequest;
            BatchSendVO newVO = new BatchSendVO();
            newVO.setParkCode(parkCode);
            newVO.setParkId(parkId);
            newVO.setTaskId(vo.getTaskId());
            ArrayList<BatchSendVO.SubTaskInfo> list = new ArrayList<BatchSendVO.SubTaskInfo>();
            list.add(subTaskInfo);
            newVO.setSubTaskInfos(list);
            ParkInoutdevice parkInoutdevice = listMap.get(subTaskInfo.getChannelId()).get(0);
            ParkConfig parkConfig = this.getParkConfig(parkId);
            try {
                channelRulesRequest = this.getChannelRulesRequest(parkConfig, parkInoutdevice, parkCode);
            }
            catch (ResponseBodyException e) {
                return ObjectResponse.failed((String)"410", (String)TextConstant.getDefaultMessage((String)"1", (String)"\u901a\u9053\u8bbe\u5907\u672a\u627e\u5230"));
            }
            this.batchDownConfigHandle.batchDown(newVO, channelRulesRequest, P2cDownCmdEnum.\u8f66\u573a\u6743\u9650\u4e0b\u53d1.getCmdType());
        }
        return ObjectResponse.success();
    }

    @Override
    public ObjectResponse<Void> batchSendRepeat(BatchSendRepeatVO vo) {
        ChannelRulesRequest channelRulesRequest;
        log.info("[\u901a\u9053\u6743\u9650\u6279\u91cf\u4e0b\u53d1] \u53c2\u6570[{}]", (Object)vo);
        String parkCode = vo.getParkCode();
        Long parkId = vo.getParkId();
        Long channelId = vo.getChannelId();
        ObjectResponse parkInoutdeviceObjectResponse = this.parkService.getInoutDeviceById(channelId);
        ParkInoutdevice parkInoutdevice = (ParkInoutdevice)parkInoutdeviceObjectResponse.getData();
        ParkConfig parkConfig = this.getParkConfig(parkId);
        try {
            channelRulesRequest = this.getChannelRulesRequest(parkConfig, parkInoutdevice, parkCode);
        }
        catch (ResponseBodyException e) {
            return ObjectResponse.failed((String)"410", (String)TextConstant.getDefaultMessage((String)"1", (String)"\u901a\u9053\u8bbe\u5907\u672a\u627e\u5230"));
        }
        this.batchDownConfigHandle.repeatBatch(vo, channelRulesRequest, P2cDownCmdEnum.\u8f66\u573a\u6743\u9650\u4e0b\u53d1.getCmdType());
        return ObjectResponse.success();
    }

    private ParkConfig getParkConfig(Long parkId) {
        ObjectResponse parkConfigObjectResponse = this.parkService.getParkConfig(parkId);
        ObjectResponse.notError((Response)parkConfigObjectResponse);
        return (ParkConfig)parkConfigObjectResponse.getData();
    }

    private ChannelRulesRequest getChannelRulesRequest(ParkConfig parkConfig, ParkInoutdevice parkInoutdevice, String parkCode) {
        int expireMcDays;
        ObjectResponse deviceByChannel = this.parkDeviceService.getDeviceByChannel(parkConfig.getParkId(), parkInoutdevice.getInandoutCode(), Integer.valueOf(1));
        ObjectResponse.notError((Response)deviceByChannel);
        ParkDevice parkDevice = (ParkDevice)((List)deviceByChannel.getData()).get(0);
        ChannelRulesRequest channelRulesRequest = new ChannelRulesRequest();
        channelRulesRequest.setRunningMode(Integer.valueOf(1));
        channelRulesRequest.setIssupTempcar(parkInoutdevice.getIsAllowTempcarrun());
        ParkRegion parkRegion = (ParkRegion)this.parkRegionDao.selectById((Serializable)parkInoutdevice.getRegionId());
        AssertTools.notNull((Object)parkRegion, (String)"404", (String)"\u901a\u9053\u6240\u5c5e\u533a\u57df\u4fe1\u606f\u672a\u627e\u5230");
        if (parkRegion.getOilCarFullFlag() == 1 || parkRegion.getChargeCarFullFlag() == 1) {
            channelRulesRequest.setRunningMode(Integer.valueOf(2));
        }
        if (DingZhiFuncConstants.DZ001_PARKS.contains(parkCode)) {
            channelRulesRequest.setIssupTempcar(Integer.valueOf(0));
        } else if (P2cVersionEnum.getIndex((String)parkDevice.getProtocolVer()) < P2cVersionEnum.\u7248\u672c9.getIndex()) {
            Integer integer;
            if (P2cVersionEnum.getIndex((String)parkDevice.getProtocolVer()) < P2cVersionEnum.\u7248\u672c5.getIndex() && NumberUtils.toPrimitive((Integer)parkConfig.getFilterTime()) > 0) {
                channelRulesRequest.setIssupTempcar(Integer.valueOf(0));
            }
            if (this.redisUtils.exists("PARK_FULL_" + parkCode + "_" + parkRegion.getId())) {
                channelRulesRequest.setIssupTempcar(Integer.valueOf(0));
            }
            if (Objects.nonNull(parkInoutdevice.getIsAllowBluerun()) && Objects.nonNull(parkInoutdevice.getIsAllowNewenergycarrun()) && Objects.nonNull(parkInoutdevice.getIsAllowTempcarrun()) && 1 == parkInoutdevice.getIsAllowTempcarrun() && (0 == parkInoutdevice.getIsAllowNewenergycarrun() || 0 == parkInoutdevice.getIsAllowBluerun())) {
                channelRulesRequest.setIssupTempcar(Integer.valueOf(0));
            }
            if (Objects.nonNull(parkInoutdevice.getIsAllowBluerun()) && Objects.nonNull(parkInoutdevice.getIsAllowNewenergycarrun()) && Objects.nonNull(parkInoutdevice.getIsAllowYellowcarrun()) && Objects.nonNull(parkInoutdevice.getIsAllowTempcarrun()) && Objects.nonNull(parkInoutdevice.getIsAllowNocardrun()) && 1 == parkInoutdevice.getIsAllowTempcarrun() && 0 == parkInoutdevice.getIsAllowYellowcarrun() && 0 == parkInoutdevice.getIsAllowNocardrun() && (1 == parkInoutdevice.getIsAllowBluerun() || 1 == parkInoutdevice.getIsAllowNewenergycarrun())) {
                channelRulesRequest.setIssupTempcar(Integer.valueOf(0));
            }
            if (Objects.nonNull(parkInoutdevice.getIsAllowVipCar()) && 0 == parkInoutdevice.getIsAllowVipCar()) {
                channelRulesRequest.setIssupTempcar(Integer.valueOf(0));
            }
            if (!StringUtils.isEmpty((CharSequence)parkInoutdevice.getVipCarTypeId())) {
                channelRulesRequest.setIssupTempcar(Integer.valueOf(0));
            }
            if (Objects.nonNull(parkInoutdevice.getIsAllowMonthCar()) && 1 == parkInoutdevice.getIsAllowMonthCar() && Objects.nonNull(parkInoutdevice.getIsAllowAbcar()) && 0 == parkInoutdevice.getIsAllowAbcar()) {
                channelRulesRequest.setIssupTempcar(Integer.valueOf(0));
            }
            if ((integer = Integer.valueOf(1)).equals(parkRegion.getIsFullForbidenter()) || integer.equals(parkRegion.getIsFullForbidReservEnter()) || integer.equals(parkRegion.getIsFullForbidStoreEnter())) {
                channelRulesRequest.setIssupTempcar(Integer.valueOf(0));
            }
        }
        boolean enableNotPay = false;
        if (!Integer.valueOf(0).equals(channelRulesRequest.getIssupTempcar())) {
            int enterpayType = NumberUtils.toPrimitive((Integer)parkConfig.getEnterpayType());
            int exitpayType = NumberUtils.toPrimitive((Integer)parkConfig.getExitpayType());
            if (Integer.valueOf(1).equals(parkInoutdevice.getInandoutType()) && enterpayType == 1) {
                channelRulesRequest.setIssupTempcar(Integer.valueOf(0));
                enableNotPay = true;
            }
            if (Integer.valueOf(2).equals(parkInoutdevice.getInandoutType()) && exitpayType == 1) {
                channelRulesRequest.setIssupTempcar(Integer.valueOf(0));
                enableNotPay = true;
            }
        }
        channelRulesRequest.setIsAllowNocardrun(parkInoutdevice.getIsAllowNocardrun());
        int isOpenVaguetype = NumberUtils.toPrimitive((Integer)parkInoutdevice.getIsOpenVaguetype());
        channelRulesRequest.setVagueInfo(Integer.valueOf(isOpenVaguetype == 1 ? NumberUtils.toPrimitive((Integer)parkInoutdevice.getVaguetype()) + 1 : 0));
        channelRulesRequest.setFreetime(Integer.valueOf(0));
        channelRulesRequest.setIsfreeAfterpay(parkConfig.getIsfreeAfterpay(Integer.valueOf(15)));
        channelRulesRequest.setIsfreeSpecialcar(parkConfig.getIsfreeSpecialcar());
        channelRulesRequest.setIssupAbmanage(Integer.valueOf(NumberUtils.toPrimitive((Integer)parkConfig.getIssupAbmanage())));
        channelRulesRequest.setIsupimage(parkConfig.getIsupimage());
        channelRulesRequest.setIsAllowYellowcarrun(parkInoutdevice.getIsAllowYellowcarrun());
        channelRulesRequest.setCacheExpires(parkInoutdevice.getCacheExpires());
        channelRulesRequest.setOvertimeBillType(parkConfig.getOvertimeBillType());
        channelRulesRequest.setIsnotgetsmallchange(parkConfig.getIsnotgetsmallchange());
        channelRulesRequest.setFreetimeStatus(parkConfig.getFreetimeStatus());
        channelRulesRequest.setIsFilltime(parkConfig.getIsFilltime());
        channelRulesRequest.setIsallowfreetmonce(Integer.valueOf(parkConfig.getIsallowfreetmonce() == null ? 1 : parkConfig.getIsallowfreetmonce()));
        channelRulesRequest.setChargeVersionNum(Integer.valueOf(parkConfig.getChargeVersionNum() == null ? 0 : parkConfig.getChargeVersionNum()));
        channelRulesRequest.setBillPrecision(parkConfig.getBillPrecision());
        channelRulesRequest.setIsfixedfees(parkConfig.getIsfixedfees());
        channelRulesRequest.setFixedfeevalue(parkConfig.getFixedfeevalue() != null ? Integer.valueOf(parkConfig.getFixedfeevalue() * 100) : null);
        channelRulesRequest.setIsSpecialPark(Integer.valueOf(0));
        if (NumberUtils.toPrimitive((Integer)parkConfig.getFilterTime()) > 0) {
            if (NumberUtils.toPrimitive((Integer)parkConfig.getPlateFilterType(), (int)1) == 1) {
                channelRulesRequest.setIsSpecialPark(Integer.valueOf(1));
                channelRulesRequest.setEnexMinTime(parkConfig.getFilterTime());
                channelRulesRequest.setExenMinTime(parkConfig.getFilterTime());
            } else {
                channelRulesRequest.setIssupTempcar(Integer.valueOf(0));
            }
        }
        channelRulesRequest.setIsAllowBlackCar(parkInoutdevice.getIsAllowBackCar());
        channelRulesRequest.setIsAllowBluerun(parkInoutdevice.getIsAllowBluerun());
        channelRulesRequest.setIsAllowNewenergycarrun(parkInoutdevice.getIsAllowNewenergycarrun());
        channelRulesRequest.setIsAllowVisitCar(parkInoutdevice.getIsAllowVisitCar());
        channelRulesRequest.setIsAllowMonthCar(parkInoutdevice.getIsAllowMonthCar());
        int overTimeDayToCamera = NumberUtils.toPrimitive((Integer)parkConfig.getIsAllowOvertimeCar()) == 1 ? NumberUtils.toPrimitive((Integer)parkConfig.getOverTimeDay(), (int)999999999) : 0;
        int n = expireMcDays = NumberUtils.toPrimitive((Integer)parkConfig.getIsExpireMc()) == 1 ? NumberUtils.toPrimitive((Integer)parkConfig.getExpireMcDays()) : 0;
        if (Integer.valueOf(1).equals(parkConfig.getIsAllowOvertimeCar()) || Integer.valueOf(1).equals(parkConfig.getIsExpireMc())) {
            channelRulesRequest.setOverTimeDay(Integer.valueOf(Math.min(overTimeDayToCamera, expireMcDays)));
        } else {
            channelRulesRequest.setOverTimeDay(Integer.valueOf(0));
        }
        if (this.customRepeatExEnable && this.customRepeatExParkCodes.contains(parkCode)) {
            channelRulesRequest.setIssupTempcar(Integer.valueOf(0));
            channelRulesRequest.setFreetime(Integer.valueOf(0));
        }
        channelRulesRequest.setIsExpireMc(parkConfig.getIsExpireMc());
        channelRulesRequest.setIsAllowAbcar(parkInoutdevice.getIsAllowAbcar());
        channelRulesRequest.setIsAllowStoredCar(parkInoutdevice.getIsAllowStoredCar());
        channelRulesRequest.setIsAllowVipCar(parkInoutdevice.getIsAllowVipCar());
        channelRulesRequest.setVipCarTypeId(parkInoutdevice.getVipCarTypeId());
        channelRulesRequest.setFixedFeeValueBig(parkConfig.getFixedFeeValueBig() != null ? Integer.valueOf(parkConfig.getFixedFeeValueBig() * 100) : null);
        channelRulesRequest.setFullEmptynum(parkRegion.getFullEmptynum());
        channelRulesRequest.setIsFullForbidenter(Integer.valueOf(NumberUtils.toPrimitive((Integer)parkRegion.getIsFullForbidenter(), (int)0) == 0 ? 1 : 0));
        channelRulesRequest.setIsFullForbidmonthenter(Integer.valueOf(NumberUtils.toPrimitive((Integer)parkRegion.getIsFullForbidMonthEnter(), (int)0) == 0 ? 1 : 0));
        channelRulesRequest.setIsFullForbidreserventer(Integer.valueOf(NumberUtils.toPrimitive((Integer)parkRegion.getIsFullForbidReservEnter(), (int)0) == 0 ? 1 : 0));
        channelRulesRequest.setIsFullForbidstoreenter(Integer.valueOf(NumberUtils.toPrimitive((Integer)parkRegion.getIsFullForbidStoreEnter(), (int)0) == 0 ? 1 : 0));
        channelRulesRequest.setIsFullForbidblackenter(Integer.valueOf(NumberUtils.toPrimitive((Integer)parkRegion.getIsFullForbidblackenter(), (int)0) == 0 ? 1 : 0));
        channelRulesRequest.setIsFullForbidvipenter(Integer.valueOf(NumberUtils.toPrimitive((Integer)parkRegion.getIsFullForbidVIPEnter(), (int)0) == 0 ? 1 : 0));
        channelRulesRequest.setFullVipCarTypeId(parkRegion.getVipCarTypeId());
        if (parkConfig.getIsCardcount() != null) {
            channelRulesRequest.setIsCardcount(Integer.valueOf(parkConfig.getIsCardcount() == 2 ? 0 : 1));
        } else {
            channelRulesRequest.setIsCardcount(Integer.valueOf(0));
        }
        if (Integer.valueOf(0).equals(parkConfig.getFreeCarReenter())) {
            channelRulesRequest.setIsAllowMonthCar(Integer.valueOf(0));
            if (Integer.valueOf(1).equals(channelRulesRequest.getIsAllowVipCar()) && StringUtils.isNotBlank((CharSequence)channelRulesRequest.getVipCarTypeId())) {
                String[] strings = channelRulesRequest.getVipCarTypeId().split(",");
                Object[] newArray = (String[])Arrays.stream(strings).filter(org.apache.commons.lang3.StringUtils::isNotBlank).filter(id -> {
                    VipTypeDto vipTypeDto = this.vipTypeDao.selectById(Integer.valueOf(id));
                    return vipTypeDto != null && !DiscountTypeEnum.\u5168\u514d.getType().equals(vipTypeDto.getType());
                }).toArray(String[]::new);
                channelRulesRequest.setVipCarTypeId(StringUtils.joinWith((String)",", (Object[])newArray));
            }
        }
        String qrCodeUr = NumberUtils.toPrimitive((Integer)parkInoutdevice.getInandoutType()) == 1 ? this.webUrl + "/noplate/enter/index?parkCode=" + parkCode + "&channelId=" + parkInoutdevice.getInandoutCode() : this.webUrl + "/h5/pay/exit?parkCode=" + parkCode + "&channelId=" + parkInoutdevice.getInandoutCode();
        channelRulesRequest.setShowQrCodeUrl(qrCodeUr);
        channelRulesRequest.setMoneyunitType(parkConfig.getMoneyunitType());
        ObjectResponse objectResponse = this.parkService.findByParkId(parkConfig.getParkId());
        ObjectResponse.notError((Response)objectResponse, (String)"\u8f66\u573a\u4e0d\u5b58\u5728");
        Park park = (Park)objectResponse.getData();
        if (Integer.valueOf(1).equals(park.getIsInterior())) {
            channelRulesRequest.setRegionId(parkInoutdevice.getRegionId());
            channelRulesRequest.setNestType(parkRegion.getPositionType());
            channelRulesRequest.setRegionName(parkRegion.getRegionName());
            channelRulesRequest.setRegionType(Integer.valueOf(Long.valueOf(0L).equals(parkRegion.getFatherRelationId()) ? 1 : 2));
            channelRulesRequest.setIsMaster(parkInoutdevice.getIsMaster());
            channelRulesRequest.setSwitchFreeTime(park.getSwitchFeeTime());
        } else {
            channelRulesRequest.setNestType(Integer.valueOf(0));
        }
        return channelRulesRequest;
    }

    @Override
    public void dealResponse(P2cBaseResponse<String> p2cBaseResponse, Long parkId, String parkCode, String deviceNo) {
        Integer subTaskId = (Integer)this.redisUtils.get("batchdown:msgid:" + p2cBaseResponse.getMessageId(), Integer.class);
        if (subTaskId != null) {
            this.batchDownConfigHandle.dealBatchResponse(p2cBaseResponse, subTaskId, parkId);
        }
        this.p2cDownHandle.dealResponse(p2cBaseResponse, parkId, P2cDownCmdEnum.\u901a\u9053\u6743\u9650\u4e0b\u53d1.getCmdType());
    }
}

