/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.down.p2c.impl;

import cn.hutool.core.thread.ThreadUtil;
import cn.hutool.core.util.StrUtil;
import com.icetech.basics.api.BlacklistService;
import com.icetech.basics.constants.TextConstant;
import com.icetech.basics.domain.entity.Blacklist;
import com.icetech.cloudcenter.domain.enumeration.P2cDownCmdEnum;
import com.icetech.cloudcenter.domain.request.p2c.BlacklistRequest;
import com.icetech.cloudcenter.domain.request.p2c.ClearListRequest;
import com.icetech.cloudcenter.domain.request.p2c.QueryListRequest;
import com.icetech.cloudcenter.domain.response.p2c.P2cBaseResponse;
import com.icetech.cloudcenter.domain.vo.BatchSendRepeatVO;
import com.icetech.cloudcenter.domain.vo.BatchSendVO;
import com.icetech.common.domain.SendRequest;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.Response;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.down.Message;
import com.icetech.park.service.down.p2c.DownService;
import com.icetech.park.service.down.p2c.ResponseService;
import com.icetech.park.service.down.p2c.SendMsgServiceImpl;
import com.icetech.park.service.handle.BatchDownBizHandle;
import com.icetech.park.service.handle.P2cDownHandle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="p2cBlacklistServiceImpl")
public class BlacklistServiceImpl
extends AbstractService
implements ResponseService<String>,
DownService<List<BlacklistRequest>, Void> {
    private static final Logger log = LoggerFactory.getLogger(BlacklistServiceImpl.class);
    @Autowired
    private P2cDownHandle p2cDownHandle;
    @Autowired
    private BlacklistService blacklistService;
    @Autowired
    private SendMsgServiceImpl sendMsgService;
    @Autowired
    private BatchDownBizHandle<BlacklistRequest> batchDownBizHandle;
    private static String[] HEADERS = new String[]{"id", "blackId", "plateNum"};

    @Override
    public ObjectResponse<Void> send(SendRequest sendRequest, String parkCode) {
        ObjectResponse blacklistResponse = this.blacklistService.getById(sendRequest.getServiceId());
        if (!ObjectResponse.isSuccess((Response)blacklistResponse)) {
            return ObjectResponse.failed((String)"410", (String)TextConstant.getDefaultMessage((String)"1", (String)"\u9ed1\u540d\u5355\u6570\u636e\u4e0d\u5b58\u5728"));
        }
        ObjectResponse.notError((Response)blacklistResponse);
        Blacklist blacklist = (Blacklist)blacklistResponse.getData();
        if (blacklist.getType() == 3 || blacklist.getStatus() == 1) {
            ClearListRequest clearListRequest = new ClearListRequest();
            clearListRequest.setDataType(Integer.valueOf(QueryListRequest.DataType.\u9ed1\u540d\u5355.getVal()));
            clearListRequest.setId(blacklist.getId());
            sendRequest.setReqServiceType(P2cDownCmdEnum.\u540d\u5355\u6570\u636e\u6e05\u7a7a.getCmdType());
            return this.sendMsgService.send2Park(sendRequest, parkCode, clearListRequest);
        }
        BlacklistRequest blacklistRequest = new BlacklistRequest();
        blacklistRequest.setBlackId(blacklist.getId());
        blacklistRequest.setPlateNum(blacklist.getPlate());
        ArrayList<BlacklistRequest> list = new ArrayList<BlacklistRequest>();
        list.add(blacklistRequest);
        return this.sendMsgService.send2Park(sendRequest, parkCode, list);
    }

    private ObjectResponse<Void> send(Long parkId, String parkCode, List<BlacklistRequest> blacklist) {
        Message<List<BlacklistRequest>> message = new Message<List<BlacklistRequest>>(parkId, P2cDownCmdEnum.\u9ed1\u540d\u5355\u4e0b\u53d1.getCmdType(), blacklist);
        Object[] messageIdArr = this.p2cDownHandle.send2Park(parkCode, message);
        if (ArrayUtils.isEmpty((Object[])messageIdArr)) {
            return ObjectResponse.failed((String)"3003");
        }
        return ObjectResponse.success();
    }

    @Override
    public void dealResponse(P2cBaseResponse<String> p2cBaseResponse, Long parkId, String parkCode, String deviceNo) {
        this.p2cDownHandle.dealResponse(p2cBaseResponse, parkId, P2cDownCmdEnum.\u9ed1\u540d\u5355\u4e0b\u53d1.getCmdType());
    }

    @Override
    public ObjectResponse<Void> batchSend(BatchSendVO vo) {
        Long parkId = vo.getParkId();
        String parkCode = vo.getParkCode();
        ObjectResponse blacklistRet = this.blacklistService.getValidByParkId(parkId);
        if (blacklistRet.getCode().equals("404")) {
            log.info("<\u6279\u91cf\u9ed1\u540d\u5355\u4e0b\u53d1> \u6ca1\u6709\u7b26\u5408\u6bd4\u5bf9\u6761\u4ef6\u7684\u9ed1\u540d\u5355\u8f66\uff0c\u5ffd\u7565\u4e0b\u53d1\uff0c\u8f66\u573a\u7f16\u53f7\uff1a{}", (Object)parkCode);
            return ObjectResponse.success();
        }
        if (ObjectResponse.isSuccess((Response)blacklistRet)) {
            List blacklists = (List)blacklistRet.getData();
            ArrayList<BlacklistRequest> list = new ArrayList<BlacklistRequest>();
            for (Blacklist blacklist : blacklists) {
                BlacklistRequest blacklistRequest = new BlacklistRequest();
                blacklistRequest.setBlackId(blacklist.getId());
                blacklistRequest.setPlateNum(blacklist.getPlate());
                list.add(blacklistRequest);
            }
            List<Object> idList = list.stream().map(BlacklistRequest::getBlackId).collect(Collectors.toList());
            this.batchDownBizHandle.batchDown(vo, list, idList, HEADERS, P2cDownCmdEnum.\u9ed1\u540d\u5355\u4e0b\u53d1.getCmdType());
            return ObjectResponse.success();
        }
        return ObjectResponse.failed((String)blacklistRet.getCode(), (String)blacklistRet.getMsg());
    }

    @Override
    public ObjectResponse<Void> batchSend(List<SendRequest> sendRequestList, Long parkId, String parkCode) {
        List ids = sendRequestList.stream().map(SendRequest::getServiceId).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(ids)) {
            return ObjectResponse.failed((String)"402");
        }
        sendRequestList.forEach(sendRequest -> {
            ClearListRequest clearListRequest = new ClearListRequest();
            clearListRequest.setId(Integer.valueOf(sendRequest.getServiceId().intValue()));
            clearListRequest.setDataType(Integer.valueOf(QueryListRequest.DataType.\u9ed1\u540d\u5355.getVal()));
            sendRequest.setReqServiceType(P2cDownCmdEnum.\u540d\u5355\u6570\u636e\u6e05\u7a7a.getCmdType());
            this.sendMsgService.send2Park((SendRequest)sendRequest, parkCode, clearListRequest);
            ThreadUtil.sleep((long)200L);
        });
        return ObjectResponse.success();
    }

    @Override
    public ObjectResponse<Void> batchSendRepeat(BatchSendRepeatVO vo) {
        String parkCode = vo.getParkCode();
        ObjectResponse blacklistRet = StrUtil.isNotBlank((CharSequence)vo.getFailIds()) ? this.blacklistService.getValidByIds(Arrays.asList(vo.getFailIds().split(","))) : this.blacklistService.getValidByParkId(vo.getParkId());
        if (blacklistRet.getCode().equals("404")) {
            log.info("<\u6279\u91cf\u9ed1\u540d\u5355\u4e0b\u53d1-\u91cd\u53d1> \u6ca1\u6709\u7b26\u5408\u6bd4\u5bf9\u6761\u4ef6\u7684\u9ed1\u540d\u5355\u8f66\uff0c\u5ffd\u7565\u4e0b\u53d1\uff0c\u8f66\u573a\u7f16\u53f7\uff1a{}", (Object)parkCode);
            return ObjectResponse.success();
        }
        if (ObjectResponse.isSuccess((Response)blacklistRet)) {
            List blacklists = (List)blacklistRet.getData();
            ArrayList<BlacklistRequest> list = new ArrayList<BlacklistRequest>();
            for (Blacklist blacklist : blacklists) {
                BlacklistRequest blacklistRequest = new BlacklistRequest();
                blacklistRequest.setBlackId(blacklist.getId());
                blacklistRequest.setPlateNum(blacklist.getPlate());
                list.add(blacklistRequest);
            }
            List<Object> idList = list.stream().map(BlacklistRequest::getBlackId).collect(Collectors.toList());
            this.batchDownBizHandle.repeatBatch(vo, list, idList, HEADERS, P2cDownCmdEnum.\u9ed1\u540d\u5355\u4e0b\u53d1.getCmdType());
            return ObjectResponse.success();
        }
        return ObjectResponse.failed((String)blacklistRet.getCode(), (String)blacklistRet.getMsg());
    }
}

