/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.down.p2c;

import com.icetech.basics.domain.SendMessage;
import com.icetech.cloudcenter.domain.base.Request;
import com.icetech.cloudcenter.domain.enumeration.P2cDownCmdEnum;
import com.icetech.cloudcenter.domain.enumeration.P2cVersionEnum;
import com.icetech.cloudcenter.domain.request.p2c.MonthCardRequest;
import com.icetech.cloudcenter.domain.request.p2c.QueryListRequest;
import com.icetech.cloudcenter.domain.vo.p2c.TokenDeviceVo;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.exception.ResponseBodyException;
import com.icetech.park.service.down.Message;
import com.icetech.park.service.down.SendMsgCommon;
import com.icetech.park.service.handle.P2cDownHandle;
import com.icetech.third.utils.JsonUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SendMsgServiceImpl
extends SendMsgCommon {
    private static final Logger log = LoggerFactory.getLogger(SendMsgServiceImpl.class);
    @Autowired
    private P2cDownHandle p2cDownHandle;

    @Override
    public <T, R> ObjectResponse<R> send(Message<T> message, String sendDevices, String parkCode) {
        T payload = message.getPayload();
        String[] targetArr = sendDevices.split(";");
        if (targetArr.length == 0) {
            return ObjectResponse.success();
        }
        SendMessage sendMessage = SendMessage.builder().type("1").build();
        boolean hasFail = false;
        String lastDeviceVersion = null;
        ArrayList<Object> offLineDescribes = new ArrayList<Object>();
        ArrayList failDescribes = new ArrayList();
        ArrayList<SendMessage.Describe> lowVerDescribes = new ArrayList<SendMessage.Describe>();
        for (String serialNumber : targetArr) {
            String messageId;
            List serialNumbers;
            TokenDeviceVo tokenDeviceVo;
            block23: {
                MonthCardRequest.Details details;
                int n;
                MonthCardRequest monthCardRequest;
                if (serialNumber == null || serialNumber.trim().isEmpty()) continue;
                tokenDeviceVo = this.cacheHandle.getDeviceInfo(serialNumber);
                if (tokenDeviceVo == null) {
                    hasFail = true;
                    if (CollectionUtils.isNotEmpty(offLineDescribes)) {
                        for (SendMessage.Describe describe : offLineDescribes) {
                            List list = describe.getSerialNumbers();
                            if (CollectionUtils.isEmpty((Collection)list)) {
                                list.add(serialNumber);
                                continue;
                            }
                            if (list.contains(serialNumber)) continue;
                            list.add(serialNumber);
                        }
                    } else {
                        ArrayList<String> nums2 = new ArrayList<String>();
                        nums2.add(serialNumber);
                        offLineDescribes.add(SendMessage.Describe.builder().failType("10003").serialNumbers(nums2).build());
                    }
                    log.info("[\u4e0b\u53d1\u4e1a\u52a1\u6570\u636e] \u8bbe\u5907\u5e8f\u5217\u53f7[{}]\u4e0d\u5728\u7ebf", (Object)serialNumber);
                    continue;
                }
                if (message.getServiceType().equals(P2cDownCmdEnum.\u6708\u5361.getCmdType()) && P2cVersionEnum.\u7248\u672c4.getIndex() > P2cVersionEnum.getIndex((String)tokenDeviceVo.getVersion()) && (monthCardRequest = (MonthCardRequest)message.getPayload()).getDetails().size() == 1 && (n = (details = (MonthCardRequest.Details)monthCardRequest.getDetails().get(0)).getPlateNum().split(",").length) > details.getPlotCount()) {
                    this.clearListService.execute(message.getParkId(), parkCode, QueryListRequest.DataType.\u6708\u5361.getVal(), details.getCardId());
                    sendMessage.setDescribes(Collections.singletonList(SendMessage.Describe.builder().serialNumbers(Collections.singletonList(tokenDeviceVo.getDeviceNo())).failType("10005").versions(Collections.singletonList(tokenDeviceVo.getVersion())).build()));
                    return ObjectResponse.failed((String)"407", (String)JsonUtils.toJson((Object)sendMessage));
                }
                if (tokenDeviceVo.getVersion() != null && !tokenDeviceVo.getVersion().equals(lastDeviceVersion)) {
                    try {
                        if (payload instanceof List) {
                            List list = (List)payload;
                            Object e = list.get(0);
                            if (e instanceof Request) {
                                for (Object o : list) {
                                    Request request = (Request)o;
                                    request.buildByVersion(tokenDeviceVo.getVersion());
                                }
                            }
                            break block23;
                        }
                        if (!(payload instanceof Request)) break block23;
                        Request request = (Request)payload;
                        request.buildByVersion(tokenDeviceVo.getVersion());
                    }
                    catch (ResponseBodyException re) {
                        hasFail = true;
                        if (CollectionUtils.isNotEmpty(lowVerDescribes)) {
                            for (SendMessage.Describe describe : lowVerDescribes) {
                                serialNumbers = describe.getSerialNumbers();
                                List versions = describe.getVersions();
                                if (CollectionUtils.isEmpty((Collection)serialNumbers)) {
                                    serialNumbers.add(serialNumber);
                                    versions.add(tokenDeviceVo.getVersion());
                                    continue;
                                }
                                if (serialNumbers.contains(serialNumber)) continue;
                                serialNumbers.add(serialNumber);
                                versions.add(tokenDeviceVo.getVersion());
                            }
                            continue;
                        }
                        ArrayList<String> arrayList = new ArrayList<String>();
                        arrayList.add(serialNumber);
                        ArrayList<String> arrayList2 = new ArrayList<String>();
                        arrayList2.add(tokenDeviceVo.getVersion());
                        lowVerDescribes.add(SendMessage.Describe.builder().failType("10005").serialNumbers(arrayList).versions(arrayList2).build());
                        continue;
                    }
                }
            }
            if ((messageId = this.p2cDownHandle.send(parkCode, serialNumber, message)) == null) {
                hasFail = true;
                if (CollectionUtils.isEmpty(failDescribes)) {
                    ArrayList<String> arrayList = new ArrayList<String>();
                    arrayList.add(serialNumber);
                    offLineDescribes.add(SendMessage.Describe.builder().failType("10004").serialNumbers(arrayList).build());
                } else {
                    for (SendMessage.Describe describe : offLineDescribes) {
                        serialNumbers = describe.getSerialNumbers();
                        if (CollectionUtils.isEmpty((Collection)serialNumbers)) {
                            serialNumbers.add(serialNumber);
                            continue;
                        }
                        if (serialNumbers.contains(serialNumber)) continue;
                        serialNumbers.add(serialNumber);
                    }
                }
            }
            lastDeviceVersion = tokenDeviceVo.getVersion();
        }
        if (hasFail) {
            offLineDescribes.addAll(failDescribes);
            offLineDescribes.addAll(lowVerDescribes);
            sendMessage.setDescribes(offLineDescribes);
            log.info("[\u7aef\u4e91-\u4e1a\u52a1\u6570\u636e\u4e0b\u53d1] \u8bbe\u5907\u4e0d\u5728\u7ebf\u6216\u54cd\u5e94\u8d85\u65f6, \u53c2\u6570[{}]", message);
            return ObjectResponse.failed((String)"410", (String)JsonUtils.toJson((Object)sendMessage));
        }
        return ObjectResponse.success();
    }
}

